/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.ProgressRunnable;
import gaiasky.util.i18n.I18n;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.function.Consumer;

public class DownloadHelper {
    private static final Logger.Log logger = Logger.getLogger(DownloadHelper.class);

    public static Net.HttpRequest downloadFile(String url, FileHandle to, boolean offlineMode, ProgressRunnable progressDownload, ProgressRunnable progressHashResume, Consumer<String> finish, Runnable fail, Runnable cancel) {
        long startSize;
        boolean resume;
        if (url.startsWith("file://")) {
            String srcString = url.replaceFirst("file://", "");
            Path source = Paths.get(srcString, new String[0]);
            logger.info("Using file:// protocol: " + srcString);
            if (Files.exists(source, new LinkOption[0]) && Files.isRegularFile(source, new LinkOption[0]) && Files.isReadable(source)) {
                Path target = Path.of(to.path(), new String[0]);
                try {
                    Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                    finish.accept("");
                }
                catch (IOException e) {
                    logger.error(I18n.msg("error.file.copy", srcString, to.path()));
                }
                catch (Exception e) {
                    logger.error(e);
                    if (fail != null) {
                        fail.run();
                    }
                }
            } else {
                logger.error(I18n.msg("error.loading.notexistent", srcString));
                if (fail != null) {
                    fail.run();
                }
            }
            return null;
        }
        Net.HttpRequest request = new Net.HttpRequest("GET");
        request.setFollowRedirects(true);
        request.setTimeOut(2500);
        request.setUrl(url);
        long age = TimeUtils.millis() - to.lastModified();
        if (age > Constants.getPartFileMaxAgeMs() && to.exists()) {
            to.delete();
        }
        boolean bl = resume = to.exists() && to.name().endsWith(".part");
        if (resume) {
            startSize = to.file().length();
            request.setHeader("Range", "bytes=" + startSize + "-");
            logger.info("Resuming download, part file found: " + String.valueOf(to.file().toPath()));
        } else {
            startSize = 0L;
        }
        if (offlineMode) {
            if (fail != null) {
                fail.run();
            }
        } else {
            DownloadHelper.sendRequest(request, url, resume, to, startSize, progressDownload, progressHashResume, finish, fail, cancel);
        }
        return request;
    }

    public static void sendRequest(final Net.HttpRequest request, final String url, final boolean resume, final FileHandle to, final long startSize, final ProgressRunnable progressDownload, final ProgressRunnable progressHashResume, final Consumer<String> finish, final Runnable fail, final Runnable cancel) {
        Gdx.net.sendHttpRequest(request, new Net.HttpResponseListener(){
            private boolean cancelled = false;

            public void handleHttpResponse(Net.HttpResponse httpResponse) {
                block17: {
                    int status = httpResponse.getStatus().getStatusCode();
                    if (status == 416) {
                        if (resume) {
                            try {
                                Files.delete(to.file().toPath());
                            }
                            catch (IOException e) {
                                logger.error(e);
                            }
                        }
                        DownloadHelper.sendRequest(request, url, false, to, 0L, progressDownload, progressHashResume, finish, fail, cancel);
                        return;
                    }
                    long length = Long.parseLong(httpResponse.getHeader("Content-Length"));
                    if (status < 400) {
                        try {
                            int count;
                            InputStream is = httpResponse.getResultAsStream();
                            OutputStream os = to.write(resume);
                            byte[] bytes = new byte[1024];
                            long read = 0L;
                            long lastTimeMs = System.currentTimeMillis();
                            long lastRead = 0L;
                            double bytesPerMs = 0.0;
                            long totalLength = length + startSize;
                            logger.info(I18n.msg("gui.download.starting", url));
                            logger.info("Reading " + length + " bytes " + (String)(resume ? "(resuming from " + startSize + ", total is " + totalLength + ")" : ""));
                            MessageDigest md = MessageDigest.getInstance("SHA-256");
                            DigestInputStream dis = new DigestInputStream(is, md);
                            while ((count = dis.read(bytes, 0, bytes.length)) != -1 && !this.cancelled) {
                                boolean updateSpeed;
                                os.write(bytes, 0, count);
                                double progressValue = (double)(startSize + (read += (long)count)) / (double)totalLength * 100.0;
                                long currentTimeMs = System.currentTimeMillis();
                                boolean bl = updateSpeed = currentTimeMs - lastTimeMs >= 1000L;
                                if (updateSpeed) {
                                    long elapsedMs = currentTimeMs - lastTimeMs;
                                    long readInterval = read - lastRead;
                                    bytesPerMs = (double)readInterval / (double)elapsedMs;
                                }
                                if (progressDownload != null) {
                                    progressDownload.run(startSize + read, totalLength, progressValue, bytesPerMs);
                                }
                                if (!updateSpeed) continue;
                                lastTimeMs = currentTimeMs;
                                lastRead = read;
                            }
                            is.close();
                            os.close();
                            logger.info(I18n.msg("gui.download.finished", to.file().toPath()));
                            if (finish == null || this.cancelled) break block17;
                            if (resume) {
                                try {
                                    logger.info("Recomputing sha156 checksum due to being a resumed download: " + String.valueOf(to.file().toPath()));
                                    md.reset();
                                    InputStream fis = to.read();
                                    length = to.length();
                                    read = 0L;
                                    while ((count = fis.read(bytes, 0, bytes.length)) != -1) {
                                        boolean updateSpeed;
                                        md.update(bytes, 0, count);
                                        double progressValue = (double)(read += (long)count) / (double)length * 100.0;
                                        long currentTimeMs = System.currentTimeMillis();
                                        boolean bl = updateSpeed = currentTimeMs - lastTimeMs >= 1000L;
                                        if (updateSpeed) {
                                            long elapsedMs = currentTimeMs - lastTimeMs;
                                            long readInterval = read - lastRead;
                                            bytesPerMs = (double)readInterval / (double)elapsedMs;
                                        }
                                        if (progressHashResume == null) continue;
                                        progressHashResume.run(read, length, progressValue, bytesPerMs);
                                    }
                                }
                                catch (IOException e) {
                                    logger.error("Failed computing sha256 checksum of resumed download.", e);
                                }
                            }
                            byte[] digestBytes = md.digest();
                            String digest = this.bytesToHex(digestBytes);
                            finish.accept(digest);
                        }
                        catch (Exception e) {
                            logger.error(e);
                            if (fail != null) {
                                fail.run();
                            }
                            break block17;
                        }
                    }
                    logger.error(I18n.msg("gui.download.error.httpstatus", status));
                    if (fail != null) {
                        fail.run();
                    }
                }
            }

            private String bytesToHex(byte[] hash) {
                StringBuilder hexString = new StringBuilder(2 * hash.length);
                for (byte b : hash) {
                    String hex = Integer.toHexString(0xFF & b);
                    if (hex.length() == 1) {
                        hexString.append('0');
                    }
                    hexString.append(hex);
                }
                return hexString.toString();
            }

            public void failed(Throwable t) {
                logger.error(I18n.msg("gui.download.fail"));
                if (fail != null) {
                    fail.run();
                }
            }

            public void cancelled() {
                logger.error(I18n.msg("gui.download.cancelled", url));
                this.cancelled = true;
                if (cancel != null) {
                    cancel.run();
                }
            }
        });
    }
}

