/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;

public class FastObjectIntMap<K> {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private K[] keys;
    private int[] values;
    private int size;
    private int capacity;
    private int threshold;
    private final Class<K> clazz;

    public FastObjectIntMap(int initialCapacity, Class<K> c) {
        this.clazz = c;
        this.capacity = Math.max(16, initialCapacity);
        this.keys = (Object[])Array.newInstance(this.clazz, this.capacity);
        this.values = new int[this.capacity];
        Arrays.fill(this.keys, null);
        this.threshold = (int)((float)this.capacity * 0.75f);
        this.size = 0;
    }

    public int get(K key) {
        int index = this.indexOf(key);
        return index != -1 ? this.values[index] : 0;
    }

    public void put(K key, int value) {
        int index;
        if (this.size >= this.threshold) {
            this.resize(this.capacity * 2);
        }
        if (this.keys[index = this.findSlot(key)] == null) {
            this.keys[index] = key;
            this.values[index] = value;
            ++this.size;
        } else {
            this.values[index] = value;
        }
    }

    public boolean containsKey(K key) {
        return this.indexOf(key) != -1;
    }

    public K[] keys() {
        return this.keys;
    }

    public int size() {
        return this.size;
    }

    private int findSlot(K key) {
        int hash = this.hash(key);
        int index = hash % this.capacity;
        while (this.keys[index] != null && !Objects.equals(this.keys[index], key)) {
            index = (index + 1) % this.capacity;
        }
        return index;
    }

    private int indexOf(K key) {
        int hash = this.hash(key);
        int index = hash % this.capacity;
        while (this.keys[index] != null) {
            if (Objects.equals(this.keys[index], key)) {
                return index;
            }
            index = (index + 1) % this.capacity;
        }
        return -1;
    }

    private void resize(int newCapacity) {
        K[] oldKeys = this.keys;
        int[] oldValues = this.values;
        this.capacity = newCapacity;
        this.threshold = (int)((float)this.capacity * 0.75f);
        this.keys = (Object[])Array.newInstance(this.clazz, this.capacity);
        this.values = new int[this.capacity];
        Arrays.fill(this.keys, null);
        this.size = 0;
        for (int i = 0; i < oldKeys.length; ++i) {
            if (oldKeys[i] == null) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }

    private int hash(Object key) {
        return key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
    }
}

