/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;

public class FastStringObjectMap<V> {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private String[] keys;
    private V[] values;
    private int size;
    private int capacity;
    private int threshold;
    private final Class<V> clazz;

    public FastStringObjectMap(int initialCapacity, Class<V> c) {
        this.clazz = c;
        this.capacity = Math.max(16, initialCapacity);
        this.keys = new String[this.capacity];
        this.values = (Object[])Array.newInstance(this.clazz, this.capacity);
        Arrays.fill(this.keys, null);
        this.threshold = (int)((float)this.capacity * 0.75f);
        this.size = 0;
    }

    public V get(String key) {
        int index = this.indexOf(key);
        return index != -1 ? (V)this.values[index] : null;
    }

    public void put(String key, V value) {
        int index;
        if (this.size >= this.threshold) {
            this.resize(this.capacity * 2);
        }
        if (this.keys[index = this.findSlot(key)] == null) {
            this.keys[index] = key;
            this.values[index] = value;
            ++this.size;
        } else {
            this.values[index] = value;
        }
    }

    public boolean containsKey(String key) {
        return this.indexOf(key) != -1;
    }

    public String[] keys() {
        return this.keys;
    }

    public V remove(String key) {
        int index = this.indexOf(key);
        if (index == -1) {
            return null;
        }
        V oldValue = this.values[index];
        this.keys[index] = null;
        this.values[index] = null;
        --this.size;
        index = (index + 1) % this.capacity;
        while (this.keys[index] != null) {
            String rehashKey = this.keys[index];
            V rehashValue = this.values[index];
            this.keys[index] = null;
            this.values[index] = null;
            --this.size;
            this.put(rehashKey, rehashValue);
            index = (index + 1) % this.capacity;
        }
        return oldValue;
    }

    public int size() {
        return this.size;
    }

    private int findSlot(String key) {
        int hash = this.hash(key);
        int index = hash % this.capacity;
        while (this.keys[index] != null && !Objects.equals(this.keys[index], key)) {
            index = (index + 1) % this.capacity;
        }
        return index;
    }

    private int indexOf(String key) {
        int hash = this.hash(key);
        int index = hash % this.capacity;
        while (this.keys[index] != null) {
            if (Objects.equals(this.keys[index], key)) {
                return index;
            }
            index = (index + 1) % this.capacity;
        }
        return -1;
    }

    private void resize(int newCapacity) {
        String[] oldKeys = this.keys;
        V[] oldValues = this.values;
        this.capacity = newCapacity;
        this.threshold = (int)((float)this.capacity * 0.75f);
        this.keys = new String[this.capacity];
        this.values = (Object[])Array.newInstance(this.clazz, this.capacity);
        Arrays.fill(this.keys, null);
        this.size = 0;
        for (int i = 0; i < oldKeys.length; ++i) {
            if (oldKeys[i] == null) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }

    private int hash(String key) {
        return key == null ? 0 : key.hashCode() & Integer.MAX_VALUE;
    }
}

