/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.ui.TooltipManager;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import gaiasky.GaiaSky;
import gaiasky.gui.bookmarks.BookmarksManager;
import gaiasky.render.MainPostProcessor;
import gaiasky.script.ConsoleManager;
import gaiasky.script.EventScriptingInterface;
import gaiasky.script.HiddenHelperUser;
import gaiasky.script.ScriptingServer;
import gaiasky.util.CatalogManager;
import gaiasky.util.GaiaSkyAssets;
import gaiasky.util.LocationLogManager;
import gaiasky.util.gravwaves.RelativisticEffectsManager;
import gaiasky.util.samp.SAMPClient;
import gaiasky.util.svt.SVTManager;

public class GaiaSkyLoader
extends AsynchronousAssetLoader<GaiaSkyAssets, GaiaSkyLoaderParameters> {
    private GaiaSkyAssets assets;

    public GaiaSkyLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, GaiaSkyLoaderParameters parameter) {
        this.assets = new GaiaSkyAssets();
        if (parameter.firstStage) {
            TooltipManager.getInstance().initialTime = 1.0f;
            HiddenHelperUser.initialize();
            RelativisticEffectsManager.initialize(parameter.gaiaSky.time);
            LocationLogManager.initialize();
            Timer.instance();
            this.assets.catalogManager = new CatalogManager();
            if (!parameter.noScripting) {
                this.assets.scriptingInterface = new EventScriptingInterface(parameter.gaiaSky.assetManager, this.assets.catalogManager);
                ScriptingServer.initialize(this.assets.scriptingInterface);
            }
            this.assets.bookmarksManager = new BookmarksManager();
            this.assets.sampClient = new SAMPClient(this.assets.catalogManager);
            this.assets.sampClient.initialize(parameter.gaiaSky.getGlobalResources().getSkin());
            this.assets.svtManager = new SVTManager();
            this.assets.postProcessor = new MainPostProcessor(null);
            this.assets.postProcessor.initialize(manager);
            this.assets.consoleManager = new ConsoleManager(this.assets.scriptingInterface);
        }
    }

    public GaiaSkyAssets loadSync(AssetManager manager, String fileName, FileHandle file, GaiaSkyLoaderParameters parameter) {
        if (parameter.firstStage) {
            this.assets.svtManager.doneLoading(manager);
            this.assets.postProcessor.doneLoading(manager);
        }
        return this.assets;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, GaiaSkyLoaderParameters parameter) {
        return null;
    }

    public static class GaiaSkyLoaderParameters
    extends AssetLoaderParameters<GaiaSkyAssets> {
        public boolean firstStage;
        public boolean noScripting;
        public GaiaSky gaiaSky;

        public GaiaSkyLoaderParameters(GaiaSky gaiaSky, boolean noScripting, boolean firstStage) {
            this.gaiaSky = gaiaSky;
            this.noScripting = noScripting;
            this.firstStage = firstStage;
        }

        public GaiaSkyLoaderParameters(GaiaSky gaiaSky, boolean noScripting) {
            this(gaiaSky, noScripting, true);
        }
    }
}

