/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.scene.camera.ICamera;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.gdx.g2d.ExtSpriteBatch;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.io.IOException;
import java.nio.IntBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import net.jafama.FastMath;

public class GlobalResources {
    private static final Logger.Log logger = Logger.getLogger(GlobalResources.class);
    private static final Vector3D aux = new Vector3D();
    private static final IntBuffer buf = BufferUtils.newIntBuffer((int)16);
    private final SpriteBatch spriteBatch;
    private final ExtShaderProgram extSpriteShader;
    private final ExtSpriteBatch extSpriteBatch;
    private final ShaderProgram shapeShader;
    private final ShaderProgram spriteShader;
    private Skin skin;
    public static final DecimalFormat nf = new DecimalFormat("#########.###");
    public static final DecimalFormat nfSci = new DecimalFormat("0.###E0");
    private final Map<String, Texture> textures = new HashMap<String, Texture>();

    public GlobalResources() {
        this.shapeShader = new ShaderProgram(Gdx.files.internal("shader/2d/shape.vertex.glsl"), Gdx.files.internal("shader/2d/shape.fragment.glsl"));
        if (!this.shapeShader.isCompiled()) {
            logger.info("ShapeRenderer shader compilation failed: " + this.shapeShader.getLog());
        }
        this.spriteShader = new ShaderProgram(Gdx.files.internal("shader/2d/spritebatch.vertex.glsl"), Gdx.files.internal("shader/2d/spritebatch.fragment.glsl"));
        if (!this.spriteShader.isCompiled()) {
            logger.info("SpriteBatch shader compilation failed: " + this.spriteShader.getLog());
        }
        this.spriteBatch = new SpriteBatch(500, this.getSpriteShader());
        this.extSpriteShader = new ExtShaderProgram("spritebatch", Gdx.files.internal("shader/2d/spritebatch.vertex.glsl"), Gdx.files.internal("shader/2d/spritebatch.fragment.glsl"));
        if (!this.extSpriteShader.isCompiled()) {
            logger.info("ExtSpriteBatch shader compilation failed: " + this.extSpriteShader.getLog());
        }
        this.extSpriteBatch = new ExtSpriteBatch(1000, this.getExtSpriteShader());
        this.updateSkin();
    }

    public void initialize(AssetManager manager) {
        TextureLoader.TextureParameter params = new TextureLoader.TextureParameter();
        params.minFilter = Texture.TextureFilter.Linear;
        params.magFilter = Texture.TextureFilter.Linear;
        manager.load("img/markers/crosshair-focus.png", Texture.class, (AssetLoaderParameters)params);
        manager.load("img/markers/crosshair-closest.png", Texture.class, (AssetLoaderParameters)params);
        manager.load("img/markers/crosshair-home.png", Texture.class, (AssetLoaderParameters)params);
        manager.load("img/markers/crosshair-arrow.png", Texture.class, (AssetLoaderParameters)params);
        manager.load("img/markers/ai-pointer.png", Texture.class, (AssetLoaderParameters)params);
        manager.load("img/markers/ai-vel.png", Texture.class, (AssetLoaderParameters)params);
        manager.load("img/markers/ai-antivel.png", Texture.class, (AssetLoaderParameters)params);
        manager.load("img/markers/gravwave-pointer.png", Texture.class, (AssetLoaderParameters)params);
        manager.load("img/markers/loc-marker-default.png", Texture.class, (AssetLoaderParameters)params);
        manager.load("img/markers/loc-marker-flag.png", Texture.class, (AssetLoaderParameters)params);
        manager.load("img/markers/loc-marker-city.png", Texture.class, (AssetLoaderParameters)params);
        manager.load("img/markers/loc-marker-town.png", Texture.class, (AssetLoaderParameters)params);
        manager.load("img/markers/loc-marker-landmark.png", Texture.class, (AssetLoaderParameters)params);
        manager.load(Settings.settings.data.dataFile("$data/tex/base/attitudeindicator.png"), Texture.class, (AssetLoaderParameters)params);
    }

    public void doneLoading(AssetManager manager) {
        this.textures.put("crosshair-focus", (Texture)manager.get("img/markers/crosshair-focus.png"));
        this.textures.put("crosshair-closest", (Texture)manager.get("img/markers/crosshair-closest.png"));
        this.textures.put("crosshair-home", (Texture)manager.get("img/markers/crosshair-home.png"));
        this.textures.put("crosshair-arrow", (Texture)manager.get("img/markers/crosshair-arrow.png"));
        this.textures.put("ai-pointer", (Texture)manager.get("img/markers/ai-pointer.png"));
        this.textures.put("ai-vel", (Texture)manager.get("img/markers/ai-vel.png"));
        this.textures.put("ai-antivel", (Texture)manager.get("img/markers/ai-antivel.png"));
        this.textures.put("gravwave-pointer", (Texture)manager.get("img/markers/gravwave-pointer.png"));
        this.textures.put("loc-marker-default", (Texture)manager.get("img/markers/loc-marker-default.png"));
        this.textures.put("loc-marker-flag", (Texture)manager.get("img/markers/loc-marker-flag.png"));
        this.textures.put("loc-marker-city", (Texture)manager.get("img/markers/loc-marker-city.png"));
        this.textures.put("loc-marker-town", (Texture)manager.get("img/markers/loc-marker-town.png"));
        this.textures.put("loc-marker-landmark", (Texture)manager.get("img/markers/loc-marker-landmark.png"));
        this.textures.put("attitude-indicator", (Texture)manager.get(Settings.settings.data.dataFile("$data/tex/base/attitudeindicator.png"), Texture.class));
    }

    public Texture getTexture(String name) {
        return this.textures != null ? this.textures.get(name) : null;
    }

    public static String formatNumber(double number) {
        if (number > 99999.0 || number < -99999.0) {
            return nfSci.format(number);
        }
        return nf.format(number);
    }

    public static Pair<Double, String> doubleToDistanceString(double d, Settings.DistanceUnits du) {
        if (Math.abs(d *= Constants.U_TO_KM) < 1.0) {
            return new Pair<Double, String>(d * 1000.0, I18n.msg("gui.unit.m"));
        }
        if (Math.abs(d) < 1.4959787100000001E7) {
            return new Pair<Double, String>(d, I18n.msg("gui.unit.km"));
        }
        if (Math.abs(d) < 0.1 * du.toKm) {
            return new Pair<Double, String>(d * 6.6845871088633344E-9, I18n.msg("gui.unit.au"));
        }
        return new Pair<Double, String>(d * du.fromKm, du.getUnitString());
    }

    public static Pair<Double, String> doubleToVelocityString(double d, Settings.DistanceUnits du) {
        Pair<Double, String> res = GlobalResources.doubleToDistanceString(d, du);
        res.setSecond(res.getSecond().concat("/").concat(I18n.msg("gui.unit.second")));
        return res;
    }

    public static float[] toFloatArray(double[] array) {
        float[] res = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            res[i] = (float)array[i];
        }
        return res;
    }

    public static boolean isInView(Vector3Q point, double len, float coneAngle, Vector3D dir) {
        return FastMath.acos((double)(point.tov3d().dot(dir) / len)) < (double)coneAngle;
    }

    public static boolean isInView(Vector3D point, double len, float coneAngle, Vector3D dir) {
        return FastMath.acos((double)(point.dot(dir) / len)) < (double)coneAngle;
    }

    public static boolean equal(String buf, char[] compareTo, boolean ignoreCase) {
        if (buf == null || compareTo == null || buf.isEmpty()) {
            return false;
        }
        int len = FastMath.min((int)buf.length(), (int)compareTo.length);
        if (ignoreCase) {
            for (int i = 0; i < len; ++i) {
                char b;
                char a = buf.charAt(i);
                if (a == (b = compareTo[i]) || a - 32 == b) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                char b;
                char a = buf.charAt(i);
                if (a == (b = compareTo[i])) continue;
                return false;
            }
        }
        return true;
    }

    public static int countOccurrences(String haystack, char needle) {
        int count = 0;
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++count;
        }
        return count;
    }

    public static void listRecursive(Path f, Array<Path> l, String ... extensions) {
        if (Files.exists(f, new LinkOption[0])) {
            if (Files.isDirectory(f, new LinkOption[0])) {
                try (Stream<Path> partial = Files.list(f);){
                    partial.forEachOrdered(p -> GlobalResources.listRecursive(p, l, extensions));
                }
                catch (IOException e) {
                    logger.error(e);
                }
            } else if (GlobalResources.endsWithAny(f.getFileName().toString(), extensions)) {
                l.add((Object)f);
            }
        }
    }

    private static boolean endsWithAny(String str, String ... extensions) {
        for (String ext : extensions) {
            if (!str.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public static void deleteRecursively(Path path) throws IOException {
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).filter(p -> (!p.toString().endsWith(".part") || p.toString().endsWith(".part") && TimeUtils.millis() - p.toFile().lastModified() > Constants.getPartFileMaxAgeMs()) && !Files.isDirectory(p, new LinkOption[0])).map(Path::toFile).forEach(f -> {
                if (!f.delete()) {
                    logger.debug(I18n.msg("error.file.delete.fail", f));
                }
            });
        }
    }

    public static void copyFile(Path sourceFile, Path destinationFile, boolean ow) throws IOException {
        if (!Files.exists(destinationFile, new LinkOption[0]) || ow) {
            Files.copy(sourceFile, destinationFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static boolean endsWith(String s, String[] endings) {
        if (endings == null) {
            return true;
        }
        for (String ending : endings) {
            if (!s.endsWith(ending)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumeric(String str) {
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        list.sort(Map.Entry.comparingByValue());
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return result;
    }

    public static float angle2d(Vector3 v1, Vector3 v2) {
        return (float)(57.29577951308232 * FastMath.atan2((double)(v2.y - v1.y), (double)(v2.x - v1.x)));
    }

    public static synchronized void applyRelativisticAberration(Vector3D pos, ICamera cam) {
        if (Settings.settings.runtime.relativisticAberration) {
            Vector3D camDir = aux;
            if (cam.getVelocity() != null) {
                camDir.set(cam.getVelocity()).nor();
            } else {
                camDir.set(1.0, 0.0, 0.0);
            }
            double vc = cam.getSpeed() / 1.079253E9;
            if (vc > 0.0) {
                camDir.scl(-1.0);
                double cosThS = camDir.dot(pos) / pos.len();
                double th_s = FastMath.acos((double)cosThS);
                double cosThO = (cosThS - vc) / (1.0 - vc * cosThS);
                double th_o = FastMath.acos((double)cosThO);
                pos.rotate(camDir.crs(pos).nor(), FastMath.toDegrees((double)(th_o - th_s)));
            }
        }
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / FastMath.log((double)unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / FastMath.pow((double)unit, (double)exp), pre);
    }

    public static long size(Path path) throws IOException {
        final AtomicLong size = new AtomicLong(0L);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                size.addAndGet(attrs.size());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                logger.info("skipped: " + String.valueOf(file) + " (" + String.valueOf(exc) + ")");
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                if (exc != null) {
                    logger.info("had trouble traversing: " + String.valueOf(dir) + " (" + String.valueOf(exc) + ")");
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return size.get();
    }

    public static String[] parseWhitespaceSeparatedList(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        int n = str.length();
        StringBuilder current = new StringBuilder();
        boolean inString = false;
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (c == '\"') {
                if (inString) {
                    l.add(current.toString());
                    current = new StringBuilder();
                    inString = false;
                    continue;
                }
                inString = true;
                continue;
            }
            if (!inString) continue;
            current.append(c);
        }
        return l.toArray(new String[0]);
    }

    public static String toString(String[] l, String quote, String separator) {
        if (l == null || l.length == 0) {
            return null;
        }
        if (quote == null) {
            quote = "";
        }
        if (separator == null) {
            separator = "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : l) {
            sb.append(quote).append(s).append(quote).append(separator);
        }
        return sb.toString().trim();
    }

    public static String unpackAssetPath(String path, Settings.GraphicsQuality gq) {
        if (path.contains("%#QUAL#%")) {
            for (int i = gq.ordinal(); i >= 0; --i) {
                Settings.GraphicsQuality quality = Settings.GraphicsQuality.values()[i];
                String suffix = quality.suffix;
                String texSuffix = path.replace("%#QUAL#%", suffix);
                if (!Settings.settings.data.dataFileHandle(texSuffix).exists()) continue;
                return texSuffix;
            }
            String texNoSuffix = path.replace("%#QUAL#%", "");
            if (Settings.settings.data.dataFileHandle(texNoSuffix).exists()) {
                return texNoSuffix;
            }
            int n = Settings.GraphicsQuality.values().length;
            for (int i = gq.ordinal(); i < n; ++i) {
                Settings.GraphicsQuality quality = Settings.GraphicsQuality.values()[i];
                String suffix = quality.suffix;
                String texSuffix = path.replace("%#QUAL#%", suffix);
                if (!Settings.settings.data.dataFileHandle(texSuffix).exists()) continue;
                return texSuffix;
            }
            logger.error("Texture not found: " + path);
            return null;
        }
        return path;
    }

    public static String unpackAssetPath(String path, Settings.GraphicsQuality gq, String ... extensions) {
        if (!path.contains("%#QUAL#%")) {
            for (String extension : extensions) {
                String tex = path + extension;
                if (!Settings.settings.data.dataFileHandle(tex).exists()) continue;
                return tex;
            }
        } else {
            for (String extension : extensions) {
                for (int i = gq.ordinal(); i >= 0; --i) {
                    Settings.GraphicsQuality quality = Settings.GraphicsQuality.values()[i];
                    String suffix = quality.suffix;
                    String texSuffix = path.replace("%#QUAL#%", suffix) + extension;
                    if (!Settings.settings.data.dataFileHandle(texSuffix).exists()) continue;
                    return texSuffix;
                }
            }
            for (String extension : extensions) {
                String texNoSuffix = path.replace("%#QUAL#%", "") + extension;
                if (!Settings.settings.data.dataFileHandle(texNoSuffix).exists()) continue;
                return texNoSuffix;
            }
            for (String extension : extensions) {
                int n = Settings.GraphicsQuality.values().length;
                for (int i = gq.ordinal(); i < n; ++i) {
                    Settings.GraphicsQuality quality = Settings.GraphicsQuality.values()[i];
                    String suffix = quality.suffix;
                    String texSuffix = path.replace("%#QUAL#%", suffix) + extension;
                    if (!Settings.settings.data.dataFileHandle(texSuffix).exists()) continue;
                    return texSuffix;
                }
            }
        }
        return null;
    }

    public static String unpackAssetPath(String tex) {
        return GlobalResources.unpackAssetPath(tex, Settings.settings.graphics.quality);
    }

    public static String unpackAssetPathExtensions(String tex, String ... extensions) {
        return GlobalResources.unpackAssetPath(tex, Settings.settings.graphics.quality, extensions);
    }

    public static String resolveCubemapSide(String baseLocation, String ... sideSuffixes) throws RuntimeException {
        FileHandle[] files;
        FileHandle loc = Gdx.files.absolute(baseLocation);
        for (FileHandle file : files = loc.list()) {
            for (String suffix : sideSuffixes) {
                if (!file.name().contains("_" + suffix + ".")) continue;
                return file.file().getAbsolutePath().replaceAll("\\\\", "/");
            }
        }
        throw new RuntimeException("Cubemap side '" + TextUtils.arrayToStr(sideSuffixes) + "' not found in folder: " + baseLocation);
    }

    public static synchronized String getGLExtensions() {
        Gdx.gl.glGetIntegerv(33309, buf);
        int extensionCount = buf.get(0);
        if (extensionCount > 0) {
            String[] extensionStrings = new String[extensionCount];
            for (int i = 0; i < extensionCount; ++i) {
                extensionStrings[i] = Gdx.gl30.glGetStringi(7939, i);
            }
            return TextUtils.arrayToStr(extensionStrings);
        }
        return "";
    }

    public static String[] combinations(String[] values) {
        Array combinations = new Array();
        int n = values.length;
        int top = (int)FastMath.pow((double)2.0, (double)n);
        for (int bits = 0; bits < top; ++bits) {
            StringBuilder defines = new StringBuilder();
            String bin = TextUtils.padString(Integer.toBinaryString(bits), n, '0');
            for (int bit = 0; bit < n; ++bit) {
                int idx = n - 1 - bit;
                if (bin.charAt(idx) != '1') continue;
                defines.append(values[bit]);
            }
            combinations.add((Object)defines.toString());
        }
        return (String[])combinations.toArray(String[]::new);
    }

    public static String nObjectsToString(long objects) {
        if ((double)objects > 1.0E18) {
            return String.format("%1$.1f %2$s", (double)objects / 1.0E18, I18n.msg("gui.unit.exa"));
        }
        if ((double)objects > 1.0E15) {
            return String.format("%1$.1f %2$s", (double)objects / 1.0E15, I18n.msg("gui.unit.peta"));
        }
        if ((double)objects > 1.0E12) {
            return String.format("%1$.1f %2$s", (double)objects / 1.0E12, I18n.msg("gui.unit.tera"));
        }
        if ((double)objects > 1.0E9) {
            return String.format("%1$.1f %2$s", (double)objects / 1.0E9, I18n.msg("gui.unit.giga"));
        }
        if ((double)objects > 1000000.0) {
            return String.format("%1$.1f %2$s", (double)objects / 1000000.0, I18n.msg("gui.unit.mega"));
        }
        if ((double)objects > 1000.0) {
            return String.format("%1$.1f %2$s", (double)objects / 1000.0, I18n.msg("gui.unit.kilo"));
        }
        if ((double)objects > 100.0) {
            return String.format("%1$.1f %2$s", (double)objects / 100.0, I18n.msg("gui.unit.hecto"));
        }
        if ((double)objects > 10.0) {
            return String.format("%1$.1f %2$s", (double)objects / 10.0, I18n.msg("gui.unit.deca"));
        }
        return "" + objects;
    }

    public static String msToTimeString(long ms) {
        double seconds = (double)ms / 1000.0;
        double minutes = seconds / 60.0;
        double hours = minutes / 60.0;
        double days = hours / 24.0;
        double years = days / 365.25;
        if (seconds < 60.0) {
            return String.format("%1$.0f %2$s", seconds, I18n.msg("gui.unit.second"));
        }
        if (minutes < 60.0) {
            return String.format("%1$.0f %2$s", minutes, I18n.msg("gui.unit.minute"));
        }
        if (hours < 24.0) {
            return String.format("%1$.0f %2$s", hours, I18n.msg("gui.unit.hour"));
        }
        if (days < 365.25) {
            return String.format("%1$.0f %2$s", days, I18n.msg("gui.unit.day"));
        }
        return String.format("%1$.0f %2$s", years, I18n.msg("gui.unit.year"));
    }

    public void updateSkin() {
        FileHandle fh = Gdx.files.internal("skins/" + Settings.settings.program.ui.theme + "/" + Settings.settings.program.ui.theme + ".json");
        if (!fh.exists()) {
            logger.info("User interface theme '" + Settings.settings.program.ui.theme + "' not found, using 'dark-green' instead");
            Settings.settings.program.ui.theme = "dark-green";
            fh = Gdx.files.internal("skins/" + Settings.settings.program.ui.theme + "/" + Settings.settings.program.ui.theme + ".json");
        }
        this.setSkin(new Skin(fh));
        ObjectMap fonts = this.getSkin().getAll(BitmapFont.class);
        for (String key : fonts.keys()) {
            ((BitmapFont)fonts.get((Object)key)).getRegion().getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        }
    }

    public ShaderProgram getShapeShader() {
        return this.shapeShader;
    }

    public ShaderProgram getSpriteShader() {
        return this.spriteShader;
    }

    public SpriteBatch getSpriteBatch() {
        return this.spriteBatch;
    }

    public ExtShaderProgram getExtSpriteShader() {
        return this.extSpriteShader;
    }

    public ExtSpriteBatch getExtSpriteBatch() {
        return this.extSpriteBatch;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
    }

    public void resize(int width, int height) {
        if (this.spriteBatch != null) {
            this.spriteBatch.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, (float)width, (float)height);
        }
    }
}

