/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.SnapshotArray;
import gaiasky.GaiaSky;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.Link;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnTextTooltip;
import net.jafama.FastMath;

public class GuiUtils {
    private static final ThreadLocal<Vector2> vec2 = ThreadLocal.withInitial(Vector2::new);

    public static void addNotificationWindow(String title, final String message, Skin skin, Stage stage, final Runnable ok) {
        GenericDialog dialog = new GenericDialog(title, skin, stage){

            @Override
            protected void build() {
                OwnLabel msg = new OwnLabel((CharSequence)message, this.skin);
                this.content.add((Actor)msg).pad(pad18).row();
            }

            @Override
            protected boolean accept() {
                if (ok != null) {
                    ok.run();
                }
                return true;
            }

            @Override
            protected void cancel() {
            }

            @Override
            public void dispose() {
            }
        };
        dialog.setAcceptText(I18n.msg("gui.ok"));
        dialog.setCancelText(null);
        dialog.buildSuper();
        dialog.show(stage);
    }

    public static void addNoConnectionWindow(Skin skin, Stage stage) {
        GuiUtils.addNoConnectionWindow(skin, stage, null);
    }

    public static void addNoConnectionWindow(Skin skin, Stage stage, final Runnable ok) {
        String title = I18n.msg("notif.error", I18n.msg("gui.download.noconnection.title"));
        if (Settings.settings.program.offlineMode) {
            title = I18n.msg("gui.system.offlinemode");
        }
        GenericDialog dialog = new GenericDialog(title, skin, stage){

            @Override
            protected void build() {
                if (Settings.settings.program.offlineMode) {
                    OwnLabel info = new OwnLabel((CharSequence)I18n.msg("gui.download.offlinemode.continue"), this.skin);
                    this.content.add((Actor)info).pad(pad18).row();
                    Link docs = new Link((CharSequence)I18n.msg("gui.wiki.moreinfo"), this.skin, "http://docs.gaiasky.space/Config-file.html");
                    this.content.add((Actor)docs).pad(pad18).padTop(pad20).row();
                } else {
                    OwnLabel info = new OwnLabel((CharSequence)I18n.msg("gui.download.noconnection.continue"), this.skin);
                    this.content.add((Actor)info).pad(pad18).row();
                    Link manualDownload = new Link(I18n.msg("gui.download.manual"), this.skin, "link", Settings.settings.program.url.dataMirror);
                    this.content.add((Actor)manualDownload).pad(pad18);
                }
            }

            @Override
            protected boolean accept() {
                if (ok != null) {
                    ok.run();
                }
                return true;
            }

            @Override
            protected void cancel() {
            }

            @Override
            public void dispose() {
            }
        };
        dialog.setAcceptText(I18n.msg("gui.ok"));
        dialog.setCancelText(null);
        dialog.buildSuper();
        dialog.show(stage);
    }

    public static void addNoConnectionExit(Skin skin, Stage stage) {
        GenericDialog exitDialog = new GenericDialog(I18n.msg("notif.error", I18n.msg("gui.download.noconnection.title")), skin, stage){

            @Override
            protected void build() {
                String text = Settings.settings.program.offlineMode ? I18n.msg("gui.download.offlinemode") : I18n.msg("gui.download.noconnection");
                OwnLabel info = new OwnLabel((CharSequence)text, this.skin);
                OwnLabel gsExit = new OwnLabel((CharSequence)I18n.msg("notif.gaiasky.exit"), this.skin);
                Link manualDownload = new Link(I18n.msg("gui.download.manual"), this.skin, "link", "https://gaia.ari.uni-heidelberg.de/gaiasky/files/autodownload");
                this.content.add((Actor)info).left().pad(10.0f).row();
                this.content.add((Actor)gsExit).left().pad(10.0f).row();
                this.content.add((Actor)manualDownload).pad(10.0f);
            }

            @Override
            protected boolean accept() {
                GaiaSky.postRunnable(() -> ((Application)Gdx.app).exit());
                return true;
            }

            @Override
            protected void cancel() {
            }

            @Override
            public void dispose() {
            }
        };
        exitDialog.setAcceptText(I18n.msg("gui.exit"));
        exitDialog.setCancelText(null);
        exitDialog.buildSuper();
        exitDialog.show(stage);
    }

    public static void addNoVRConnectionExit(Skin skin, Stage stage) {
        GenericDialog exitDialog = new GenericDialog(I18n.msg("notif.error", I18n.msg("gui.vr.noconnection.title")), skin, stage){

            @Override
            protected void build() {
                OwnLabel info1 = new OwnLabel((CharSequence)I18n.msg("gui.vr.noconnection.1"), this.skin);
                OwnLabel info2 = new OwnLabel((CharSequence)I18n.msg("gui.vr.noconnection.2"), this.skin);
                OwnLabel gsExit = new OwnLabel((CharSequence)I18n.msg("notif.gaiasky.exit"), this.skin);
                this.content.add((Actor)info1).left().padTop(10.0f).padBottom(5.0f).row();
                this.content.add((Actor)info2).left().padBottom(10.0f).row();
                this.content.add((Actor)gsExit).left().padTop(10.0f).row();
            }

            @Override
            protected boolean accept() {
                GaiaSky.postRunnable(() -> ((Application)Gdx.app).exit());
                return true;
            }

            @Override
            protected void cancel() {
            }

            @Override
            public void dispose() {
            }
        };
        exitDialog.setAcceptText(I18n.msg("gui.exit"));
        exitDialog.setCancelText(null);
        exitDialog.buildSuper();
        exitDialog.show(stage);
    }

    public static void addNoVRDataExit(Skin skin, Stage stage) {
        GenericDialog exitDialog = new GenericDialog(I18n.msg("notif.error", I18n.msg("gui.vr.nodata.title")), skin, stage){

            @Override
            protected void build() {
                OwnLabel info1 = new OwnLabel((CharSequence)I18n.msg("gui.vr.nodata.1"), this.skin);
                OwnLabel info2 = new OwnLabel((CharSequence)I18n.msg("gui.vr.nodata.2"), this.skin);
                OwnLabel gsExit = new OwnLabel((CharSequence)I18n.msg("notif.gaiasky.exit"), this.skin);
                this.content.add((Actor)info1).left().padTop(10.0f).padBottom(5.0f).row();
                this.content.add((Actor)info2).left().padBottom(10.0f).row();
                this.content.add((Actor)gsExit).left().padTop(10.0f).row();
            }

            @Override
            protected boolean accept() {
                GaiaSky.postRunnable(() -> ((Application)Gdx.app).exit());
                return true;
            }

            @Override
            protected void cancel() {
                GaiaSky.postRunnable(() -> ((Application)Gdx.app).exit());
            }

            @Override
            public void dispose() {
            }
        };
        exitDialog.setAcceptText(I18n.msg("gui.exit"));
        exitDialog.setCancelText(null);
        exitDialog.buildSuper();
        exitDialog.show(stage);
    }

    public static HorizontalGroup getTooltipHorizontalGroup(Actor actor, String tooltipText, float space, Skin skin) {
        HorizontalGroup hg = new HorizontalGroup();
        hg.space(space);
        hg.addActor(actor);
        OwnImageButton tooltip = new OwnImageButton(skin, "tooltip");
        tooltip.addListener((EventListener)new OwnTextTooltip(tooltipText, skin));
        hg.addActor((Actor)tooltip);
        return hg;
    }

    public static HorizontalGroup tooltipHg(Actor actor, String key, Skin skin) {
        return GuiUtils.getTooltipHorizontalGroup(actor, I18n.msg(key), 12.8f, skin);
    }

    public static void sliderMove(boolean up, float percent, Slider slider) {
        float max = slider.getMaxValue();
        float min = slider.getMinValue();
        float val = slider.getValue();
        float inc = (max - min) * percent;
        slider.setValue(MathUtils.clamp((float)(val + (up ? inc : -inc)), (float)min, (float)max));
    }

    public static void selectBoxMoveSelection(boolean up, boolean jump, SelectBox<?> selectBox) {
        int index = selectBox.getSelectedIndex();
        index = jump ? (up ? 0 : selectBox.getItems().size - 1) : (up ? FastMath.max((int)(index - 1), (int)0) : (index + 1) % selectBox.getItems().size);
        selectBox.setSelectedIndex(index);
    }

    public static ScrollPane getScrollPaneIn(Actor actor) {
        if (actor instanceof ScrollPane) {
            return (ScrollPane)actor;
        }
        if (actor instanceof WidgetGroup) {
            WidgetGroup group = (WidgetGroup)actor;
            SnapshotArray children = group.getChildren();
            for (Actor child : children) {
                ScrollPane scroll = GuiUtils.getScrollPaneIn(child);
                if (scroll == null) continue;
                return scroll;
            }
        }
        return null;
    }

    public static ScrollPane getScrollPaneAncestor(Actor actor) {
        if (actor == null) {
            return null;
        }
        if (actor instanceof ScrollPane) {
            ScrollPane scroll = (ScrollPane)actor;
            return scroll;
        }
        return GuiUtils.getScrollPaneAncestor((Actor)actor.getParent());
    }

    public static void ensureScrollVisible(Actor actor) {
        if (actor != null) {
            Group parent;
            for (parent = actor.getParent(); parent != null && !(parent instanceof ScrollPane); parent = parent.getParent()) {
            }
            if (parent != null) {
                ScrollPane scrollPane = (ScrollPane)parent;
                Vector2 coordinates = actor.localToAscendantCoordinates(scrollPane.getActor(), vec2.get().set(actor.getX(), actor.getY()));
                scrollPane.scrollTo(coordinates.x, coordinates.y, actor.getWidth(), FastMath.min((float)200.0f, (float)(actor.getHeight() * 10.0f)));
            }
        }
    }

    public static Array<Actor> getInputWidgets(Array<? extends Actor> actors, Array<Actor> list) {
        for (Actor actor : actors) {
            GuiUtils.getInputWidgets(actor, list);
        }
        return list;
    }

    public static Array<Actor> getInputWidgets(Actor actor, Array<Actor> list) {
        if (actor != null) {
            if (GuiUtils.isInputWidget(actor) && GuiUtils.isNotDisabled(actor) && !GuiUtils.isTooltipWidget(actor)) {
                list.add((Object)actor);
            } else if (actor instanceof WidgetGroup) {
                GuiUtils.getInputWidgetsInGroup((WidgetGroup)actor, list);
            }
        }
        return list;
    }

    private static void getInputWidgetsInGroup(WidgetGroup actor, Array<Actor> list) {
        SnapshotArray children = actor.getChildren();
        for (Actor child : children) {
            GuiUtils.getInputWidgets(child, list);
        }
    }

    public static boolean isInputWidget(Actor actor) {
        return actor instanceof SelectBox || actor instanceof TextField || actor instanceof Button || actor instanceof Slider;
    }

    public static boolean isTooltipWidget(Actor actor) {
        return actor instanceof OwnImageButton && ((OwnImageButton)actor).getStyle().imageUp.toString().contains("tooltip");
    }

    public static boolean isNotDisabled(Actor actor) {
        return !(actor instanceof Disableable) || !((Disableable)actor).isDisabled();
    }
}

