/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static boolean isMonochrome(BufferedImage image) {
        return image.getColorModel().getColorSpace().getType() == 6;
    }

    public static boolean monochromeToRGB(File file) throws IOException {
        BufferedImage monochrome = ImageIO.read(file);
        if (ImageUtils.isMonochrome(monochrome)) {
            BufferedImage rgb = ImageUtils.monochromeToRGB(monochrome);
            String extension = file.getName().substring(file.getName().lastIndexOf(46) + 1);
            ImageIO.write((RenderedImage)rgb, extension, file);
            return true;
        }
        return false;
    }

    private static BufferedImage monochromeToRGB(BufferedImage monochrome) {
        int width = monochrome.getWidth();
        int height = monochrome.getHeight();
        BufferedImage rgbImage = new BufferedImage(width, height, 1);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color grayColor = new Color(monochrome.getRGB(x, y));
                rgbImage.setRGB(x, y, grayColor.getRGB());
            }
        }
        return rgbImage;
    }
}

