/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import java.util.Arrays;

public class IntDoubleHeap {
    private int[] indices;
    private double[] values;
    private int size;

    public IntDoubleHeap(int capacity) {
        this.indices = new int[capacity];
        this.values = new double[capacity];
        this.size = 0;
    }

    public void add(int index, double value) {
        this.ensureCapacity();
        this.indices[this.size] = index;
        this.values[this.size] = value;
        this.heapifyUp(this.size);
        ++this.size;
    }

    public double peekValue() {
        if (this.size == 0) {
            throw new IllegalStateException("Heap is empty");
        }
        return this.values[0];
    }

    public int peekIndex() {
        if (this.size == 0) {
            throw new IllegalStateException("Heap is empty");
        }
        return this.indices[0];
    }

    public void poll() {
        if (this.size == 0) {
            throw new IllegalStateException("Heap is empty");
        }
        --this.size;
        this.indices[0] = this.indices[this.size];
        this.values[0] = this.values[this.size];
        this.heapifyDown(0);
    }

    public int maxIndex() {
        if (this.size == 0) {
            throw new IllegalStateException("Heap is empty");
        }
        int maxIdx = 0;
        for (int i = 1; i < this.size; ++i) {
            if (!(this.values[i] > this.values[maxIdx])) continue;
            maxIdx = i;
        }
        return maxIdx;
    }

    public double value(int index) {
        if (this.size == 0) {
            throw new IllegalStateException("Heap is empty");
        }
        return this.values[index];
    }

    public int index(int index) {
        if (this.size == 0) {
            throw new IllegalStateException("Heap is empty");
        }
        return this.indices[index];
    }

    public void remove(int index) {
        if (this.size == 0) {
            throw new IllegalStateException("Heap is empty");
        }
        --this.size;
        this.indices[index] = this.indices[this.size];
        this.values[index] = this.values[this.size];
        this.heapifyDown(index);
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    private void ensureCapacity() {
        if (this.size >= this.indices.length) {
            int newCapacity = this.indices.length * 2;
            this.indices = Arrays.copyOf(this.indices, newCapacity);
            this.values = Arrays.copyOf(this.values, newCapacity);
        }
    }

    public int[] indexArray() {
        return this.indices;
    }

    private void heapifyUp(int i) {
        int parent;
        while (i > 0 && this.values[i] < this.values[parent = (i - 1) / 2]) {
            this.swap(i, parent);
            i = parent;
        }
    }

    private void heapifyDown(int i) {
        while (true) {
            int left = 2 * i + 1;
            int right = 2 * i + 2;
            int smallest = i;
            if (left < this.size && this.values[left] < this.values[smallest]) {
                smallest = left;
            }
            if (right < this.size && this.values[right] < this.values[smallest]) {
                smallest = right;
            }
            if (smallest == i) break;
            this.swap(i, smallest);
            i = smallest;
        }
    }

    private void swap(int i, int j) {
        int tmpIndex = this.indices[i];
        this.indices[i] = this.indices[j];
        this.indices[j] = tmpIndex;
        double tmpValue = this.values[i];
        this.values[i] = this.values[j];
        this.values[j] = tmpValue;
    }
}

