/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.gdx.utils.Array;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.StdRandom;
import java.util.MissingResourceException;
import java.util.Scanner;

public class LoadingTextGenerator {
    private static final int MAX_KEYS = 100;
    private final String[] verbs = this.read("funny.verb.");
    private final String[] adjectives = this.read("funny.adjective.", 4);
    private final String[] objects = this.read("funny.object.");
    private final String[][] set = this.createOrder("funny.order");

    private String[] read(String keyPrefix) {
        return this.read(keyPrefix, 0);
    }

    private String[] read(String keyPrefix, int nBlanks) {
        int i;
        Array strings = new Array();
        for (i = 0; i < 100; ++i) {
            try {
                String s = I18n.msg(keyPrefix + i);
                strings.add((Object)s);
                continue;
            }
            catch (MissingResourceException s) {
                // empty catch block
            }
        }
        if (nBlanks > 0) {
            for (i = 0; i < nBlanks; ++i) {
                strings.add((Object)"");
            }
        }
        String[] out = new String[strings.size];
        for (int i2 = 0; i2 < strings.size; ++i2) {
            out[i2] = (String)strings.get(i2);
        }
        return out;
    }

    private String[][] createOrder(String key) {
        String[] tokens;
        Scanner scanner = new Scanner(I18n.msg(key));
        String order = null;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine().trim();
            if (line.startsWith("#")) continue;
            order = line;
            break;
        }
        String[][] result = null;
        if (order != null && !order.isBlank() && (tokens = order.split("\\s+")).length == 3) {
            result = new String[3][];
            for (int i = 0; i < 3; ++i) {
                if (tokens[i].equalsIgnoreCase("V")) {
                    result[i] = this.verbs;
                    continue;
                }
                if (tokens[i].equalsIgnoreCase("A")) {
                    result[i] = this.adjectives;
                    continue;
                }
                if (!tokens[i].equalsIgnoreCase("O")) continue;
                result[i] = this.objects;
            }
        }
        if (result == null) {
            result = new String[][]{this.verbs, this.adjectives, this.objects};
        }
        return result;
    }

    private String next(int index, String sep) {
        String next = this.set[index][StdRandom.uniform(this.set[index].length)];
        next = !next.isBlank() ? next + sep : "";
        return next;
    }

    public String next() {
        String first = this.next(0, " ");
        String second = this.next(1, " ");
        String third = this.next(2, "");
        return first + second + third;
    }
}

