/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.camera.ICamera;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.time.ITimeFrameProvider;
import java.time.Instant;
import java.util.LinkedList;
import net.jafama.FastMath;

public class LocationLogManager
implements IObserver {
    protected static final Logger.Log logger = Logger.getLogger(LocationLogManager.class);
    private static final int MAX_SIZE = 200;
    private static LocationLogManager instance;
    private final LinkedList<LocationRecord> locations = new LinkedList();

    public static LocationLogManager instance() {
        if (instance == null) {
            LocationLogManager.initialize();
        }
        return instance;
    }

    public static void initialize() {
        instance = new LocationLogManager();
    }

    public LinkedList<LocationRecord> getLocations() {
        return this.locations;
    }

    public void clearLocations() {
        this.locations.clear();
    }

    public void startCapturing() {
        if (!EventManager.instance.isSubscribedTo(this, Event.CAMERA_NEW_CLOSEST)) {
            EventManager.instance.subscribe((IObserver)this, Event.CAMERA_NEW_CLOSEST);
        }
    }

    public void stopCapturing() {
        EventManager.instance.unsubscribe((IObserver)this, Event.CAMERA_NEW_CLOSEST);
    }

    public void addRecord(IFocus object, ICamera camera, ITimeFrameProvider time) {
        if (object != null) {
            Instant entryTime = Instant.now();
            Instant simulationTime = time.getTime();
            String name = object.getClosestLocalizedName();
            boolean found = false;
            int stop = FastMath.max((int)0, (int)(this.locations.size() - 10));
            for (int i = this.locations.size() - 1; i >= stop; --i) {
                if (!this.locations.get((int)i).name.equalsIgnoreCase(name)) continue;
                found = true;
                break;
            }
            if (!found) {
                LocationRecord record = new LocationRecord();
                record.name = name;
                record.entryTime = entryTime;
                record.simulationTime = simulationTime;
                record.position = new Vector3Q().set(camera.getPos());
                record.direction = new Vector3D().set(camera.getDirection());
                record.up = new Vector3D().set(camera.getUp());
                if (this.locations.size() == 200) {
                    this.locations.pollFirst();
                }
                this.locations.add(record);
                EventManager.publish(Event.NEW_LOCATION_RECORD, this, this.locations);
                logger.debug(I18n.msg("gui.locationlog.newrecord", record.toStringFull()));
            }
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.CAMERA_NEW_CLOSEST) {
            IFocus closest = (IFocus)data[0];
            this.addRecord(closest, GaiaSky.instance.getICamera(), GaiaSky.instance.time);
        }
    }

    public static class LocationRecord {
        public String name;
        public Vector3Q position;
        public Vector3D direction;
        public Vector3D up;
        public Instant simulationTime;
        public Instant entryTime;

        public String toString() {
            String elapsedStr = "";
            if (this.entryTime != null) {
                elapsedStr = this.elapsedString();
            }
            return this.name + " (" + I18n.msg("gui.locationlog.ago", elapsedStr) + ")";
        }

        public String elapsedString() {
            long elapsedMs = Instant.now().toEpochMilli() - this.entryTime.toEpochMilli();
            return GlobalResources.msToTimeString(elapsedMs);
        }

        public String toStringFull() {
            return "LocationRecord{\n\tname='" + this.name + "'\n\tposition=" + String.valueOf(this.position) + "\n\tdirection=" + String.valueOf(this.direction) + "\n\tup=" + String.valueOf(this.up) + "\n\tsimulationTime=" + String.valueOf(this.simulationTime) + "\n\tentryTime=" + String.valueOf(this.entryTime) + "\n}";
        }
    }
}

