/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import gaiasky.event.Event;
import gaiasky.event.EventManager;
import java.util.HashMap;
import java.util.Map;

public class Logger {
    private static final Map<String, Log> logObjects;
    public static LoggerLevel level;

    private static void error(Throwable t, String tag) {
        if (Logger.inLevel(LoggerLevel.ERROR)) {
            if (EventManager.instance.hasSubscriptors(Event.JAVA_EXCEPTION)) {
                EventManager.publish(Event.JAVA_EXCEPTION, null, t, tag);
            } else {
                System.err.println(tag);
                t.printStackTrace(System.err);
            }
        }
    }

    private static void error(Throwable t) {
        if (Logger.inLevel(LoggerLevel.ERROR)) {
            if (EventManager.instance.hasSubscriptors(Event.JAVA_EXCEPTION)) {
                EventManager.publish(Event.JAVA_EXCEPTION, null, t);
            } else {
                t.printStackTrace(System.err);
            }
        }
    }

    private static void error(Object ... messages) {
        if (Logger.inLevel(LoggerLevel.ERROR)) {
            Logger.log(LoggerLevel.ERROR, messages);
        }
    }

    private static void warn(Object ... messages) {
        if (Logger.inLevel(LoggerLevel.WARN)) {
            Logger.log(LoggerLevel.WARN, messages);
        }
    }

    private static void info(Object ... messages) {
        if (Logger.inLevel(LoggerLevel.INFO)) {
            Logger.log(LoggerLevel.INFO, messages);
        }
    }

    private static void debug(Object ... messages) {
        if (Logger.inLevel(LoggerLevel.DEBUG)) {
            Logger.log(LoggerLevel.DEBUG, messages);
        }
    }

    public static void log(LoggerLevel level, Object ... messages) {
        Object[] msgs;
        Object msg;
        int idx = -1;
        for (int i = 0; i < messages.length; ++i) {
            msg = messages[i];
            if (!(msg instanceof String) || !((String)msg).contains("{}")) continue;
            idx = i;
            break;
        }
        if (idx >= 0) {
            msg = Logger.parse((String)messages[idx], Logger.removeFirstN(messages, idx + 1));
            msgs = Logger.getFirstNPlus(messages, idx, msg);
        } else {
            msgs = messages;
        }
        EventManager.publish(Event.POST_NOTIFICATION, null, new Object[]{level, msgs});
    }

    private static Object[] removeFirstN(Object[] arr, int n) {
        Object[] res = new Object[arr.length - n];
        if (arr.length - n >= 0) {
            System.arraycopy(arr, n, res, 0, arr.length - n);
        }
        return res;
    }

    private static Object[] getFirstNPlus(Object[] arr, int n, Object additional) {
        Object[] res = new Object[n + 1];
        if (n >= 0) {
            System.arraycopy(arr, 0, res, 0, n);
        }
        res[n] = additional;
        return res;
    }

    private static String parse(String msg, Object ... args) {
        for (Object arg1 : args) {
            String arg = arg1 != null ? arg1.toString() : "null";
            msg = msg.replaceFirst("\\{}", arg);
        }
        return msg;
    }

    private static boolean inLevel(LoggerLevel l) {
        return l.getVal() <= level.getVal();
    }

    public static Log getLogger() {
        return Logger.getLogger("");
    }

    public static Log getLogger(Class<?> clazz) {
        return Logger.getLogger(clazz.getSimpleName());
    }

    public static Log getLogger(String tag) {
        if (logObjects.containsKey(tag)) {
            return logObjects.get(tag);
        }
        Log log = new Log(tag);
        logObjects.put(tag, log);
        return log;
    }

    static {
        level = LoggerLevel.INFO;
        logObjects = new HashMap<String, Log>();
    }

    public static enum LoggerLevel {
        ERROR(0),
        WARN(1),
        INFO(2),
        DEBUG(3);

        public final int val;

        private LoggerLevel(int val) {
            this.val = val;
        }

        public int getVal() {
            return this.val;
        }
    }

    public static class Log {
        private final String tag;

        private Log(Class<?> clazz) {
            this.tag = clazz.getSimpleName();
        }

        private Log(String tag) {
            this.tag = tag;
        }

        public void error(Throwable t) {
            Logger.error(t, this.tag);
        }

        public void error(Throwable t, String message) {
            Logger.error(t, this.prependTag(new String[]{message}));
        }

        public void error(Object ... messages) {
            Logger.error(this.prependTag(messages));
        }

        public void warn(Object ... messages) {
            Logger.warn(this.prependTag(messages));
        }

        public void debug(Object ... messages) {
            Logger.debug(this.prependTag(messages));
        }

        public void info(Object ... messages) {
            Logger.info(this.prependTag(messages));
        }

        public void log(LoggerLevel level, Object ... messages) {
            Logger.log(level, this.prependTag(messages));
        }

        private Object[] prependTag(Object[] msgs) {
            Object[] result = new Object[msgs.length + 1];
            System.arraycopy(msgs, 0, result, 1, msgs.length);
            result[0] = this.tag;
            return result;
        }
    }
}

