/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.gdx.utils.LongMap;

public class LruCacheLong<V> {
    private final int capacity;
    private final LongMap<Node<V>> map;
    private Node<V> head;
    private Node<V> tail;

    public LruCacheLong(int capacity) {
        this.capacity = capacity;
        this.map = new LongMap(capacity);
    }

    public V getLeastRecentlyUsed() {
        return this.tail != null ? (V)this.tail.value : null;
    }

    public V get(long key) {
        Node node = (Node)this.map.get(key);
        if (node == null) {
            return null;
        }
        this.moveToHead(node);
        return node.value;
    }

    public void put(long key, V value) {
        Node node = (Node)this.map.get(key);
        if (node != null) {
            node.value = value;
            this.moveToHead(node);
        } else {
            Node<V> newNode = new Node<V>(key, value);
            this.map.put(key, newNode);
            this.addNode(newNode);
            if (this.map.size > this.capacity) {
                Node<V> tailNode = this.popTail();
                this.map.remove(tailNode.key);
            }
        }
    }

    public boolean containsKey(long key) {
        return this.map.containsKey(key);
    }

    public V remove(long key) {
        Node node = (Node)this.map.remove(key);
        if (node == null) {
            return null;
        }
        this.removeNode(node);
        return node.value;
    }

    public int size() {
        return this.map.size;
    }

    public void clear() {
        this.map.clear();
        this.tail = null;
        this.head = null;
    }

    private void addNode(Node<V> node) {
        node.next = this.head;
        node.prev = null;
        if (this.head != null) {
            this.head.prev = node;
        }
        this.head = node;
        if (this.tail == null) {
            this.tail = node;
        }
    }

    private void removeNode(Node<V> node) {
        if (node.prev != null) {
            node.prev.next = node.next;
        } else {
            this.head = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        } else {
            this.tail = node.prev;
        }
    }

    private void moveToHead(Node<V> node) {
        this.removeNode(node);
        this.addNode(node);
    }

    private Node<V> popTail() {
        Node<V> node = this.tail;
        this.removeNode(node);
        return node;
    }

    private static class Node<V> {
        long key;
        V value;
        Node<V> prev;
        Node<V> next;

        Node(long key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

