/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.render.ComponentTypes;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.time.ITimeFrameProvider;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class MasterManager
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(MasterManager.class);
    private static final long RECONNECT_TIME_MS = 5000L;
    public static MasterManager instance;
    private final List<String> slaves;
    private final HttpClient http;
    private byte[] slaveStates;
    private byte[] slaveFlags;
    private long[] slavePingTimes;
    private ResponseHandler[] responseHandlers;
    private ExceptHandler[] exceptHandlers;

    private MasterManager() {
        int i;
        this.slaves = Settings.settings.program.net.master.slaves;
        if (this.slaves != null && !this.slaves.isEmpty()) {
            this.slaveStates = new byte[this.slaves.size()];
            this.slaveFlags = new byte[this.slaves.size()];
            this.slavePingTimes = new long[this.slaves.size()];
            for (i = 0; i < this.slaveStates.length; ++i) {
                this.slaveStates[i] = 0;
                this.slaveFlags[i] = 0;
                this.slavePingTimes[i] = 0L;
            }
        }
        if (this.slaves != null && !this.slaves.isEmpty()) {
            this.responseHandlers = new ResponseHandler[this.slaves.size()];
            this.exceptHandlers = new ExceptHandler[this.slaves.size()];
            for (i = 0; i < this.slaveStates.length; ++i) {
                this.responseHandlers[i] = new ResponseHandler(i);
                this.exceptHandlers[i] = new ExceptHandler(i);
            }
        }
        this.http = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
        EventManager.instance.subscribe((IObserver)this, Event.TOGGLE_VISIBILITY_CMD, Event.STAR_BRIGHTNESS_CMD, Event.STAR_BASE_LEVEL_CMD, Event.STAR_POINT_SIZE_CMD, Event.DISPOSE);
    }

    public static void initialize() {
        if (Settings.settings.program.net.slave.active && Settings.settings.program.net.master.active) {
            logger.error("Can't be master and slave at the same time!");
            return;
        }
        if (Settings.settings.program.net.master.active) {
            instance = new MasterManager();
        }
    }

    public static boolean hasSlaves() {
        return instance != null && MasterManager.instance.slaves != null && !MasterManager.instance.slaves.isEmpty();
    }

    public boolean isSlaveConnected(String slaveName) {
        return this.isSlaveConnected(this.getSlaveIndex(slaveName));
    }

    public int getSlaveIndex(String slaveName) {
        return this.slaves.indexOf(slaveName);
    }

    public boolean isSlaveConnected(int index) {
        if (index >= 0 && index < this.slaves.size()) {
            return this.slaveStates[index] == 0;
        }
        return false;
    }

    public byte[] getSlaveStates() {
        return this.slaveStates;
    }

    public void boardcastCameraAndTime(Vector3Q pos, Vector3D dir, Vector3D up, ITimeFrameProvider time) {
        String spos = TextUtils.surround(pos.toString(), "[", "]");
        String sdir = TextUtils.surround(dir.toString(), "[", "]");
        String sup = TextUtils.surround(up.toString(), "[", "]");
        String stime = Long.toString(time.getTime().toEpochMilli());
        boolean slaveOffline = false;
        int i = 0;
        for (String slave : this.slaves) {
            if (this.slaveStates[i] == 0 || this.slaveFlags[i] == 1) {
                HttpRequest req = HttpRequest.newBuilder().uri(URI.create(slave + "setCameraStateAndTime?arg0=" + spos + "&arg1=" + sdir + "&arg2=" + sup + "&arg3=" + stime)).GET().build();
                try {
                    ((CompletableFuture)this.http.sendAsync(req, this.rhandler(i)).thenApply(HttpResponse::body)).exceptionally((Function)this.ehandler(i));
                }
                catch (Exception e) {
                    logger.error(e);
                }
                if (this.slaveFlags[i] == 1) {
                    this.slaveFlags[i] = 0;
                }
            } else {
                slaveOffline = this.slaveStates[i] == -1;
            }
            ++i;
        }
        if (slaveOffline) {
            long now = System.currentTimeMillis();
            for (i = 0; i < this.slaveFlags.length; ++i) {
                if (this.slaveStates[i] >= 0 || now - this.slavePingTimes[i] <= 5000L) continue;
                this.slaveFlags[i] = 1;
            }
        }
    }

    public void boardcastCamera(Vector3D pos, Vector3D dir, Vector3D up) {
        String spos = TextUtils.surround(pos.toString(), "[", "]");
        String sdir = TextUtils.surround(dir.toString(), "[", "]");
        String sup = TextUtils.surround(up.toString(), "[", "]");
        int i = 0;
        for (String slave : this.slaves) {
            if (this.slaveStates[i] == 0) {
                HttpRequest req = HttpRequest.newBuilder().uri(URI.create(slave + "setCameraState?arg0=" + spos + "&arg1=" + sdir + "&arg2=" + sup)).GET().build();
                ((CompletableFuture)this.http.sendAsync(req, this.rhandler(i)).thenApply(HttpResponse::body)).exceptionally((Function)this.ehandler(i));
            }
            ++i;
        }
    }

    public void setSlaveYaw(String slave, float yaw) {
        String syaw = Float.toString(yaw);
        if (this.isSlaveConnected(slave)) {
            int i = this.getSlaveIndex(slave);
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(slave + "setProjectionYaw?arg0=" + syaw)).GET().build();
            ((CompletableFuture)this.http.sendAsync(req, this.rhandler(i)).thenApply(HttpResponse::body)).exceptionally((Function)this.ehandler(i));
        }
    }

    public void setSlavePitch(String slave, float pitch) {
        String spitch = Float.toString(pitch);
        if (this.isSlaveConnected(slave)) {
            int i = this.getSlaveIndex(slave);
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(slave + "setProjectionPitch?arg0=" + spitch)).GET().build();
            ((CompletableFuture)this.http.sendAsync(req, this.rhandler(i)).thenApply(HttpResponse::body)).exceptionally((Function)this.ehandler(i));
        }
    }

    public void setSlaveRoll(String slave, float roll) {
        String sroll = Float.toString(roll);
        if (this.isSlaveConnected(slave)) {
            int i = this.getSlaveIndex(slave);
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(slave + "setProjectionRoll?arg0=" + sroll)).GET().build();
            ((CompletableFuture)this.http.sendAsync(req, this.rhandler(i)).thenApply(HttpResponse::body)).exceptionally((Function)this.ehandler(i));
        }
    }

    public void setSlaveFov(String slave, float fov) {
        String sfov = Float.toString(fov);
        if (this.isSlaveConnected(slave)) {
            int i = this.getSlaveIndex(slave);
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(slave + "setProjectionFov?arg0=" + sfov)).GET().build();
            ((CompletableFuture)this.http.sendAsync(req, this.rhandler(i)).thenApply(HttpResponse::body)).exceptionally((Function)this.ehandler(i));
        }
    }

    public List<String> getSlaves() {
        return this.slaves;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case TOGGLE_VISIBILITY_CMD: {
                Boolean state;
                String key = (String)data[0];
                if (data.length == 2) {
                    state = (Boolean)data[1];
                } else {
                    ComponentTypes.ComponentType ct = ComponentTypes.ComponentType.getFromKey(key);
                    state = Settings.settings.scene.visibility.get(ct.toString());
                }
                int i = 0;
                for (String slave : this.slaves) {
                    if (this.slaveStates[i] == 0) {
                        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(slave + "setVisibility?arg0=" + key + "&arg1=" + state.toString())).GET().build();
                        ((CompletableFuture)this.http.sendAsync(req, this.rhandler(i)).thenApply(HttpResponse::body)).exceptionally((Function)this.ehandler(i));
                    }
                    ++i;
                }
                break;
            }
            case STAR_BRIGHTNESS_CMD: {
                float brightness = MathUtilsDouble.lint(((Float)data[0]).floatValue(), 0.4f, 8.0f, 0.0f, 100.0f);
                String sbr = Float.toString(brightness);
                int i = 0;
                for (String slave : this.slaves) {
                    if (this.slaveStates[i] == 0) {
                        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(slave + "setStarBrightness?arg0=" + sbr)).GET().build();
                        ((CompletableFuture)this.http.sendAsync(req, this.rhandler(i)).thenApply(HttpResponse::body)).exceptionally((Function)this.ehandler(i));
                    }
                    ++i;
                }
                break;
            }
            case STAR_POINT_SIZE_CMD: {
                float size = ((Float)data[0]).floatValue();
                String ssize = Float.toString(size);
                int i = 0;
                for (String slave : this.slaves) {
                    if (this.slaveStates[i] == 0) {
                        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(slave + "setStarSize?arg0=" + ssize)).GET().build();
                        ((CompletableFuture)this.http.sendAsync(req, this.rhandler(i)).thenApply(HttpResponse::body)).exceptionally((Function)this.ehandler(i));
                    }
                    ++i;
                }
                break;
            }
            case STAR_BASE_LEVEL_CMD: {
                float opacity = ((Float)data[0]).floatValue();
                String sop = Float.toString(opacity);
                int i = 0;
                for (String slave : this.slaves) {
                    if (this.slaveStates[i] == 0) {
                        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(slave + "setMinStarOpacity?arg0=" + sop)).GET().build();
                        ((CompletableFuture)this.http.sendAsync(req, this.rhandler(i)).thenApply(HttpResponse::body)).exceptionally((Function)this.ehandler(i));
                    }
                    ++i;
                }
                break;
            }
            case DISPOSE: {
                int i = 0;
                for (String slave : this.slaves) {
                    if (this.slaveStates[i] == 0) {
                        HttpRequest req = HttpRequest.newBuilder().uri(URI.create(slave + "quit")).GET().build();
                        ((CompletableFuture)this.http.sendAsync(req, this.rhandler(i)).thenApply(HttpResponse::body)).exceptionally((Function)this.ehandler(i));
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private ResponseHandler rhandler(int index) {
        return this.responseHandlers[index];
    }

    private ExceptHandler ehandler(int index) {
        return this.exceptHandlers[index];
    }

    private void markSlaveOffline(int index) {
        this.slaveEvent(index, -1);
        this.slaveStates[index] = -1;
        this.slavePingTimes[index] = System.currentTimeMillis();
    }

    private void makeSlaveOnline(int index) {
        this.slaveEvent(index, 0);
        this.slaveStates[index] = 0;
    }

    private void slaveEvent(int idx, int newState) {
        if (this.slaveStates[idx] != newState) {
            EventManager.publish(Event.SLAVE_CONNECTION_EVENT, this, idx, this.slaves.get(idx), newState >= 0);
        }
    }

    private class ResponseHandler
    implements HttpResponse.BodyHandler<String> {
        private final int idx;

        public ResponseHandler(int idx) {
            this.idx = idx;
        }

        @Override
        public HttpResponse.BodySubscriber apply(HttpResponse.ResponseInfo responseInfo) {
            if (responseInfo.statusCode() != 200) {
                MasterManager.this.markSlaveOffline(this.idx);
                logger.error("Connection failed for slave " + this.idx + " (" + MasterManager.this.slaves.get(this.idx) + ")");
            } else {
                MasterManager.this.makeSlaveOnline(this.idx);
            }
            return HttpResponse.BodySubscribers.discarding();
        }
    }

    private class ExceptHandler
    implements Function<Throwable, String> {
        private final int idx;

        public ExceptHandler(int idx) {
            this.idx = idx;
        }

        @Override
        public String apply(Throwable throwable) {
            logger.error("Connection failed for slave " + this.idx + " (" + MasterManager.this.slaves.get(this.idx) + ") with " + throwable.getMessage());
            MasterManager.this.markSlaveOffline(this.idx);
            return null;
        }
    }
}

