/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import gaiasky.util.Bits;
import gaiasky.util.Pair;
import gaiasky.util.gdx.IntMeshPartBuilder;
import gaiasky.util.gdx.IntModelBuilder;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.shader.Material;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ModelCache {
    public static ModelCache cache = new ModelCache();
    final Map<String, IntModel> modelCache = new HashMap<String, IntModel>();
    public IntModelBuilder mb = new IntModelBuilder();

    public Pair<IntModel, Map<String, Material>> getModel(String shape, Map<String, Object> params, Bits attributes, int primitiveType) {
        Material mat;
        String key = this.getKey(shape, params, attributes, primitiveType);
        IntModel model = null;
        HashMap<String, Material> materials = new HashMap<String, Material>();
        if (this.modelCache.containsKey(key)) {
            model = this.modelCache.get(key);
            mat = (Material)model.materials.first();
        } else {
            mat = new Material();
            switch (shape) {
                case "sphere": {
                    int quality = ((Long)params.get("quality")).intValue();
                    float diameter = params.containsKey("diameter") ? ((Double)params.get("diameter")).floatValue() : 1.0f;
                    float oblateness = params.containsKey("oblateness") ? ((Double)params.get("oblateness")).floatValue() : 0.0f;
                    boolean flip = params.containsKey("flip") ? (Boolean)params.get("flip") : false;
                    model = this.mb.createSphere(diameter, diameter, diameter * (1.0f - oblateness), quality, quality, flip, primitiveType, mat, attributes);
                    this.modelCache.put(key, model);
                    break;
                }
                case "icosphere": {
                    int recursion = ((Long)params.get("recursion")).intValue();
                    float diameter = params.containsKey("diameter") ? ((Double)params.get("diameter")).floatValue() : 1.0f;
                    boolean flip = params.containsKey("flip") ? (Boolean)params.get("flip") : false;
                    model = this.mb.createIcoSphere(diameter / 2.0f, recursion, flip, false, primitiveType, mat, attributes);
                    this.modelCache.put(key, model);
                    break;
                }
                case "octahedronsphere": {
                    int divisions = ((Long)params.get("divisions")).intValue();
                    float diameter = params.containsKey("diameter") ? ((Double)params.get("diameter")).floatValue() : 1.0f;
                    boolean flip = params.containsKey("flip") ? (Boolean)params.get("flip") : false;
                    model = this.mb.createOctahedronSphere(diameter / 2.0f, divisions, flip, false, primitiveType, mat, attributes);
                    this.modelCache.put(key, model);
                    break;
                }
                case "plane": 
                case "patch": 
                case "surface": 
                case "billboard": {
                    float side;
                    int divisionsU = ((Long)params.get("divisionsu")).intValue();
                    int divisionsV = ((Long)params.get("divisionsv")).intValue();
                    float width = side = params.containsKey("size") ? ((Double)params.get("size")).floatValue() : (params.containsKey("side") ? ((Double)params.get("side")).floatValue() : -1.0f);
                    float height = side;
                    if (side < 0.0f) {
                        width = ((Double)params.get("width")).floatValue();
                        height = ((Double)params.get("height")).floatValue();
                    }
                    boolean flip = params.containsKey("flip") ? (Boolean)params.get("flip") : false;
                    model = this.mb.createPlane(width, height, divisionsU, divisionsV, flip, primitiveType, mat, attributes);
                    this.modelCache.put(key, model);
                    break;
                }
                case "disc": {
                    float diameter2 = (params.containsKey("diameter") ? ((Double)params.get("diameter")).floatValue() : 1.0f) / 2.0f;
                    IntMeshPartBuilder.VertexInfo vt00 = new IntMeshPartBuilder.VertexInfo();
                    vt00.setPos(-diameter2, 0.0f, -diameter2);
                    vt00.setNor(0.0f, 1.0f, 0.0f);
                    vt00.setUV(0.0f, 0.0f);
                    IntMeshPartBuilder.VertexInfo vt01 = new IntMeshPartBuilder.VertexInfo();
                    vt01.setPos(diameter2, 0.0f, -diameter2);
                    vt01.setNor(0.0f, 1.0f, 0.0f);
                    vt01.setUV(0.0f, 1.0f);
                    IntMeshPartBuilder.VertexInfo vt11 = new IntMeshPartBuilder.VertexInfo();
                    vt11.setPos(diameter2, 0.0f, diameter2);
                    vt11.setNor(0.0f, 1.0f, 0.0f);
                    vt11.setUV(1.0f, 1.0f);
                    IntMeshPartBuilder.VertexInfo vt10 = new IntMeshPartBuilder.VertexInfo();
                    vt10.setPos(-diameter2, 0.0f, diameter2);
                    vt10.setNor(0.0f, 1.0f, 0.0f);
                    vt10.setUV(1.0f, 0.0f);
                    IntMeshPartBuilder.VertexInfo vb00 = new IntMeshPartBuilder.VertexInfo();
                    vb00.setPos(-diameter2, 0.0f, -diameter2);
                    vb00.setNor(0.0f, 1.0f, 0.0f);
                    vb00.setUV(0.0f, 0.0f);
                    IntMeshPartBuilder.VertexInfo vb01 = new IntMeshPartBuilder.VertexInfo();
                    vb01.setPos(diameter2, 0.0f, -diameter2);
                    vb01.setNor(0.0f, 1.0f, 0.0f);
                    vb01.setUV(0.0f, 1.0f);
                    IntMeshPartBuilder.VertexInfo vb11 = new IntMeshPartBuilder.VertexInfo();
                    vb11.setPos(diameter2, 0.0f, diameter2);
                    vb11.setNor(0.0f, 1.0f, 0.0f);
                    vb11.setUV(1.0f, 1.0f);
                    IntMeshPartBuilder.VertexInfo vb10 = new IntMeshPartBuilder.VertexInfo();
                    vb10.setPos(-diameter2, 0.0f, diameter2);
                    vb10.setNor(0.0f, 1.0f, 0.0f);
                    vb10.setUV(1.0f, 0.0f);
                    this.mb.begin();
                    this.mb.part("up", primitiveType, attributes, mat).rect(vt00, vt01, vt11, vt10);
                    this.mb.part("down", primitiveType, attributes, mat).rect(vb00, vb10, vb11, vb01);
                    model = this.mb.end();
                    break;
                }
                case "twofacedbillboard": {
                    float diameter2 = (params.containsKey("diameter") ? ((Double)params.get("diameter")).floatValue() : 1.0f) / 2.0f;
                    IntMeshPartBuilder.VertexInfo vt00 = new IntMeshPartBuilder.VertexInfo();
                    vt00.setPos(-diameter2, -diameter2, 0.0f);
                    vt00.setNor(0.0f, 1.0f, 0.0f);
                    vt00.setUV(1.0f, 1.0f);
                    IntMeshPartBuilder.VertexInfo vt01 = new IntMeshPartBuilder.VertexInfo();
                    vt01.setPos(-diameter2, diameter2, 0.0f);
                    vt01.setNor(0.0f, 1.0f, 0.0f);
                    vt01.setUV(1.0f, 0.0f);
                    IntMeshPartBuilder.VertexInfo vt11 = new IntMeshPartBuilder.VertexInfo();
                    vt11.setPos(diameter2, diameter2, 0.0f);
                    vt11.setNor(0.0f, 1.0f, 0.0f);
                    vt11.setUV(0.0f, 0.0f);
                    IntMeshPartBuilder.VertexInfo vt10 = new IntMeshPartBuilder.VertexInfo();
                    vt10.setPos(diameter2, -diameter2, 0.0f);
                    vt10.setNor(0.0f, 1.0f, 0.0f);
                    vt10.setUV(0.0f, 1.0f);
                    IntMeshPartBuilder.VertexInfo vb00 = new IntMeshPartBuilder.VertexInfo();
                    vb00.setPos(-diameter2, -diameter2, 0.0f);
                    vb00.setNor(0.0f, 1.0f, 0.0f);
                    vb00.setUV(1.0f, 1.0f);
                    IntMeshPartBuilder.VertexInfo vb01 = new IntMeshPartBuilder.VertexInfo();
                    vb01.setPos(-diameter2, diameter2, 0.0f);
                    vb01.setNor(0.0f, 1.0f, 0.0f);
                    vb01.setUV(1.0f, 0.0f);
                    IntMeshPartBuilder.VertexInfo vb11 = new IntMeshPartBuilder.VertexInfo();
                    vb11.setPos(diameter2, diameter2, 0.0f);
                    vb11.setNor(0.0f, 1.0f, 0.0f);
                    vb11.setUV(0.0f, 0.0f);
                    IntMeshPartBuilder.VertexInfo vb10 = new IntMeshPartBuilder.VertexInfo();
                    vb10.setPos(diameter2, -diameter2, 0.0f);
                    vb10.setNor(0.0f, 1.0f, 0.0f);
                    vb10.setUV(0.0f, 1.0f);
                    this.mb.begin();
                    this.mb.part("up", primitiveType, attributes, mat).rect(vt00, vt01, vt11, vt10);
                    this.mb.part("down", primitiveType, attributes, mat).rect(vb00, vb10, vb11, vb01);
                    model = this.mb.end();
                    break;
                }
                case "cylinder": {
                    float width = ((Double)params.get("width")).floatValue();
                    float height = ((Double)params.get("height")).floatValue();
                    float depth = ((Double)params.get("depth")).floatValue();
                    int divisions = ((Long)params.get("divisions")).intValue();
                    boolean flip = params.containsKey("flip") ? (Boolean)params.get("flip") : false;
                    model = this.mb.createCylinder(width, height, depth, divisions, flip, primitiveType, mat, attributes);
                    break;
                }
                case "ring": {
                    boolean sph;
                    Material ringMat = new Material();
                    materials.put("ring", ringMat);
                    int quality = ((Long)params.get("quality")).intValue();
                    int divisions = ((Long)params.get("divisions")).intValue();
                    float innerRad = ((Double)params.get("innerradius")).floatValue();
                    float outerRad = ((Double)params.get("outerradius")).floatValue();
                    boolean bl = sph = params.containsKey("sphere-in-ring") ? (Boolean)params.get("sphere-in-ring") : true;
                    if (sph) {
                        model = ModelCache.cache.mb.createSphereRing(1.0f, quality, quality, innerRad, outerRad, divisions, primitiveType, mat, ringMat, attributes);
                        break;
                    }
                    model = ModelCache.cache.mb.createRing(1.0f, quality, quality, innerRad, outerRad, divisions, primitiveType, mat, ringMat, attributes);
                    break;
                }
                case "cone": {
                    float width = ((Double)params.get("width")).floatValue();
                    float height = ((Double)params.get("height")).floatValue();
                    float depth = ((Double)params.get("depth")).floatValue();
                    int divisions = ((Long)params.get("divisions")).intValue();
                    int hDivisions = 0;
                    if (params.containsKey("hdivisions")) {
                        hDivisions = ((Long)params.get("hdivisions")).intValue();
                    }
                    if (hDivisions == 0) {
                        model = this.mb.createCone(width, height, depth, divisions, primitiveType, mat, attributes);
                        break;
                    }
                    model = this.mb.createCone(width, height, depth, divisions, hDivisions, primitiveType, mat, attributes);
                    break;
                }
                case "cube": 
                case "box": {
                    float depth;
                    float height;
                    float width;
                    if (params.containsKey("width")) {
                        width = ((Double)params.get("width")).floatValue();
                        height = ((Double)params.get("height")).floatValue();
                        depth = ((Double)params.get("depth")).floatValue();
                    } else {
                        width = ((Double)params.get("size")).floatValue();
                        height = ((Double)params.get("size")).floatValue();
                        depth = ((Double)params.get("size")).floatValue();
                    }
                    boolean flip = params.containsKey("flip") ? (Boolean)params.get("flip") : false;
                    model = this.mb.createBox(width, height, depth, flip, mat, attributes);
                }
            }
        }
        materials.put("base", mat);
        return new Pair<IntModel, Map<String, Material>>(model, materials);
    }

    private String getKey(String shape, Map<String, Object> params, Bits attributes, int primitiveType) {
        Object[] par;
        StringBuilder key = new StringBuilder(shape + "-" + String.valueOf(attributes) + "-" + primitiveType);
        Set<String> keys = params.keySet();
        for (Object object : par = keys.toArray()) {
            key.append("-").append(params.get(object.toString()));
        }
        return key.toString();
    }

    public void dispose() {
        Collection<IntModel> models = this.modelCache.values();
        for (IntModel model : models) {
            try {
                model.dispose();
            }
            catch (Exception exception) {}
        }
    }
}

