/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import gaiasky.util.Settings;
import gaiasky.util.gdx.g2d.ExtSpriteBatch;
import gaiasky.util.gdx.graphics.TextureView;

public class RenderUtils {
    public static void renderBackbuffer(FrameBuffer fb, SpriteBatch sb, Graphics g) {
        Texture tex = (Texture)fb.getColorBufferTexture();
        sb.begin();
        sb.draw(tex, 0.0f, 0.0f, (float)tex.getWidth(), (float)tex.getHeight(), 0.0f, 0.0f, 1.0f, 1.0f);
        sb.end();
    }

    public static void renderKeepAspect(FrameBuffer fb, SpriteBatch sb, Graphics g) {
        RenderUtils.renderKeepAspect(fb, sb, g, null);
    }

    public static void renderKeepAspect(FrameBuffer fb, SpriteBatch sb, Graphics g, Vector2 lastSize) {
        RenderUtils.renderKeepAspect((Texture)fb.getColorBufferTexture(), sb, g, lastSize);
    }

    public static void renderKeepAspect(Texture tex, SpriteBatch sb, Graphics g, Vector2 lastSize) {
        int sy;
        int sx;
        float tw = tex.getWidth();
        float th = tex.getHeight();
        float tar = tw / th;
        float gw = (float)((double)g.getWidth() * Settings.settings.graphics.backBufferScale);
        float gh = (float)((double)g.getHeight() * Settings.settings.graphics.backBufferScale);
        float gar = gw / gh;
        if (lastSize != null && (tw != lastSize.x || th != lastSize.y)) {
            Matrix4 mat = sb.getProjectionMatrix();
            mat.setToOrtho2D(0.0f, 0.0f, tw, th);
        }
        float x = 0.0f;
        float y = 0.0f;
        float w = tw;
        int sw = (int)gw;
        int sh = (int)gh;
        if (gw > tw && gh > th) {
            x = 0.0f;
            y = 0.0f;
            if (gar > tar) {
                sw = (int)tw;
                sh = (int)(tw / gar);
            } else {
                sw = (int)(th * gar);
                sh = (int)th;
            }
            sx = (int)((tw - (float)sw) / 2.0f);
            sy = (int)((th - (float)sh) / 2.0f);
        } else if (tw >= gw) {
            sx = (int)((tw - gw) / 2.0f);
            if (th >= gh) {
                sy = (int)((th - gh) / 2.0f);
            } else {
                x = 0.0f;
                y = 0.0f;
                sw = (int)(th * gar);
                sh = (int)th;
                sx = (int)((tw - (float)sw) / 2.0f);
                sy = (int)((th - (float)sh) / 2.0f);
            }
        } else {
            w = gw;
            x = 0.0f;
            y = 0.0f;
            w = tw;
            sw = (int)tw;
            sh = (int)(tw / gar);
            sx = (int)((tw - (float)sw) / 2.0f);
            sy = (int)((th - (float)sh) / 2.0f);
        }
        sb.begin();
        sb.draw(tex, x, y, w, th, sx, sy, sw, sh, false, true);
        sb.end();
        if (lastSize != null) {
            lastSize.set(tw, th);
        }
    }

    public static void renderKeepAspect(TextureView tex, ExtSpriteBatch sb, Graphics g, Vector2 lastSize) {
        int sy;
        int sx;
        float tw = tex.getWidth();
        float th = tex.getHeight();
        float tar = tw / th;
        float gw = (float)((double)g.getWidth() * Settings.settings.graphics.backBufferScale);
        float gh = (float)((double)g.getHeight() * Settings.settings.graphics.backBufferScale);
        float gar = gw / gh;
        if (lastSize != null && (tw != lastSize.x || th != lastSize.y)) {
            Matrix4 mat = sb.getProjectionMatrix();
            mat.setToOrtho2D(0.0f, 0.0f, tw, th);
        }
        float x = 0.0f;
        float y = 0.0f;
        float w = tw;
        int sw = (int)gw;
        int sh = (int)gh;
        if (gw > tw && gh > th) {
            x = 0.0f;
            y = 0.0f;
            if (gar > tar) {
                sw = (int)tw;
                sh = (int)(tw / gar);
            } else {
                sw = (int)(th * gar);
                sh = (int)th;
            }
            sx = (int)((tw - (float)sw) / 2.0f);
            sy = (int)((th - (float)sh) / 2.0f);
        } else if (tw >= gw) {
            sx = (int)((tw - gw) / 2.0f);
            if (th >= gh) {
                sy = (int)((th - gh) / 2.0f);
            } else {
                x = 0.0f;
                y = 0.0f;
                sw = (int)(th * gar);
                sh = (int)th;
                sx = (int)((tw - (float)sw) / 2.0f);
                sy = (int)((th - (float)sh) / 2.0f);
            }
        } else {
            w = gw;
            x = 0.0f;
            y = 0.0f;
            w = tw;
            sw = (int)tw;
            sh = (int)(tw / gar);
            sx = (int)((tw - (float)sw) / 2.0f);
            sy = (int)((th - (float)sh) / 2.0f);
        }
        sb.begin();
        sb.draw(tex, x, y, w, th, sx, sy, sw, sh, false, true);
        sb.end();
        if (lastSize != null) {
            lastSize.set(tw, th);
        }
    }
}

