/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.main.KeyBindings;
import gaiasky.gui.main.ModePopupInfo;
import gaiasky.input.AbstractGamepadListener;
import gaiasky.render.ComponentTypes;
import gaiasky.render.postprocess.effects.CubmeapProjectionEffect;
import gaiasky.util.Constants;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.SettingsObject;
import gaiasky.util.SlaveManager;
import gaiasky.util.camera.rec.KeyframesManager;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.update.VersionChecker;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jafama.FastMath;

public class Settings
extends SettingsObject {
    public static final int SOURCE_VERSION = 3061001;
    public static final String ASSETS_LOC = new File(System.getProperty("assets.location") != null ? System.getProperty("assets.location") : ".").getAbsolutePath();
    public static final String APPLICATION_SHORT_NAME = "gaiasky";
    public static final String HOMEPAGE = "https://gaiasky.space";
    public static final String HOMEPAGE_DOWNLOADS = "https://gaiasky.space/downloads";
    public static final String DOCUMENTATION = "http://docs.gaiasky.space";
    public static final String REPOSITORY = "https://codeberg.org/gaiasky/gaiasky";
    public static final String SOCIAL_MEDIA_NAME = "#GaiaSky";
    public static final String SOCIAL_MEDIA_URL = "https://mastodon.social/tags/GaiaSky";
    public static final String ICON_URL;
    public static final String REPO_ISSUES = "https://codeberg.org/gaiasky/gaiasky/issues";
    public static final String AUTHOR_NAME = "Toni Sagrist\u00e0 Sell\u00e9s";
    public static final String AUTHOR_NAME_PLAIN = "Toni Sagrista Selles";
    public static final String AUTHOR_EMAIL = "tsagrista@ari.uni-heidelberg.de";
    public static final String AUTHOR_AFFILIATION = "Universit\u00e4t Heidelberg, Zentrum f\u00fcr Astronomie, Astronomisches Rechen-Institut";
    public static final String AUTHOR_AFFILIATION_PLAIN = "Universitaet Heidelberg, Zentrum fuer Astronomie, Astronomisches Rechen-Institut";
    public static final String AUTHOR_WEBSITE_TEXT = "tonisagrista.com";
    public static final String AUTHOR_WEBSITE_FULL = "https://tonisagrista.com";
    public static final String LICENSE_URL = "https://opensource.org/licenses/MPL-2.0";
    private static final Logger.Log logger;
    public static String APPLICATION_NAME;
    public static String APPLICATION_NAME_TITLE;
    public static Settings settings;
    public int configVersion;
    @JsonIgnore
    public boolean initialized = false;
    @JsonIgnore
    public VersionSettings version;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DataSettings data;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PerformanceSettings performance;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GraphicsSettings graphics;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SceneSettings scene;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ProgramSettings program;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ControlsSettings controls;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public FrameSettings frame;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ScreenshotSettings screenshot;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CamrecorderSettings camrecorder;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PostprocessSettings postprocess;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SpacecraftSettings spacecraft;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ProxySettings proxy;
    @JsonIgnore
    public RuntimeSettings runtime;
    @JsonIgnore
    private AtomicBoolean enabled = new AtomicBoolean(true);

    public static boolean setSettingsReference(Settings s) {
        if (s != null) {
            if (settings != null) {
                settings.setEnabled(false);
                settings.dispose();
            }
            settings = s;
            settings.setEnabled(true);
            return true;
        }
        return false;
    }

    @JsonIgnore
    public void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }

    @Override
    @JsonIgnore
    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void initialize() {
        this.parent = null;
        this.setParentRecursive(this);
        this.setupListeners();
        this.initialized = true;
    }

    public static Path assetsPath(String relativeAssetsLoc) {
        return Path.of(ASSETS_LOC, relativeAssetsLoc);
    }

    public static String assetsFileStr(String relativeAssetsLoc) {
        return Settings.assetsPath(relativeAssetsLoc).toString();
    }

    public static String getApplicationTitle(boolean vr) {
        return APPLICATION_NAME_TITLE + (vr ? "\nVR" : "");
    }

    public static String getShortApplicationName() {
        return APPLICATION_SHORT_NAME + Settings.settings.program.net.getNetName() + " " + Settings.settings.version.version + " (build " + Settings.settings.version.build + ")";
    }

    public static String getSuperShortApplicationName() {
        return APPLICATION_NAME + " " + Settings.settings.version.version;
    }

    public static String getApplicationName(boolean vr) {
        return APPLICATION_NAME + (vr ? " VR" : "");
    }

    @Override
    public Settings clone() {
        Settings c = (Settings)super.clone();
        c.enabled = new AtomicBoolean(false);
        if (this.camrecorder != null) {
            c.camrecorder = this.camrecorder.clone();
        }
        if (this.controls != null) {
            c.controls = this.controls.clone();
        }
        if (this.data != null) {
            c.data = this.data.clone();
        }
        if (this.frame != null) {
            c.frame = this.frame.clone();
        }
        if (this.graphics != null) {
            c.graphics = this.graphics.clone();
        }
        if (this.performance != null) {
            c.performance = this.performance.clone();
        }
        if (this.postprocess != null) {
            c.postprocess = this.postprocess.clone();
        }
        if (this.program != null) {
            c.program = this.program.clone();
        }
        if (this.proxy != null) {
            c.proxy = this.proxy.clone();
        }
        if (this.runtime != null) {
            c.runtime = this.runtime.clone();
        }
        if (this.scene != null) {
            c.scene = this.scene.clone();
        }
        if (this.screenshot != null) {
            c.screenshot = this.screenshot.clone();
        }
        if (this.spacecraft != null) {
            c.spacecraft = this.spacecraft.clone();
        }
        if (this.version != null) {
            c.version = this.version.clone();
        }
        c.initialize();
        return c;
    }

    @Override
    protected void setParentRecursive(SettingsObject s) {
        if (this.camrecorder != null) {
            this.camrecorder.setParent(s);
        }
        if (this.controls != null) {
            this.controls.setParent(s);
        }
        if (this.data != null) {
            this.data.setParent(s);
        }
        if (this.frame != null) {
            this.frame.setParent(s);
        }
        if (this.graphics != null) {
            this.graphics.setParent(s);
        }
        if (this.performance != null) {
            this.performance.setParent(s);
        }
        if (this.postprocess != null) {
            this.postprocess.setParent(s);
        }
        if (this.program != null) {
            this.program.setParent(s);
        }
        if (this.proxy != null) {
            this.proxy.setParent(s);
        }
        if (this.runtime != null) {
            this.runtime.setParent(s);
        }
        if (this.scene != null) {
            this.scene.setParent(s);
        }
        if (this.screenshot != null) {
            this.screenshot.setParent(s);
        }
        if (this.spacecraft != null) {
            this.spacecraft.setParent(s);
        }
        if (this.version != null) {
            this.version.setParent(s);
        }
    }

    @Override
    public void setupListeners() {
        if (this.camrecorder != null) {
            this.camrecorder.setupListeners();
        }
        if (this.controls != null) {
            this.controls.setupListeners();
        }
        if (this.data != null) {
            this.data.setupListeners();
        }
        if (this.frame != null) {
            this.frame.setupListeners();
        }
        if (this.graphics != null) {
            this.graphics.setupListeners();
        }
        if (this.performance != null) {
            this.performance.setupListeners();
        }
        if (this.postprocess != null) {
            this.postprocess.setupListeners();
        }
        if (this.program != null) {
            this.program.setupListeners();
        }
        if (this.proxy != null) {
            this.proxy.setupListeners();
        }
        if (this.runtime != null) {
            this.runtime.setupListeners();
        }
        if (this.scene != null) {
            this.scene.setupListeners();
        }
        if (this.screenshot != null) {
            this.screenshot.setupListeners();
        }
        if (this.spacecraft != null) {
            this.spacecraft.setupListeners();
        }
        if (this.version != null) {
            this.version.setupListeners();
        }
    }

    public void dispose() {
        if (this.camrecorder != null) {
            this.camrecorder.dispose();
        }
        if (this.controls != null) {
            this.controls.dispose();
        }
        if (this.data != null) {
            this.data.dispose();
        }
        if (this.frame != null) {
            this.frame.dispose();
        }
        if (this.graphics != null) {
            this.graphics.dispose();
        }
        if (this.performance != null) {
            this.performance.dispose();
        }
        if (this.postprocess != null) {
            this.postprocess.dispose();
        }
        if (this.program != null) {
            this.program.dispose();
        }
        if (this.proxy != null) {
            this.proxy.dispose();
        }
        if (this.runtime != null) {
            this.runtime.dispose();
        }
        if (this.scene != null) {
            this.scene.dispose();
        }
        if (this.screenshot != null) {
            this.screenshot.dispose();
        }
        if (this.spacecraft != null) {
            this.spacecraft.dispose();
        }
        if (this.version != null) {
            this.version.dispose();
        }
    }

    @Override
    public void apply() {
        if (this.camrecorder != null) {
            this.camrecorder.apply();
        }
        if (this.controls != null) {
            this.controls.apply();
        }
        if (this.data != null) {
            this.data.apply();
        }
        if (this.frame != null) {
            this.frame.apply();
        }
        if (this.graphics != null) {
            this.graphics.apply();
        }
        if (this.performance != null) {
            this.performance.apply();
        }
        if (this.postprocess != null) {
            this.postprocess.apply();
        }
        if (this.program != null) {
            this.program.apply();
        }
        if (this.proxy != null) {
            this.proxy.apply();
        }
        if (this.runtime != null) {
            this.runtime.apply();
        }
        if (this.scene != null) {
            this.scene.apply();
        }
        if (this.screenshot != null) {
            this.screenshot.apply();
        }
        if (this.spacecraft != null) {
            this.spacecraft.apply();
        }
        if (this.version != null) {
            this.version.apply();
        }
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = VersionChecker.correctVersionNumber(configVersion);
    }

    static {
        logger = Logger.getLogger(Settings.class);
        APPLICATION_NAME = "Gaia Sky";
        APPLICATION_NAME_TITLE = "G a i a  S k y";
        Path iconPath = Path.of(ASSETS_LOC + "/icon/gs_icon_256.png", new String[0]);
        if (Files.exists(iconPath, new LinkOption[0])) {
            logger.debug("Icon found: " + String.valueOf(iconPath));
            ICON_URL = "file://" + String.valueOf(iconPath.toAbsolutePath());
        } else {
            logger.debug("Icon not found: " + String.valueOf(iconPath) + ", using: " + ASSETS_LOC + "/gs_icon_256.png");
            ICON_URL = "file://" + ASSETS_LOC + "/gs_icon_128.png";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ProgramSettings
    extends SettingsObject
    implements IObserver {
        public boolean safeMode;
        @JsonIgnore
        public boolean safeModeFlag;
        public boolean debugInfo;
        public boolean offlineMode;
        public boolean shaderCache = false;
        public boolean saveProceduralTextures = false;
        public boolean displayTimeNoUi = true;
        public MinimapSettings minimap;
        public FileChooserSettings fileChooser;
        public PointerSettings pointer;
        public RecursiveGridSettings recursiveGrid;
        public UVGridSettings uvGrid;
        public ModeStereoSettings modeStereo;
        public ModeCubemapSettings modeCubemap;
        public NetSettings net;
        public UiSettings ui;
        public boolean exitConfirmation;
        public String locale;
        public UpdateSettings update;
        public UrlSettings url;
        public DefaultTimeZone timeZone = DefaultTimeZone.UTC;
        @JsonIgnore
        public final Set<String> recommendedDatasets = Set.of("default-data", "gaia-dr3-best", "catalog-nbg", "catalog-nebulae", "catalog-sdss-12");

        @JsonIgnore
        public String getDefaultLocale() {
            return "en-GB";
        }

        public String getLocale() {
            if (this.locale == null || this.locale.isEmpty()) {
                this.locale = Locale.getDefault().toLanguageTag();
            }
            return this.locale;
        }

        @JsonIgnore
        public boolean isStereoOrCubemap() {
            return this.modeStereo.active || this.modeCubemap.active;
        }

        @JsonIgnore
        public boolean isCubemap() {
            return this.modeCubemap.active;
        }

        @JsonIgnore
        public boolean isStereo() {
            return this.modeStereo.active;
        }

        @JsonProperty(value="timeZone")
        public void setTimeZone(String timeZone) {
            if (timeZone == null || timeZone.isEmpty()) {
                timeZone = "UTC";
            }
            this.timeZone = DefaultTimeZone.valueOf(timeZone.toUpperCase(Locale.ROOT));
        }

        @Override
        public void notify(Event event, Object source, Object ... data) {
            if (this.isEnabled() && source != this) {
                switch (event) {
                    case STEREOSCOPIC_CMD: {
                        this.modeStereo.active = (Boolean)data[0];
                        if (!this.modeStereo.active || !this.modeCubemap.active) break;
                        this.modeStereo.active = false;
                        EventManager.publish(Event.DISPLAY_GUI_CMD, this, true, I18n.msg("notif.cleanmode"));
                        break;
                    }
                    case STEREO_PROFILE_CMD: {
                        this.modeStereo.profile = StereoProfile.values()[(Integer)data[0]];
                        break;
                    }
                    case CUBEMAP_CMD: {
                        boolean bl = this.modeCubemap.active = (Boolean)data[0] != false && !Settings.settings.runtime.openXr;
                        if (this.modeCubemap.active) {
                            this.modeCubemap.projection = (CubmeapProjectionEffect.CubemapProjection)((Object)data[1]);
                            ModePopupInfo mpi = new ModePopupInfo();
                            if (this.modeCubemap.projection.isPanorama()) {
                                String[] keysStrToggle = KeyBindings.instance.getStringArrayKeys("action.toggle/element.360");
                                String[] keysStrProj = KeyBindings.instance.getStringArrayKeys("action.toggle/element.projection");
                                mpi.title = I18n.msg("gui.360.title");
                                mpi.header = I18n.msg("gui.360.notice.header");
                                mpi.addMapping(I18n.msg("gui.360.notice.back"), keysStrToggle);
                                mpi.addMapping(I18n.msg("gui.360.notice.projection"), keysStrProj);
                                if (Settings.settings.scene.renderer.pointCloud.isPoints()) {
                                    mpi.warn = I18n.msg("gui.360.notice.renderer");
                                }
                            } else if (this.modeCubemap.projection.isPlanetarium()) {
                                String[] keysStr = KeyBindings.instance.getStringArrayKeys("action.toggle/element.planetarium");
                                String[] keysStrProj = KeyBindings.instance.getStringArrayKeys("action.toggle/element.planetarium.projection");
                                mpi.title = I18n.msg("gui.planetarium.title");
                                mpi.header = I18n.msg("gui.planetarium.notice.header");
                                mpi.addMapping(I18n.msg("gui.planetarium.notice.back"), keysStr);
                                mpi.addMapping(I18n.msg("gui.360.notice.projection"), keysStrProj);
                                if (Settings.settings.scene.renderer.pointCloud.isPoints()) {
                                    mpi.warn = I18n.msg("gui.360.notice.renderer");
                                }
                            } else if (this.modeCubemap.projection.isOrthosphere()) {
                                String[] keysStrToggle = KeyBindings.instance.getStringArrayKeys("action.toggle/element.orthosphere");
                                String[] keysStrProfile = KeyBindings.instance.getStringArrayKeys("action.toggle/element.orthosphere.profile");
                                mpi.title = I18n.msg("gui.orthosphere.title");
                                mpi.header = I18n.msg("gui.orthosphere.notice.header");
                                mpi.addMapping(I18n.msg("gui.orthosphere.notice.back"), keysStrToggle);
                                mpi.addMapping(I18n.msg("gui.orthosphere.notice.profile"), keysStrProfile);
                            }
                            EventManager.publish(Event.MODE_POPUP_CMD, this, mpi, "cubemap", Float.valueOf(10.0f));
                            break;
                        }
                        EventManager.publish(Event.MODE_POPUP_CMD, this, null, "cubemap");
                        EventManager.publish(Event.FOV_CHANGED_CMD, this, Float.valueOf(GaiaSky.instance.cameraManager.getCamera().fieldOfView));
                        break;
                    }
                    case CUBEMAP_PROJECTION_CMD: {
                        this.modeCubemap.projection = (CubmeapProjectionEffect.CubemapProjection)((Object)data[0]);
                        logger.info(I18n.msg("gui.360.projection", this.modeCubemap.projection.toString()));
                        break;
                    }
                    case PLANETARIUM_PROJECTION_CMD: {
                        this.modeCubemap.projection = (CubmeapProjectionEffect.CubemapProjection)((Object)data[0]);
                        if (this.modeCubemap.projection.isSphericalMirror() && this.modeCubemap.planetarium.sphericalMirrorWarp == null) {
                            this.modeCubemap.projection = CubmeapProjectionEffect.CubemapProjection.AZIMUTHAL_EQUIDISTANT;
                            EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("gui.planetarium.sphericalmirror.nowarpfile"), Float.valueOf(10.0f));
                            break;
                        }
                        logger.info(I18n.msg("gui.360.projection", this.modeCubemap.projection.toString()));
                        break;
                    }
                    case SHOW_NOTIFICATIONS_CMD: {
                        this.ui.notifications = (Boolean)data[0];
                        break;
                    }
                    case INDEXOFREFRACTION_CMD: {
                        this.modeCubemap.celestialSphereIndexOfRefraction = ((Float)data[0]).floatValue();
                        break;
                    }
                    case CUBEMAP_RESOLUTION_CMD: {
                        this.modeCubemap.faceResolution = (Integer)data[0];
                        break;
                    }
                    case MINIMAP_DISPLAY_CMD: {
                        this.minimap.active = (Boolean)data[0];
                        break;
                    }
                    case MINIMAP_TOGGLE_CMD: {
                        this.minimap.active = !this.minimap.active;
                        break;
                    }
                    case PLANETARIUM_APERTURE_CMD: {
                        this.modeCubemap.planetarium.aperture = ((Float)data[0]).floatValue();
                        break;
                    }
                    case PLANETARIUM_ANGLE_CMD: {
                        this.modeCubemap.planetarium.angle = ((Float)data[0]).floatValue();
                        break;
                    }
                    case PLANETARIUM_GEOMETRYWARP_FILE_CMD: {
                        this.modeCubemap.planetarium.sphericalMirrorWarp = (Path)data[0];
                        break;
                    }
                    case POINTER_GUIDES_CMD: {
                        if (data.length <= 0 || data[0] == null) break;
                        this.pointer.guides.active = (Boolean)data[0];
                        if (data.length <= 1 || data[1] == null) break;
                        this.pointer.guides.color = (float[])data[1];
                        if (data.length <= 2 || data[2] == null) break;
                        this.pointer.guides.width = ((Float)data[2]).floatValue();
                        break;
                    }
                    case UV_GRID_FRAME_COORDINATES_CMD: {
                        if (data.length <= 0 || data[0] == null) break;
                        this.uvGrid.frameCoordinates = (Boolean)data[0];
                        break;
                    }
                    case UI_SCALE_FACTOR_CMD: {
                        this.ui.scale = ((Float)data[0]).floatValue();
                        break;
                    }
                    case PROCEDURAL_GENERATION_SAVE_TEXTURES_CMD: {
                        this.saveProceduralTextures = (Boolean)data[0];
                        break;
                    }
                }
            }
        }

        @Override
        public ProgramSettings clone() {
            ProgramSettings c = (ProgramSettings)super.clone();
            c.minimap = this.minimap.clone();
            c.fileChooser = this.fileChooser.clone();
            c.pointer = this.pointer.clone();
            c.ui = this.ui.clone();
            c.net = this.net.clone();
            c.modeCubemap = this.modeCubemap.clone();
            c.modeStereo = this.modeStereo.clone();
            c.recursiveGrid = this.recursiveGrid.clone();
            c.url = this.url.clone();
            c.update = this.update.clone();
            return c;
        }

        @Override
        protected void setParentRecursive(SettingsObject s) {
            this.minimap.setParent(s);
            this.fileChooser.setParent(s);
            this.ui.setParent(s);
            this.net.setParent(s);
            this.modeCubemap.setParent(s);
            this.modeStereo.setParent(s);
            this.recursiveGrid.setParent(s);
            this.url.setParent(s);
            this.update.setParent(s);
        }

        @Override
        protected void setupListeners() {
            EventManager.instance.subscribe((IObserver)this, Event.STEREOSCOPIC_CMD, Event.STEREO_PROFILE_CMD, Event.CUBEMAP_CMD, Event.CUBEMAP_PROJECTION_CMD, Event.PLANETARIUM_PROJECTION_CMD, Event.INDEXOFREFRACTION_CMD, Event.MINIMAP_DISPLAY_CMD, Event.MINIMAP_TOGGLE_CMD, Event.PLANETARIUM_APERTURE_CMD, Event.PLANETARIUM_ANGLE_CMD, Event.CUBEMAP_PROJECTION_CMD, Event.PLANETARIUM_GEOMETRYWARP_FILE_CMD, Event.CUBEMAP_RESOLUTION_CMD, Event.POINTER_GUIDES_CMD, Event.UI_SCALE_FACTOR_CMD, Event.UV_GRID_FRAME_COORDINATES_CMD, Event.PROCEDURAL_GENERATION_SAVE_TEXTURES_CMD, Event.SHOW_NOTIFICATIONS_CMD);
            this.minimap.setupListeners();
            this.fileChooser.setupListeners();
            this.ui.setupListeners();
            this.net.setupListeners();
            this.modeCubemap.setupListeners();
            this.modeStereo.setupListeners();
            this.recursiveGrid.setupListeners();
            this.url.setupListeners();
            this.update.setupListeners();
        }

        public void dispose() {
            EventManager.instance.removeAllSubscriptions((IObserver)this);
            this.minimap.dispose();
            this.fileChooser.dispose();
            this.ui.dispose();
            this.net.dispose();
            this.modeCubemap.dispose();
            this.modeStereo.dispose();
            this.recursiveGrid.dispose();
            this.url.dispose();
            this.update.dispose();
        }

        @Override
        public void apply() {
            EventManager.publish(Event.INDEXOFREFRACTION_CMD, this, Float.valueOf(this.modeCubemap.celestialSphereIndexOfRefraction));
            EventManager.publish(Event.CUBEMAP_RESOLUTION_CMD, this, this.modeCubemap.faceResolution);
            EventManager.publish(Event.PLANETARIUM_APERTURE_CMD, this, Float.valueOf(this.modeCubemap.planetarium.aperture));
            EventManager.publish(Event.PLANETARIUM_GEOMETRYWARP_FILE_CMD, this, this.modeCubemap.planetarium.sphericalMirrorWarp);
            EventManager.publish(Event.PLANETARIUM_ANGLE_CMD, this, Float.valueOf(this.modeCubemap.planetarium.angle));
            EventManager.publish(Event.POINTER_GUIDES_CMD, this, this.pointer.guides.active, this.pointer.guides.color, Float.valueOf(this.pointer.guides.width));
            GaiaSky.postRunnable(() -> {
                EventManager.publish(Event.STEREOSCOPIC_CMD, this, this.modeStereo.active);
                EventManager.publish(Event.STEREO_PROFILE_CMD, this, this.modeStereo.profile.ordinal());
                EventManager.publish(Event.CUBEMAP_CMD, this, new Object[]{this.modeCubemap.active, this.modeCubemap.projection});
                EventManager.publish(Event.MINIMAP_DISPLAY_CMD, this, this.minimap.active);
                EventManager.publish(Event.UI_SCALE_RECOMPUTE_CMD, this, new Object[0]);
            });
            this.minimap.apply();
            this.fileChooser.apply();
            this.ui.apply();
            this.net.apply();
            this.modeCubemap.apply();
            this.modeStereo.apply();
            this.recursiveGrid.apply();
            this.url.apply();
            this.update.apply();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class ModeStereoSettings
        extends SettingsObject {
            public boolean active;
            public StereoProfile profile;
            @JsonIgnore
            public float eyeSeparation = 1.0f;

            public void setProfile(String profileString) {
                if (profileString.equalsIgnoreCase("ANAGLYPH")) {
                    profileString = StereoProfile.ANAGLYPH_RED_CYAN.toString();
                }
                this.profile = StereoProfile.valueOf(profileString.toUpperCase(Locale.ROOT));
            }

            @JsonIgnore
            public boolean isStereoHalfWidth() {
                return this.active && this.profile.correctAspect();
            }

            @JsonIgnore
            public boolean isStereoFullWidth() {
                return !this.isStereoHalfWidth();
            }

            @JsonIgnore
            public boolean isStereoHalfViewport() {
                return this.active && !this.profile.isAnaglyph();
            }

            @JsonIgnore
            public boolean isStereoVR() {
                return this.active && this.profile.isVR();
            }

            @Override
            public ModeStereoSettings clone() {
                return (ModeStereoSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class ModeCubemapSettings
        extends SettingsObject {
            public boolean active;
            public CubmeapProjectionEffect.CubemapProjection projection;
            public int faceResolution;
            public PlanetariumSettings planetarium;
            public float celestialSphereIndexOfRefraction;

            public void setProjection(String projectionString) {
                this.projection = CubmeapProjectionEffect.CubemapProjection.valueOf(projectionString.toUpperCase(Locale.ROOT));
            }

            @JsonIgnore
            public boolean isPlanetariumOn() {
                return this.active && this.projection.isPlanetarium();
            }

            @JsonIgnore
            public boolean isPanoramaOn() {
                return this.active && this.projection.isPanorama();
            }

            @JsonIgnore
            public boolean isOrthosphereOn() {
                return this.active && this.projection.isOrthosphere();
            }

            @JsonIgnore
            public boolean isFixedFov() {
                return this.isPanoramaOn() || this.isPlanetariumOn();
            }

            @Override
            public ModeCubemapSettings clone() {
                ModeCubemapSettings c = (ModeCubemapSettings)super.clone();
                c.planetarium = this.planetarium.clone();
                return c;
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
                this.planetarium.setParent(s);
            }

            @Override
            protected void setupListeners() {
                this.planetarium.setupListeners();
            }

            public void dispose() {
                this.planetarium.dispose();
            }

            @Override
            public void apply() {
                this.planetarium.apply();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class PlanetariumSettings
            extends SettingsObject {
                public float aperture;
                public float angle;
                public Path sphericalMirrorWarp;

                public void setSphericalMirrorWarp(String file) {
                    if (file != null) {
                        try {
                            this.sphericalMirrorWarp = Path.of(file, new String[0]);
                        }
                        catch (InvalidPathException e) {
                            logger.error("Invalid spherical mirror mesh warp file path: " + file);
                            logger.error(e);
                        }
                    }
                }

                public String getSphericalMirrorWarp() {
                    if (this.sphericalMirrorWarp != null) {
                        return this.sphericalMirrorWarp.toString();
                    }
                    return null;
                }

                @Override
                public PlanetariumSettings clone() {
                    return (PlanetariumSettings)super.clone();
                }

                @Override
                protected void setParentRecursive(SettingsObject s) {
                }

                @Override
                protected void setupListeners() {
                }

                public void dispose() {
                }

                @Override
                public void apply() {
                }
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class UiSettings
        extends SettingsObject {
            public String theme;
            public float scale;
            public long animationMs = 600L;
            public boolean newUI = true;
            public boolean expandOnMouseOver = false;
            public boolean modeChangeInfo;
            public boolean notifications = false;
            public DistanceUnits distanceUnits;

            @JsonProperty(value="theme")
            public void setTheme(String theme) {
                if (!theme.equals("default")) {
                    theme = "default";
                }
                this.theme = theme;
            }

            public void setScale(Float scale) {
                this.scale = MathUtils.clamp((float)scale.floatValue(), (float)0.7f, (float)2.0f);
            }

            @JsonIgnore
            public float getAnimationSeconds() {
                return (float)this.animationMs / 1000.0f;
            }

            @JsonProperty(value="distanceUnits")
            public void setDistanceUnits(String distanceUnits) {
                if (distanceUnits == null || distanceUnits.isEmpty()) {
                    distanceUnits = "PC";
                }
                this.distanceUnits = DistanceUnits.valueOf(distanceUnits.toUpperCase(Locale.ROOT));
            }

            @Override
            public UiSettings clone() {
                return (UiSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class MinimapSettings
        extends SettingsObject {
            public boolean active;
            public float size;
            public boolean inWindow = false;

            @Override
            public MinimapSettings clone() {
                return (MinimapSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class PointerSettings
        extends SettingsObject {
            public boolean coordinates;
            public GuidesSettings guides;

            @Override
            public PointerSettings clone() {
                PointerSettings c = (PointerSettings)super.clone();
                c.guides = this.guides.clone();
                return c;
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
                this.guides.setParent(s);
            }

            @Override
            protected void setupListeners() {
                this.guides.setupListeners();
            }

            public void dispose() {
                this.guides.dispose();
            }

            @Override
            public void apply() {
                this.guides.apply();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class GuidesSettings
            extends SettingsObject {
                public boolean active;
                public float[] color;
                public float width;

                @Override
                public GuidesSettings clone() {
                    GuidesSettings c = (GuidesSettings)super.clone();
                    c.color = (float[])this.color.clone();
                    return c;
                }

                @Override
                protected void setParentRecursive(SettingsObject s) {
                }

                @Override
                protected void setupListeners() {
                }

                public void dispose() {
                }

                @Override
                public void apply() {
                }
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class UVGridSettings
        extends SettingsObject {
            public boolean frameCoordinates = true;

            @Override
            public UVGridSettings clone() {
                return (UVGridSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class FileChooserSettings
        extends SettingsObject {
            public boolean showHidden;
            public String lastLocation;

            @Override
            public FileChooserSettings clone() {
                return (FileChooserSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class NetSettings
        extends SettingsObject {
            public int restPort;
            public MasterSettings master;
            public SlaveSettings slave;

            @JsonIgnore
            public String getNetName() {
                if (this.master.active) {
                    return " MASTER";
                }
                if (this.slave.active) {
                    return " SLAVE";
                }
                return "";
            }

            @JsonIgnore
            public boolean isMasterInstance() {
                return this.master.active;
            }

            @JsonIgnore
            public boolean isSlaveInstance() {
                return this.slave.active;
            }

            @JsonIgnore
            public boolean isSlaveMPCDIPresent() {
                return this.slave.configFile != null && !this.slave.configFile.isEmpty();
            }

            public boolean areSlaveConfigPropertiesPresent() {
                return !Double.isNaN(this.slave.yaw) && !Double.isNaN(this.slave.pitch) && !Double.isNaN(this.slave.roll);
            }

            @Override
            public NetSettings clone() {
                NetSettings c = (NetSettings)super.clone();
                c.master = this.master.clone();
                c.slave = this.slave.clone();
                return c;
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
                this.master.setParent(s);
                this.slave.setParent(s);
            }

            @Override
            protected void setupListeners() {
                this.master.setupListeners();
                this.slave.setupListeners();
            }

            public void dispose() {
                this.master.dispose();
                this.slave.dispose();
            }

            @Override
            public void apply() {
                this.master.apply();
                this.slave.apply();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class MasterSettings
            extends SettingsObject {
                public boolean active;
                public List<String> slaves;

                @Override
                public MasterSettings clone() {
                    MasterSettings c = (MasterSettings)super.clone();
                    c.slaves = new ArrayList<String>(this.slaves);
                    return c;
                }

                @Override
                protected void setParentRecursive(SettingsObject s) {
                }

                @Override
                protected void setupListeners() {
                }

                public void dispose() {
                }

                @Override
                public void apply() {
                }
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class SlaveSettings
            extends SettingsObject {
                public boolean active;
                public String configFile;
                public String warpFile;
                public String blendFile;
                public float yaw;
                public float pitch;
                public float roll;

                @Override
                public SlaveSettings clone() {
                    return (SlaveSettings)super.clone();
                }

                @Override
                protected void setParentRecursive(SettingsObject s) {
                }

                @Override
                protected void setupListeners() {
                }

                public void dispose() {
                }

                @Override
                public void apply() {
                }
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class RecursiveGridSettings
        extends SettingsObject {
            public OriginType origin;
            public GridStyle style;
            public boolean projectionLines;

            public void setOrigin(String originString) {
                try {
                    this.origin = OriginType.valueOf(originString.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    this.origin = OriginType.REFSYS;
                }
            }

            public void setStyle(String styleString) {
                try {
                    this.style = GridStyle.valueOf(styleString.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    this.style = GridStyle.CIRCULAR;
                }
            }

            @Override
            public RecursiveGridSettings clone() {
                return (RecursiveGridSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class UrlSettings
        extends SettingsObject {
            public String versionCheck;
            public String dataMirror = "https://gaia.ari.uni-heidelberg.de/gaiasky/files/repository/";
            public String dataDescriptor;

            public void setVersionCheck(String versionCheck) {
                if (versionCheck.startsWith("https://gitlab.com")) {
                    versionCheck = "https://codeberg.org/api/v1/repos/gaiasky/gaiasky/tags";
                }
                this.versionCheck = versionCheck;
            }

            @Override
            public UrlSettings clone() {
                return (UrlSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class UpdateSettings
        extends SettingsObject {
            @JsonIgnore
            public static long VERSION_CHECK_INTERVAL_MS = 86400000L;
            public Instant lastCheck;
            public String lastVersion;

            @JsonIgnore
            public String getLastCheckedString() {
                DateTimeFormatter df = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM).withLocale(I18n.locale).withZone(ZoneOffset.UTC);
                return df.format(this.lastCheck);
            }

            @Override
            public UpdateSettings clone() {
                UpdateSettings c = (UpdateSettings)super.clone();
                c.lastCheck = Instant.ofEpochMilli(this.lastCheck.toEpochMilli());
                return c;
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class VersionSettings
    extends SettingsObject {
        public String version;
        public int versionNumber;
        public Instant buildTime;
        public String builder;
        public String system;
        public String build;
        private DateTimeFormatter dateFormatter;

        public void initialize(String version, Instant buildTime, String builder, String system, String build) {
            this.version = version;
            this.versionNumber = VersionChecker.stringToVersionNumber(version);
            this.buildTime = buildTime;
            this.builder = builder;
            this.system = system;
            this.build = build;
            this.dateFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        }

        public String toString() {
            return this.version;
        }

        public String getBuildTimePretty() {
            return this.dateFormatter.format(this.buildTime);
        }

        @Override
        public VersionSettings clone() {
            VersionSettings c = (VersionSettings)super.clone();
            c.buildTime = Instant.ofEpochMilli(this.buildTime.toEpochMilli());
            return c;
        }

        @Override
        protected void setParentRecursive(SettingsObject s) {
        }

        @Override
        protected void setupListeners() {
        }

        public void dispose() {
        }

        @Override
        public void apply() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class CamrecorderSettings
    extends SettingsObject
    implements IObserver {
        public double targetFps;
        public KeyframeSettings keyframe;
        public boolean auto;

        @Override
        public void notify(Event event, Object source, Object ... data) {
            if (this.isEnabled() && source != this && event == Event.CAMRECORDER_FPS_CMD) {
                this.targetFps = (Double)data[0];
            }
        }

        @Override
        public CamrecorderSettings clone() {
            CamrecorderSettings c = (CamrecorderSettings)super.clone();
            c.keyframe = this.keyframe.clone();
            return c;
        }

        @Override
        protected void setParentRecursive(SettingsObject s) {
            this.keyframe.setParent(s);
        }

        @Override
        protected void setupListeners() {
            EventManager.instance.subscribe((IObserver)this, Event.CAMRECORDER_FPS_CMD);
            this.keyframe.setupListeners();
        }

        public void dispose() {
            EventManager.instance.removeAllSubscriptions((IObserver)this);
            this.keyframe.dispose();
        }

        @Override
        public void apply() {
            EventManager.publish(Event.CAMRECORDER_FPS_CMD, this, this.targetFps);
            this.keyframe.apply();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class KeyframeSettings
        extends SettingsObject {
            public KeyframesManager.PathType position;
            @Deprecated
            public KeyframesManager.PathType orientation;

            @Override
            public KeyframeSettings clone() {
                return (KeyframeSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void setPosition(String positionString) {
                this.position = this.getPathType(positionString);
            }

            public void setOrientation(String orientationString) {
                this.orientation = this.getPathType(orientationString);
            }

            private KeyframesManager.PathType getPathType(String str) {
                if (str.equalsIgnoreCase("SPLINE")) {
                    str = KeyframesManager.PathType.CATMULL_ROM_SPLINE.toString();
                }
                return KeyframesManager.PathType.valueOf(str.toUpperCase(Locale.ROOT));
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ControlsSettings
    extends SettingsObject {
        public GamepadSettings gamepad;

        @Override
        public ControlsSettings clone() {
            ControlsSettings c = (ControlsSettings)super.clone();
            c.gamepad = this.gamepad.clone();
            return c;
        }

        @Override
        protected void setParentRecursive(SettingsObject s) {
            this.gamepad.setParent(s);
        }

        @Override
        protected void setupListeners() {
            this.gamepad.setupListeners();
        }

        public void dispose() {
            this.gamepad.dispose();
        }

        @Override
        public void apply() {
            this.gamepad.apply();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class GamepadSettings
        extends SettingsObject
        implements IObserver {
            private final Map<Controller, Set<ControllerListener>> controllerListenersMap = new HashMap<Controller, Set<ControllerListener>>();
            public String mappingsFile;
            public boolean invertX;
            public boolean invertY;
            public String[] blacklist;

            @Override
            public GamepadSettings clone() {
                GamepadSettings c = (GamepadSettings)super.clone();
                c.controllerListenersMap.clear();
                c.controllerListenersMap.putAll(this.controllerListenersMap);
                c.blacklist = (String[])this.blacklist.clone();
                return c;
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
                EventManager.instance.subscribe((IObserver)this, Event.INVERT_X_CMD, Event.INVERT_Y_CMD);
            }

            public void dispose() {
                EventManager.instance.removeAllSubscriptions((IObserver)this);
            }

            public boolean isControllerBlacklisted(String controllerName) {
                if (this.blacklist == null) {
                    return false;
                }
                for (String cn : this.blacklist) {
                    if (!controllerName.equalsIgnoreCase(cn)) continue;
                    return true;
                }
                return false;
            }

            private void addListener(Controller controller, ControllerListener controllerListener) {
                if (!this.controllerListenersMap.containsKey(controller)) {
                    HashSet<ControllerListener> cs = new HashSet<ControllerListener>();
                    cs.add(controllerListener);
                    this.controllerListenersMap.put(controller, cs);
                } else {
                    Set<ControllerListener> cs = this.controllerListenersMap.get(controller);
                    cs.add(controllerListener);
                }
                this.activate(controllerListener);
            }

            private void activate(ControllerListener l) {
                if (l instanceof AbstractGamepadListener) {
                    ((AbstractGamepadListener)l).activate();
                }
            }

            private void removeListener(Controller controller, ControllerListener controllerListener) {
                if (this.controllerListenersMap.containsKey(controller)) {
                    Set<ControllerListener> cs = this.controllerListenersMap.get(controller);
                    cs.remove(controllerListener);
                    this.deactivate(controllerListener);
                }
            }

            private void deactivate(ControllerListener l) {
                if (l instanceof AbstractGamepadListener) {
                    ((AbstractGamepadListener)l).deactivate();
                }
            }

            public void addControllerListener(ControllerListener listener) {
                Array controllers = Controllers.getControllers();
                for (Controller controller : controllers) {
                    if (this.isControllerBlacklisted(controller.getName())) continue;
                    controller.removeListener(listener);
                    controller.addListener(listener);
                    this.addListener(controller, listener);
                }
            }

            public void addControllerListener(ControllerListener listener, String controllerName) {
                Array controllers = Controllers.getControllers();
                for (Controller controller : controllers) {
                    if (this.isControllerBlacklisted(controller.getName()) || !controllerName.equals(controller.getName())) continue;
                    controller.removeListener(listener);
                    controller.addListener(listener);
                    this.addListener(controller, listener);
                }
            }

            public void removeControllerListener(ControllerListener listener) {
                Array controllers = Controllers.getControllers();
                for (Controller controller : controllers) {
                    if (this.isControllerBlacklisted(controller.getName())) continue;
                    controller.removeListener(listener);
                    this.removeListener(controller, listener);
                }
            }

            public void removeAllControllerListeners() {
                Array controllers = Controllers.getControllers();
                for (Controller controller : controllers) {
                    Set<ControllerListener> s;
                    if (this.isControllerBlacklisted(controller.getName()) || (s = this.controllerListenersMap.get(controller)) == null) continue;
                    for (ControllerListener cl : s) {
                        controller.removeListener(cl);
                        this.deactivate(cl);
                    }
                    s.clear();
                }
            }

            @JsonIgnore
            public Set<ControllerListener> getControllerListeners() {
                Array controllers = Controllers.getControllers();
                if (!controllers.isEmpty()) {
                    Controller c = (Controller)controllers.get(0);
                    if (this.controllerListenersMap.containsKey(c) && this.controllerListenersMap.get(c) != null) {
                        return new HashSet<ControllerListener>((Collection)this.controllerListenersMap.get(c));
                    }
                    return new HashSet<ControllerListener>();
                }
                return new HashSet<ControllerListener>();
            }

            @JsonIgnore
            public void setControllerListeners(Set<ControllerListener> controllerListeners) {
                if (controllerListeners != null) {
                    for (ControllerListener listener : controllerListeners) {
                        this.addControllerListener(listener);
                    }
                }
            }

            @Override
            public void notify(Event event, Object source, Object ... data) {
                if (this.isEnabled() && source != this) {
                    switch (event) {
                        case INVERT_X_CMD: {
                            this.invertX = (Boolean)data[0];
                            break;
                        }
                        case INVERT_Y_CMD: {
                            this.invertY = (Boolean)data[0];
                        }
                    }
                }
            }

            @Override
            public void apply() {
                EventManager.publish(Event.INVERT_X_CMD, this, this.invertX);
                EventManager.publish(Event.INVERT_Y_CMD, this, this.invertY);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DataSettings
    extends SettingsObject {
        public String location;
        public List<String> dataFiles;
        public String reflectionSkyboxLocation;
        public boolean highAccuracy;
        public boolean realGaiaAttitude;

        public void setSkyboxLocation(String location) {
            this.reflectionSkyboxLocation = location;
        }

        public Path dataPath(String pathStr, String dsLocation) {
            String resolvedPathStr = pathStr.replaceAll("\\*", "%#QUAL#%");
            if (resolvedPathStr.startsWith("$data/")) {
                String pathFromDataStr = resolvedPathStr.replace("$data/", "");
                Path pathFromData = Path.of(pathFromDataStr, new String[0]);
                Path resolvedPath = Path.of(this.location, new String[0]).resolve(pathFromDataStr);
                if (!(Files.exists(resolvedPath, new LinkOption[0]) || dsLocation == null || dsLocation.isEmpty() || pathFromData.getName(0).toString().equals(dsLocation))) {
                    return Path.of(this.location, new String[0]).resolve(dsLocation).resolve(pathFromDataStr);
                }
                return resolvedPath;
            }
            Path p = Path.of(resolvedPathStr, new String[0]);
            if (p.toFile().exists()) {
                return p;
            }
            return Path.of(this.location, new String[0]).resolve(resolvedPathStr);
        }

        public Path dataPath(String path) {
            return this.dataPath(path, "default-data");
        }

        public String dataFile(String path, String dsLocation) {
            return this.dataPath(path, dsLocation).toString().replaceAll("\\\\", "/");
        }

        public String dataFile(String path) {
            if (path == null) {
                return null;
            }
            return this.dataFile(path, "default-data");
        }

        public FileHandle dataFileHandle(String path, String dsLocation) {
            if (path == null) {
                return null;
            }
            return new FileHandle(this.dataFile(path, dsLocation));
        }

        public FileHandle dataFileHandle(String path) {
            return this.dataFileHandle(path, "default-data");
        }

        public boolean addSelectedCatalog(Path catalog) {
            if (!(Files.exists(catalog, new LinkOption[0]) && Files.isReadable(catalog) && Files.isRegularFile(catalog, new LinkOption[0]))) {
                return false;
            }
            for (String pathStr : this.dataFiles) {
                Path path = Path.of(pathStr, new String[0]);
                try {
                    if (!Files.isSameFile(path, catalog)) continue;
                    return false;
                }
                catch (IOException e) {
                    logger.error(e);
                }
            }
            this.dataFiles.add(catalog.toString());
            return true;
        }

        @Override
        public DataSettings clone() {
            DataSettings c = (DataSettings)super.clone();
            c.dataFiles = new ArrayList<String>(this.dataFiles);
            return c;
        }

        @Override
        protected void setParentRecursive(SettingsObject s) {
        }

        @Override
        protected void setupListeners() {
        }

        public void dispose() {
        }

        @Override
        public void apply() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class FrameSettings
    extends ScreenshotSettings
    implements IObserver {
        @JsonIgnore
        public boolean active;
        public String prefix;
        public boolean time;
        public double targetFps;

        @Override
        protected void setupListeners() {
            EventManager.instance.subscribe((IObserver)this, Event.CONFIG_FRAME_OUTPUT_CMD, Event.FRAME_OUTPUT_CMD, Event.FRAME_OUTPUT_MODE_CMD);
        }

        @Override
        public void notify(Event event, Object source, Object ... data) {
            if (this.isEnabled() && source != this) {
                switch (event) {
                    case CONFIG_FRAME_OUTPUT_CMD: {
                        boolean updateFrameSize = this.resolution[0] != (Integer)data[0] || this.resolution[1] != (Integer)data[1];
                        this.resolution[0] = (Integer)data[0];
                        this.resolution[1] = (Integer)data[1];
                        this.targetFps = (Double)data[2];
                        this.location = (String)data[3];
                        this.prefix = (String)data[4];
                        if (!updateFrameSize) break;
                        EventManager.publish(Event.FRAME_SIZE_UPDATE, this, this.resolution[0], this.resolution[1]);
                        break;
                    }
                    case FRAME_OUTPUT_MODE_CMD: {
                        Object newMode = data[0];
                        ScreenshotMode mode = null;
                        if (newMode instanceof String) {
                            try {
                                mode = ScreenshotMode.valueOf(((String)newMode).toUpperCase(Locale.ROOT));
                            }
                            catch (IllegalArgumentException e) {
                                logger.error("Given value is not a representation of ScreenshotMode (simple|advanced): '" + String.valueOf(newMode) + "'");
                            }
                        } else {
                            mode = (ScreenshotMode)((Object)newMode);
                        }
                        if (mode == null) break;
                        this.mode = mode;
                        break;
                    }
                    case FRAME_OUTPUT_CMD: {
                        this.active = (Boolean)data[0];
                        if (this.active || GaiaSky.instance == null) break;
                        EventManager.publish(Event.FLUSH_FRAMES, this, new Object[0]);
                        break;
                    }
                }
            }
        }

        @Override
        public FrameSettings clone() {
            return (FrameSettings)super.clone();
        }

        @Override
        public void apply() {
            EventManager.publish(Event.FRAME_OUTPUT_MODE_CMD, this, new Object[]{this.mode});
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GraphicsSettings
    extends SettingsObject
    implements IObserver {
        @JsonIgnore
        public final double[] dynamicResolutionScale = new double[]{1.0, 0.85f, 0.75, 0.5};
        public GraphicsQuality quality;
        public int[] resolution;
        public boolean resizable;
        public FullscreenSettings fullScreen;
        public boolean vsync;
        public double fpsLimit;
        public double backBufferScale;
        @JsonIgnore
        public int[] backBufferResolution;
        public boolean dynamicResolution;
        public boolean screenOutput;
        public boolean useSRGB = false;
        public int[] proceduralGenerationResolution = new int[]{3000, 1500};

        public void updateBackBufferResolution() {
            if (this.backBufferResolution == null) {
                this.backBufferResolution = new int[2];
            }
            if (Gdx.graphics != null && settings != null && (this.backBufferResolution[0] <= 0 || this.backBufferResolution[1] <= 0)) {
                this.backBufferResolution[0] = (int)((double)Gdx.graphics.getWidth() * this.backBufferScale);
                this.backBufferResolution[1] = (int)((double)Gdx.graphics.getWidth() * this.backBufferScale);
            }
        }

        public void setQuality(String qualityString) {
            this.quality = GraphicsQuality.valueOf(qualityString.toUpperCase());
        }

        @JsonIgnore
        public int getScreenWidth() {
            return this.fullScreen.active ? this.fullScreen.resolution[0] : this.resolution[0];
        }

        @JsonIgnore
        public int getScreenHeight() {
            return this.fullScreen.active ? this.fullScreen.resolution[1] : this.resolution[1];
        }

        public void resize(int w, int h) {
            if (this.fullScreen.active) {
                this.fullScreen.resolution[0] = w;
                this.fullScreen.resolution[1] = h;
            } else {
                this.resolution[0] = w;
                this.resolution[1] = h;
            }
        }

        @Override
        public void notify(Event event, Object source, Object ... data) {
            if (this.isEnabled() && source != this) {
                switch (event) {
                    case LIMIT_FPS_CMD: {
                        this.fpsLimit = (Double)data[0];
                        if (!(this.fpsLimit > 0.0)) break;
                        GaiaSky.postRunnable(() -> GaiaSky.instance.resetDynamicResolution());
                        break;
                    }
                    case BACKBUFFER_SCALE_CMD: {
                        this.backBufferScale = ((Float)data[0]).floatValue();
                        this.updateBackBufferResolution();
                        break;
                    }
                    case PROCEDURAL_GENERATION_RESOLUTION_CMD: {
                        int w = (Integer)data[0];
                        int h = (Integer)data[1];
                        this.proceduralGenerationResolution[0] = w;
                        this.proceduralGenerationResolution[1] = h;
                    }
                }
            }
        }

        @Override
        public GraphicsSettings clone() {
            GraphicsSettings c = (GraphicsSettings)super.clone();
            c.backBufferResolution = (int[])this.backBufferResolution.clone();
            c.resolution = (int[])this.resolution.clone();
            c.fullScreen = this.fullScreen.clone();
            return c;
        }

        @Override
        protected void setParentRecursive(SettingsObject s) {
            this.fullScreen.setParent(s);
        }

        @Override
        protected void setupListeners() {
            EventManager.instance.subscribe((IObserver)this, Event.LIMIT_FPS_CMD, Event.BACKBUFFER_SCALE_CMD, Event.PROCEDURAL_GENERATION_RESOLUTION_CMD);
            this.fullScreen.setupListeners();
        }

        public void dispose() {
            EventManager.instance.removeAllSubscriptions((IObserver)this);
            this.fullScreen.dispose();
        }

        @Override
        public void apply() {
            EventManager.publish(Event.LIMIT_FPS_CMD, this, this.fpsLimit);
            this.updateBackBufferResolution();
            this.fullScreen.apply();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class FullscreenSettings
        extends SettingsObject {
            public boolean active;
            public int[] resolution;
            public int bitDepth;
            public int refreshRate;

            @Override
            public FullscreenSettings clone() {
                FullscreenSettings c = (FullscreenSettings)super.clone();
                c.resolution = (int[])this.resolution.clone();
                return c;
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PerformanceSettings
    extends SettingsObject {
        public boolean multithreading;
        public int numberThreads;

        @JsonIgnore
        public int getNumberOfThreads() {
            if (this.numberThreads <= 0) {
                return Runtime.getRuntime().availableProcessors();
            }
            return this.numberThreads;
        }

        @Override
        public PerformanceSettings clone() {
            return (PerformanceSettings)super.clone();
        }

        @Override
        protected void setParentRecursive(SettingsObject s) {
        }

        @Override
        protected void setupListeners() {
        }

        public void dispose() {
        }

        @Override
        public void apply() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PostprocessSettings
    extends SettingsObject
    implements IObserver {
        public AntialiasSettings antialiasing;
        public BloomSettings bloom;
        public UnsharpMaskSettings unsharpMask;
        public ChromaticAberrationSettings chromaticAberration;
        public FilmGrainSettings filmGrain;
        public LensFlareSettings lensFlare;
        public LightGlowSettings lightGlow;
        public LevelsSettings levels;
        public ToneMappingSettings toneMapping;
        public SSRSettings ssr;
        public MotionBlurSettings motionBlur;
        public ReprojectionSettings reprojection;
        public UpscaleFilter upscaleFilter = UpscaleFilter.NEAREST;
        public GeometryWarpSettings warpingMesh;

        public void setUpscaleFilter(String upscaleFilterString) {
            this.upscaleFilter = UpscaleFilter.valueOf(upscaleFilterString.toUpperCase(Locale.ROOT));
        }

        public void setAntialias(String ignored) {
        }

        public AntialiasType getAntialias(int code) {
            return switch (code) {
                case -1 -> AntialiasType.FXAA;
                case -2 -> AntialiasType.NFAA;
                case 1 -> AntialiasType.SSAA;
                default -> AntialiasType.NONE;
            };
        }

        @Override
        public void notify(Event event, Object source, Object ... data) {
            if (this.isEnabled() && source != this) {
                switch (event) {
                    case ANTIALIASING_CMD: {
                        this.antialiasing.type = (AntialiasType)((Object)data[0]);
                        break;
                    }
                    case FXAA_QUALITY_CMD: {
                        this.antialiasing.quality = MathUtils.clamp((int)((Integer)data[0]), (int)0, (int)2);
                        break;
                    }
                    case BLOOM_CMD: {
                        this.bloom.intensity = ((Float)data[0]).floatValue();
                        break;
                    }
                    case UNSHARP_MASK_CMD: {
                        this.unsharpMask.factor = ((Float)data[0]).floatValue();
                        break;
                    }
                    case CHROMATIC_ABERRATION_CMD: {
                        this.chromaticAberration.amount = ((Float)data[0]).floatValue();
                        break;
                    }
                    case FILM_GRAIN_CMD: {
                        this.filmGrain.intensity = ((Float)data[0]).floatValue();
                        break;
                    }
                    case LENS_FLARE_CMD: {
                        float strength = ((Float)data[0]).floatValue();
                        this.lensFlare.active = strength > 0.0f;
                        this.lensFlare.strength = strength;
                        break;
                    }
                    case LIGHT_GLOW_CMD: {
                        this.lightGlow.active = (Boolean)data[0];
                        break;
                    }
                    case SSR_CMD: {
                        this.ssr.active = (Boolean)data[0];
                        break;
                    }
                    case MOTION_BLUR_CMD: {
                        this.motionBlur.strength = ((Float)data[0]).floatValue();
                        this.motionBlur.active = this.motionBlur.strength > 0.0f;
                        break;
                    }
                    case REPROJECTION_CMD: {
                        this.reprojection.active = (Boolean)data[0];
                        this.reprojection.mode = (ReprojectionMode)((Object)data[1]);
                        break;
                    }
                    case BRIGHTNESS_CMD: {
                        this.levels.brightness = MathUtils.clamp((float)((Float)data[0]).floatValue(), (float)-1.0f, (float)1.0f);
                        break;
                    }
                    case CONTRAST_CMD: {
                        this.levels.contrast = MathUtils.clamp((float)((Float)data[0]).floatValue(), (float)0.0f, (float)2.0f);
                        break;
                    }
                    case HUE_CMD: {
                        this.levels.hue = MathUtils.clamp((float)((Float)data[0]).floatValue(), (float)0.0f, (float)2.0f);
                        break;
                    }
                    case SATURATION_CMD: {
                        this.levels.saturation = MathUtils.clamp((float)((Float)data[0]).floatValue(), (float)0.0f, (float)2.0f);
                        break;
                    }
                    case GAMMA_CMD: {
                        this.levels.gamma = MathUtils.clamp((float)((Float)data[0]).floatValue(), (float)0.001f, (float)3.0f);
                        break;
                    }
                    case TONEMAPPING_TYPE_CMD: {
                        ToneMapping newTM = data[0] instanceof String ? ToneMapping.valueOf(((String)data[0]).toUpperCase(Locale.ROOT)) : (ToneMapping)((Object)data[0]);
                        this.toneMapping.type = newTM;
                        break;
                    }
                    case EXPOSURE_CMD: {
                        this.toneMapping.exposure = MathUtilsDouble.clamp(((Float)data[0]).floatValue(), 0.0f, 10.0f);
                        break;
                    }
                    case UPSCALE_FILTER_CMD: {
                        this.upscaleFilter = (UpscaleFilter)((Object)data[0]);
                        break;
                    }
                }
            }
        }

        @Override
        public PostprocessSettings clone() {
            PostprocessSettings c = (PostprocessSettings)super.clone();
            c.antialiasing = this.antialiasing.clone();
            c.bloom = this.bloom.clone();
            c.unsharpMask = this.unsharpMask.clone();
            c.chromaticAberration = this.chromaticAberration.clone();
            c.filmGrain = this.filmGrain.clone();
            c.lensFlare = this.lensFlare.clone();
            c.lightGlow = this.lightGlow.clone();
            c.levels = this.levels.clone();
            c.toneMapping = this.toneMapping.clone();
            c.ssr = this.ssr.clone();
            c.motionBlur = this.motionBlur.clone();
            c.reprojection = this.reprojection.clone();
            c.warpingMesh = this.warpingMesh.clone();
            return c;
        }

        @Override
        protected void setParentRecursive(SettingsObject s) {
            this.antialiasing.setParent(s);
            this.bloom.setParent(s);
            this.unsharpMask.setParent(s);
            this.chromaticAberration.setParent(s);
            this.filmGrain.setParent(s);
            this.lensFlare.setParent(s);
            this.lightGlow.setParent(s);
            this.levels.setParent(s);
            this.toneMapping.setParent(s);
            this.ssr.setParent(s);
            this.motionBlur.setParent(s);
            this.reprojection.setParent(s);
            this.warpingMesh.setParent(s);
        }

        @Override
        protected void setupListeners() {
            EventManager.instance.subscribe((IObserver)this, Event.BLOOM_CMD, Event.UNSHARP_MASK_CMD, Event.LENS_FLARE_CMD, Event.MOTION_BLUR_CMD, Event.SSR_CMD, Event.LIGHT_GLOW_CMD, Event.REPROJECTION_CMD, Event.BRIGHTNESS_CMD, Event.CONTRAST_CMD, Event.HUE_CMD, Event.SATURATION_CMD, Event.GAMMA_CMD, Event.TONEMAPPING_TYPE_CMD, Event.EXPOSURE_CMD, Event.UPSCALE_FILTER_CMD, Event.CHROMATIC_ABERRATION_CMD, Event.FILM_GRAIN_CMD, Event.ANTIALIASING_CMD, Event.FXAA_QUALITY_CMD);
            this.antialiasing.setupListeners();
            this.bloom.setupListeners();
            this.unsharpMask.setupListeners();
            this.chromaticAberration.setupListeners();
            this.filmGrain.setupListeners();
            this.lensFlare.setupListeners();
            this.lightGlow.setupListeners();
            this.levels.setupListeners();
            this.toneMapping.setupListeners();
            this.ssr.setupListeners();
            this.motionBlur.setupListeners();
            this.reprojection.setupListeners();
            this.warpingMesh.setupListeners();
        }

        public void dispose() {
            EventManager.instance.removeAllSubscriptions((IObserver)this);
            this.antialiasing.apply();
            this.bloom.dispose();
            this.unsharpMask.dispose();
            this.chromaticAberration.dispose();
            this.filmGrain.dispose();
            this.lensFlare.dispose();
            this.lightGlow.dispose();
            this.levels.dispose();
            this.toneMapping.dispose();
            this.ssr.dispose();
            this.motionBlur.dispose();
            this.reprojection.dispose();
            this.warpingMesh.dispose();
        }

        @Override
        public void apply() {
            GaiaSky.postRunnable(() -> {
                EventManager.publish(Event.ANTIALIASING_CMD, this, new Object[]{this.antialiasing.type});
                EventManager.publish(Event.FXAA_QUALITY_CMD, this, this.antialiasing.quality);
                EventManager.publish(Event.BLOOM_CMD, this, Float.valueOf(this.bloom.intensity));
                EventManager.publish(Event.UNSHARP_MASK_CMD, this, Float.valueOf(this.unsharpMask.factor));
                EventManager.publish(Event.CHROMATIC_ABERRATION_CMD, this, Float.valueOf(this.chromaticAberration.amount));
                EventManager.publish(Event.FILM_GRAIN_CMD, this, Float.valueOf(this.filmGrain.intensity));
                EventManager.publish(Event.LENS_FLARE_CMD, this, Float.valueOf(this.lensFlare.strength));
                EventManager.publish(Event.LIGHT_GLOW_CMD, this, this.lightGlow.active);
                EventManager.publish(Event.SSR_CMD, this, this.ssr.active);
                EventManager.publish(Event.MOTION_BLUR_CMD, this, Float.valueOf(this.motionBlur.strength));
                EventManager.publish(Event.REPROJECTION_CMD, this, new Object[]{this.reprojection.active, this.reprojection.mode});
                EventManager.publish(Event.BRIGHTNESS_CMD, this, Float.valueOf(this.levels.brightness));
                EventManager.publish(Event.CONTRAST_CMD, this, Float.valueOf(this.levels.contrast));
                EventManager.publish(Event.SATURATION_CMD, this, Float.valueOf(this.levels.saturation));
                EventManager.publish(Event.GAMMA_CMD, this, Float.valueOf(this.levels.gamma));
                EventManager.publish(Event.TONEMAPPING_TYPE_CMD, this, new Object[]{this.toneMapping.type});
                EventManager.publish(Event.EXPOSURE_CMD, this, Float.valueOf(this.toneMapping.exposure));
                EventManager.publish(Event.UPSCALE_FILTER_CMD, this, new Object[]{this.upscaleFilter});
                this.antialiasing.apply();
                this.bloom.apply();
                this.unsharpMask.apply();
                this.chromaticAberration.apply();
                this.filmGrain.apply();
                this.lensFlare.apply();
                this.lightGlow.apply();
                this.levels.apply();
                this.toneMapping.apply();
                this.ssr.apply();
                this.motionBlur.apply();
                this.reprojection.apply();
                this.warpingMesh.apply();
            });
        }

        public static enum AntialiasType {
            NONE(0),
            FXAA(-1),
            NFAA(-2),
            SSAA(1);

            final int aaCode;

            private AntialiasType(int aacode) {
                this.aaCode = aacode;
            }

            public static AntialiasType getFromCode(int code) {
                return switch (code) {
                    case 0 -> NONE;
                    case -1 -> FXAA;
                    case -2 -> NFAA;
                    case 1 -> SSAA;
                    default -> throw new IllegalStateException("Unexpected value: " + code);
                };
            }

            public int getAACode() {
                return this.aaCode;
            }

            public boolean isPostProcessAntialias() {
                return this.aaCode < 0;
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class AntialiasSettings
        extends SettingsObject {
            public AntialiasType type = AntialiasType.FXAA;
            public int quality = 1;

            @Override
            public AntialiasSettings clone() {
                return (AntialiasSettings)super.clone();
            }

            @Override
            void apply() {
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class BloomSettings
        extends SettingsObject {
            public float intensity;
            public float fboScale = 0.5f;

            @Override
            public BloomSettings clone() {
                return (BloomSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class UnsharpMaskSettings
        extends SettingsObject {
            public float factor;

            @Override
            public UnsharpMaskSettings clone() {
                return (UnsharpMaskSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class ChromaticAberrationSettings
        extends SettingsObject {
            public float amount = 0.01f;

            @Override
            public ChromaticAberrationSettings clone() {
                return (ChromaticAberrationSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class FilmGrainSettings
        extends SettingsObject {
            public float intensity = 0.0f;

            @Override
            public FilmGrainSettings clone() {
                return (FilmGrainSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class LensFlareSettings
        extends SettingsObject {
            public boolean active;
            public LensFlareType type = LensFlareType.SIMPLE;
            public float strength = 1.0f;
            public int numGhosts = 8;
            public float haloWidth = 0.5f;
            public int blurPasses = 35;
            public float flareSaturation = 0.8f;
            public float bias = -0.98f;
            public String texLensColor = "$data/tex/base/lenscolor.png";
            public String texLensDirt = "$data/tex/base/lensdirt%#QUAL#%.jpg";
            public String texLensStarburst = "$data/tex/base/lensstarburst.jpg";
            public float fboScale = 0.4f;

            public void setType(String type) {
                this.type = LensFlareType.valueOf(type.toUpperCase(Locale.ROOT));
            }

            @Override
            public LensFlareSettings clone() {
                return (LensFlareSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class LightGlowSettings
        extends SettingsObject {
            public boolean active;
            public int samples = 1;

            @Override
            public LightGlowSettings clone() {
                return (LightGlowSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class SSRSettings
        extends SettingsObject {
            public boolean active;

            @Override
            public SSRSettings clone() {
                return (SSRSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class MotionBlurSettings
        extends SettingsObject {
            public boolean active;
            public float strength;

            @Override
            public MotionBlurSettings clone() {
                return (MotionBlurSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class ReprojectionSettings
        extends SettingsObject {
            public boolean active;
            public ReprojectionMode mode;

            public void setReprojection(String reprojectionString) {
                this.mode = ReprojectionMode.valueOf(reprojectionString.toUpperCase(Locale.ROOT));
            }

            @Override
            public ReprojectionSettings clone() {
                return (ReprojectionSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class LevelsSettings
        extends SettingsObject {
            public float brightness;
            public float contrast;
            public float hue;
            public float saturation;
            public float gamma;

            @Override
            public LevelsSettings clone() {
                return (LevelsSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class ToneMappingSettings
        extends SettingsObject {
            public ToneMapping type;
            public float exposure;

            public void setType(String typeString) {
                this.type = ToneMapping.valueOf(typeString.toUpperCase(Locale.ROOT));
            }

            @Override
            public ToneMappingSettings clone() {
                return (ToneMappingSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class GeometryWarpSettings
        extends SettingsObject {
            public String pfmFile = null;

            @Override
            public GeometryWarpSettings clone() {
                return (GeometryWarpSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ProxySettings
    extends SettingsObject {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public ProxyBean http;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public ProxyBean https;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public ProxyBean socks;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public ProxyBean ftp;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public Boolean useSystemProxies;

        @Override
        public ProxySettings clone() {
            ProxySettings c = (ProxySettings)super.clone();
            c.http = this.http.clone();
            c.https = this.https.clone();
            c.socks = this.socks.clone();
            c.ftp = this.ftp.clone();
            return c;
        }

        @Override
        protected void setParentRecursive(SettingsObject s) {
            this.http.setParent(s);
            this.https.setParent(s);
            this.socks.setParent(s);
            this.ftp.setParent(s);
        }

        @Override
        protected void setupListeners() {
            this.http.setupListeners();
            this.https.setupListeners();
            this.socks.setupListeners();
            this.ftp.setupListeners();
        }

        @Override
        public void apply() {
            this.http.apply();
            this.https.apply();
            this.socks.apply();
            this.ftp.apply();
        }

        public void dispose() {
            this.http.dispose();
            this.https.dispose();
            this.socks.dispose();
            this.ftp.dispose();
        }

        public static class ProxyBean
        extends SettingsObject {
            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public Integer version;
            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public Integer port;
            @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
            public String host;
            @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
            public String username;
            @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
            public String password;
            @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
            public String nonProxyHosts;

            @Override
            public ProxyBean clone() {
                return (ProxyBean)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RuntimeSettings
    extends SettingsObject
    implements IObserver {
        public boolean openXr = false;
        public boolean displayGui = true;
        public boolean updatePause = false;
        public boolean timeOn = false;
        public boolean realTime = false;
        public boolean inputEnabled = true;
        public boolean recordCamera = false;
        public boolean recordKeyframeCamera = false;
        public boolean drawOctree = false;
        public boolean relativisticAberration = false;
        public boolean gravitationalWaves = false;
        public boolean displayVrGui = false;
        public boolean octreeLoadActive = false;
        public long maxTimeMs = 157788000000000000L;
        public long minTimeMs = -this.maxTimeMs;

        public void setMaxTime(long years) {
            this.maxTimeMs = years * 31557600000L;
            this.minTimeMs = -this.maxTimeMs;
        }

        public void toggleTimeOn(Boolean timeOn) {
            this.timeOn = Objects.requireNonNullElseGet(timeOn, () -> !this.timeOn);
        }

        public void toggleRecord(Boolean rec, Settings settings) {
            this.recordCamera = Objects.requireNonNullElseGet(rec, () -> !this.recordCamera);
        }

        @Override
        public void notify(Event event, Object source, Object ... data) {
            if (this.isEnabled() && source != this) {
                switch (event) {
                    case INPUT_ENABLED_CMD: {
                        this.inputEnabled = (Boolean)data[0];
                        break;
                    }
                    case DISPLAY_GUI_CMD: {
                        this.displayGui = (Boolean)data[0];
                        break;
                    }
                    case DISPLAY_VR_GUI_CMD: {
                        if (data.length > 1) {
                            this.displayVrGui = (Boolean)data[1];
                            break;
                        }
                        this.displayVrGui = !this.displayVrGui;
                        break;
                    }
                    case TOGGLE_UPDATEPAUSE: {
                        this.updatePause = !this.updatePause;
                        EventManager.publish(Event.UPDATEPAUSE_CHANGED, this, this.updatePause);
                        break;
                    }
                    case TIME_STATE_CMD: {
                        this.toggleTimeOn((Boolean)data[0]);
                        break;
                    }
                    case RECORD_CAMERA_CMD: {
                        this.toggleRecord((Boolean)data[0], settings);
                        break;
                    }
                    case RELATIVISTIC_ABERRATION_CMD: {
                        this.relativisticAberration = (Boolean)data[0];
                        break;
                    }
                    case GRAV_WAVE_START: {
                        this.gravitationalWaves = true;
                        break;
                    }
                    case GRAV_WAVE_STOP: {
                        this.gravitationalWaves = false;
                        break;
                    }
                }
            }
        }

        @Override
        public RuntimeSettings clone() {
            return (RuntimeSettings)super.clone();
        }

        @Override
        protected void setParentRecursive(SettingsObject s) {
        }

        @Override
        protected void setupListeners() {
            EventManager.instance.subscribe((IObserver)this, Event.INPUT_ENABLED_CMD, Event.DISPLAY_GUI_CMD, Event.TOGGLE_UPDATEPAUSE, Event.TIME_STATE_CMD, Event.RECORD_CAMERA_CMD, Event.RELATIVISTIC_ABERRATION_CMD, Event.GRAV_WAVE_START, Event.GRAV_WAVE_STOP, Event.DISPLAY_VR_GUI_CMD);
        }

        public void dispose() {
            EventManager.instance.removeAllSubscriptions((IObserver)this);
        }

        @Override
        public void apply() {
            EventManager.publish(Event.INPUT_ENABLED_CMD, this, this.inputEnabled);
            EventManager.publish(Event.DISPLAY_GUI_CMD, this, this.displayGui, I18n.msg("notif.cleanmode"));
            EventManager.publish(Event.DISPLAY_VR_GUI_CMD, this, this.displayVrGui);
            EventManager.publish(Event.TIME_STATE_CMD, this, this.timeOn);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SceneSettings
    extends SettingsObject
    implements IObserver {
        public String homeObject;
        public long fadeMs;
        public CameraSettings camera;
        public ParticleSettings particleGroups;
        public StarSettings star;
        public LabelSettings label;
        public ProperMotionSettings properMotion;
        public OctreeSettings octree;
        public RendererSettings renderer;
        public CrosshairSettings crosshair;
        public InitializationSettings initialization;
        public Map<String, Boolean> visibility;
        @JsonIgnore
        public double distanceScaleDesktop = 1.0;
        @JsonIgnore
        public double distanceScaleVr = 10000.0;

        public void setVisibility(Map<String, Object> map) {
            ComponentTypes.ComponentType[] cts = ComponentTypes.ComponentType.values();
            Comparator<String> componentTypeComparator = Comparator.comparingInt(s -> ComponentTypes.ComponentType.valueOf(s).ordinal());
            this.visibility = new TreeMap<String, Boolean>(componentTypeComparator);
            for (ComponentTypes.ComponentType ct : cts) {
                String key = ct.name();
                if (map.containsKey(key)) {
                    this.visibility.put(key, (Boolean)map.get(key));
                    continue;
                }
                this.visibility.put(key, false);
            }
        }

        @Override
        public void notify(Event event, Object source, Object ... data) {
            if (this.isEnabled() && source != this && Objects.requireNonNull(event) == Event.TOGGLE_VISIBILITY_CMD) {
                ComponentTypes.ComponentType ct;
                String key = (String)data[0];
                Boolean state = null;
                if (data.length == 2) {
                    state = (Boolean)data[1];
                }
                if ((ct = ComponentTypes.ComponentType.getFromKey(key)) != null) {
                    this.visibility.put(ct.name(), state != null ? state : this.visibility.get(ct.name()) == false);
                }
            }
        }

        @Override
        public SceneSettings clone() {
            SceneSettings c = (SceneSettings)super.clone();
            c.camera = this.camera.clone();
            c.star = this.star.clone();
            c.renderer = this.renderer.clone();
            c.octree = this.octree.clone();
            c.crosshair = this.crosshair.clone();
            c.properMotion = this.properMotion.clone();
            c.label = this.label.clone();
            c.particleGroups = this.particleGroups.clone();
            c.initialization = this.initialization.clone();
            c.visibility = new HashMap<String, Boolean>(this.visibility);
            return c;
        }

        @Override
        protected void setParentRecursive(SettingsObject s) {
            this.camera.setParent(s);
            this.star.setParent(s);
            this.renderer.setParent(s);
            this.octree.setParent(s);
            this.crosshair.setParent(s);
            this.properMotion.setParent(s);
            this.label.setParent(s);
            this.particleGroups.setParent(s);
            this.initialization.setParent(s);
        }

        @Override
        protected void setupListeners() {
            EventManager.instance.subscribe((IObserver)this, Event.TOGGLE_VISIBILITY_CMD);
            this.camera.setupListeners();
            this.star.setupListeners();
            this.renderer.setupListeners();
            this.octree.setupListeners();
            this.crosshair.setupListeners();
            this.properMotion.setupListeners();
            this.label.setupListeners();
            this.particleGroups.setupListeners();
            this.initialization.setupListeners();
        }

        public void dispose() {
            EventManager.instance.removeAllSubscriptions((IObserver)this);
            this.camera.dispose();
            this.star.dispose();
            this.renderer.dispose();
            this.octree.dispose();
            this.crosshair.dispose();
            this.properMotion.dispose();
            this.label.dispose();
            this.particleGroups.dispose();
            this.initialization.dispose();
        }

        @Override
        public void apply() {
            Set<String> keys = this.visibility.keySet();
            for (String ctName : keys) {
                Boolean value = this.visibility.get(ctName);
                ComponentTypes.ComponentType ct = ComponentTypes.ComponentType.valueOf(ctName);
                EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, ct.key, value);
            }
            this.camera.apply();
            this.star.apply();
            this.renderer.apply();
            this.octree.apply();
            this.crosshair.apply();
            this.properMotion.apply();
            this.label.apply();
            this.particleGroups.apply();
            this.initialization.apply();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class CameraSettings
        extends SettingsObject
        implements IObserver {
            public int speedLimitIndex;
            @JsonIgnore
            public double speedLimit;
            public double speed;
            public double turn;
            public double rotate;
            public float fov;
            public boolean cinematic;
            public boolean targetMode;
            public boolean starDistanceScaling = true;
            public FocusSettings focusLock;

            @JsonProperty(value="speedLimitIndex")
            public void setSpeedLimitIndex(int index) {
                this.speedLimitIndex = index;
                this.updateSpeedLimit();
            }

            @Override
            public void notify(Event event, Object source, Object ... data) {
                if (this.isEnabled() && source != this) {
                    switch (event) {
                        case FOCUS_LOCK_CMD: {
                            this.focusLock.position = (Boolean)data[0];
                            break;
                        }
                        case ORIENTATION_LOCK_CMD: {
                            this.focusLock.orientation = (Boolean)data[0];
                            break;
                        }
                        case FOV_CHANGED_CMD: {
                            if (SlaveManager.projectionActive()) break;
                            boolean checkMax = source instanceof Actor;
                            this.fov = MathUtilsDouble.clamp(((Float)data[0]).floatValue(), 1.0f, checkMax ? 150.0f : 179.0f);
                            break;
                        }
                        case CAMERA_SPEED_CMD: {
                            this.speed = ((Float)data[0]).floatValue();
                            break;
                        }
                        case ROTATION_SPEED_CMD: {
                            this.rotate = ((Float)data[0]).floatValue();
                            break;
                        }
                        case TURNING_SPEED_CMD: {
                            this.turn = ((Float)data[0]).floatValue();
                            break;
                        }
                        case SPEED_LIMIT_CMD: {
                            this.speedLimitIndex = (Integer)data[0];
                            this.updateSpeedLimit();
                            break;
                        }
                        case CAMERA_CINEMATIC_CMD: {
                            this.cinematic = (Boolean)data[0];
                        }
                    }
                }
            }

            public void updateSpeedLimit() {
                switch (this.speedLimitIndex) {
                    case 0: {
                        this.speedLimit = 2.77777778E-4 * Constants.KM_TO_U;
                        break;
                    }
                    case 1: {
                        this.speedLimit = 0.00277777778 * Constants.KM_TO_U;
                        break;
                    }
                    case 2: {
                        this.speedLimit = 0.0277777778 * Constants.KM_TO_U;
                        break;
                    }
                    case 3: {
                        this.speedLimit = 0.277777778 * Constants.KM_TO_U;
                        break;
                    }
                    case 4: {
                        this.speedLimit = Constants.KM_TO_U;
                        break;
                    }
                    case 5: {
                        this.speedLimit = Constants.KM_TO_U;
                        break;
                    }
                    case 6: {
                        this.speedLimit = Constants.KM_TO_U;
                        break;
                    }
                    case 7: {
                        this.speedLimit = 0.277777778 * Constants.KM_TO_U;
                        break;
                    }
                    case 8: {
                        this.speedLimit = 2997924.58 * Constants.M_TO_U;
                        break;
                    }
                    case 9: {
                        this.speedLimit = 2.99792458E7 * Constants.M_TO_U;
                        break;
                    }
                    case 10: {
                        this.speedLimit = 1.49896229E8 * Constants.M_TO_U;
                        break;
                    }
                    case 11: {
                        this.speedLimit = 2.398339664E8 * Constants.M_TO_U;
                        break;
                    }
                    case 12: {
                        this.speedLimit = 2.698132122E8 * Constants.M_TO_U;
                        break;
                    }
                    case 13: {
                        this.speedLimit = 2.9679453342E8 * Constants.M_TO_U;
                        break;
                    }
                    case 14: {
                        this.speedLimit = 2.9978946007542E8 * Constants.M_TO_U;
                        break;
                    }
                    case 15: {
                        this.speedLimit = 2.99792458E8 * Constants.M_TO_U;
                        break;
                    }
                    case 16: {
                        this.speedLimit = 5.99584916E8 * Constants.M_TO_U;
                        break;
                    }
                    case 17: {
                        this.speedLimit = 2.99792458E9 * Constants.M_TO_U;
                        break;
                    }
                    case 18: {
                        this.speedLimit = 2.99792458E11 * Constants.M_TO_U;
                        break;
                    }
                    case 19: {
                        this.speedLimit = Constants.AU_TO_U;
                        break;
                    }
                    case 20: {
                        this.speedLimit = 10.0 * Constants.AU_TO_U;
                        break;
                    }
                    case 21: {
                        this.speedLimit = 1000.0 * Constants.AU_TO_U;
                        break;
                    }
                    case 22: {
                        this.speedLimit = 10000.0 * Constants.AU_TO_U;
                        break;
                    }
                    case 23: {
                        this.speedLimit = Constants.PC_TO_U;
                        break;
                    }
                    case 24: {
                        this.speedLimit = 2.0 * Constants.PC_TO_U;
                        break;
                    }
                    case 25: {
                        this.speedLimit = 10.0 * Constants.PC_TO_U;
                        break;
                    }
                    case 26: {
                        this.speedLimit = 1000.0 * Constants.PC_TO_U;
                        break;
                    }
                    case 27: {
                        this.speedLimit = -1.0;
                    }
                }
            }

            @Override
            public CameraSettings clone() {
                CameraSettings c = (CameraSettings)super.clone();
                c.focusLock = this.focusLock.clone();
                return c;
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
                this.focusLock.setParent(s);
            }

            @Override
            protected void setupListeners() {
                EventManager.instance.subscribe((IObserver)this, Event.CAMERA_CINEMATIC_CMD, Event.FOCUS_LOCK_CMD, Event.ORIENTATION_LOCK_CMD, Event.FOV_CHANGED_CMD, Event.CAMERA_SPEED_CMD, Event.ROTATION_SPEED_CMD, Event.TURNING_SPEED_CMD, Event.SPEED_LIMIT_CMD);
                this.focusLock.setupListeners();
            }

            public void dispose() {
                EventManager.instance.removeAllSubscriptions((IObserver)this);
                this.focusLock.dispose();
            }

            @Override
            public void apply() {
                EventManager.publish(Event.FOCUS_LOCK_CMD, this, this.focusLock.position);
                EventManager.publish(Event.ORIENTATION_LOCK_CMD, this, this.focusLock.orientation);
                EventManager.publish(Event.FOV_CHANGED_CMD, this, Float.valueOf(this.fov));
                EventManager.publish(Event.CAMERA_SPEED_CMD, this, Float.valueOf((float)this.speed));
                EventManager.publish(Event.ROTATION_SPEED_CMD, this, Float.valueOf((float)this.rotate));
                EventManager.publish(Event.TURNING_SPEED_CMD, this, Float.valueOf((float)this.turn));
                EventManager.publish(Event.SPEED_LIMIT_CMD, this, this.speedLimitIndex);
                EventManager.publish(Event.CAMERA_CINEMATIC_CMD, this, this.cinematic);
                this.focusLock.apply();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class FocusSettings
            extends SettingsObject {
                public boolean position;
                public boolean orientation;

                @Override
                public FocusSettings clone() {
                    return (FocusSettings)super.clone();
                }

                @Override
                protected void setParentRecursive(SettingsObject s) {
                }

                @Override
                protected void setupListeners() {
                }

                public void dispose() {
                }

                @Override
                public void apply() {
                }
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class StarSettings
        extends SettingsObject
        implements IObserver {
            public boolean renderStarSpheres;
            public float brightness;
            public float power;
            public float pointSize;
            public float saturate = 0.16f;
            public double glowFactor = 0.06;
            public float[] opacity;
            public int textureIndex = 4;
            public int textureIndexLens = 1;
            public GroupSettings group;
            public ThresholdSettings threshold;
            @JsonIgnore
            private float pointSizeBak;

            public static float getStarPointSize() {
                if (Settings.settings.program.modeCubemap.active) {
                    float screenArea = Settings.settings.graphics.getScreenHeight() * Settings.settings.graphics.getScreenWidth();
                    float cubemapRes = Settings.settings.program.modeCubemap.faceResolution;
                    float pointSize = cubemapRes <= 2000.0f ? MathUtilsDouble.lint(cubemapRes, 500.0f, 2000.0f, 20.0f, 8.0f) : MathUtilsDouble.lint(cubemapRes, 2000.0f, 3000.0f, 8.0f, 4.0f);
                    return MathUtils.clamp((float)pointSize, (float)0.0f, (float)50.0f) * (Settings.settings.scene.star.pointSize / 3.75f) * (MathUtilsDouble.lint(screenArea, 500000.0f, 8000000.0f, 1.8f, 4.8f) / 3.75f);
                }
                return Settings.settings.scene.star.pointSize;
            }

            @JsonIgnore
            public String getStarTexture(int textureIndex) {
                String starTexIdx = String.format("%02d", textureIndex);
                String texture = Settings.settings.data.dataFile(GlobalResources.unpackAssetPathExtensions("$data/tex/base/star-tex-" + starTexIdx + "%#QUAL#%", ".jpg", ".png"));
                if (texture == null) {
                    for (int i = 1; i < 9; ++i) {
                        starTexIdx = String.format("%02d", i);
                        texture = Settings.settings.data.dataFile(GlobalResources.unpackAssetPathExtensions("$data/tex/base/star-tex-" + starTexIdx + "%#QUAL#%", ".jpg", ".png"));
                        if (texture == null) continue;
                        return texture;
                    }
                } else {
                    return texture;
                }
                return null;
            }

            @JsonIgnore
            public IntArray getStarTextureIndices() {
                IntArray result = new IntArray(9);
                for (int i = 1; i < 9; ++i) {
                    String starTexIdx = String.format("%02d", i);
                    String t = GlobalResources.unpackAssetPathExtensions("$data/tex/base/star-tex-" + starTexIdx + "%#QUAL#%", ".jpg", ".png");
                    if (t == null) continue;
                    result.add(i);
                }
                return result;
            }

            @JsonIgnore
            public String getStarTexture() {
                return this.getStarTexture(this.textureIndex);
            }

            @JsonIgnore
            public String getStarLensTexture() {
                return this.getStarTexture(this.textureIndexLens);
            }

            public void setPointSize(float pointSize) {
                this.pointSize = pointSize;
                this.pointSizeBak = pointSize;
            }

            @Override
            public void notify(Event event, Object source, Object ... data) {
                if (this.isEnabled() && source != this) {
                    switch (event) {
                        case STAR_POINT_SIZE_CMD: {
                            this.pointSize = ((Float)data[0]).floatValue();
                            break;
                        }
                        case STAR_POINT_SIZE_INCREASE_CMD: {
                            float size = FastMath.min((float)(this.pointSize + 0.01f), (float)20.0f);
                            EventManager.publish(Event.STAR_POINT_SIZE_CMD, this, Float.valueOf(size));
                            break;
                        }
                        case STAR_POINT_SIZE_DECREASE_CMD: {
                            float size = FastMath.max((float)(this.pointSize - 0.01f), (float)0.1f);
                            EventManager.publish(Event.STAR_POINT_SIZE_CMD, this, Float.valueOf(size));
                            break;
                        }
                        case STAR_POINT_SIZE_RESET_CMD: {
                            this.pointSize = this.pointSizeBak;
                            break;
                        }
                        case STAR_BASE_LEVEL_CMD: {
                            this.opacity[0] = ((Float)data[0]).floatValue();
                            break;
                        }
                        case STAR_GROUP_BILLBOARD_CMD: {
                            this.group.billboard = (Boolean)data[0];
                            break;
                        }
                        case STAR_GROUP_NEAREST_CMD: {
                            this.group.numBillboard = (Integer)data[0];
                            this.group.numLabels = (Integer)data[0];
                            this.group.numVelocityVector = (Integer)data[0];
                            break;
                        }
                        case BILLBOARD_TEXTURE_IDX_CMD: {
                            this.textureIndex = (Integer)data[0];
                            break;
                        }
                        case STAR_BRIGHTNESS_CMD: {
                            this.brightness = MathUtilsDouble.clamp(((Float)data[0]).floatValue(), 0.4f, 8.0f);
                            break;
                        }
                        case STAR_BRIGHTNESS_POW_CMD: {
                            this.power = ((Float)data[0]).floatValue();
                            break;
                        }
                        case STAR_GLOW_FACTOR_CMD: {
                            this.glowFactor = ((Float)data[0]).floatValue();
                        }
                    }
                }
            }

            @Override
            public StarSettings clone() {
                StarSettings c = (StarSettings)super.clone();
                c.opacity = (float[])this.opacity.clone();
                c.group = this.group.clone();
                c.threshold = this.threshold.clone();
                return c;
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
                this.group.setParent(s);
                this.threshold.setParent(s);
            }

            @Override
            protected void setupListeners() {
                EventManager.instance.subscribe((IObserver)this, Event.STAR_BRIGHTNESS_CMD, Event.STAR_BRIGHTNESS_POW_CMD, Event.STAR_GLOW_FACTOR_CMD, Event.STAR_POINT_SIZE_CMD, Event.STAR_POINT_SIZE_INCREASE_CMD, Event.STAR_POINT_SIZE_DECREASE_CMD, Event.STAR_POINT_SIZE_RESET_CMD, Event.STAR_BASE_LEVEL_CMD, Event.STAR_GROUP_BILLBOARD_CMD, Event.STAR_GROUP_NEAREST_CMD, Event.BILLBOARD_TEXTURE_IDX_CMD);
                this.group.setupListeners();
                this.threshold.setupListeners();
            }

            public void dispose() {
                EventManager.instance.removeAllSubscriptions((IObserver)this);
                this.group.dispose();
                this.threshold.dispose();
            }

            @Override
            public void apply() {
                EventManager.publish(Event.STAR_POINT_SIZE_CMD, this, Float.valueOf(this.pointSize));
                EventManager.publish(Event.STAR_BASE_LEVEL_CMD, this, Float.valueOf(this.opacity[0]));
                EventManager.publish(Event.STAR_GROUP_BILLBOARD_CMD, this, this.group.billboard);
                EventManager.publish(Event.BILLBOARD_TEXTURE_IDX_CMD, this, this.textureIndex);
                EventManager.publish(Event.STAR_BRIGHTNESS_CMD, this, Float.valueOf(this.brightness));
                EventManager.publish(Event.STAR_BRIGHTNESS_POW_CMD, this, Float.valueOf(this.power));
                EventManager.publish(Event.STAR_GLOW_FACTOR_CMD, this, Float.valueOf((float)this.glowFactor));
                this.group.apply();
                this.threshold.apply();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class GroupSettings
            extends SettingsObject {
                public boolean billboard;
                public int numBillboard;
                public int numLabels = 30;
                public int numVelocityVector;

                @JsonIgnore
                public int getMaxNumIndices() {
                    return MathUtilsDouble.max(this.numLabels, this.numVelocityVector, this.numBillboard);
                }

                public void setNumLabel(int numLabels) {
                    this.numLabels = numLabels;
                }

                @Override
                public GroupSettings clone() {
                    return (GroupSettings)super.clone();
                }

                @Override
                protected void setParentRecursive(SettingsObject s) {
                }

                @Override
                protected void setupListeners() {
                }

                public void dispose() {
                }

                @Override
                public void apply() {
                }
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class ThresholdSettings
            extends SettingsObject {
                public double quad;
                public double point;
                public double none;

                @Override
                public ThresholdSettings clone() {
                    return (ThresholdSettings)super.clone();
                }

                @Override
                protected void setParentRecursive(SettingsObject s) {
                }

                @Override
                protected void setupListeners() {
                }

                public void dispose() {
                }

                @Override
                public void apply() {
                }
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class RendererSettings
        extends SettingsObject
        implements IObserver {
            public PointCloudMode pointCloud = PointCloudMode.POINTS;
            public double ambient;
            public LineSettings line;
            public ShadowSettings shadow;
            public EclipseSettings eclipses;
            public ElevationSettings elevation;
            public VirtualTextureSettings virtualTextures;
            @JsonIgnore
            public double orbitSolidAngleThreshold = FastMath.toRadians((double)1.5);

            @JsonProperty(value="pointCloud")
            public void setPointCloud(String pointCloud) {
                if (pointCloud == null || pointCloud.isEmpty()) {
                    pointCloud = "POINTS";
                }
                if (pointCloud.startsWith("GL_")) {
                    pointCloud = pointCloud.substring(3);
                }
                if (pointCloud.equalsIgnoreCase("TRIANGLES_INSTANCED")) {
                    pointCloud = "TRIANGLES";
                }
                this.pointCloud = PointCloudMode.valueOf(pointCloud.toUpperCase(Locale.ROOT));
            }

            @Override
            public void notify(Event event, Object source, Object ... data) {
                if (this.isEnabled() && source != this) {
                    switch (event) {
                        case AMBIENT_LIGHT_CMD: {
                            this.ambient = ((Float)data[0]).floatValue();
                            break;
                        }
                        case ELEVATION_MULTIPLIER_CMD: {
                            this.elevation.multiplier = MathUtilsDouble.clamp(((Float)data[0]).floatValue(), 0.0f, 15.0f);
                            break;
                        }
                        case ELEVATION_TYPE_CMD: {
                            this.elevation.type = (ElevationType)((Object)data[0]);
                            break;
                        }
                        case TESSELLATION_QUALITY_CMD: {
                            this.elevation.quality = ((Float)data[0]).floatValue();
                            break;
                        }
                        case ORBIT_SOLID_ANGLE_TH_CMD: {
                            this.orbitSolidAngleThreshold = (Double)data[0];
                            break;
                        }
                        case SVT_CACHE_SIZE_CMD: {
                            this.virtualTextures.cacheSize = (Integer)data[0];
                        }
                    }
                }
            }

            @Override
            public RendererSettings clone() {
                RendererSettings c = (RendererSettings)super.clone();
                c.line = this.line.clone();
                c.shadow = this.shadow.clone();
                c.eclipses = this.eclipses.clone();
                c.elevation = this.elevation.clone();
                c.virtualTextures = this.virtualTextures.clone();
                return c;
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
                this.line.setParent(s);
                this.shadow.setParent(s);
                this.eclipses.setParent(s);
                this.elevation.setParent(s);
                this.virtualTextures.setParent(s);
            }

            @Override
            protected void setupListeners() {
                EventManager.instance.subscribe((IObserver)this, Event.AMBIENT_LIGHT_CMD, Event.ELEVATION_MULTIPLIER_CMD, Event.ELEVATION_TYPE_CMD, Event.TESSELLATION_QUALITY_CMD, Event.ORBIT_SOLID_ANGLE_TH_CMD, Event.SVT_CACHE_SIZE_CMD);
                this.line.setupListeners();
                this.shadow.setupListeners();
                this.eclipses.setupListeners();
                this.elevation.setupListeners();
                this.virtualTextures.setupListeners();
            }

            public void dispose() {
                EventManager.instance.removeAllSubscriptions((IObserver)this);
                this.line.dispose();
                this.shadow.dispose();
                this.eclipses.dispose();
                this.elevation.dispose();
                this.virtualTextures.dispose();
            }

            @Override
            public void apply() {
                EventManager.publish(Event.AMBIENT_LIGHT_CMD, this, Float.valueOf((float)this.ambient));
                EventManager.publish(Event.ELEVATION_MULTIPLIER_CMD, this, Float.valueOf((float)this.elevation.multiplier));
                EventManager.publish(Event.ELEVATION_TYPE_CMD, this, new Object[]{this.elevation.type});
                EventManager.publish(Event.TESSELLATION_QUALITY_CMD, this, Float.valueOf((float)this.elevation.quality));
                EventManager.publish(Event.ORBIT_SOLID_ANGLE_TH_CMD, this, this.orbitSolidAngleThreshold);
                EventManager.publish(Event.SVT_CACHE_SIZE_CMD, this, this.virtualTextures.cacheSize);
                this.line.apply();
                this.shadow.apply();
                this.eclipses.apply();
                this.elevation.apply();
                this.virtualTextures.apply();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class ElevationSettings
            extends SettingsObject {
                public ElevationType type;
                public double multiplier;
                public double quality;

                public void setType(String typeString) {
                    if (typeString.equalsIgnoreCase("PARALLAX_MAPPING")) {
                        typeString = "REGULAR";
                    }
                    this.type = ElevationType.valueOf(typeString.toUpperCase());
                }

                @Override
                public ElevationSettings clone() {
                    return (ElevationSettings)super.clone();
                }

                @Override
                protected void setParentRecursive(SettingsObject s) {
                }

                @Override
                protected void setupListeners() {
                }

                public void dispose() {
                }

                @Override
                public void apply() {
                }
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class VirtualTextureSettings
            extends SettingsObject {
                public int cacheSize;
                public double detectionBufferFactor;
                public int maxTilesPerFrame = 8;

                @Override
                public VirtualTextureSettings clone() {
                    return (VirtualTextureSettings)super.clone();
                }

                @Override
                protected void setParentRecursive(SettingsObject s) {
                }

                @Override
                protected void setupListeners() {
                }

                public void dispose() {
                }

                @Override
                public void apply() {
                }
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class LineSettings
            extends SettingsObject
            implements IObserver {
                public LineMode mode = LineMode.POLYLINE_QUADSTRIP;
                public float width;
                public float glWidthBias = 0.0f;

                @JsonIgnore
                public boolean isNormalLineRenderer() {
                    return this.mode.equals((Object)LineMode.GL_LINES);
                }

                @JsonIgnore
                public boolean isQuadLineRenderer() {
                    return this.mode.equals((Object)LineMode.POLYLINE_QUADSTRIP);
                }

                @Override
                public LineSettings clone() {
                    return (LineSettings)super.clone();
                }

                @Override
                protected void setParentRecursive(SettingsObject s) {
                }

                @Override
                protected void setupListeners() {
                    EventManager.instance.subscribe((IObserver)this, Event.LINE_WIDTH_CMD);
                }

                @Override
                public void notify(Event event, Object source, Object ... data) {
                    if (this.isEnabled() && source != this && Objects.requireNonNull(event) == Event.LINE_WIDTH_CMD) {
                        this.width = MathUtilsDouble.clamp(((Float)data[0]).floatValue(), 0.2f, 3.5f);
                    }
                }

                public void dispose() {
                    EventManager.instance.removeAllSubscriptions((IObserver)this);
                }

                @Override
                public void apply() {
                    EventManager.publish(Event.LINE_WIDTH_CMD, this, Float.valueOf(this.width));
                }
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class ShadowSettings
            extends SettingsObject {
                public boolean active;
                public int resolution;
                public int number;

                @Override
                public ShadowSettings clone() {
                    return (ShadowSettings)super.clone();
                }

                @Override
                protected void setParentRecursive(SettingsObject s) {
                }

                @Override
                protected void setupListeners() {
                }

                public void dispose() {
                }

                @Override
                public void apply() {
                }
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static class EclipseSettings
            extends SettingsObject {
                public boolean active;
                public boolean outlines;

                @Override
                public EclipseSettings clone() {
                    return (EclipseSettings)super.clone();
                }

                @Override
                protected void setParentRecursive(SettingsObject s) {
                }

                @Override
                protected void setupListeners() {
                }

                public void dispose() {
                }

                @Override
                public void apply() {
                }
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class OctreeSettings
        extends SettingsObject
        implements IObserver {
            public int maxStars;
            public float[] threshold;
            public boolean fade;

            @Override
            public void notify(Event event, Object source, Object ... data) {
                if (this.isEnabled() && source != this && event == Event.OCTREE_PARTICLE_FADE_CMD) {
                    this.fade = (Boolean)data[0];
                }
            }

            @Override
            public OctreeSettings clone() {
                OctreeSettings c = (OctreeSettings)super.clone();
                c.threshold = (float[])this.threshold.clone();
                return c;
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
                EventManager.instance.subscribe((IObserver)this, Event.OCTREE_PARTICLE_FADE_CMD);
            }

            public void dispose() {
                EventManager.instance.removeAllSubscriptions((IObserver)this);
            }

            @Override
            public void apply() {
                EventManager.publish(Event.OCTREE_PARTICLE_FADE_CMD, this, this.fade);
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class CrosshairSettings
        extends SettingsObject
        implements IObserver {
            public boolean focus;
            public boolean closest;
            public boolean home;

            @Override
            public void notify(Event event, Object source, Object ... data) {
                if (this.isEnabled() && source != this) {
                    switch (event) {
                        case CROSSHAIR_FOCUS_CMD: {
                            this.focus = (Boolean)data[0];
                            break;
                        }
                        case CROSSHAIR_CLOSEST_CMD: {
                            this.closest = (Boolean)data[0];
                            break;
                        }
                        case CROSSHAIR_HOME_CMD: {
                            this.home = (Boolean)data[0];
                            break;
                        }
                    }
                }
            }

            @Override
            public CrosshairSettings clone() {
                return (CrosshairSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
                EventManager.instance.subscribe((IObserver)this, Event.CROSSHAIR_FOCUS_CMD, Event.CROSSHAIR_CLOSEST_CMD, Event.CROSSHAIR_HOME_CMD);
            }

            public void dispose() {
                EventManager.instance.removeAllSubscriptions((IObserver)this);
            }

            @Override
            public void apply() {
                EventManager.publish(Event.CROSSHAIR_FOCUS_CMD, this, this.focus);
                EventManager.publish(Event.CROSSHAIR_CLOSEST_CMD, this, this.closest);
                EventManager.publish(Event.CROSSHAIR_HOME_CMD, this, this.home);
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class ProperMotionSettings
        extends SettingsObject
        implements IObserver {
            public float length;
            public double number;
            public int colorMode;
            public boolean arrowHeads;

            @Override
            public void notify(Event event, Object source, Object ... data) {
                if (this.isEnabled() && source != this) {
                    switch (event) {
                        case PM_NUM_FACTOR_CMD: {
                            this.number = MathUtilsDouble.clamp(((Float)data[0]).floatValue(), 1.0f, 10.0f);
                            break;
                        }
                        case PM_LEN_FACTOR_CMD: {
                            this.length = MathUtilsDouble.clamp(((Float)data[0]).floatValue(), 500.0f, 50000.0f);
                            break;
                        }
                        case PM_COLOR_MODE_CMD: {
                            this.colorMode = MathUtilsDouble.clamp((Integer)data[0], 0, 5);
                            break;
                        }
                        case PM_ARROWHEADS_CMD: {
                            this.arrowHeads = (Boolean)data[0];
                        }
                    }
                }
            }

            @Override
            public ProperMotionSettings clone() {
                return (ProperMotionSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
                EventManager.instance.subscribe((IObserver)this, Event.PM_LEN_FACTOR_CMD, Event.PM_NUM_FACTOR_CMD, Event.PM_COLOR_MODE_CMD, Event.PM_ARROWHEADS_CMD);
            }

            public void dispose() {
                EventManager.instance.removeAllSubscriptions((IObserver)this);
            }

            @Override
            public void apply() {
                EventManager.publish(Event.PM_NUM_FACTOR_CMD, this, Float.valueOf((float)this.number));
                EventManager.publish(Event.PM_LEN_FACTOR_CMD, this, Float.valueOf(this.length));
                EventManager.publish(Event.PM_COLOR_MODE_CMD, this, this.colorMode);
                EventManager.publish(Event.PM_ARROWHEADS_CMD, this, this.arrowHeads);
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class LabelSettings
        extends SettingsObject
        implements IObserver {
            public float size;
            public float number;

            @Override
            public void notify(Event event, Object source, Object ... data) {
                if (this.isEnabled() && source != this && event == Event.LABEL_SIZE_CMD) {
                    this.size = MathUtilsDouble.clamp(((Float)data[0]).floatValue(), 0.7f, 2.5f);
                }
            }

            @Override
            public LabelSettings clone() {
                return (LabelSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
                EventManager.instance.subscribe((IObserver)this, Event.LABEL_SIZE_CMD);
            }

            public void dispose() {
                EventManager.instance.removeAllSubscriptions((IObserver)this);
            }

            @Override
            public void apply() {
                EventManager.publish(Event.LABEL_SIZE_CMD, this, Float.valueOf(this.size));
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class ParticleSettings
        extends SettingsObject {
            public int numLabels = 0;
            public boolean motionTrails = true;

            @Override
            public ParticleSettings clone() {
                return (ParticleSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class InitializationSettings
        extends SettingsObject {
            public boolean lazyTexture;
            public boolean lazyMesh;

            @Override
            public InitializationSettings clone() {
                return (InitializationSettings)super.clone();
            }

            @Override
            protected void setParentRecursive(SettingsObject s) {
            }

            @Override
            protected void setupListeners() {
            }

            public void dispose() {
            }

            @Override
            public void apply() {
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ScreenshotSettings
    extends SettingsObject
    implements IObserver {
        public static final int MIN_SCREENSHOT_SIZE = 50;
        public static final int MAX_SCREENSHOT_SIZE = 25000;
        public String location;
        public ImageFormat format;
        public float quality;
        public ScreenshotMode mode;
        public int[] resolution;

        public void setFormat(String formatString) {
            this.format = ImageFormat.valueOf(formatString.toUpperCase(Locale.ROOT));
        }

        public void setMode(String modeString) {
            this.mode = ScreenshotMode.valueOf(modeString);
        }

        @JsonIgnore
        public boolean isSimpleMode() {
            return this.mode.equals((Object)ScreenshotMode.SIMPLE);
        }

        @JsonIgnore
        public boolean isAdvancedMode() {
            return this.mode.equals((Object)ScreenshotMode.ADVANCED);
        }

        @Override
        public void notify(Event event, Object source, Object ... data) {
            if (this.isEnabled() && source != this) {
                switch (event) {
                    case CONFIG_SCREENSHOT_CMD: {
                        this.resolution[0] = (Integer)data[0];
                        this.resolution[1] = (Integer)data[1];
                        this.location = (String)data[3];
                        break;
                    }
                    case SCREENSHOT_MODE_CMD: {
                        Object newMode = data[0];
                        ScreenshotMode mode = null;
                        if (newMode instanceof String) {
                            try {
                                mode = ScreenshotMode.valueOf(((String)newMode).toUpperCase(Locale.ROOT));
                            }
                            catch (IllegalArgumentException e) {
                                logger.error("Given value is not a representation of ScreenshotMode (simple|advanced): '" + String.valueOf(newMode) + "'");
                            }
                        } else {
                            mode = (ScreenshotMode)((Object)newMode);
                        }
                        if (mode == null) break;
                        this.mode = mode;
                    }
                }
            }
        }

        @Override
        public ScreenshotSettings clone() {
            ScreenshotSettings c = (ScreenshotSettings)super.clone();
            c.resolution = (int[])this.resolution.clone();
            return c;
        }

        @Override
        protected void setParentRecursive(SettingsObject s) {
        }

        @Override
        protected void setupListeners() {
            EventManager.instance.subscribe((IObserver)this, Event.CONFIG_SCREENSHOT_CMD, Event.SCREENSHOT_MODE_CMD);
        }

        public void dispose() {
            EventManager.instance.removeAllSubscriptions((IObserver)this);
        }

        @Override
        public void apply() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SpacecraftSettings
    extends SettingsObject {
        public boolean velocityDirection;
        public boolean showAxes;

        @Override
        public SpacecraftSettings clone() {
            return (SpacecraftSettings)super.clone();
        }

        @Override
        protected void setParentRecursive(SettingsObject s) {
        }

        @Override
        protected void setupListeners() {
        }

        public void dispose() {
        }

        @Override
        public void apply() {
        }
    }

    public static enum DistanceUnits {
        INTERNAL(Constants.U_TO_KM, Constants.KM_TO_U, "internal"),
        M(0.001, 1000.0, "m"),
        KM(1.0, 1.0, "km"),
        AU(1.49597871E8, 6.6845871088633344E-9, "au"),
        PC(3.08567758149137E13, 3.2407792894443624E-14, "pc"),
        LY(9.46073E12, 1.057000886823744E-13, "ly");

        public final double toKm;
        public final double fromKm;
        private final String unitString;

        private DistanceUnits(double toKm, double fromKm, String unitString) {
            this.toKm = toKm;
            this.fromKm = fromKm;
            this.unitString = unitString;
        }

        public String getUnitString() {
            return I18n.msg("gui.unit." + this.unitString);
        }

        public double toInternalUnits(double value) {
            return value * this.toKm * Constants.KM_TO_U;
        }

        public double fromInternalUnits(double internal) {
            return internal * Constants.U_TO_KM * this.fromKm;
        }
    }

    public static enum DefaultTimeZone {
        UTC,
        SYSTEM_DEFAULT;


        public ZoneId getTimeZone() {
            if (this.equals((Object)UTC)) {
                return ZoneId.of("UTC");
            }
            return ZoneOffset.systemDefault();
        }
    }

    public static enum LineMode {
        POLYLINE_QUADSTRIP,
        GL_LINES;

    }

    public static enum PointCloudMode {
        TRIANGLES,
        POINTS;


        public boolean isPoints() {
            return this.equals((Object)POINTS);
        }

        public boolean isTriangles() {
            return this.equals((Object)TRIANGLES);
        }
    }

    public static enum ToneMapping {
        AUTO,
        EXPOSURE,
        ACES,
        UNCHARTED,
        FILMIC,
        NONE;

    }

    public static enum UpscaleFilter {
        NEAREST(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest),
        LINEAR(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear),
        XBRZ(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);

        public final Texture.TextureFilter minification;
        public final Texture.TextureFilter magnification;

        private UpscaleFilter(Texture.TextureFilter min, Texture.TextureFilter mag) {
            this.minification = min;
            this.magnification = mag;
        }

        public String toString() {
            return I18n.msg("gui.upscale." + this.name().toLowerCase(Locale.ROOT));
        }
    }

    public static enum GraphicsQuality {
        LOW("gui.gquality.low", "-low", 1024, 512),
        NORMAL("gui.gquality.normal", "-med", 2048, 1024),
        HIGH("gui.gquality.high", "-high", 4096, 2048),
        ULTRA("gui.gquality.ultra", "-ultra", 8192, 4096);

        public final String key;
        public final String suffix;
        public final int texWidthTarget;
        public final int texHeightTarget;

        private GraphicsQuality(String key, String suffix, int texWidthTarget, int texHeightTarget) {
            this.key = key;
            this.suffix = suffix;
            this.texWidthTarget = texWidthTarget;
            this.texHeightTarget = texHeightTarget;
        }

        public boolean isAtLeast(GraphicsQuality gq) {
            return this.ordinal() >= gq.ordinal();
        }

        public boolean isAtMost(GraphicsQuality gq) {
            return this.ordinal() <= gq.ordinal();
        }

        public boolean isLow() {
            return this.equals((Object)LOW);
        }

        public boolean isNormal() {
            return this.equals((Object)NORMAL);
        }

        public boolean isHigh() {
            return this.equals((Object)HIGH);
        }

        public boolean isUltra() {
            return this.equals((Object)ULTRA);
        }

        public int getGlowNLights() {
            if (this.isLow()) {
                return 4;
            }
            if (this.isNormal()) {
                return 5;
            }
            if (this.isHigh()) {
                return 6;
            }
            if (this.isUltra()) {
                return 8;
            }
            return 5;
        }
    }

    public static enum ElevationType {
        REGULAR,
        TESSELLATION,
        NONE;


        public boolean isRegular() {
            return this.equals((Object)REGULAR);
        }

        public boolean isTessellation() {
            return this.equals((Object)TESSELLATION);
        }

        public boolean isParallaxMapping() {
            return false;
        }

        public boolean isNone() {
            return this.equals((Object)NONE);
        }
    }

    public static enum GridStyle {
        CIRCULAR,
        SQUARE;

    }

    public static enum OriginType {
        REFSYS,
        FOCUS;


        public boolean isRefSys() {
            return this.equals((Object)REFSYS);
        }

        public boolean isFocus() {
            return this.equals((Object)FOCUS);
        }
    }

    public static enum StereoProfile {
        VR_HEADSET,
        HORIZONTAL_3DTV,
        VERTICAL_3DTV,
        CROSSEYE,
        PARALLEL_VIEW,
        ANAGLYPH_RED_CYAN,
        ANAGLYPH_RED_BLUE;


        public boolean isHorizontal() {
            return this.equals((Object)VR_HEADSET) || this.equals((Object)HORIZONTAL_3DTV) || this.equals((Object)CROSSEYE) || this.equals((Object)PARALLEL_VIEW);
        }

        public boolean isVertical() {
            return this.equals((Object)VERTICAL_3DTV);
        }

        public boolean isVR() {
            return this.equals((Object)VR_HEADSET);
        }

        public boolean isAnaglyph() {
            return this.equals((Object)ANAGLYPH_RED_BLUE) || this.equals((Object)ANAGLYPH_RED_CYAN);
        }

        public boolean isAnaglyphRedCyan() {
            return this.equals((Object)ANAGLYPH_RED_CYAN);
        }

        public boolean isAnaglyphRedBlue() {
            return this.equals((Object)ANAGLYPH_RED_BLUE);
        }

        public int getAnaglyphModeInteger() {
            if (this.isAnaglyphRedBlue()) {
                return 0;
            }
            if (this.isAnaglyphRedCyan()) {
                return 1;
            }
            return 1;
        }

        public boolean correctAspect() {
            return !this.equals((Object)HORIZONTAL_3DTV) && !this.isAnaglyph();
        }
    }

    public static enum LensFlareType {
        SIMPLE,
        COMPLEX,
        PSEUDO;


        public boolean isPseudoLensFlare() {
            return this == PSEUDO;
        }

        public boolean isSimpleLensFlare() {
            return this == SIMPLE;
        }

        public boolean isComplexLensFlare() {
            return this == COMPLEX;
        }
    }

    public static enum ReprojectionMode {
        DISABLED(-1),
        DEFAULT(0),
        ACCURATE(1),
        STEREOGRAPHIC_SCREEN(10),
        STEREOGRAPHIC_LONG(11),
        STEREOGRAPHIC_SHORT(12),
        STEREOGRAPHIC_180(13),
        LAMBERT_SCREEN(20),
        LAMBERT_LONG(21),
        LAMBERT_SHORT(22),
        LAMBERT_180(23),
        ORTHOGRAPHIC_SCREEN(30),
        ORTHOGRAPHIC_LONG(31),
        ORTHOGRAPHIC_SHORT(32),
        ORTHOGRAPHIC_180(33);

        public final int mode;

        private ReprojectionMode(int mode) {
            this.mode = mode;
        }

        public String toString() {
            try {
                String name = I18n.msg("gui.reproj.mode." + this.name().toLowerCase(Locale.ROOT));
                if (name != null && !name.isEmpty()) {
                    return name;
                }
                return this.name();
            }
            catch (Exception e) {
                return this.name();
            }
        }
    }

    public static enum ImageFormat {
        PNG("png"),
        JPG("jpg");

        public final String extension;

        private ImageFormat(String extension) {
            this.extension = extension;
        }
    }

    public static enum ScreenshotMode {
        SIMPLE,
        ADVANCED;

    }
}

