/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import gaiasky.desktop.GaiaSkyDesktop;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.math.MathUtilsDouble;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Properties;
import net.jafama.FastMath;

public class SettingsManager {
    private static final Logger.Log logger = Logger.getLogger(SettingsManager.class);
    public static SettingsManager instance;
    private Settings settings;
    private Properties vp;
    private ObjectMapper mapper;

    public SettingsManager(boolean vr) {
        try {
            InputStream vis = GaiaSkyDesktop.class.getResourceAsStream("/version");
            if (vis == null) {
                vis = new FileInputStream(Settings.ASSETS_LOC + File.separator + "dummyversion");
            }
            this.vp = new Properties();
            this.vp.load(vis);
            this.initializeMapper();
            String propsFileProperty = System.getProperty("properties.file");
            if (propsFileProperty == null || propsFileProperty.isEmpty()) {
                propsFileProperty = this.initConfigFile(vr);
            }
            File confFile = new File(propsFileProperty);
            this.settings = this.loadSettings(confFile);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public SettingsManager(InputStream fis, InputStream vis) {
        try {
            this.vp = new Properties();
            this.vp.load(vis);
            this.initializeMapper();
            this.settings = (Settings)this.mapper.readValue(fis, Settings.class);
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    public Settings loadSettings(File configFile) throws IOException {
        FileInputStream fis = new FileInputStream(configFile);
        return (Settings)this.mapper.readValue((InputStream)fis, Settings.class);
    }

    public static void initialize(boolean vr) throws Exception {
        instance = new SettingsManager(vr);
        instance.initSettings();
    }

    public static void initialize(FileInputStream fis, FileInputStream vis) {
        instance = new SettingsManager(fis, vis);
        instance.initSettings();
    }

    private static void setProxySettings(Settings.ProxySettings.ProxyBean proxy, String protocol) {
        SettingsManager.setProxySettings(proxy, protocol, protocol);
    }

    private static void setProxySettings(Settings.ProxySettings.ProxyBean proxy, String protocol, String nonProxyHostsProtocol) {
        if (proxy.host != null) {
            System.setProperty(protocol + ".proxyHost", proxy.host);
        }
        if (proxy.port != null) {
            System.setProperty(protocol + ".proxyPort", Integer.toString(proxy.port));
        }
        if (proxy.nonProxyHosts != null) {
            System.setProperty(nonProxyHostsProtocol + ".nonProxyHosts", proxy.password);
        }
        if (proxy.username != null) {
            System.setProperty(protocol + ".proxyUser", proxy.username);
        }
        if (proxy.password != null) {
            System.setProperty(protocol + ".proxyPassword", proxy.password);
        }
    }

    private static void setSocksProxySettings(Settings.ProxySettings.ProxyBean proxy) {
        if (proxy.version != null) {
            System.setProperty("socksProxyVersion", Integer.toString(proxy.version));
        }
        if (proxy.host != null) {
            System.setProperty("socksProxyHost", proxy.host);
        }
        if (proxy.port != null) {
            System.setProperty("socksProxyPort", Integer.toString(proxy.port));
        }
        if (proxy.username != null) {
            System.setProperty("java.net.socks.username", proxy.username);
        }
        if (proxy.password != null) {
            System.setProperty("java.net.socks.password", proxy.password);
        }
    }

    public static void initializeProxyAuthenticator() {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                    String protocol = this.getRequestingProtocol().toLowerCase(Locale.ROOT);
                    String host = System.getProperty(protocol + ".proxyHost", "");
                    String port = System.getProperty(protocol + ".proxyPort", "80");
                    String user = System.getProperty(protocol + ".proxyUser", "");
                    String password = System.getProperty(protocol + ".proxyPassword", "");
                    if (this.getRequestingHost().equalsIgnoreCase(host) && Integer.parseInt(port) == this.getRequestingPort()) {
                        return new PasswordAuthentication(user, password.toCharArray());
                    }
                }
                return null;
            }
        });
        System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
    }

    public static void persistSettings(Settings settings, File settingsFile) {
        if (instance != null) {
            instance.persist(settings, settingsFile);
        }
    }

    public static void persistSettings(File settingsFile) {
        if (instance != null) {
            instance.persist(SettingsManager.instance.settings, settingsFile);
        }
    }

    public static String getConfigFileName(boolean vr) {
        if (vr) {
            return "config.vr.yaml";
        }
        return "config.yaml";
    }

    public static boolean setSettingsInstance(Settings settings) {
        return Settings.setSettingsReference(settings);
    }

    private void initializeMapper() {
        YAMLFactory yaml = new YAMLFactory();
        yaml.disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.INDENT_ARRAYS);
        this.mapper = new ObjectMapper((JsonFactory)yaml);
        this.mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper.findAndRegisterModules();
    }

    public void initSettings() {
        Settings.VersionSettings versionSettings = new Settings.VersionSettings();
        String versionStr = this.vp.getProperty("version");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE MMM dd kk:mm:ss z yyyy", Locale.ENGLISH);
        Instant buildTime = null;
        try {
            buildTime = LocalDateTime.parse(this.vp.getProperty("buildtime"), formatter).toInstant(ZoneOffset.UTC);
        }
        catch (DateTimeParseException e) {
            formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy hh:mm a", Locale.ENGLISH);
            try {
                buildTime = LocalDateTime.parse(this.vp.getProperty("buildtime"), formatter).toInstant(ZoneOffset.UTC);
            }
            catch (DateTimeParseException e1) {
                logger.error(e1);
            }
        }
        versionSettings.initialize(versionStr, buildTime, this.vp.getProperty("builder"), this.vp.getProperty("system"), this.vp.getProperty("build"));
        this.settings.runtime = new Settings.RuntimeSettings();
        this.settings.version = versionSettings;
        Settings.settings = this.settings;
        String arch = System.getProperty("sun.arch.data.model");
        if (this.settings.data.location == null || this.settings.data.location.isBlank()) {
            this.settings.data.location = SysUtils.getDefaultDatasetsDir().toAbsolutePath().toString().replaceAll("\\\\", "/");
        }
        if (this.settings.program.ui.distanceUnits == null) {
            this.settings.program.ui.distanceUnits = Settings.DistanceUnits.PC;
        }
        if (this.settings.scene.renderer.eclipses == null) {
            this.settings.scene.renderer.eclipses = new Settings.SceneSettings.RendererSettings.EclipseSettings();
            this.settings.scene.renderer.eclipses.active = true;
            this.settings.scene.renderer.eclipses.outlines = false;
        }
        this.settings.graphics.backBufferResolution = new int[2];
        this.settings.graphics.backBufferResolution[0] = (int)((double)this.settings.graphics.resolution[0] * this.settings.graphics.backBufferScale);
        this.settings.graphics.backBufferResolution[1] = (int)((double)this.settings.graphics.resolution[1] * this.settings.graphics.backBufferScale);
        if (SysUtils.isMac() && this.settings.scene.renderer.elevation.type.isTessellation()) {
            this.settings.scene.renderer.elevation.type = Settings.ElevationType.NONE;
        }
        this.settings.program.minimap.size = MathUtilsDouble.clamp(this.settings.program.minimap.size, 150.0f, 350.0f);
        if (this.settings.scene.particleGroups == null) {
            this.settings.scene.particleGroups = new Settings.SceneSettings.ParticleSettings();
        }
        if (arch.equals("32")) {
            float delta = FastMath.abs((float)(this.settings.scene.octree.threshold[1] - this.settings.scene.octree.threshold[0]));
            this.settings.scene.octree.threshold[0] = (float)FastMath.toRadians((double)80.0);
            this.settings.scene.octree.threshold[1] = this.settings.scene.octree.threshold[1] + delta;
        }
        if (arch.equals("32")) {
            this.settings.scene.octree.maxStars = 1500000;
        }
        try {
            String fl = this.settings.frame.location;
            if (fl == null || fl.isBlank()) {
                Path framesDir = SysUtils.getDefaultFramesDir();
                Files.createDirectories(framesDir, new FileAttribute[0]);
                fl = framesDir.toAbsolutePath().toString();
            }
            this.settings.frame.location = fl.replaceAll("\\\\", "/");
        }
        catch (IOException e) {
            logger.error("Error initializing frame output location", e);
        }
        try {
            String sl = this.settings.screenshot.location;
            if (sl == null || sl.isBlank()) {
                Path screenshotsDir = SysUtils.getDefaultScreenshotsDir();
                Files.createDirectories(screenshotsDir, new FileAttribute[0]);
                sl = screenshotsDir.toAbsolutePath().toString();
            }
            this.settings.screenshot.location = sl.replaceAll("\\\\", "/");
        }
        catch (IOException e) {
            logger.error("Error initializing frame output location", e);
        }
        if (this.settings.postprocess.chromaticAberration == null) {
            this.settings.postprocess.chromaticAberration = new Settings.PostprocessSettings.ChromaticAberrationSettings();
            if (this.settings.runtime.openXr) {
                this.settings.postprocess.chromaticAberration.amount = 0.0f;
            }
        }
        if (this.settings.postprocess.filmGrain == null) {
            this.settings.postprocess.filmGrain = new Settings.PostprocessSettings.FilmGrainSettings();
        }
        if (this.settings.proxy != null) {
            if (this.settings.proxy.useSystemProxies != null) {
                System.setProperty("java.net.useSystemProxies", Boolean.toString(this.settings.proxy.useSystemProxies));
            }
            if (this.settings.proxy.http != null) {
                SettingsManager.setProxySettings(this.settings.proxy.http, "http");
            }
            if (this.settings.proxy.https != null) {
                SettingsManager.setProxySettings(this.settings.proxy.https, "https", "http");
            }
            if (this.settings.proxy.socks != null) {
                SettingsManager.setSocksProxySettings(this.settings.proxy.socks);
            }
            if (this.settings.proxy.ftp != null) {
                SettingsManager.setProxySettings(this.settings.proxy.ftp, "ftp");
            }
        }
        SettingsManager.initializeProxyAuthenticator();
        if (this.settings.scene.renderer.virtualTextures == null) {
            this.settings.scene.renderer.virtualTextures = new Settings.SceneSettings.RendererSettings.VirtualTextureSettings();
            this.settings.scene.renderer.virtualTextures.cacheSize = 8;
            this.settings.scene.renderer.virtualTextures.detectionBufferFactor = 8.0;
        }
        if (!this.settings.scene.visibility.containsKey("Keyframes")) {
            this.settings.scene.visibility.put("Keyframes", true);
        }
        if (this.settings.program.recursiveGrid.style == null) {
            this.settings.program.recursiveGrid.style = Settings.GridStyle.CIRCULAR;
        }
        if (this.settings.program.uvGrid == null) {
            this.settings.program.uvGrid = new Settings.ProgramSettings.UVGridSettings();
        }
        if (this.settings.scene.renderer.line == null) {
            Settings.SceneSettings.RendererSettings.LineSettings ls = new Settings.SceneSettings.RendererSettings.LineSettings();
            ls.mode = Settings.LineMode.POLYLINE_QUADSTRIP;
            ls.width = 1.0f;
            ls.glWidthBias = 0.0f;
            this.settings.scene.renderer.line = ls;
        }
        if (this.settings.postprocess.antialiasing == null) {
            this.settings.postprocess.antialiasing = new Settings.PostprocessSettings.AntialiasSettings();
        } else if (this.settings.postprocess.antialiasing.type == null) {
            this.settings.postprocess.antialiasing.type = Settings.PostprocessSettings.AntialiasType.FXAA;
        }
        this.settings.initialize();
    }

    private void persist(Settings settings, File settingsFile) {
        try {
            boolean backup = settings.program.safeMode;
            if (settings.program.safeModeFlag) {
                settings.program.safeMode = false;
            }
            FileOutputStream fos = new FileOutputStream(settingsFile);
            SequenceWriter sw = this.mapper.writerWithDefaultPrettyPrinter().writeValues((OutputStream)fos);
            sw.write((Object)settings);
            if (settings.program.safeModeFlag) {
                settings.program.safeMode = backup;
            }
            logger.info("Settings saved to " + settingsFile.getAbsolutePath());
        }
        catch (Exception e) {
            logger.error(e);
        }
    }

    private String initConfigFile(boolean vr) throws IOException {
        Path userFolder = SysUtils.getConfigDir();
        Path userFolderConfFile = userFolder.resolve(SettingsManager.getConfigFileName(vr));
        if (!Files.exists(userFolderConfFile, new LinkOption[0])) {
            GlobalResources.copyFile(Path.of("conf", SettingsManager.getConfigFileName(vr)), userFolderConfFile, false);
        }
        String props = userFolderConfFile.toAbsolutePath().toString();
        System.setProperty("properties.file", props);
        return props;
    }
}

