/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import gaiasky.util.GlobalResources;
import gaiasky.util.Settings;
import gaiasky.util.camera.rec.KeyframesManager;
import gaiasky.util.parse.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;

public class SettingsMorph {
    public static void morphSettings(Path propertiesFile, Path yamlFile) throws IOException {
        String jsonObjects;
        Properties p = new Properties();
        p.load(new FileInputStream(propertiesFile.toFile()));
        Settings s = new Settings();
        s.configVersion = SettingsMorph.i32("properties.version", p);
        Settings.PerformanceSettings performance = new Settings.PerformanceSettings();
        performance.multithreading = SettingsMorph.bool("global.conf.multithreading", p);
        performance.numberThreads = SettingsMorph.i32("global.conf.numthreads", p);
        s.performance = performance;
        Settings.GraphicsSettings graphics = new Settings.GraphicsSettings();
        graphics.screenOutput = SettingsMorph.bool("graphics.screen.screenoutput", p);
        int w = SettingsMorph.i32("graphics.screen.width", p);
        int h = SettingsMorph.i32("graphics.screen.height", p);
        graphics.resolution = new int[]{w, h};
        Settings.GraphicsSettings.FullscreenSettings fullScreen = new Settings.GraphicsSettings.FullscreenSettings();
        int fsw = SettingsMorph.i32("graphics.screen.fullscreen.width", p);
        int fsh = SettingsMorph.i32("graphics.screen.fullscreen.height", p);
        fullScreen.resolution = new int[]{fsw, fsh};
        fullScreen.active = SettingsMorph.bool("graphics.screen.fullscreen", p);
        graphics.fullScreen = fullScreen;
        graphics.resizable = SettingsMorph.bool("graphics.screen.resizable", p);
        graphics.vsync = SettingsMorph.bool("graphics.screen.vsync", p);
        graphics.fpsLimit = SettingsMorph.i32("graphics.limit.fps", p);
        graphics.backBufferScale = SettingsMorph.f64("graphics.backbuffer.scale", p);
        graphics.dynamicResolution = SettingsMorph.bool("graphics.dynamic.resolution", p);
        graphics.quality = Settings.GraphicsQuality.valueOf(SettingsMorph.str("scene.graphics.quality", p).toUpperCase(Locale.ROOT));
        s.graphics = graphics;
        Settings.FrameSettings frame = new Settings.FrameSettings();
        frame.mode = SettingsMorph.screenshotMode(SettingsMorph.str("graphics.render.mode", p));
        int fw = SettingsMorph.i32("graphics.render.width", p);
        int fh = SettingsMorph.i32("graphics.render.height", p);
        frame.resolution = new int[]{fw, fh};
        frame.targetFps = SettingsMorph.f64("graphics.render.targetfps", p);
        frame.location = SettingsMorph.str("graphics.render.folder", p);
        frame.prefix = SettingsMorph.str("graphics.render.filename", p);
        frame.time = SettingsMorph.bool("graphics.render.time", p);
        frame.format = Settings.ImageFormat.valueOf(SettingsMorph.str("graphics.render.format", p).toUpperCase(Locale.ROOT));
        frame.quality = SettingsMorph.f32("graphics.render.quality", p);
        s.frame = frame;
        Settings.ScreenshotSettings screenshot = new Settings.ScreenshotSettings();
        screenshot.mode = SettingsMorph.screenshotMode(SettingsMorph.str("screenshot.mode", p).toUpperCase(Locale.ROOT));
        int sw = SettingsMorph.i32("screenshot.width", p);
        int sh = SettingsMorph.i32("screenshot.height", p);
        screenshot.resolution = new int[]{sw, sh};
        screenshot.location = SettingsMorph.str("screenshot.folder", p);
        screenshot.format = Settings.ImageFormat.valueOf(SettingsMorph.str("screenshot.format", p).toUpperCase(Locale.ROOT));
        screenshot.quality = SettingsMorph.f32("screenshot.quality", p);
        s.screenshot = screenshot;
        Settings.CamrecorderSettings camrec = new Settings.CamrecorderSettings();
        Settings.CamrecorderSettings.KeyframeSettings keyframe = new Settings.CamrecorderSettings.KeyframeSettings();
        keyframe.position = KeyframesManager.PathType.valueOf(SettingsMorph.str("graphics.camera.keyframe.path.position", p));
        keyframe.orientation = KeyframesManager.PathType.valueOf(SettingsMorph.str("graphics.camera.keyframe.path.orientation", p));
        camrec.keyframe = keyframe;
        camrec.targetFps = SettingsMorph.f64("graphics.camera.recording.targetfps", p);
        camrec.auto = SettingsMorph.bool("graphics.camera.recording.frameoutputatuo", p);
        s.camrecorder = camrec;
        Settings.DataSettings data = new Settings.DataSettings();
        data.location = SettingsMorph.str("data.location", p);
        ArrayList<String> dataFiles = new ArrayList<String>();
        String jsonCatalog = SettingsMorph.str("data.json.catalog", p);
        if (jsonCatalog != null && !jsonCatalog.isBlank()) {
            String[] tokens = jsonCatalog.split(File.pathSeparator);
            dataFiles.addAll(Arrays.asList(tokens));
        }
        if ((jsonObjects = SettingsMorph.str("data.json.objects", p)) != null && !jsonObjects.isBlank()) {
            String[] tokens = jsonObjects.split(",");
            dataFiles.addAll(Arrays.asList(tokens));
        }
        data.dataFiles = new ArrayList<String>(dataFiles.size());
        for (String dataFile : dataFiles) {
            Path dataLocation = Path.of(Settings.settings.data.location, new String[0]);
            String relative = dataLocation.toUri().relativize(new File(dataFile).toURI()).getPath();
            String f = "$data/" + relative;
            data.dataFiles.add(f);
        }
        data.highAccuracy = SettingsMorph.bool("data.highaccuracy.positions", p);
        data.reflectionSkyboxLocation = SettingsMorph.str("data.skybox.location", p);
        data.realGaiaAttitude = SettingsMorph.bool("data.attitude.real", p);
        s.data = data;
        Settings.SceneSettings scene = new Settings.SceneSettings();
        scene.homeObject = SettingsMorph.str("scene.object.startup", p);
        scene.initialization = new Settings.SceneSettings.InitializationSettings();
        scene.initialization.lazyTexture = SettingsMorph.bool("scene.lazy.texture", p);
        scene.initialization.lazyMesh = SettingsMorph.bool("scene.lazy.mesh", p);
        Settings.SceneSettings.CameraSettings camera = new Settings.SceneSettings.CameraSettings();
        camera.speedLimitIndex = SettingsMorph.i32("scene.camera.speedlimit", p);
        camera.speed = SettingsMorph.f64("scene.camera.focus.vel", p);
        camera.turn = SettingsMorph.f64("scene.camera.turn.vel", p);
        camera.rotate = SettingsMorph.f64("scene.camera.rotate.vel", p);
        camera.fov = SettingsMorph.f32("scene.camera.fov", p);
        camera.cinematic = SettingsMorph.bool("scene.camera.cinematic", p);
        camera.targetMode = SettingsMorph.bool("scene.camera.free.targetmode", p);
        Settings.SceneSettings.CameraSettings.FocusSettings focusLock = new Settings.SceneSettings.CameraSettings.FocusSettings();
        focusLock.position = SettingsMorph.bool("scene.focuslock", p);
        focusLock.orientation = SettingsMorph.bool("scene.focuslock.orientation", p);
        camera.focusLock = focusLock;
        scene.camera = camera;
        scene.fadeMs = SettingsMorph.i32("scene.object.fadems", p);
        Settings.SceneSettings.StarSettings star = new Settings.SceneSettings.StarSettings();
        star.brightness = SettingsMorph.f32("scene.star.brightness", p);
        star.power = SettingsMorph.f32("scene.star.brightness.pow", p);
        star.pointSize = SettingsMorph.f32("scene.star.point.size", p);
        star.textureIndex = SettingsMorph.i32("scene.star.tex.index", p);
        Settings.SceneSettings.StarSettings.GroupSettings group = new Settings.SceneSettings.StarSettings.GroupSettings();
        group.billboard = SettingsMorph.bool("scene.star.group.billboard.flag", p);
        group.numBillboard = SettingsMorph.i32("scene.star.group.billboards", p);
        group.numLabels = SettingsMorph.i32("scene.star.group.labels", p);
        group.numVelocityVector = SettingsMorph.i32("scene.star.group.velocityvectors", p);
        star.group = group;
        star.threshold = new Settings.SceneSettings.StarSettings.ThresholdSettings();
        star.threshold.quad = SettingsMorph.f64("scene.star.threshold.quad", p);
        star.threshold.point = SettingsMorph.f64("scene.star.threshold.point", p);
        star.threshold.none = SettingsMorph.f64("scene.star.threshold.none", p);
        float alpha0 = SettingsMorph.f32("scene.point.alpha.min", p);
        float alpha1 = SettingsMorph.f32("scene.point.alpha.max", p);
        star.opacity = new float[]{alpha0, alpha1};
        scene.star = star;
        Settings.SceneSettings.OctreeSettings octree = new Settings.SceneSettings.OctreeSettings();
        float th0 = SettingsMorph.f32("scene.octant.threshold.0", p);
        float th1 = SettingsMorph.f32("scene.octant.threshold.1", p);
        octree.threshold = new float[]{th0, th1};
        octree.maxStars = SettingsMorph.i32("scene.octree.maxstars", p);
        octree.fade = SettingsMorph.bool("scene.octree.particle.fade", p);
        scene.octree = octree;
        Settings.SceneSettings.RendererSettings renderer = new Settings.SceneSettings.RendererSettings();
        renderer.ambient = SettingsMorph.f32("scene.ambient", p);
        renderer.shadow = new Settings.SceneSettings.RendererSettings.ShadowSettings();
        renderer.shadow.active = SettingsMorph.bool("scene.shadowmapping", p);
        renderer.shadow.resolution = SettingsMorph.i32("scene.shadowmapping.resolution", p);
        renderer.shadow.number = SettingsMorph.i32("scene.shadowmapping.nshadows", p);
        renderer.elevation = new Settings.SceneSettings.RendererSettings.ElevationSettings();
        renderer.elevation.type = Settings.ElevationType.valueOf(SettingsMorph.str("scene.elevation.type", p).toUpperCase(Locale.ROOT));
        renderer.elevation.multiplier = SettingsMorph.f64("scene.elevation.multiplier", p);
        renderer.elevation.quality = SettingsMorph.f64("scene.tessellation.quality", p);
        Settings.SceneSettings.RendererSettings.LineSettings line = new Settings.SceneSettings.RendererSettings.LineSettings();
        line.width = SettingsMorph.f32("scene.line.width", p);
        scene.renderer.line = line;
        scene.renderer = renderer;
        Settings.SceneSettings.LabelSettings label = new Settings.SceneSettings.LabelSettings();
        label.size = SettingsMorph.f32("scene.label.size", p);
        label.number = SettingsMorph.f32("scene.label.number", p);
        scene.label = label;
        scene.properMotion = new Settings.SceneSettings.ProperMotionSettings();
        scene.properMotion.length = SettingsMorph.f32("scene.propermotion.lenfactor", p);
        scene.properMotion.number = SettingsMorph.f32("scene.propermotion.numfactor", p);
        scene.properMotion.colorMode = SettingsMorph.i32("scene.propermotion.colormode", p);
        scene.properMotion.arrowHeads = SettingsMorph.bool("scene.propermotion.arrowheads", p);
        scene.crosshair = new Settings.SceneSettings.CrosshairSettings();
        scene.crosshair.focus = SettingsMorph.bool("scene.crosshair.focus", p);
        scene.crosshair.closest = SettingsMorph.bool("scene.crosshair.closest", p);
        scene.crosshair.home = SettingsMorph.bool("scene.crosshair.home", p);
        scene.visibility = new HashMap<String, Boolean>();
        p.keySet().stream().filter(key -> ((String)key).startsWith("scene.visibility.")).forEach(key -> {
            String ct = ((String)key).substring(17);
            scene.visibility.put(ct, SettingsMorph.bool((String)key, p));
        });
        s.scene = scene;
        Settings.PostprocessSettings postprocess = new Settings.PostprocessSettings();
        postprocess.antialiasing = new Settings.PostprocessSettings.AntialiasSettings();
        postprocess.antialiasing.type = Settings.PostprocessSettings.AntialiasType.getFromCode(SettingsMorph.i32("postprocess.antialiasing", p));
        postprocess.bloom = new Settings.PostprocessSettings.BloomSettings();
        postprocess.bloom.intensity = SettingsMorph.f32("postprocess.bloom.intensity", p);
        postprocess.unsharpMask = new Settings.PostprocessSettings.UnsharpMaskSettings();
        postprocess.unsharpMask.factor = SettingsMorph.f32("postprocess.unsharpmask.factor", p);
        postprocess.motionBlur.active = SettingsMorph.f32("postprocess.motionblur", p) != 0.0f;
        postprocess.lensFlare.active = SettingsMorph.bool("postprocess.lensflare", p);
        postprocess.lightGlow.active = SettingsMorph.bool("postprocess.lightscattering", p);
        postprocess.reprojection.active = SettingsMorph.bool("postprocess.fisheye", p);
        Settings.PostprocessSettings.LevelsSettings levels = new Settings.PostprocessSettings.LevelsSettings();
        levels.brightness = SettingsMorph.f32("postprocess.brightness", p);
        levels.contrast = SettingsMorph.f32("postprocess.contrast", p);
        levels.hue = SettingsMorph.f32("postprocess.hue", p);
        levels.saturation = SettingsMorph.f32("postprocess.saturation", p);
        levels.gamma = SettingsMorph.f32("postprocess.gamma", p);
        postprocess.levels = levels;
        postprocess.toneMapping = new Settings.PostprocessSettings.ToneMappingSettings();
        postprocess.toneMapping.setType(SettingsMorph.str("postprocess.tonemapping.type", p));
        postprocess.toneMapping.exposure = SettingsMorph.f32("postprocess.exposure", p);
        s.postprocess = postprocess;
        Settings.ProgramSettings program = new Settings.ProgramSettings();
        program.safeMode = SettingsMorph.bool("program.safe.graphics.mode", p);
        program.debugInfo = SettingsMorph.bool("program.debuginfo", p);
        program.fileChooser = new Settings.ProgramSettings.FileChooserSettings();
        program.fileChooser.showHidden = SettingsMorph.bool("program.filechooser.showhidden", p);
        program.fileChooser.lastLocation = SettingsMorph.str("program.last.filesystem.location", p);
        program.pointer = new Settings.ProgramSettings.PointerSettings();
        program.pointer.coordinates = SettingsMorph.bool("program.pointer.coords.display", p);
        program.pointer.guides = new Settings.ProgramSettings.PointerSettings.GuidesSettings();
        program.pointer.guides.active = SettingsMorph.bool("program.pointer.guides.display", p);
        program.pointer.guides.color = SettingsMorph.arr("program.pointer.guides.color", p);
        program.pointer.guides.width = SettingsMorph.f32("program.pointer.guides.width", p);
        program.recursiveGrid = new Settings.ProgramSettings.RecursiveGridSettings();
        program.recursiveGrid.setOrigin(SettingsMorph.str("program.recursivegrid.origin", p));
        program.recursiveGrid.projectionLines = SettingsMorph.bool("program.recursivegrid.origin.lines", p);
        program.minimap = new Settings.ProgramSettings.MinimapSettings();
        program.minimap.active = SettingsMorph.bool("program.display.minimap", p);
        program.minimap.size = SettingsMorph.f32("program.minimap.size", p);
        program.minimap.inWindow = false;
        program.modeStereo = new Settings.ProgramSettings.ModeStereoSettings();
        program.modeStereo.active = SettingsMorph.bool("program.stereoscopic", p);
        program.modeStereo.profile = Settings.StereoProfile.values()[SettingsMorph.i32("program.stereoscopic.profile", p)];
        program.modeCubemap = new Settings.ProgramSettings.ModeCubemapSettings();
        program.modeCubemap.active = SettingsMorph.bool("program.cubemap", p);
        program.modeCubemap.setProjection(SettingsMorph.str("program.cubemap.projection", p));
        program.modeCubemap.faceResolution = SettingsMorph.i32("program.cubemap.face.resolution", p);
        program.modeCubemap.celestialSphereIndexOfRefraction = SettingsMorph.f32("program.modeCubemap.celestialSphereIndexOfRefraction", p);
        program.modeCubemap.planetarium = new Settings.ProgramSettings.ModeCubemapSettings.PlanetariumSettings();
        program.modeCubemap.planetarium.angle = SettingsMorph.f32("program.planetarium.angle", p);
        program.modeCubemap.planetarium.aperture = SettingsMorph.f32("program.planetarium.aperture", p);
        program.net = new Settings.ProgramSettings.NetSettings();
        program.net.restPort = SettingsMorph.i32("program.restport", p);
        program.net.master = new Settings.ProgramSettings.NetSettings.MasterSettings();
        program.net.master.active = SettingsMorph.bool("program.net.master", p);
        program.net.slave = new Settings.ProgramSettings.NetSettings.SlaveSettings();
        program.net.slave.active = SettingsMorph.bool("program.net.slave", p);
        program.net.slave.configFile = SettingsMorph.str("program.net.slave.config", p);
        program.net.slave.yaw = SettingsMorph.f32("program.net.slave.yaw", p);
        program.net.slave.pitch = SettingsMorph.f32("program.net.slave.pitch", p);
        program.net.slave.roll = SettingsMorph.f32("program.net.slave.roll", p);
        program.net.slave.warpFile = SettingsMorph.str("program.net.slave.warp", p);
        program.net.slave.blendFile = SettingsMorph.str("program.net.slave.blend", p);
        program.ui = new Settings.ProgramSettings.UiSettings();
        program.ui.theme = SettingsMorph.str("program.ui.theme", p);
        program.ui.scale = SettingsMorph.f32("program.ui.scale", p);
        program.exitConfirmation = SettingsMorph.bool("program.exit.confirmation", p);
        program.locale = SettingsMorph.str("program.locale", p);
        program.update = new Settings.ProgramSettings.UpdateSettings();
        program.update.lastVersion = "";
        program.url = new Settings.ProgramSettings.UrlSettings();
        program.url.versionCheck = SettingsMorph.escapeURL(SettingsMorph.str("program.url.versioncheck", p));
        program.url.dataMirror = SettingsMorph.escapeURL(SettingsMorph.str("program.url.data.mirror", p));
        program.url.dataDescriptor = SettingsMorph.escapeURL(SettingsMorph.str("program.url.data.descriptor", p));
        s.program = program;
        Settings.ControlsSettings controls = new Settings.ControlsSettings();
        controls.gamepad = new Settings.ControlsSettings.GamepadSettings();
        controls.gamepad.mappingsFile = SettingsMorph.str("controls.gamepad.mappings.file", p);
        controls.gamepad.invertX = SettingsMorph.bool("controls.invert.x", p);
        controls.gamepad.invertY = SettingsMorph.bool("controls.invert.y", p);
        String blacklist = SettingsMorph.str("controls.blacklist", p);
        controls.gamepad.blacklist = GlobalResources.parseWhitespaceSeparatedList(blacklist);
        if (controls.gamepad.blacklist == null) {
            controls.gamepad.blacklist = new String[0];
        }
        s.controls = controls;
        Settings.SpacecraftSettings spacecraft = new Settings.SpacecraftSettings();
        spacecraft.velocityDirection = SettingsMorph.bool("spacecraft.velocity.direction", p);
        spacecraft.showAxes = SettingsMorph.bool("spacecraft.show.axes", p);
        s.spacecraft = spacecraft;
        YAMLFactory yaml = new YAMLFactory();
        yaml.disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.INDENT_ARRAYS);
        ObjectMapper mapper = new ObjectMapper((JsonFactory)yaml);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.findAndRegisterModules();
        FileOutputStream fos = new FileOutputStream(yamlFile.toFile());
        SequenceWriter sequenceWriter = mapper.writerWithDefaultPrettyPrinter().writeValues((OutputStream)fos);
        sequenceWriter.write((Object)s);
        fos.close();
    }

    private static Settings.ScreenshotMode screenshotMode(String value) {
        if (value.equalsIgnoreCase("redraw")) {
            value = "ADVANCED";
        }
        return Settings.ScreenshotMode.valueOf(value.toUpperCase(Locale.ROOT));
    }

    private static float[] arr(String key, Properties properties) {
        String arr = SettingsMorph.str(key, properties);
        return Parser.parseFloatArray(arr);
    }

    private static String str(String key, Properties properties) {
        return properties.getProperty(key);
    }

    private static boolean bool(String key, Properties properties) {
        return Parser.parseBoolean(properties.getProperty(key));
    }

    private static float f32(String key, Properties properties) {
        return Parser.parseFloat(properties.getProperty(key));
    }

    private static double f64(String key, Properties properties) {
        return Parser.parseDouble(properties.getProperty(key));
    }

    private static int i32(String key, Properties properties) {
        return Parser.parseInt(properties.getProperty(key));
    }

    private static long i64(String key, Properties properties) {
        return Parser.parseLong(properties.getProperty(key));
    }

    private static String escapeURL(String url) {
        return url.replaceAll("\\\\", "");
    }
}

