/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.ZipUtils;
import gaiasky.util.gdx.loader.OwnTextureLoader;
import gaiasky.util.gdx.loader.PFMData;
import gaiasky.util.gdx.loader.PFMDataLoader;
import gaiasky.util.i18n.I18n;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SlaveManager {
    private static final Logger.Log logger = Logger.getLogger(SlaveManager.class);
    public static SlaveManager instance;
    public String bufferId;
    public String regionId;
    public Path pfm;
    public Path blend;
    public int xResolution;
    public int yResolution;
    public float yaw;
    public float pitch;
    public float roll;
    public float upAngle;
    public float downAngle;
    public float rightAngle;
    public float leftAngle;
    public float cameraFov;
    private boolean initialized = false;

    public SlaveManager() {
        Settings settings = Settings.settings;
        if (settings.program.net.slave.active && settings.program.net.master.active) {
            logger.error("Can't be master and slave at the same time!");
            return;
        }
        if (settings.program.net.slave.active) {
            if (settings.program.net.isSlaveMPCDIPresent()) {
                logger.info("Using slave configuration file: " + settings.program.net.slave.configFile);
                String mpcdi = settings.program.net.slave.configFile;
                try {
                    Path loc = this.unpackMpcdi(mpcdi);
                    this.parseMpcdi(mpcdi, loc);
                    if (this.initialized) {
                        this.pushToConf();
                        this.printInfo();
                    }
                }
                catch (Exception e) {
                    logger.error(e);
                }
            } else if (settings.program.net.areSlaveConfigPropertiesPresent()) {
                this.yaw = settings.program.net.slave.yaw;
                this.pitch = settings.program.net.slave.pitch;
                this.roll = settings.program.net.slave.roll;
                this.xResolution = settings.graphics.fullScreen.resolution[0];
                this.yResolution = settings.graphics.fullScreen.resolution[1];
                this.rightAngle = this.leftAngle = settings.scene.camera.fov / 2.0f;
                this.downAngle = this.leftAngle;
                this.upAngle = this.leftAngle;
                this.pfm = settings.program.net.slave.warpFile != null && !settings.program.net.slave.warpFile.isEmpty() ? Paths.get(settings.program.net.slave.warpFile, new String[0]) : null;
                this.blend = settings.program.net.slave.blendFile != null && !settings.program.net.slave.blendFile.isEmpty() ? Paths.get(settings.program.net.slave.blendFile, new String[0]) : null;
                this.initialized = true;
                this.setDefaultConf();
                this.printInfo();
            }
        }
    }

    public static void initialize() {
        if (instance == null && Settings.settings.program.net.slave.active) {
            instance = new SlaveManager();
        }
    }

    public static boolean projectionActive() {
        return instance != null && SlaveManager.instance.initialized;
    }

    public static void load(AssetManager manager) {
        if (SlaveManager.projectionActive()) {
            instance.loadAssets(manager);
            Gdx.graphics.setSystemCursor(Cursor.SystemCursor.None);
        }
    }

    private Path unpackMpcdi(String mpcdi) throws IOException {
        if (mpcdi != null && !mpcdi.isEmpty()) {
            Path mpcdiPath = Path.of(mpcdi, new String[0]);
            if (!mpcdiPath.isAbsolute()) {
                mpcdiPath = SysUtils.getDefaultMpcdiDir().resolve(mpcdi);
            }
            logger.info(I18n.msg("notif.loading", mpcdiPath));
            String unpackDirName = "mpcdi_" + System.nanoTime();
            Path unzipLocation = SysUtils.getDataTempDir(Settings.settings.data.location).resolve(unpackDirName);
            Files.createDirectories(unzipLocation, new FileAttribute[0]);
            ZipUtils.unzip(mpcdiPath.toString(), unzipLocation.toAbsolutePath().toString());
            return unzipLocation;
        }
        return null;
    }

    private void parseMpcdi(String mpcdi, Path loc) throws IOException, ParserConfigurationException, SAXException {
        if (loc != null) {
            Path mpcdiXml = loc.resolve("mpcdi.xml");
            if (!Files.exists(mpcdiXml, new LinkOption[0])) {
                logger.error("mpcdi.xml file not found in " + mpcdi);
                return;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(mpcdiXml.toFile());
            if (doc != null) {
                NodeList filesNodes;
                Node displayNode;
                NodeList displays;
                Element root = doc.getDocumentElement();
                String profile = root.getAttribute("profile");
                if (!profile.equalsIgnoreCase("3d")) {
                    logger.warn("Gaia Sky only supports the '3d' profile");
                }
                if ((displays = root.getElementsByTagName("display")).getLength() != 1) {
                    logger.warn(displays.getLength() + " <display> elements found in MPCDI, which goes against the specs");
                }
                if ((displayNode = displays.item(0)).getNodeType() == 1) {
                    Node bufferNode;
                    Element display = (Element)displayNode;
                    NodeList buffers = display.getElementsByTagName("buffer");
                    if (buffers.getLength() > 1) {
                        logger.warn("Gaia Sky only supports one buffer per display, found " + buffers.getLength());
                    }
                    if ((bufferNode = buffers.item(0)).getNodeType() == 1) {
                        Node regionNode;
                        Element buffer = (Element)bufferNode;
                        this.bufferId = buffer.getAttribute("id");
                        int xRes = Integer.parseInt(buffer.getAttribute("xResolution"));
                        int yRes = Integer.parseInt(buffer.getAttribute("yResolution"));
                        NodeList regions = buffer.getElementsByTagName("region");
                        if (regions.getLength() > 1) {
                            logger.warn("Gaia Sky only supports one region per buffer, found " + buffers.getLength());
                        }
                        if ((regionNode = regions.item(0)).getNodeType() == 1) {
                            Node frustumNode;
                            Element region = (Element)regionNode;
                            this.regionId = region.getAttribute("id");
                            float x = Float.parseFloat(region.getAttribute("x"));
                            float y = Float.parseFloat(region.getAttribute("y"));
                            float xs = Float.parseFloat(region.getAttribute("xSize"));
                            float ys = Float.parseFloat(region.getAttribute("ySize"));
                            this.xResolution = Integer.parseInt(region.getAttribute("xResolution"));
                            this.yResolution = Integer.parseInt(region.getAttribute("yResolution"));
                            if (x != 0.0f || y != 0.0f || xs != 1.0f || ys != 1.0f) {
                                logger.error("Gaia Sky only supports a region that covers the full frame (i.e. in [0, 1])");
                                logger.error("Stopping the parsing of MPCDI file " + mpcdi);
                                return;
                            }
                            NodeList frustums = region.getElementsByTagName("frustum");
                            if (frustums.getLength() != 1) {
                                logger.warn("More than one <frustum> tag goes against the specification of MPCDI, found " + frustums.getLength());
                            }
                            if ((frustumNode = frustums.item(0)).getNodeType() == 1) {
                                Element frustum = (Element)frustumNode;
                                this.yaw = Float.parseFloat(frustum.getElementsByTagName("yaw").item(0).getTextContent());
                                this.pitch = Float.parseFloat(frustum.getElementsByTagName("pitch").item(0).getTextContent());
                                this.roll = Float.parseFloat(frustum.getElementsByTagName("roll").item(0).getTextContent());
                                this.rightAngle = Float.parseFloat(frustum.getElementsByTagName("rightAngle").item(0).getTextContent());
                                this.leftAngle = Float.parseFloat(frustum.getElementsByTagName("leftAngle").item(0).getTextContent());
                                this.upAngle = Float.parseFloat(frustum.getElementsByTagName("upAngle").item(0).getTextContent());
                                this.downAngle = Float.parseFloat(frustum.getElementsByTagName("downAngle").item(0).getTextContent());
                                this.cameraFov = this.upAngle - this.downAngle;
                                this.initialized = true;
                            }
                        }
                    }
                }
                if ((filesNodes = root.getElementsByTagName("files")).getLength() != 1) {
                    logger.warn(filesNodes.getLength() + " <files> elements found in MPCDI, which goes against the specs");
                } else {
                    Element files;
                    Node filesetNode;
                    Node filesNode = filesNodes.item(0);
                    if (filesNode.getNodeType() == 1 && (filesetNode = (files = (Element)filesNode).getElementsByTagName("fileset").item(0)).getNodeType() == 1) {
                        Element fileset = (Element)filesetNode;
                        String reg = fileset.getAttribute("region");
                        if (reg.equals(this.regionId)) {
                            NodeList geometryWarpFiles = fileset.getElementsByTagName("geometryWarpFile");
                            if (geometryWarpFiles.getLength() < 1) {
                                logger.warn("Geometry warp file not found!");
                            } else {
                                Element interpolation;
                                NodeList interpolationNodes;
                                Element geowarp = (Element)geometryWarpFiles.item(0);
                                Element path = (Element)geowarp.getElementsByTagName("path").item(0);
                                String pfmFile = path.getTextContent();
                                this.pfm = loc.resolve(pfmFile);
                                if (!Files.exists(this.pfm, new LinkOption[0])) {
                                    logger.error("The geometry warp file does not exist: " + String.valueOf(this.pfm));
                                }
                                if ((interpolationNodes = geowarp.getElementsByTagName("interpolation")).getLength() > 0 && !(interpolation = (Element)interpolationNodes.item(0)).getTextContent().equals("linear")) {
                                    logger.warn("WARN: only linear interpolation supported, found " + interpolation.getTextContent());
                                }
                            }
                        } else {
                            logger.warn("Region in fileset tag does not match region id: " + this.regionId + " != " + reg);
                        }
                    }
                }
            }
        }
    }

    public boolean isWarpOrBlend() {
        return this.pfm != null || this.blend != null;
    }

    private void pushToConf() {
        if (this.initialized) {
            Settings.settings.graphics.fullScreen.resolution[0] = Settings.settings.graphics.resolution[0] = this.xResolution;
            Settings.settings.graphics.fullScreen.resolution[1] = Settings.settings.graphics.resolution[1] = this.yResolution;
            Settings.settings.graphics.fullScreen.active = true;
            Settings.settings.scene.camera.fov = this.cameraFov;
            this.setDefaultConf();
        }
    }

    private void setDefaultConf() {
        Settings.settings.runtime.displayGui = false;
        Settings.settings.runtime.inputEnabled = false;
        Settings.settings.scene.crosshair.focus = false;
        Settings.settings.scene.crosshair.home = false;
        Settings.settings.scene.crosshair.closest = false;
    }

    private void printInfo() {
        logger.info("Slave configuration modified with MPCDI settings");
        logger.info("   Resolution: " + this.xResolution + "x" + this.yResolution);
        logger.info("   Fov: " + this.cameraFov);
        logger.info("   Yaw/Pitch/Roll: " + this.yaw + "/" + this.pitch + "/" + this.roll);
    }

    public void loadAssets(AssetManager manager) {
        Object param;
        if (this.pfm != null && Files.exists(this.pfm, new LinkOption[0])) {
            param = new PFMDataLoader.PFMDataParameter();
            param.invert = false;
            manager.load(this.pfm.toString(), PFMData.class, (AssetLoaderParameters)param);
        }
        if (this.blend != null && Files.exists(this.blend, new LinkOption[0])) {
            param = new OwnTextureLoader.OwnTextureParameter();
            ((OwnTextureLoader.OwnTextureParameter)((Object)param)).magFilter = Texture.TextureFilter.Linear;
            ((OwnTextureLoader.OwnTextureParameter)((Object)param)).format = Pixmap.Format.RGBA8888;
            manager.load(this.blend.toString(), Texture.class, (AssetLoaderParameters)param);
        }
    }
}

