/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.util.Logger;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.screenshot.JPGWriter;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL30;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class SysUtils {
    private static final Logger.Log logger = Logger.getLogger(SysUtils.class);
    private static final String OS = System.getProperty("os.name").toLowerCase(Locale.ROOT);
    private static final boolean linux = OS.contains("linux");
    private static final boolean steamDeck;
    private static final boolean mac;
    private static final boolean windows;
    private static final boolean unix;
    private static final boolean solaris;
    private static final boolean flatpak;
    private static final String ARCH;
    private static final boolean aArch64;
    private static final String GAIASKY_DIR_NAME = "gaiasky";
    private static final String DOTGAIASKY_DIR_NAME = ".gaiasky";
    private static final String CAMERA_DIR_NAME = "camera";
    private static final String SCREENSHOTS_DIR_NAME = "screenshots";
    private static final String FRAMES_DIR_NAME = "frames";
    private static final String MAPPINGS_DIR_NAME = "mappings";
    private static final String BOOKMARKS_DIR_NAME = "bookmarks";
    private static final String MPCDI_DIR_NAME = "mpcdi";
    private static final String DATA_DIR_NAME = "data";
    private static final String CRASHREPORTS_DIR_NAME = "crashreports";
    private static final String SHADER_OUT_DIR_NAME = "shaders";
    private static final String SHADER_CACHE_DIR_NAME = "shadercache";
    private static final String LOG_DIR_NAME = "log";
    public static final String TMP_DIR_NAME = "tmp";
    public static final String CACHE_DIR_NAME = "cache";

    public static void mkdirs() {
        try {
            Files.createDirectories(SysUtils.getDataDir(), new FileAttribute[0]);
            Files.createDirectories(SysUtils.getConfigDir(), new FileAttribute[0]);
            Files.createDirectories(SysUtils.getCacheDir(), new FileAttribute[0]);
            Files.createDirectories(SysUtils.getDefaultCameraDir(), new FileAttribute[0]);
            Files.createDirectories(SysUtils.getDefaultFramesDir(), new FileAttribute[0]);
            Files.createDirectories(SysUtils.getDefaultScreenshotsDir(), new FileAttribute[0]);
            Files.createDirectories(SysUtils.getDefaultMappingsDir(), new FileAttribute[0]);
            Files.createDirectories(SysUtils.getDefaultBookmarksDir(), new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    public static void mkdir(Path dir) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    public static String getXdgDesktop() {
        return System.getenv("XDG_CURRENT_DESKTOP");
    }

    public static boolean checkLinuxDesktop(String desktop) {
        try {
            String value = SysUtils.getXdgDesktop();
            return value != null && !value.isEmpty() && value.equalsIgnoreCase(desktop);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    public static boolean checkUnity() {
        return SysUtils.isLinux() && SysUtils.checkLinuxDesktop("ubuntu");
    }

    public static boolean checkGnome() {
        return SysUtils.isLinux() && SysUtils.checkLinuxDesktop("gnome");
    }

    public static boolean checkKDE() {
        return SysUtils.isLinux() && SysUtils.checkLinuxDesktop("kde");
    }

    public static boolean checkXfce() {
        return SysUtils.isLinux() && SysUtils.checkLinuxDesktop("xfce");
    }

    public static boolean checkBudgie() {
        return SysUtils.isLinux() && SysUtils.checkLinuxDesktop("budgie:GNOME");
    }

    public static boolean checkI3() {
        return SysUtils.isLinux() && SysUtils.checkLinuxDesktop("i3");
    }

    public static String getOSName() {
        return OS;
    }

    public static String getOSFamily() {
        if (SysUtils.isLinux()) {
            return "linux";
        }
        if (SysUtils.isWindows()) {
            return "win";
        }
        if (SysUtils.isMac()) {
            return "macos";
        }
        if (SysUtils.isUnix()) {
            return "unix";
        }
        if (SysUtils.isSolaris()) {
            return "solaris";
        }
        return "unknown";
    }

    public static boolean isLinux() {
        return linux;
    }

    public static boolean isX11() {
        String sessionType = System.getenv("XDG_SESSION_TYPE");
        return sessionType != null && sessionType.equals("x11");
    }

    public static boolean isGLFWX11() {
        return GLFW.glfwGetPlatform() == 393220;
    }

    public static boolean isWayland() {
        String sessionType = System.getenv("XDG_SESSION_TYPE");
        return sessionType != null && sessionType.equals("wayland");
    }

    public static boolean isGLFWWayland() {
        return GLFW.glfwGetPlatform() == 393219;
    }

    public static boolean isWindows() {
        return windows;
    }

    public static boolean isMac() {
        return mac;
    }

    public static boolean isFlatpak() {
        return flatpak;
    }

    public static boolean isAppleSiliconMac() {
        return SysUtils.isMac() && aArch64;
    }

    public static boolean isUnix() {
        return unix;
    }

    public static boolean isSolaris() {
        return solaris;
    }

    public static boolean isSteamDeck() {
        return steamDeck;
    }

    public static boolean launchedViaInstall4j() {
        return System.getProperty("install4j.appDir") != null;
    }

    public static String getOSArchitecture() {
        return System.getProperty("os.arch");
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static Path getDefaultCameraDir() {
        return SysUtils.getDataDir().resolve(CAMERA_DIR_NAME);
    }

    public static Path getDefaultScreenshotsDir() {
        return SysUtils.getDataDir().resolve(SCREENSHOTS_DIR_NAME);
    }

    public static Path getDefaultFramesDir() {
        return SysUtils.getDataDir().resolve(FRAMES_DIR_NAME);
    }

    public static Path getDefaultMappingsDir() {
        return SysUtils.getConfigDir().resolve(MAPPINGS_DIR_NAME);
    }

    public static String getMappingsDirName() {
        return MAPPINGS_DIR_NAME;
    }

    public static Path getDefaultBookmarksDir() {
        return SysUtils.getConfigDir().resolve(BOOKMARKS_DIR_NAME);
    }

    public static String getBookmarksDirName() {
        return BOOKMARKS_DIR_NAME;
    }

    public static Path getDefaultMpcdiDir() {
        return SysUtils.getDataDir().resolve(MPCDI_DIR_NAME);
    }

    public static Path getDefaultDatasetsDir() {
        return SysUtils.getDataDir().resolve(DATA_DIR_NAME);
    }

    public static Path getCrashReportsDir() {
        return SysUtils.getDataDir().resolve(CRASHREPORTS_DIR_NAME);
    }

    public static Path getCrashShadersDir() {
        return SysUtils.getCrashReportsDir().resolve(SHADER_OUT_DIR_NAME);
    }

    public static Path getLogDir() {
        return SysUtils.getDataDir().resolve(LOG_DIR_NAME);
    }

    public static Path getDataTempDir(String dataLocation) {
        return Path.of(dataLocation, new String[0]).resolve(TMP_DIR_NAME);
    }

    public static Path getDataCacheDir(String dataLocation) {
        return Path.of(dataLocation, new String[0]).resolve(CACHE_DIR_NAME);
    }

    public static Path getDataDir() {
        if (SysUtils.isLinux()) {
            return SysUtils.getXdgDataHome().resolve(GAIASKY_DIR_NAME);
        }
        return SysUtils.getUserHome().resolve(DOTGAIASKY_DIR_NAME);
    }

    public static Path getCacheDir() {
        if (SysUtils.isLinux()) {
            return SysUtils.getXdgCacheHome().resolve(GAIASKY_DIR_NAME);
        }
        return SysUtils.getDataDir();
    }

    public static Path getShaderCacheDir() {
        if (SysUtils.isLinux()) {
            return SysUtils.getXdgCacheHome().resolve(GAIASKY_DIR_NAME).resolve(SHADER_CACHE_DIR_NAME);
        }
        return SysUtils.getDataDir().resolve(SHADER_CACHE_DIR_NAME);
    }

    public static Path getConfigDir() {
        if (SysUtils.isLinux()) {
            return SysUtils.getXdgConfigHome().resolve(GAIASKY_DIR_NAME);
        }
        return SysUtils.getUserHome().resolve(DOTGAIASKY_DIR_NAME);
    }

    public static Path getHomeDir() {
        return SysUtils.getUserHome();
    }

    public static Path getUserHome() {
        return Paths.get(System.getProperty("user.home"), new String[0]);
    }

    private static Path getXdgDataHome() {
        String dataHome = System.getenv("XDG_DATA_HOME");
        if (dataHome == null || dataHome.isBlank()) {
            return SysUtils.getUserHome().resolve(".local").resolve("share");
        }
        return Paths.get(dataHome, new String[0]);
    }

    private static Path getLocalAppData() {
        String dataFolder = System.getenv("LOCALAPPDATA");
        if (dataFolder == null || dataFolder.isBlank()) {
            return SysUtils.getUserHome().resolve("AppData").resolve("Local");
        }
        return Paths.get(dataFolder, new String[0]);
    }

    private static Path getXdgConfigHome() {
        String configHome = System.getenv("XDG_CONFIG_HOME");
        if (configHome == null || configHome.isEmpty()) {
            return Paths.get(System.getProperty("user.home"), ".config");
        }
        return Paths.get(configHome, new String[0]);
    }

    private static Path getXdgCacheHome() {
        String cacheHome = System.getenv("XDG_CACHE_HOME");
        if (cacheHome == null || cacheHome.isEmpty()) {
            return Paths.get(System.getProperty("user.home"), ".cache");
        }
        return Paths.get(cacheHome, new String[0]);
    }

    public static Path getLocalAppDataTemp() {
        return SysUtils.getLocalAppData().resolve("Temp");
    }

    public static double getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.contains(".")) {
            int pos = version.indexOf(46);
            pos = version.indexOf(46, pos + 1);
            return Double.parseDouble(version.substring(0, pos));
        }
        return Double.parseDouble(version);
    }

    public static Path getReleaseNotesFile() {
        Path workDir = Path.of(System.getProperty("user.dir"), new String[0]);
        return workDir.resolve("releasenotes.txt");
    }

    public static Path getReleaseNotesRevisionFile() {
        return SysUtils.getConfigDir().resolve(".releasenotes.rev");
    }

    public static Path getProceduralPixmapDir() {
        return Settings.settings.data.dataPath("$data/default-data/tex").resolve("procedural");
    }

    public static void saveProceduralGLTexture(Texture texture, String name, Settings.ImageFormat format) {
        if (texture != null && name != null) {
            Path proceduralDir = SysUtils.getProceduralPixmapDir();
            Path file = proceduralDir.resolve(name + "." + format.extension);
            int w = texture.getWidth();
            int h = texture.getHeight();
            Gdx.gl.glPixelStorei(3333, 1);
            Pixmap pixmap = new Pixmap(w, h, Pixmap.Format.RGBA8888);
            ByteBuffer pixels = pixmap.getPixels();
            texture.bind();
            GL30.glGetTexImage((int)texture.glTarget, (int)0, (int)6408, (int)5121, (ByteBuffer)pixels);
            GaiaSky.instance.getExecutorService().execute(() -> {
                switch (format) {
                    case JPG: {
                        JPGWriter.write(Gdx.files.absolute(file.toAbsolutePath().toString()), pixmap);
                        break;
                    }
                    case PNG: {
                        PixmapIO.writePNG((FileHandle)Gdx.files.absolute(file.toAbsolutePath().toString()), (Pixmap)pixmap);
                    }
                }
                logger.info(I18n.msg("gui.procedural.info.savetextures.ok", TextUtils.capitalise(name), file));
                pixmap.dispose();
            });
        }
    }

    public static void saveProceduralGLTextures(Texture[] textures, String[] names, Settings.ImageFormat format) {
        Path proceduralDir = SysUtils.getProceduralPixmapDir();
        Array pixmaps = new Array();
        for (int i = 0; i < textures.length; ++i) {
            Texture t = textures[i];
            if (t == null) continue;
            int w = t.getWidth();
            int h = t.getHeight();
            Gdx.gl.glPixelStorei(3333, 1);
            Pixmap pixmap = new Pixmap(w, h, Pixmap.Format.RGBA8888);
            ByteBuffer pixels = pixmap.getPixels();
            t.bind();
            GL30.glGetTexImage((int)t.glTarget, (int)0, (int)6408, (int)5121, (ByteBuffer)pixels);
            pixmaps.add(new Pair<Pixmap, Integer>(pixmap, i));
        }
        GaiaSky.instance.getExecutorService().execute(() -> {
            for (Pair pair : pixmaps) {
                Pixmap pixmap = (Pixmap)pair.getFirst();
                String name = names[(Integer)pair.getSecond()];
                Path file = proceduralDir.resolve(name + "." + format.extension);
                switch (format) {
                    case JPG: {
                        JPGWriter.write(Gdx.files.absolute(file.toAbsolutePath().toString()), pixmap);
                        break;
                    }
                    case PNG: {
                        PixmapIO.writePNG((FileHandle)Gdx.files.absolute(file.toAbsolutePath().toString()), (Pixmap)pixmap);
                    }
                }
                logger.info(I18n.msg("gui.procedural.info.savetextures.ok", TextUtils.capitalise(name), file));
                pixmap.dispose();
            }
            EventManager.publish(Event.POST_POPUP_NOTIFICATION, pixmaps, I18n.msg("gui.procedural.info.savetextures", SysUtils.getProceduralPixmapDir().toString()));
        });
    }

    public static Pixmap pixmapFromGLTexture(Texture t) {
        int w = t.getWidth();
        int h = t.getHeight();
        Gdx.gl.glPixelStorei(3333, 1);
        Pixmap pixmap = new Pixmap(w, h, Pixmap.Format.RGBA8888);
        ByteBuffer pixels = pixmap.getPixels();
        t.bind();
        GL30.glGetTexImage((int)t.glTarget, (int)0, (int)6408, (int)5121, (ByteBuffer)pixels);
        return pixmap;
    }

    public static boolean isAppImagePath(String path) {
        return path != null && path.contains("/tmp/.mount_");
    }

    public static boolean isAppImage() {
        String userDir = System.getProperty("user.dir");
        return SysUtils.isAppImagePath(userDir);
    }

    public static int[] getDisplayResolution() {
        double scale;
        int h;
        int w;
        if (SysUtils.isMac()) {
            return new int[]{1920, 1080};
        }
        try {
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            AffineTransform transform = gc.getDefaultTransform();
            double scaleX = transform.getScaleX();
            double scaleY = transform.getScaleY();
            w = (int)(gc.getBounds().getWidth() * scaleX);
            h = (int)(gc.getBounds().getHeight() * scaleY);
            if (w > 0 && h > 0) {
                return new int[]{w, h};
            }
            logger.warn(I18n.msg("error.screensize.gd"));
        }
        catch (HeadlessException e) {
            logger.warn(I18n.msg("error.screensize.gd"));
            logger.debug(e);
        }
        try {
            Rectangle rect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            double dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            scale = dpi > 0.0 ? dpi / 96.0 : 1.0;
            w = (int)((double)rect.width * scale);
            h = (int)((double)rect.height * scale);
            if (w > 0 && h > 0) {
                return new int[]{w, h};
            }
            logger.warn(I18n.msg("error.screensize.gd.windowbounds"));
        }
        catch (HeadlessException e) {
            logger.warn(I18n.msg("error.screensize.gd.windowbounds"));
            logger.debug(e);
        }
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            double dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            scale = dpi > 0.0 ? dpi / 96.0 : 1.0;
            w = (int)(screenSize.getWidth() * scale);
            h = (int)(screenSize.getHeight() * scale);
            if (w > 0 && h > 0) {
                return new int[]{w, h};
            }
            logger.warn(I18n.msg("error.screensize.toolkit"));
        }
        catch (Exception e) {
            logger.warn(I18n.msg("error.screensize.toolkit"));
            logger.debug(e);
        }
        return null;
    }

    private static String getJarName() {
        return new File(SysUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getName();
    }

    public static Path getProgramDirectory() {
        if (SysUtils.runningFromJAR()) {
            return SysUtils.getCurrentJARDirectory();
        }
        return SysUtils.getCurrentProjectDirectory();
    }

    private static boolean runningFromJAR() {
        String jarName = SysUtils.getJarName();
        return jarName.contains(".jar");
    }

    private static Path getCurrentProjectDirectory() {
        return new File("").toPath().toAbsolutePath();
    }

    private static Path getCurrentJARDirectory() {
        try {
            return Path.of(new File(SysUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParent(), new String[0]).toAbsolutePath();
        }
        catch (URISyntaxException exception) {
            logger.error(exception);
            return null;
        }
    }

    public static Path uniqueFileName(Path file) {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            logger.error("Given path is not a file: " + String.valueOf(file));
            return null;
        }
        Path parent = file.getParent();
        String fileName = FilenameUtils.getBaseName((String)file.toString());
        String ext = FilenameUtils.getExtension((String)file.toString());
        Path f = file;
        int i = 1;
        while (Files.exists(f, new LinkOption[0]) && Files.isRegularFile(f, new LinkOption[0])) {
            f = parent.resolve(fileName + "_" + i + ext);
            ++i;
        }
        return f;
    }

    static {
        mac = OS.contains("macos") || OS.contains("mac os");
        windows = OS.contains("win");
        unix = OS.contains("unix");
        solaris = OS.contains("sunos");
        SystemInfo sysInfo = new SystemInfo();
        flatpak = sysInfo.getOperatingSystem().getVersionInfo().getCodeName().contains("Flatpak");
        if (linux) {
            String boardVendor = null;
            String boardName = null;
            try {
                Path vendorPath = Paths.get("/sys/devices/virtual/dmi/id/board_vendor", new String[0]);
                Path namePath = Paths.get("/sys/devices/virtual/dmi/id/board_name", new String[0]);
                boardVendor = Files.exists(vendorPath, new LinkOption[0]) && Files.isReadable(vendorPath) ? new String(Files.readAllBytes(vendorPath)) : null;
                boardName = Files.exists(namePath, new LinkOption[0]) && Files.isReadable(namePath) ? new String(Files.readAllBytes(namePath)) : null;
            }
            catch (IOException vendorPath) {
                // empty catch block
            }
            CentralProcessor cp = new SystemInfo().getHardware().getProcessor();
            boolean deckAPU = cp.getProcessorIdentifier().getName().equalsIgnoreCase("AMD Custom APU 0405");
            steamDeck = boardVendor != null && boardVendor.equalsIgnoreCase("Valve") || boardName != null && boardName.equalsIgnoreCase("Jupiter") || deckAPU;
        } else {
            steamDeck = false;
        }
        ARCH = System.getProperty("os.arch");
        aArch64 = ARCH.contains("aarch64");
    }
}

