/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.gdx.utils.StringBuilder;
import gaiasky.GaiaSky;
import gaiasky.util.GlobalResources;
import gaiasky.util.i18n.I18n;
import java.io.BufferedReader;
import java.io.FileReader;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jafama.FastMath;

public class TextUtils {
    private static final String ANSI_REGEX = "\\u001B\\[[;\\d]*m";

    public static String stripAnsiCodes(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll(ANSI_REGEX, "");
    }

    public static String escape(String s) {
        return s.replace("\\", "\\\\").replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replace("\"", "\\\"");
    }

    public static String surroundBrackets(String in) {
        return TextUtils.surround(in, "[", "]");
    }

    public static String surround(String in, String pre, String post) {
        return pre + in + post;
    }

    public static String breakCharacters(CharSequence in, int breakChars) {
        return TextUtils.breakCharacters(in.toString(), breakChars);
    }

    public static String breakCharacters(String in, int breakChars) {
        return TextUtils.breakCharacters(in, breakChars, false);
    }

    public static String breakCharacters(String in, int breakChars, boolean forceBreak) {
        if (in == null) {
            return null;
        }
        if (breakChars > 0) {
            java.lang.StringBuilder sb = new java.lang.StringBuilder(in);
            int chars = 0;
            for (int i = 0; i < sb.length(); ++i) {
                char c = sb.charAt(i);
                if (c == '\n' || c == '\r') {
                    chars = 0;
                    continue;
                }
                if (++chars <= breakChars || !forceBreak && !Character.isSpaceChar(c) && c != '/' && c != '\\') continue;
                if (Character.isSpaceChar(c)) {
                    sb.setCharAt(i, '\n');
                } else {
                    sb.insert(i + 1, '\n');
                }
                chars = 0;
            }
            in = sb.toString();
        }
        return in;
    }

    public static long countLines(String str) {
        return str.chars().filter(ch -> ch == 10 || ch == 13).count();
    }

    public static String breakSpaces(String in, int breakSpaces) {
        if (breakSpaces > 0) {
            java.lang.StringBuilder sb = new java.lang.StringBuilder(in);
            int spaces = 0;
            for (int i = 0; i < sb.length(); ++i) {
                char c = sb.charAt(i);
                if (Character.isSpaceChar(c)) {
                    ++spaces;
                }
                if (spaces != breakSpaces) continue;
                sb.setCharAt(i, '\n');
                spaces = 0;
            }
            in = sb.toString();
        }
        return in;
    }

    public static String capString(String in, int targetLength) {
        return TextUtils.capString(in, targetLength, false);
    }

    public static String capString(String in, int targetLength, boolean fromStart) {
        if (in == null) {
            return null;
        }
        if (in.length() <= targetLength) {
            return in;
        }
        if (fromStart) {
            return "..." + in.substring(in.length() - (targetLength - 3));
        }
        return in.substring(0, targetLength - 1) + "...";
    }

    public static String propertyToMethodName(String property) {
        String[] parts = property.split("\\.");
        StringBuilder b = new StringBuilder();
        for (String part : parts) {
            b.append(TextUtils.capitalise(part));
        }
        return b.toString();
    }

    public static String capitalise(String line) {
        return Character.toUpperCase(line.charAt(0)) + line.substring(1);
    }

    public static String trueCapitalise(String line) {
        return Character.toUpperCase(line.charAt(0)) + line.substring(1).toLowerCase();
    }

    public static String concatenate(String split, String ... strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        java.lang.StringBuilder out = new java.lang.StringBuilder();
        for (String str : strings) {
            if (str == null || str.isEmpty()) continue;
            if (!out.isEmpty()) {
                out.append(split);
            }
            out.append(str);
        }
        return out.toString();
    }

    public static String concatenate(String split, List<String> strings) {
        java.lang.StringBuilder out = new java.lang.StringBuilder();
        for (String str : strings) {
            if (str == null || str.isEmpty()) continue;
            if (!out.isEmpty()) {
                out.append(split);
            }
            out.append(str);
        }
        return out.toString();
    }

    public static String arrayToStr(String[] arr) {
        java.lang.StringBuilder buff = new java.lang.StringBuilder();
        for (String s : arr) {
            buff.append(s).append('\n');
        }
        return buff.toString();
    }

    public static String arrayToStr(String[] arr, String pre, String post, String sep) {
        java.lang.StringBuilder buff = new java.lang.StringBuilder(pre);
        for (int i = 0; i < arr.length; ++i) {
            buff.append(arr[i]);
            if (i >= arr.length - 1) continue;
            buff.append(sep);
        }
        return String.valueOf(buff) + post;
    }

    public static String setToStr(Set<String> set) {
        return TextUtils.setToStr(set, "[", "]", ", ");
    }

    public static String setToStr(Set<String> set, String pre, String post, String sep) {
        java.lang.StringBuilder buff = new java.lang.StringBuilder(pre);
        if (set != null) {
            int n = set.size();
            int i = 0;
            for (String elem : set) {
                buff.append(elem);
                if (i < n - 1) {
                    buff.append(sep);
                }
                ++i;
            }
        }
        return String.valueOf(buff) + post;
    }

    public static String getFormattedTimeWarp(double warp) {
        warp = warp > 0.9 || warp < -0.9 ? (double)FastMath.round((double)warp) : (double)FastMath.round((double)(warp * 1000.0)) / 1000.0;
        return "x" + GlobalResources.formatNumber(warp);
    }

    public static String getFormattedTimeWarp() {
        return TextUtils.getFormattedTimeWarp(GaiaSky.instance.time.getWarpFactor());
    }

    public static String secondsToTimeUnit(double seconds) {
        DecimalFormat nf = GlobalResources.nf;
        DecimalFormat nfSci = GlobalResources.nfSci;
        if (seconds >= 0.0) {
            if (seconds < 60.0) {
                return nf.format(seconds) + " " + I18n.msg("gui.unit.second");
            }
            if (seconds < 3600.0) {
                return nf.format(seconds / 60.0) + " " + I18n.msg("gui.unit.minute");
            }
            if (seconds < 86400.0) {
                return nf.format(seconds / 3600.0) + " " + I18n.msg("gui.unit.hour");
            }
            if (seconds < 604800.0) {
                return nf.format(seconds / 86400.0) + " " + I18n.msg("gui.unit.day");
            }
            if (seconds < 2629800.0) {
                return nf.format(seconds / 604800.0) + " " + I18n.msg("gui.unit.week");
            }
            if (seconds < 3.15576E7) {
                return nf.format(seconds / 2629800.0) + " " + I18n.msg("gui.unit.month");
            }
            return nfSci.format(seconds / 3.15576E7) + " " + I18n.msg("gui.unit.year");
        }
        if (seconds > -60.0) {
            return nf.format(seconds) + " " + I18n.msg("gui.unit.second");
        }
        if (seconds > -3600.0) {
            return nf.format(seconds / 60.0) + " " + I18n.msg("gui.unit.minute");
        }
        if (seconds > -86400.0) {
            return nf.format(seconds / 3600.0) + " " + I18n.msg("gui.unit.hour");
        }
        if (seconds > -604800.0) {
            return nf.format(seconds / 86400.0) + " " + I18n.msg("gui.unit.day");
        }
        if (seconds > -2629800.0) {
            return nf.format(seconds / 604800.0) + " " + I18n.msg("gui.unit.week");
        }
        if (seconds > -3.15576E7) {
            return nf.format(seconds / 2629800.0) + " " + I18n.msg("gui.unit.month");
        }
        return nfSci.format(seconds / 3.15576E7) + " " + I18n.msg("gui.unit.year");
    }

    public static String[] concatAll(String base, String[] suffixes) {
        String[] result = new String[suffixes.length];
        for (int i = 0; i < suffixes.length; ++i) {
            result[i] = base + suffixes[i];
        }
        return result;
    }

    public static <T> T[] addToBeginningOfArray(T[] elements, T element) {
        T[] newArray = Arrays.copyOf(elements, elements.length + 1);
        newArray[0] = element;
        System.arraycopy(elements, 0, newArray, 1, elements.length);
        return newArray;
    }

    public static boolean contains(String[] list, String key) {
        return TextUtils.contains(list, key, false);
    }

    public static boolean contains(String[] list, String key, boolean ignoreCase) {
        AtomicBoolean result = new AtomicBoolean(false);
        Arrays.stream(list).forEach(candidate -> {
            if (ignoreCase ? candidate.equalsIgnoreCase(key) : candidate.equals(key)) {
                result.set(true);
            }
        });
        return result.get();
    }

    public static boolean startsWith(String[] list, String prefix) {
        AtomicBoolean result = new AtomicBoolean(false);
        Arrays.stream(list).forEach(candidate -> {
            if (candidate.startsWith(prefix)) {
                result.set(true);
            }
        });
        return result.get();
    }

    public static String ensureStartsWith(String base, String start) {
        if (!base.startsWith(start)) {
            return start + base;
        }
        return base;
    }

    public static boolean contains(String name, List<String> list) {
        for (String candidate : list) {
            if (candidate == null || candidate.isEmpty() || !name.contains(candidate)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOrMatches(String[] list, String key, boolean ignoreCase) {
        AtomicBoolean contained = new AtomicBoolean(false);
        Arrays.stream(list).forEach(candidate -> {
            if (ignoreCase ? candidate.equalsIgnoreCase(key) : candidate.equals(key)) {
                contained.set(true);
            } else if (key.matches((String)candidate)) {
                contained.set(true);
            }
        });
        return contained.get();
    }

    public static boolean containsOrMatches(String[][] list, String key, boolean ignoreCase) {
        AtomicBoolean contained = new AtomicBoolean(false);
        for (String[] l : list) {
            Arrays.stream(l).forEach(candidate -> {
                if (ignoreCase ? candidate.equalsIgnoreCase(key) : candidate.equals(key)) {
                    contained.set(true);
                } else if (key.matches((String)candidate)) {
                    contained.set(true);
                }
            });
        }
        return contained.get();
    }

    public static String html2text(String html) {
        return HTML4Unescape.unescapeHTML4(html.replaceAll("<.*?>", ""));
    }

    public static String unescape(String oldStr) {
        java.lang.StringBuilder newStr = new java.lang.StringBuilder(oldStr.length());
        boolean saw_backslash = false;
        for (int i = 0; i < oldStr.length(); ++i) {
            int cp = oldStr.codePointAt(i);
            if (oldStr.codePointAt(i) > 65535) {
                ++i;
            }
            if (!saw_backslash) {
                if (cp == 92) {
                    saw_backslash = true;
                    continue;
                }
                newStr.append(Character.toChars(cp));
                continue;
            }
            if (cp == 92) {
                saw_backslash = false;
                newStr.append('\\');
                newStr.append('\\');
                continue;
            }
            switch (cp) {
                case 114: {
                    newStr.append('\r');
                    break;
                }
                case 110: {
                    newStr.append('\n');
                    break;
                }
                case 102: {
                    newStr.append('\f');
                    break;
                }
                case 98: {
                    newStr.append("\\b");
                    break;
                }
                case 116: {
                    newStr.append('\t');
                    break;
                }
                case 97: {
                    newStr.append('\u0007');
                    break;
                }
                case 101: {
                    newStr.append('\u001b');
                    break;
                }
                case 99: {
                    if (++i == oldStr.length()) {
                        TextUtils.die("trailing \\c");
                    }
                    if ((cp = oldStr.codePointAt(i)) > 127) {
                        TextUtils.die("expected ASCII after \\c");
                    }
                    newStr.append(Character.toChars(cp ^ 0x40));
                    break;
                }
                case 56: 
                case 57: {
                    TextUtils.die("illegal octal digit");
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    --i;
                }
                case 48: {
                    char ch;
                    int j;
                    if (i + 1 == oldStr.length()) {
                        newStr.append(Character.toChars(0));
                        break;
                    }
                    ++i;
                    int digits = 0;
                    for (j = 0; j <= 2 && i + j != oldStr.length() && (ch = oldStr.charAt(i + j)) >= '0' && ch <= '7'; ++j) {
                        ++digits;
                    }
                    if (digits == 0) {
                        --i;
                        newStr.append('\u0000');
                        break;
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldStr.substring(i, i + digits), 8);
                    }
                    catch (NumberFormatException nfe) {
                        TextUtils.die("invalid octal value for \\0 escape");
                    }
                    newStr.append(Character.toChars(value));
                    i += digits - 1;
                    break;
                }
                case 120: {
                    int j;
                    if (i + 2 > oldStr.length()) {
                        TextUtils.die("string too short for \\x escape");
                    }
                    boolean saw_brace = false;
                    if (oldStr.charAt(++i) == '{') {
                        ++i;
                        saw_brace = true;
                    }
                    for (j = 0; j < 8 && (saw_brace || j != 2); ++j) {
                        char ch = oldStr.charAt(i + j);
                        if (ch > '\u007f') {
                            TextUtils.die("illegal non-ASCII hex digit in \\x escape");
                        }
                        if (saw_brace && ch == '}') break;
                        if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F') continue;
                        TextUtils.die(String.format("illegal hex digit #%d '%c' in \\x", ch, (int)ch));
                    }
                    if (j == 0) {
                        TextUtils.die("empty braces in \\x{} escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldStr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        TextUtils.die("invalid hex value for \\x escape");
                    }
                    newStr.append(Character.toChars(value));
                    if (saw_brace) {
                        ++j;
                    }
                    i += j - 1;
                    break;
                }
                case 117: {
                    int j;
                    if (i + 4 > oldStr.length()) {
                        TextUtils.die("string too short for \\u escape");
                    }
                    ++i;
                    for (j = 0; j < 4; ++j) {
                        if (oldStr.charAt(i + j) <= '\u007f') continue;
                        TextUtils.die("illegal non-ASCII hex digit in \\u escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldStr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        TextUtils.die("invalid hex value for \\u escape");
                    }
                    newStr.append(Character.toChars(value));
                    i += j - 1;
                    break;
                }
                case 85: {
                    int j;
                    if (i + 8 > oldStr.length()) {
                        TextUtils.die("string too short for \\U escape");
                    }
                    ++i;
                    for (j = 0; j < 8; ++j) {
                        if (oldStr.charAt(i + j) <= '\u007f') continue;
                        TextUtils.die("illegal non-ASCII hex digit in \\U escape");
                    }
                    int value = 0;
                    try {
                        value = Integer.parseInt(oldStr.substring(i, i + j), 16);
                    }
                    catch (NumberFormatException nfe) {
                        TextUtils.die("invalid hex value for \\U escape");
                    }
                    newStr.append(Character.toChars(value));
                    i += j - 1;
                    break;
                }
                default: {
                    newStr.append('\\');
                    newStr.append(Character.toChars(cp));
                }
            }
            saw_backslash = false;
        }
        if (saw_backslash) {
            newStr.append('\\');
        }
        return newStr.toString();
    }

    private static void die(String foa) {
        throw new IllegalArgumentException(foa);
    }

    public static String classSimpleName(String className) {
        if (className.contains(".")) {
            return className.substring(className.lastIndexOf(".") + 1);
        }
        return className;
    }

    public static String padString(String str, int length, char padChar) {
        if (str.length() >= length) {
            return str;
        }
        return String.format("%1$" + length + "s", str).replace(' ', padChar);
    }

    public static int hashFast(String str) {
        return TextUtils.hashFast(str.toCharArray());
    }

    public static int hashFast(char[] val) {
        int h = 0;
        int i = 0;
        int len = val.length;
        while (i + 3 < len) {
            h = 923521 * h + 29791 * val[i] + 961 * val[i + 1] + 31 * val[i + 2] + val[i + 3];
            i += 4;
        }
        while (i < len) {
            h = 31 * h + val[i];
            ++i;
        }
        return h;
    }

    public static int hashFNV1(String str) {
        return TextUtils.hashFNV1(str.toCharArray(), 1L);
    }

    public static int hashFNV1(char[] data, long seed) {
        int len = data.length;
        for (char datum : data) {
            seed += (seed << 1) + (seed << 4) + (seed << 7) + (seed << 8) + (seed << 24);
            seed ^= (long)datum;
        }
        return (int)seed;
    }

    public static int hashMurmur(String str) {
        return TextUtils.hashMurmur(str.toCharArray(), 1);
    }

    public static int hashMurmur(char[] data, int seed) {
        int m = 1540483477;
        int r = 24;
        int h = seed ^ data.length;
        int len = data.length;
        int len_4 = len >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = i << 2;
            int k = data[i_4 + 3];
            k <<= 8;
            k |= data[i_4 + 2] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 1] & 0xFF;
            k <<= 8;
            k |= data[i_4] & 0xFF;
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
        }
        int len_m = len_4 << 2;
        int left = len - len_m;
        if (left != 0) {
            if (left >= 3) {
                h ^= data[len - 3] << 16;
            }
            if (left >= 2) {
                h ^= data[len - 2] << 8;
            }
            if (left >= 1) {
                h ^= data[len - 1];
            }
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    public static Optional<String> readFirstLine(Path file) {
        Optional<String> optional;
        BufferedReader reader = new BufferedReader(new FileReader(file.toFile()));
        try {
            String line = reader.readLine();
            reader.close();
            optional = Optional.of(line);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    public static String sanitizeFilename(String input) {
        String[] reserved;
        Object sanitized = input.replaceAll("[\\\\/:*?\"<>|]", "_");
        sanitized = ((String)sanitized).replaceAll("[\\p{Cntrl}]", "");
        sanitized = ((String)sanitized).trim();
        while (((String)sanitized).endsWith(".") || ((String)sanitized).endsWith(" ")) {
            sanitized = ((String)sanitized).substring(0, ((String)sanitized).length() - 1);
        }
        for (String res : reserved = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"}) {
            if (!((String)sanitized).equalsIgnoreCase(res)) continue;
            sanitized = "_" + (String)sanitized;
            break;
        }
        if (((String)sanitized).isEmpty()) {
            sanitized = "unnamed";
        }
        return sanitized;
    }

    private static class HTML4Unescape {
        private static final HashMap<String, Integer> knownEscapes = new HashMap(1024);

        private HTML4Unescape() {
        }

        public static String unescapeHTML4(String str) {
            if (str == null) {
                return null;
            }
            int index = 0;
            while ((index = ((String)str).indexOf(38, index)) != -1) {
                int index2 = ((String)str).indexOf(59, index + 1);
                if (index2 == -1) {
                    return str;
                }
                if (((String)str).charAt(index + 1) == '#') {
                    int result = 0;
                    try {
                        if (((String)str).charAt(index + 2) == 'x') {
                            for (int i = index + 3; i < index2; ++i) {
                                result = result << 4 | HTML4Unescape.hexValue(((String)str).charAt(i));
                            }
                        } else {
                            result = Integer.parseInt(((String)str).substring(index + 2, index2));
                        }
                    }
                    catch (NumberFormatException e) {
                        index = index2;
                        continue;
                    }
                    str = ((String)str).substring(0, index) + Character.toString((char)result) + ((String)str).substring(index2 + 1);
                    ++index;
                    continue;
                }
                Integer cCode = knownEscapes.get(((String)str).substring(index + 1, index2));
                if (cCode != null) {
                    str = ((String)str).substring(0, index) + Character.toString((char)cCode.intValue()) + ((String)str).substring(index2 + 1);
                    ++index;
                    continue;
                }
                index = index2 + 1;
            }
            return str;
        }

        private static int hexValue(char c) {
            if (c >= '0' && c <= '9') {
                return c - 48;
            }
            if (c >= 'A' && c <= 'F') {
                return c - 65 + 10;
            }
            throw new NumberFormatException();
        }

        static {
            knownEscapes.put("nbsp", 32);
            knownEscapes.put("lt", 60);
            knownEscapes.put("gt", 62);
            knownEscapes.put("quot", 34);
            knownEscapes.put("amp", 38);
            knownEscapes.put("AElig", 198);
            knownEscapes.put("Aacute", 193);
            knownEscapes.put("Acirc", 194);
            knownEscapes.put("Agrave", 192);
            knownEscapes.put("Aring", 197);
            knownEscapes.put("Atilde", 195);
            knownEscapes.put("Auml", 196);
            knownEscapes.put("Ccedil", 199);
            knownEscapes.put("ETH", 208);
            knownEscapes.put("Eacute", 201);
            knownEscapes.put("Ecirc", 202);
            knownEscapes.put("Egrave", 200);
            knownEscapes.put("Euml", 203);
            knownEscapes.put("Iacute", 205);
            knownEscapes.put("Icirc", 206);
            knownEscapes.put("Igrave", 204);
            knownEscapes.put("Iuml", 207);
            knownEscapes.put("Ntilde", 209);
            knownEscapes.put("Oacute", 211);
            knownEscapes.put("Ocirc", 212);
            knownEscapes.put("Ograve", 210);
            knownEscapes.put("Oslash", 216);
            knownEscapes.put("Otilde", 213);
            knownEscapes.put("Ouml", 214);
            knownEscapes.put("THORN", 222);
            knownEscapes.put("Uacute", 218);
            knownEscapes.put("Ucirc", 219);
            knownEscapes.put("Ugrave", 217);
            knownEscapes.put("Uuml", 220);
            knownEscapes.put("Yacute", 221);
            knownEscapes.put("aacute", 225);
            knownEscapes.put("acirc", 226);
            knownEscapes.put("aelig", 230);
            knownEscapes.put("agrave", 224);
            knownEscapes.put("aring", 229);
            knownEscapes.put("atilde", 227);
            knownEscapes.put("auml", 228);
            knownEscapes.put("ccedil", 231);
            knownEscapes.put("eacute", 233);
            knownEscapes.put("ecirc", 234);
            knownEscapes.put("egrave", 232);
            knownEscapes.put("eth", 240);
            knownEscapes.put("euml", 235);
            knownEscapes.put("iacute", 237);
            knownEscapes.put("icirc", 238);
            knownEscapes.put("igrave", 236);
            knownEscapes.put("iuml", 239);
            knownEscapes.put("ntilde", 241);
            knownEscapes.put("oacute", 243);
            knownEscapes.put("ocirc", 244);
            knownEscapes.put("ograve", 242);
            knownEscapes.put("oslash", 248);
            knownEscapes.put("otilde", 245);
            knownEscapes.put("ouml", 246);
            knownEscapes.put("szlig", 223);
            knownEscapes.put("thorn", 254);
            knownEscapes.put("uacute", 250);
            knownEscapes.put("ucirc", 251);
            knownEscapes.put("ugrave", 249);
            knownEscapes.put("uuml", 252);
            knownEscapes.put("yacute", 253);
            knownEscapes.put("yuml", 255);
            knownEscapes.put("cent", 162);
            knownEscapes.put("OElig", 338);
            knownEscapes.put("oelig", 339);
            knownEscapes.put("euro", 8364);
        }
    }
}

