/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import gaiasky.gui.main.KeyBindings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.StdRandom;
import gaiasky.util.scene2d.OwnImage;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnTextButton;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;

public class TipsGenerator {
    private static final int MAX_KEYS = 100;
    private final Skin skin;
    private final List<TipPart[]> tips;
    private final int[] sequence;
    private int currentIndex = 0;

    public TipsGenerator(Skin skin) {
        int i;
        this.skin = skin;
        this.tips = new ArrayList<TipPart[]>();
        for (int j = 0; j < 100; ++j) {
            try {
                String tipStr = I18n.msg("tip." + j);
                String[] lines = tipStr.split("\\r\\n|\\n|\\r");
                KeyBindings kb = KeyBindings.instance;
                for (String line : lines) {
                    String[] tokens = line.split("\\|");
                    int n = tokens.length;
                    TipPart[] parts = new TipPart[n];
                    for (int i2 = 0; i2 < n; ++i2) {
                        TipPart part = new TipPart();
                        String token = tokens[i2].strip();
                        if (token.startsWith("$$")) {
                            int idx = token.indexOf(" ");
                            if (idx < 0) {
                                idx = token.length();
                            }
                            part.drawable = token.substring(2, idx).strip();
                            parts[i2] = part;
                        } else {
                            String keys;
                            if (token.startsWith("%%")) {
                                int idx = token.indexOf(" ");
                                if (idx < 0) {
                                    idx = token.length();
                                }
                                part.style = token.substring(2, idx).strip();
                                part.text = token.substring(idx + 1).strip();
                            } else {
                                part.text = token.strip();
                            }
                            if (!part.text.isBlank() && (keys = kb.getStringKeys(part.text)) != null) {
                                part.text = keys;
                            }
                        }
                        parts[i2] = part;
                    }
                    this.tips.add(parts);
                }
                continue;
            }
            catch (MissingResourceException tipStr) {
                // empty catch block
            }
        }
        int n = this.tips.size();
        this.sequence = new int[n];
        for (i = 0; i < n; ++i) {
            this.sequence[i] = i;
        }
        for (i = 0; i < n; ++i) {
            int randomIndexToSwap = StdRandom.uniform(n);
            int temp = this.sequence[randomIndexToSwap];
            this.sequence[randomIndexToSwap] = this.sequence[i];
            this.sequence[i] = temp;
        }
    }

    public void newTip(WidgetGroup tip) {
        TipPart[] l = this.tips.get(this.sequence[this.currentIndex]);
        this.addTip(tip, l);
        this.currentIndex = (this.currentIndex + 1) % this.tips.size();
    }

    private void addTip(WidgetGroup g, TipPart[] tip) {
        float pad5 = 8.0f;
        float pad2 = 3.2f;
        g.clear();
        for (TipPart part : tip) {
            if (part == null) continue;
            if (part.drawable != null && !part.drawable.isBlank()) {
                Drawable drawable = this.skin.getDrawable(part.drawable);
                if (drawable == null) continue;
                OwnImage image = new OwnImage(drawable);
                g.addActor((Actor)image);
                continue;
            }
            if (this.skin.has(part.style, Label.LabelStyle.class)) {
                OwnLabel label = new OwnLabel((CharSequence)part.text, this.skin, part.style);
                g.addActor((Actor)label);
                continue;
            }
            if (!this.skin.has(part.style, TextButton.TextButtonStyle.class)) continue;
            String[] keys = part.text.split("\\+");
            int n = keys.length;
            for (int i = 0; i < n; ++i) {
                String t = keys[i];
                if (I18n.hasMessage("key." + keys[i])) {
                    t = I18n.msg("key." + keys[i]);
                }
                OwnTextButton button = new OwnTextButton(t, this.skin, part.style);
                button.pad(pad2, pad5, pad2, pad5);
                g.addActor((Actor)button);
                if (i >= n - 1) continue;
                OwnLabel plus = new OwnLabel((CharSequence)"+", this.skin, "main-title-s");
                plus.setColor(0.5f, 0.5f, 0.5f, 1.0f);
                g.addActor((Actor)plus);
            }
        }
    }

    private static class TipPart {
        public String style = "main-title-s";
        public String text;
        public String drawable;

        public TipPart() {
        }

        public TipPart(String text) {
            this.text = text;
        }

        public TipPart(String text, String style) {
            this.text = text;
            this.style = style;
        }

        public String toString() {
            return this.drawable != null ? "D-" + this.drawable : "%%" + this.style + " " + this.text;
        }
    }
}

