/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

public class TopNBuffer {
    private final int capacity;
    private int size = 0;
    private final int[] indices;
    private final double[] values;

    public TopNBuffer(int capacity) {
        this.capacity = capacity;
        this.indices = new int[capacity];
        this.values = new double[capacity];
    }

    public void clear() {
        this.size = 0;
    }

    public void add(int index, double value) {
        if (this.size < this.capacity) {
            this.indices[this.size] = index;
            this.values[this.size] = value;
            ++this.size;
        } else {
            int maxIdx = this.findMaxIndex();
            if (value < this.values[maxIdx]) {
                this.indices[maxIdx] = index;
                this.values[maxIdx] = value;
            }
        }
    }

    public int[] indexArray() {
        return this.indices;
    }

    public int size() {
        return this.size;
    }

    public double getValue(int i) {
        return this.values[i];
    }

    public void sort() {
        this.quickSort(0, this.size - 1);
    }

    private void quickSort(int low, int high) {
        if (low < high) {
            int pi = this.partition(low, high);
            this.quickSort(low, pi - 1);
            this.quickSort(pi + 1, high);
        }
    }

    private int partition(int low, int high) {
        double pivot = this.values[high];
        int i = low - 1;
        for (int j = low; j < high; ++j) {
            if (!(this.values[j] < pivot)) continue;
            this.swap(++i, j);
        }
        this.swap(i + 1, high);
        return i + 1;
    }

    private void swap(int i, int j) {
        int tempIndex = this.indices[i];
        this.indices[i] = this.indices[j];
        this.indices[j] = tempIndex;
        double tempValue = this.values[i];
        this.values[i] = this.values[j];
        this.values[j] = tempValue;
    }

    private int findMaxIndex() {
        int maxIdx = 0;
        double maxVal = this.values[0];
        for (int i = 1; i < this.size; ++i) {
            if (!(this.values[i] > maxVal)) continue;
            maxVal = this.values[i];
            maxIdx = i;
        }
        return maxIdx;
    }
}

