/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import java.util.HashMap;
import java.util.Map;

public class TwoWayMap<K, V> {
    private final Map<K, V> forward = new HashMap();
    private final Map<V, K> backward = new HashMap<V, K>();

    public synchronized void add(K key, V value) {
        this.forward.put(key, value);
        this.backward.put(value, key);
    }

    public synchronized V getForward(K key) {
        return this.forward.get(key);
    }

    public synchronized K getBackward(V key) {
        return this.backward.get(key);
    }

    public synchronized boolean containsKey(K key) {
        return this.forward.containsKey(key);
    }

    public synchronized boolean containsValue(V value) {
        return this.backward.containsKey(value);
    }

    public synchronized void removeKey(K key) {
        V value = this.forward.get(key);
        this.remove(key, value);
    }

    public synchronized boolean removeValue(V value) {
        K key = this.backward.get(value);
        return this.remove(key, value);
    }

    private synchronized boolean remove(K key, V value) {
        if (value != null && key != null) {
            this.forward.remove(key);
            this.backward.remove(value);
            return true;
        }
        return false;
    }
}

