/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import java.util.Locale;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.WGLAMDGPUAssociation;

public class VMemInfo {
    private static final Logger.Log logger = Logger.getLogger(VMemInfo.class);
    private static IGraphicsDeviceInfo graphicsDeviceInfo;
    private static boolean crash;

    public static void initialize() {
        String extensions = GlobalResources.getGLExtensions().toLowerCase(Locale.ROOT);
        boolean nvxGPU = extensions.contains("GL_NVX_gpu_memory_info".toLowerCase(Locale.ROOT));
        boolean amdGPUAssoc = extensions.contains("WGL_AMD_gpu_association".toLowerCase(Locale.ROOT));
        boolean atiMemInfo = extensions.contains("GL_ATI_meminfo".toLowerCase(Locale.ROOT));
        if (nvxGPU) {
            try {
                graphicsDeviceInfo = new NvidiaVRam();
            }
            catch (Error e) {
                logger.error(e);
                crash = true;
            }
        } else if (amdGPUAssoc || atiMemInfo) {
            try {
                graphicsDeviceInfo = new AmdVRam(amdGPUAssoc, atiMemInfo);
            }
            catch (Exception e) {
                logger.error(e);
                crash = true;
            }
        } else {
            try {
                graphicsDeviceInfo = new NoneVRam();
            }
            catch (Exception e) {
                logger.error(e);
                crash = true;
            }
        }
    }

    public static double getFreeMemory() {
        if (!crash && graphicsDeviceInfo == null) {
            VMemInfo.initialize();
        }
        return graphicsDeviceInfo == null ? -1.0 : graphicsDeviceInfo.getFreeMemory();
    }

    public static double getTotalMemory() {
        if (!crash && graphicsDeviceInfo == null) {
            VMemInfo.initialize();
        }
        return graphicsDeviceInfo == null ? -1.0 : graphicsDeviceInfo.getTotalMemory();
    }

    public static double getUsedMemory() {
        if (!crash && graphicsDeviceInfo == null) {
            VMemInfo.initialize();
        }
        return graphicsDeviceInfo == null ? -1.0 : graphicsDeviceInfo.getUsedMemory();
    }

    static {
        crash = false;
    }

    private static class NvidiaVRam
    implements IGraphicsDeviceInfo {
        private final int[] buff = new int[1];
        private final double totalMem = this.computeTotalMemory();

        @Override
        public double getFreeMemory() {
            GL20.glGetIntegerv((int)36937, (int[])this.buff);
            return (double)this.buff[0] * 0.001;
        }

        public double computeTotalMemory() {
            GL20.glGetIntegerv((int)36936, (int[])this.buff);
            return (double)this.buff[0] * 0.001;
        }

        @Override
        public double getTotalMemory() {
            return this.totalMem;
        }

        @Override
        public double getUsedMemory() {
            return this.getTotalMemory() - this.getFreeMemory();
        }
    }

    public static interface IGraphicsDeviceInfo {
        public double getFreeMemory();

        public double getTotalMemory();

        public double getUsedMemory();
    }

    private static class AmdVRam
    implements IGraphicsDeviceInfo {
        private final int[] buff = new int[4];
        private final double totalMem;
        private final boolean gpuAssoc;
        private final boolean memInfo;

        public AmdVRam(boolean gpuAssoc, boolean memInfo) {
            this.gpuAssoc = gpuAssoc;
            this.memInfo = memInfo;
            this.totalMem = this.computeTotalMemory();
        }

        @Override
        public double getFreeMemory() {
            if (this.memInfo) {
                GL20.glGetIntegerv((int)34811, (int[])this.buff);
                return (double)this.buff[0] * 0.001;
            }
            return -1.0;
        }

        public double computeTotalMemory() {
            int n;
            int[] ids;
            int res;
            if (this.gpuAssoc && (res = WGLAMDGPUAssociation.wglGetGPUIDsAMD((int[])(ids = new int[n = WGLAMDGPUAssociation.nwglGetGPUIDsAMD((int)0, (long)0L)]))) > 0) {
                WGLAMDGPUAssociation.wglGetGPUInfoAMD((int)ids[0], (int)8611, (int)5125, (int[])this.buff);
                return (double)this.buff[0] * 0.001;
            }
            return -1.0;
        }

        @Override
        public double getTotalMemory() {
            return this.totalMem;
        }

        @Override
        public double getUsedMemory() {
            if (this.gpuAssoc && this.memInfo) {
                return this.getTotalMemory() - this.getFreeMemory();
            }
            return -1.0;
        }
    }

    private static class NoneVRam
    implements IGraphicsDeviceInfo {
        private NoneVRam() {
        }

        @Override
        public double getFreeMemory() {
            return -1.0;
        }

        @Override
        public double getTotalMemory() {
            return -1.0;
        }

        @Override
        public double getUsedMemory() {
            return -1.0;
        }
    }
}

