/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util;

import gaiasky.util.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtils {
    private static final Logger.Log logger = Logger.getLogger(ZipUtils.class);

    public static void unzip(String zipFilePath, String destinationDir) throws IOException {
        File dir = new File(destinationDir);
        if (!dir.exists() && dir.mkdirs()) {
            logger.debug("Output directory created: " + String.valueOf(dir));
        }
        byte[] buffer = new byte[1024];
        FileInputStream fis = new FileInputStream(zipFilePath);
        ZipInputStream zis = new ZipInputStream(fis);
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            int len;
            String fileName = ze.getName();
            File newFile = new File(destinationDir + File.separator + fileName);
            logger.info("Unzipping to " + newFile.getAbsolutePath());
            if (new File(newFile.getParent()).mkdirs()) {
                logger.debug("Directory created: " + newFile.getParent());
            }
            FileOutputStream fos = new FileOutputStream(newFile);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            zis.closeEntry();
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        fis.close();
    }
}

