/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.camera;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.Ray;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.system.update.ModelUpdater;
import gaiasky.scene.view.FocusView;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.Vector3D;

public class CameraUtils {
    private static final ModelUpdater updater = new ModelUpdater(null, 0);

    public static boolean intersectScreenSphere(IFocus f, Entity e, ICamera camera, int sx, int sy, Vector3 v0, Vector3 v1, Vector3 vec, Vector3 intersection) {
        GraphNode graph = (GraphNode)Mapper.graph.get(e);
        graph.translation.put(vec);
        v0.set((float)sx, (float)sy, 0.0f);
        v1.set((float)sx, (float)sy, 0.5f);
        camera.getCamera().unproject(v0);
        camera.getCamera().unproject(v1);
        Ray ray = new Ray(v0, v1.sub(v0).nor());
        return Intersector.intersectRaySphere((Ray)ray, (Vector3)vec, (float)((float)f.getRadius()), (Vector3)intersection);
    }

    public static boolean getLonLat(FocusView f, Entity e, ICamera camera, int sx, int sy, Vector3 v0, Vector3 v1, Vector3 vec, Vector3 intersection, Vector3D in, Vector3D out, Matrix4 localTransformInv, double[] lonlat) {
        boolean inter = CameraUtils.intersectScreenSphere(f, e, camera, sx, sy, v0, v1, vec, intersection);
        if (inter) {
            updater.setToLocalTransform(e, f.getBody(), f.getGraph(), 1.0f, localTransformInv, false);
            localTransformInv.inv();
            v0.set(intersection);
            v0.mul(localTransformInv);
            in.set(v0);
            Coordinates.cartesianToSpherical(in, out);
            lonlat[0] = (57.29577951308232 * out.x + 90.0) % 360.0;
            lonlat[1] = 57.29577951308232 * out.y;
            return true;
        }
        return false;
    }

    public static void unproject(Camera camera, Vector3 screenCoords, float viewportX, float viewportY, float viewportWidth, float viewportHeight, int screenHeight) {
        float x = screenCoords.x - viewportX;
        float y = (float)screenHeight - screenCoords.y - viewportY;
        screenCoords.x = 2.0f * x / viewportWidth - 1.0f;
        screenCoords.y = 2.0f * y / viewportHeight - 1.0f;
        screenCoords.z = 2.0f * screenCoords.z - 1.0f;
        screenCoords.prj(camera.invProjectionView);
    }

    public static void unproject(Camera camera, Vector3 screenCoords, int screenWidth, int screenHeight) {
        CameraUtils.unproject(camera, screenCoords, 0.0f, 0.0f, screenWidth, screenHeight, screenHeight);
    }
}

