/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.camera;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.camera.NaturalCamera;
import gaiasky.scene.record.RotationComponent;
import gaiasky.scene.view.FocusView;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.time.ITimeFrameProvider;
import gaiasky.util.tree.OctreeNode;
import java.util.Arrays;

public class Proximity {
    private static final int DEFAULT_SIZE = 4;
    private static final byte TYPE_UNDEFINED = -1;
    private static final byte TYPE_STAR = 0;
    private static final byte TYPE_STAR_GROUP = 1;
    private static final byte TYPE_OTHER = 2;
    public NearbyRecord[] updating;
    public NearbyRecord[] effective;
    public NearbyRecord[] array0;
    public NearbyRecord[] array1;

    public Proximity() {
        this(4);
    }

    public Proximity(int size) {
        this.array0 = new NearbyRecord[size];
        this.array1 = new NearbyRecord[size];
        this.updating = this.array0;
        this.effective = this.array1;
    }

    public void set(int index, int originalIndex, IParticleRecord pr, ICamera camera) {
        this.set(index, originalIndex, pr, camera, 0.0);
    }

    public void set(int index, int originalIndex, IParticleRecord pr, ICamera camera, double deltaYears) {
        if (this.updating[index] == null) {
            this.updating[index] = new NearbyRecord();
        }
        NearbyRecord c = this.updating[index];
        this.convert(pr, c, camera, deltaYears);
        c.index = originalIndex;
    }

    public void set(int index, int originalIndex, IFocus focus, ICamera camera) {
        if (this.updating[index] == null) {
            this.updating[index] = new NearbyRecord();
        }
        NearbyRecord c = this.updating[index];
        this.convert(focus, c, camera);
        c.index = originalIndex;
    }

    public void set(int index, NearbyRecord record) {
        this.updating[index] = record;
    }

    public void insert(int index, NearbyRecord record) {
        NearbyRecord newRecord = record;
        for (int i = index; i < this.updating.length; ++i) {
            NearbyRecord oldRecord = this.updating[i];
            this.updating[i] = newRecord;
            newRecord = oldRecord;
        }
    }

    public void insert(int index, IFocus object, ICamera camera) {
        NearbyRecord record = this.convert(object, new NearbyRecord(), camera);
        this.insert(index, record);
    }

    public boolean update(NearbyRecord object) {
        int i = 0;
        for (NearbyRecord record : this.updating) {
            if (record == null) {
                this.set(i, object);
                return true;
            }
            if (record == object) {
                return false;
            }
            if (object.distToCamera < record.distToCamera) {
                this.insert(i, object);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean update(IFocus object, ICamera camera) {
        int i = 0;
        for (NearbyRecord record : this.updating) {
            if (record == null) {
                this.set(i, -1, object, camera);
                return true;
            }
            if (record == object) {
                return false;
            }
            if (!object.getName().equalsIgnoreCase(record.name) && object.getClosestDistToCamera() < record.distToCamera) {
                this.insert(i, object, camera);
                return true;
            }
            ++i;
        }
        return false;
    }

    private byte getType(IFocus f) {
        if (f instanceof FocusView && Mapper.hip.has(((FocusView)f).getEntity())) {
            return 0;
        }
        return 2;
    }

    public void swapBuffers() {
        if (this.updating == this.array0) {
            this.updating = this.array1;
            this.effective = this.array0;
            this.clear(this.updating);
        } else {
            this.updating = this.array0;
            this.effective = this.array1;
            this.clear(this.updating);
        }
    }

    private void clear(NearbyRecord[] arr) {
        Arrays.fill(arr, null);
    }

    public NearbyRecord convert(IParticleRecord pr, NearbyRecord c, ICamera camera, double deltaYears) {
        c.pm.set(pr.vx(), pr.vy(), pr.vz()).scl(deltaYears);
        c.absolutePos.set(pr.x(), pr.y(), pr.z()).add(c.pm);
        c.pos.set(c.absolutePos).sub(camera.getPos());
        c.size = pr.size();
        c.radius = pr.radius();
        c.distToCamera = c.pos.len() - c.radius;
        c.name = pr.names()[0];
        c.type = 1;
        Color col = new Color();
        Color.abgr8888ToColor((Color)col, (float)pr.color());
        c.col[0] = col.r;
        c.col[1] = col.g;
        c.col[2] = col.b;
        c.col[3] = col.a;
        return c;
    }

    public NearbyRecord convert(IFocus focus, NearbyRecord c, ICamera camera) {
        c.pm.set(0.0, 0.0, 0.0);
        Vector3Q absPos = new Vector3Q();
        absPos = focus.getAbsolutePosition(absPos);
        c.absolutePos.set(absPos);
        c.pos.set(c.absolutePos).sub(camera.getPos());
        c.size = focus.getSize();
        c.radius = focus.getRadius();
        c.distToCamera = focus.getClosestDistToCamera();
        c.name = focus.getName();
        c.type = this.getType(focus);
        float[] col = focus.getColor();
        if (col != null) {
            c.col[0] = col[0];
            c.col[1] = col[1];
            c.col[2] = col[2];
            c.col[3] = 1.0f;
        } else {
            c.col[0] = 1.0f;
            c.col[1] = 1.0f;
            c.col[2] = 1.0f;
            c.col[3] = 1.0f;
        }
        return c;
    }

    public static class NearbyRecord
    implements IFocus {
        public double distToCamera;
        public double size;
        public double radius;
        public Vector3D pos;
        public Vector3D pm;
        public Vector3D absolutePos;
        public float[] col;
        public String name;
        public byte type = (byte)-1;
        public int index;

        public NearbyRecord() {
            this.pos = new Vector3D();
            this.pm = new Vector3D();
            this.absolutePos = new Vector3D();
            this.col = new float[4];
        }

        public boolean isStar() {
            return this.type == 0;
        }

        public boolean isStarGroup() {
            return this.type == 1;
        }

        public boolean isOther() {
            return this.type == 2;
        }

        public boolean isUndefined() {
            return this.type == -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public long getId() {
            return -1L;
        }

        @Override
        public long getCandidateId() {
            return -1L;
        }

        @Override
        public String getLocalizedName() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getNames() {
            return new String[]{this.name};
        }

        @Override
        public boolean hasName(String name) {
            return this.name.equalsIgnoreCase(name);
        }

        @Override
        public boolean hasName(String name, boolean matchCase) {
            return matchCase ? this.name.equals(name) : this.name.equalsIgnoreCase(name);
        }

        @Override
        public String getClosestName() {
            return this.name;
        }

        @Override
        public String getClosestLocalizedName() {
            return I18n.localize(this.getClosestName());
        }

        @Override
        public String getCandidateName() {
            return this.name;
        }

        @Override
        public ComponentTypes getCt() {
            return new ComponentTypes(ComponentTypes.ComponentType.Stars);
        }

        @Override
        public boolean isFocusActive() {
            return true;
        }

        @Override
        public Vector3Q getPos() {
            return null;
        }

        @Override
        public Entity getFirstStarAncestorEntity() {
            return null;
        }

        @Override
        public IFocus getFirstStarAncestor() {
            return null;
        }

        @Override
        public Vector3Q getAbsolutePosition(Vector3Q out) {
            return out.set(this.absolutePos);
        }

        @Override
        public Vector3Q getAbsolutePosition(String name, Vector3Q out) {
            if (name.equalsIgnoreCase(this.name)) {
                return out.set(this.absolutePos);
            }
            return out;
        }

        @Override
        public Vector3Q getClosestAbsolutePos(Vector3Q out) {
            return out.set(this.absolutePos);
        }

        @Override
        public Vector2D getPosSph() {
            return null;
        }

        @Override
        public Vector3Q getPredictedPosition(Vector3Q aux, ITimeFrameProvider time, ICamera camera, boolean force) {
            return null;
        }

        @Override
        public Vector3Q getPredictedPosition(Vector3Q aux, double deltaTime) {
            return null;
        }

        @Override
        public double getDistToCamera() {
            return this.distToCamera;
        }

        @Override
        public double getClosestDistToCamera() {
            return this.distToCamera;
        }

        @Override
        public double getSolidAngle() {
            return 0.0;
        }

        @Override
        public double getSolidAngleApparent() {
            return 0.0;
        }

        @Override
        public double getCandidateSolidAngleApparent() {
            return 0.0;
        }

        @Override
        public double getAlpha() {
            return 0.0;
        }

        @Override
        public double getDelta() {
            return 0.0;
        }

        @Override
        public double getSize() {
            return this.size;
        }

        @Override
        public double getRadius() {
            return this.radius;
        }

        @Override
        public double getTEff() {
            return 0.0;
        }

        @Override
        public double getElevationAt(Vector3Q camPos) {
            return 0.0;
        }

        @Override
        public double getElevationAt(Vector3Q camPos, boolean useFuturePosition) {
            return 0.0;
        }

        @Override
        public double getElevationAt(Vector3Q camPos, Vector3Q nextPos) {
            return 0.0;
        }

        @Override
        public double getHeightScale() {
            return 0.0;
        }

        @Override
        public float getAppmag() {
            return 0.0f;
        }

        @Override
        public float getAbsmag() {
            return 0.0f;
        }

        @Override
        public Matrix4D getOrientation() {
            return null;
        }

        @Override
        public RotationComponent getRotationComponent() {
            return null;
        }

        @Override
        public QuaternionDouble getOrientationQuaternion() {
            return null;
        }

        @Override
        public void addHitCoordinate(int screenX, int screenY, int w, int h, int pixelDist, NaturalCamera camera, Array<IFocus> hits) {
        }

        @Override
        public void addEntityHitCoordinate(int screenX, int screenY, int w, int h, int pixelDist, NaturalCamera camera, Array<Entity> hits) {
        }

        @Override
        public void addHitRay(Vector3D p0, Vector3D p1, NaturalCamera camera, Array<IFocus> hits) {
        }

        @Override
        public void addEntityHitRay(Vector3D p0, Vector3D p1, NaturalCamera camera, Array<Entity> hits) {
        }

        @Override
        public void makeFocus() {
        }

        @Override
        public IFocus getFocus(String name) {
            return null;
        }

        @Override
        public boolean isCoordinatesTimeOverflow() {
            return false;
        }

        @Override
        public int getSceneGraphDepth() {
            return 0;
        }

        @Override
        public OctreeNode getOctant() {
            return null;
        }

        @Override
        public boolean isCopy() {
            return false;
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public boolean isCameraCollision() {
            return true;
        }

        @Override
        public float[] getColor() {
            return this.col;
        }

        @Override
        public boolean isForceLabel() {
            return false;
        }

        @Override
        public boolean isForceLabel(String name) {
            return false;
        }
    }
}

