/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.camera.rec;

import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.window.FileNameWindow;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.camera.rec.CameraPath;
import gaiasky.util.camera.rec.KeyframesManager;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.time.ITimeFrameProvider;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;

public class Camcorder
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(Camcorder.class);
    public static Camcorder instance;
    private final DateFormat df;
    Vector3D dir;
    Vector3D upp;
    Vector3D aux1;
    Vector3D aux2;
    float time;
    private final AtomicReference<RecorderState> mode = new AtomicReference<RecorderState>(RecorderState.IDLE);
    private final AtomicReference<CameraPath> recordingPath;
    private final AtomicReference<CameraPath> playingPath;
    private double fpsLimitBackup = 0.0;
    private long startMs;
    private final AtomicReference<String> currentFileName = new AtomicReference<Object>(null);

    public Camcorder() {
        this.recordingPath = new AtomicReference();
        this.playingPath = new AtomicReference();
        this.df = new SimpleDateFormat("yyyyMMdd_HH-mm-ss-SSS");
        this.dir = new Vector3D();
        this.upp = new Vector3D();
        this.aux1 = new Vector3D();
        this.aux2 = new Vector3D();
        EventManager.instance.subscribe((IObserver)this, Event.RECORD_CAMERA_CMD, Event.PLAY_CAMERA_CMD, Event.UPDATE_CAM_RECORDER);
    }

    public static void initialize() {
        instance = new Camcorder();
        KeyframesManager.initialize();
    }

    public void update(ITimeFrameProvider time, Vector3Q position, Vector3D direction, Vector3D up) {
        switch (this.mode.get().ordinal()) {
            case 0: {
                if (this.recordingPath.get() == null) break;
                this.recordingPath.get().add(time.getTime(), position.x(), position.y(), position.z(), direction.x(), direction.y(), direction.z(), up.x(), up.y(), up.z());
                break;
            }
            case 1: {
                if (this.playingPath == null) break;
                if (this.playingPath.get().i < this.playingPath.get().n) {
                    EventManager.publish(Event.TIME_CHANGE_CMD, this, this.playingPath.get().times.get((int)this.playingPath.get().i));
                    int ip = (int)this.playingPath.get().i * 9;
                    position.set(this.playingPath.get().data.get(ip), this.playingPath.get().data.get(ip + 1), this.playingPath.get().data.get(ip + 2));
                    direction.set(this.playingPath.get().data.get(ip + 3), this.playingPath.get().data.get(ip + 4), this.playingPath.get().data.get(ip + 5));
                    up.set(this.playingPath.get().data.get(ip + 6), this.playingPath.get().data.get(ip + 7), this.playingPath.get().data.get(ip + 8));
                    ++this.playingPath.get().i;
                    break;
                }
                if (this.playingPath.get().frameRate > 0.0) {
                    EventManager.publish(Event.LIMIT_FPS_CMD, this, this.fpsLimitBackup);
                    this.fpsLimitBackup = 0.0;
                }
                this.playingPath.set(null);
                this.mode.set(RecorderState.IDLE);
                EventManager.publish(Event.CAMERA_STOP, this, new Object[0]);
                logger.info(I18n.msg("notif.cameraplay.done"));
                EventManager.publish(Event.CAMERA_PLAY_INFO, this, false);
                EventManager.publish(Event.FRAME_OUTPUT_CMD, this, false);
                break;
            }
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case RECORD_CAMERA_CMD: {
                String filename;
                RecorderState newMode;
                Boolean state = (Boolean)data[0];
                if (state.booleanValue() && this.mode.get() != RecorderState.IDLE) {
                    logger.warn(I18n.msg("notif.cameraplay.record.busy", this.mode));
                    return;
                }
                RecorderState recorderState = newMode = state != false ? RecorderState.RECORDING : RecorderState.IDLE;
                if (newMode == RecorderState.RECORDING) {
                    if (this.mode.get() == RecorderState.RECORDING) {
                        logger.info(I18n.msg("error.camerarecord.already"));
                        return;
                    }
                    this.recordingPath.set(new CameraPath(Settings.settings.camrecorder.targetFps));
                    if (this.recordingPath.get().frameRate > 0.0) {
                        this.fpsLimitBackup = Settings.settings.graphics.fpsLimit;
                        EventManager.publish(Event.LIMIT_FPS_CMD, this, this.recordingPath.get().frameRate);
                    }
                    logger.info(I18n.msg("notif.camerarecord.start"));
                    this.startMs = System.currentTimeMillis();
                    this.time = 0.0f;
                    this.mode.set(RecorderState.RECORDING);
                    if (data.length > 1 && data[1] != null && !((String)data[1]).isBlank()) {
                        this.currentFileName.set((String)data[1]);
                        break;
                    }
                    this.currentFileName.set(null);
                    break;
                }
                boolean showFilePicker = true;
                if (data.length > 2 && data[2] != null) {
                    showFilePicker = (Boolean)data[2];
                }
                if (this.mode.get() == RecorderState.IDLE) {
                    return;
                }
                if (this.recordingPath != null && this.recordingPath.get().frameRate > 0.0) {
                    EventManager.publish(Event.LIMIT_FPS_CMD, this, this.fpsLimitBackup);
                    this.fpsLimitBackup = 0.0;
                }
                if (data.length > 1 && data[1] != null && !((String)data[1]).isBlank()) {
                    filename = (String)data[1];
                } else if (this.currentFileName.get() != null) {
                    filename = this.currentFileName.get();
                    this.currentFileName.set(null);
                } else {
                    filename = this.df.format(new Date());
                }
                this.mode.set(RecorderState.IDLE);
                if (showFilePicker) {
                    Stage stage = GaiaSky.instance.mainGui.getGuiStage();
                    Skin skin = GaiaSky.instance.getGlobalResources().getSkin();
                    FileNameWindow fnw = new FileNameWindow(filename + ".gsc", stage, skin);
                    OwnTextField textField = fnw.getFileNameField();
                    fnw.setAcceptListener(() -> {
                        if (textField.isValid()) {
                            this.finishPlayback(textField.getText());
                        } else {
                            EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("error.file.name.notvalid", textField.getText()), Float.valueOf(10.0f));
                        }
                    });
                    fnw.setCancelListener(() -> EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("notif.cameraplay.discard"), Float.valueOf(10.0f)));
                    fnw.show(stage);
                    break;
                }
                this.finishPlayback(filename);
                break;
            }
            case PLAY_CAMERA_CMD: {
                Boolean state = (Boolean)data[0];
                if (state.booleanValue()) {
                    if (this.playingPath != null) {
                        logger.warn(I18n.msg("notif.cameraplay.already"));
                    }
                    if (this.mode.get() != RecorderState.IDLE) {
                        logger.warn(I18n.msg("notif.cameraplay.record.busy", this.mode));
                        return;
                    }
                    Object f = data[1];
                    Path file = f instanceof String ? Paths.get((String)f, new String[0]) : (Path)f;
                    try {
                        this.playingPath.set(new CameraPath(Files.newInputStream(file, new OpenOption[0])));
                        logger.info(I18n.msg("notif.cameraplay.start", file));
                        EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("notif.cameraplay.start", file));
                        if (this.playingPath.get().frameRate > 0.0) {
                            this.fpsLimitBackup = Settings.settings.graphics.fpsLimit;
                            EventManager.publish(Event.LIMIT_FPS_CMD, this, this.playingPath.get().frameRate);
                        }
                        this.mode.set(RecorderState.PLAYING);
                        EventManager.publish(Event.CAMERA_PLAY_INFO, this, true);
                        if (!Settings.settings.camrecorder.auto) break;
                        EventManager.publish(Event.FRAME_OUTPUT_CMD, this, true);
                    }
                    catch (Exception e) {
                        EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("error.file.parse", file));
                        logger.error(e);
                    }
                    break;
                }
                if (this.mode.get() != RecorderState.PLAYING) {
                    logger.warn(I18n.msg("notif.cameraplay.notplaying", this.mode));
                    return;
                }
                this.mode.set(RecorderState.IDLE);
                EventManager.publish(Event.CAMERA_STOP, this, new Object[0]);
                if (this.playingPath.get().frameRate > 0.0) {
                    EventManager.publish(Event.LIMIT_FPS_CMD, this, this.fpsLimitBackup);
                    this.fpsLimitBackup = 0.0;
                }
                logger.info(I18n.msg("notif.cameraplay.done"));
                EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("notif.cameraplay.done"));
                EventManager.publish(Event.CAMERA_PLAY_INFO, this, false);
                EventManager.publish(Event.FRAME_OUTPUT_CMD, this, false);
                break;
            }
            case UPDATE_CAM_RECORDER: {
                ITimeFrameProvider dt = (ITimeFrameProvider)data[0];
                Vector3Q pos = (Vector3Q)data[1];
                Vector3D dir = (Vector3D)data[2];
                Vector3D up = (Vector3D)data[3];
                this.update(dt, pos, dir, up);
                break;
            }
        }
    }

    public boolean isRecording() {
        return this.mode.get() == RecorderState.RECORDING;
    }

    public boolean isPlaying() {
        return this.mode.get() == RecorderState.PLAYING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishPlayback(String filename) {
        Path f;
        if (!((String)filename).endsWith(".gsc")) {
            filename = (String)filename + ".gsc";
        }
        if (Files.exists(f = SysUtils.getDefaultCameraDir().resolve((String)filename), new LinkOption[0])) {
            f = SysUtils.uniqueFileName(f);
        }
        try {
            if (this.recordingPath.get() != null) {
                this.recordingPath.get().persist(f);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        finally {
            this.recordingPath.set(null);
        }
        long elapsed = System.currentTimeMillis() - this.startMs;
        this.startMs = 0L;
        float secs = (float)elapsed / 1000.0f;
        assert (f != null);
        logger.info(I18n.msg("notif.camerarecord.done", f.toAbsolutePath(), Float.valueOf(secs)));
        EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("notif.camerarecord.done", f.toAbsolutePath(), Float.valueOf(secs)));
    }

    public static enum RecorderState {
        RECORDING,
        PLAYING,
        STEPPING,
        IDLE;

    }
}

