/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.camera.rec;

import com.badlogic.gdx.utils.Array;
import gaiasky.util.DoubleArray;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.camera.rec.Keyframe;
import gaiasky.util.camera.rec.KeyframesManager;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.parse.Parser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.List;

public class CameraPath {
    private static final Logger.Log logger = Logger.getLogger(CameraPath.class);
    public long n;
    public final Array<Instant> times = new Array();
    public final DoubleArray data = new DoubleArray();
    public double frameRate = -1.0;
    public long i;
    private static final String sep = ",";
    private static final String gscFileSeparatorRegex = "[\\s,]+";

    public CameraPath(double targetFps) {
        this.n = 0L;
        this.i = 0L;
        this.frameRate = targetFps;
    }

    public CameraPath(InputStream file) throws RuntimeException {
        try (BufferedReader is = new BufferedReader(new InputStreamReader(file));){
            String line;
            while ((line = is.readLine()) != null) {
                boolean comment = (line = line.strip()).startsWith("#");
                if (comment && line.startsWith("#fps")) {
                    String fpsString = line.split(gscFileSeparatorRegex)[1];
                    try {
                        this.frameRate = Parser.parseDoubleException(fpsString);
                    }
                    catch (NumberFormatException ignored) {
                        logger.error("Error parsing FPS value from line: " + line);
                    }
                }
                if (comment) continue;
                String[] tokens = line.split(gscFileSeparatorRegex);
                try {
                    this.times.add((Object)Instant.ofEpochMilli(Parser.parseLongException(tokens[0])));
                }
                catch (NumberFormatException ignored) {
                    this.times.add((Object)Instant.parse(tokens[0]));
                }
                this.data.add(Parser.parseDouble(tokens[1]), Parser.parseDouble(tokens[2]), Parser.parseDouble(tokens[3]));
                this.data.add(Parser.parseDouble(tokens[4]), Parser.parseDouble(tokens[5]), Parser.parseDouble(tokens[6]));
                this.data.add(Parser.parseDouble(tokens[7]), Parser.parseDouble(tokens[8]), Parser.parseDouble(tokens[9]));
            }
            this.n = this.times.size;
            this.i = 0L;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CameraPath(List<Keyframe> keyframes, KeyframesManager.PathPart[] posSplines) {
        QuaternionDouble q = new QuaternionDouble();
        QuaternionDouble q0 = new QuaternionDouble();
        QuaternionDouble q1 = new QuaternionDouble();
        Vector3D v3d1 = new Vector3D();
        Vector3D v3d2 = new Vector3D();
        this.frameRate = Settings.settings.camrecorder.targetFps;
        KeyframesManager.PathPart currentPosSpline = posSplines[0];
        int k = 0;
        double splinePosIdx = 0.0;
        double splinePosStep = 1.0 / (double)(currentPosSpline.nPoints - 1);
        for (int i = 1; i < keyframes.size(); ++i) {
            Keyframe k0 = keyframes.get(i - 1);
            Keyframe k1 = keyframes.get(i);
            q0.setFromCamera(k0.dir, k0.up);
            q1.setFromCamera(k1.dir, k1.up);
            long nFrames = (long)(k1.seconds * this.frameRate);
            double splinePosSubStep = splinePosStep / (double)nFrames;
            long dt = k1.time.toEpochMilli() - k0.time.toEpochMilli();
            long tStep = dt / nFrames;
            for (long fr = 0L; fr < nFrames; ++fr) {
                double a = (double)fr / (double)nFrames;
                double b = splinePosIdx + splinePosSubStep * (double)fr;
                this.times.add((Object)k0.time.plusMillis(tStep * fr));
                currentPosSpline.path.valueAt(v3d1, b);
                this.data.add(v3d1.x, v3d1.y, v3d1.z);
                q.set(q0).slerp(q1, a);
                q.getDirection(v3d1);
                v3d1.nor();
                this.data.add(v3d1.x, v3d1.y, v3d1.z);
                q.getUp(v3d2);
                this.data.add(v3d2.x, v3d2.y, v3d2.z);
            }
            splinePosIdx += splinePosStep;
            if (!k1.seam || i >= keyframes.size() - 1 || Settings.settings.camrecorder.keyframe.position != KeyframesManager.PathType.CATMULL_ROM_SPLINE) continue;
            currentPosSpline = posSplines[++k];
            splinePosIdx = 0.0;
            splinePosStep = 1.0 / (double)(currentPosSpline.nPoints - 1);
        }
        Keyframe kf = keyframes.get(keyframes.size() - 1);
        this.times.add((Object)kf.time);
        this.data.add(kf.pos.x, kf.pos.y, kf.pos.z);
        this.data.add(kf.dir.x, kf.dir.y, kf.dir.z);
        this.data.add(kf.up.x, kf.up.y, kf.up.z);
        this.n = this.times.size;
    }

    public void add(Instant time, double px, double py, double pz, double dx, double dy, double dz, double ux, double uy, double uz) {
        this.times.add((Object)time);
        this.data.add(px, py, pz);
        this.data.add(dx, dy, dz);
        this.data.add(ux, uy, uz);
        this.n = this.times.size;
    }

    public void persist(Path f) throws Exception {
        if (Files.exists(f, new LinkOption[0])) {
            throw new RuntimeException(I18n.msg("error.file.exists", f.toString()));
        }
        Files.createFile(f, new FileAttribute[0]);
        try (BufferedWriter os = new BufferedWriter(new FileWriter(f.toFile()));){
            if (this.frameRate > 0.0) {
                os.append("#fps ").append(Double.toString(this.frameRate)).append("\n");
            }
            os.append("#time").append(sep).append("pos_x").append(sep).append("pos_y").append(sep).append("pos_z").append(sep);
            os.append("dir_x").append(sep).append("dir_y").append(sep).append("dir_z").append(sep);
            os.append("up_x").append(sep).append("up_y").append(sep).append("up_z").append(sep);
            os.append("\n");
            int i = 0;
            while ((long)i < this.n) {
                os.append(((Instant)this.times.get(i)).toString()).append(sep);
                int ip = i * 9;
                os.append(Double.toString(this.data.get(ip))).append(sep).append(Double.toString(this.data.get(ip + 1))).append(sep).append(Double.toString(this.data.get(ip + 2)));
                os.append(sep).append(Double.toString(this.data.get(ip + 3))).append(sep).append(Double.toString(this.data.get(ip + 4))).append(sep).append(Double.toString(this.data.get(ip + 5)));
                os.append(sep).append(Double.toString(this.data.get(ip + 6))).append(sep).append(Double.toString(this.data.get(ip + 7))).append(sep).append(Double.toString(this.data.get(ip + 8)));
                os.append("\n");
                ++i;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

