/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.camera.rec;

import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.scene.camera.CameraManager;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.camera.rec.Camcorder;
import gaiasky.util.camera.rec.CameraPath;
import gaiasky.util.camera.rec.Keyframe;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.BSplineDouble;
import gaiasky.util.math.CatmullRomSplineDouble;
import gaiasky.util.math.LinearDouble;
import gaiasky.util.math.PathDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.math.VectorDouble;
import gaiasky.util.parse.Parser;
import gaiasky.util.time.ITimeFrameProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class KeyframesManager
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(KeyframesManager.class);
    private static final String sep = ",";
    private static final String gkfFileSeparatorRegex = ",";
    public static KeyframesManager instance;
    public final List<Keyframe> keyframes;
    public Vector3Q pos;
    public Vector3D dir;
    public Vector3D up;
    public ITimeFrameProvider t;
    public CameraPath currentPath;
    public final AtomicReference<Camcorder.RecorderState> state = new AtomicReference<Camcorder.RecorderState>(Camcorder.RecorderState.IDLE);

    public KeyframesManager() {
        this.keyframes = Collections.synchronizedList(new ArrayList());
        EventManager.instance.subscribe((IObserver)this, Event.KEYFRAMES_FILE_SAVE, Event.KEYFRAMES_EXPORT, Event.UPDATE_CAM_RECORDER, Event.KEYFRAME_PLAY_FRAME);
    }

    public static void initialize() {
        instance = new KeyframesManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regenerateCameraPath() {
        List<Keyframe> list = this.keyframes;
        synchronized (list) {
            this.currentPath = new CameraPath(this.keyframes, this.positionsToPathParts(this.keyframes, Settings.settings.camrecorder.keyframe.position));
        }
    }

    public void clean() {
        this.keyframes.clear();
    }

    public long getFrameNumber(Keyframe kf) {
        if (kf == null || this.keyframes.isEmpty() || !this.keyframes.contains(kf)) {
            return -1L;
        }
        double t = 0.0;
        int i = 0;
        while (!this.keyframes.get(i).equals(kf)) {
            t += this.keyframes.get((int)i).seconds;
            ++i;
        }
        return (long)((t += kf.seconds) * Settings.settings.camrecorder.targetFps);
    }

    private PathDouble<Vector3D> getPath(Vector3D[] data, PathType pathType) {
        if (pathType == PathType.LINEAR) {
            return new LinearDouble((VectorDouble[])data);
        }
        if (pathType == PathType.CATMULL_ROM_SPLINE) {
            VectorDouble[] extData = new Vector3D[data.length + 2];
            System.arraycopy(data, 0, extData, 1, data.length);
            extData[0] = data[0];
            extData[data.length + 1] = data[data.length - 1];
            return new CatmullRomSplineDouble(extData, false);
        }
        if (pathType == PathType.B_SPLINE) {
            VectorDouble[] extData = new Vector3D[data.length + 2];
            System.arraycopy(data, 0, extData, 1, data.length);
            extData[0] = data[0];
            extData[data.length + 1] = data[data.length - 1];
            return new BSplineDouble(extData, false);
        }
        return new LinearDouble((VectorDouble[])data);
    }

    public List<Keyframe> loadKeyframesFile(Path file) throws RuntimeException {
        List<Keyframe> list;
        BufferedReader br = new BufferedReader(new FileReader(file.toFile()));
        try {
            String line;
            List<Keyframe> result = Collections.synchronizedList(new ArrayList());
            while ((line = br.readLine()) != null) {
                Vector3D up;
                Vector3D dir;
                Vector3D pos;
                Instant time;
                double secs;
                if ((line = line.strip()).startsWith("#")) continue;
                String[] tokens = line.split(",");
                if (tokens.length == 13) {
                    secs = Parser.parseDouble(tokens[0]);
                    time = this.parseTime(tokens[1]);
                    pos = new Vector3D(Parser.parseDouble(tokens[2]), Parser.parseDouble(tokens[3]), Parser.parseDouble(tokens[4]));
                    dir = new Vector3D(Parser.parseDouble(tokens[5]), Parser.parseDouble(tokens[6]), Parser.parseDouble(tokens[7]));
                    up = new Vector3D(Parser.parseDouble(tokens[8]), Parser.parseDouble(tokens[9]), Parser.parseDouble(tokens[10]));
                    boolean seam = Parser.parseInt(tokens[11]) == 1;
                    String name = tokens[12];
                    Keyframe kf = new Keyframe(name, pos, dir, up, time, secs, seam);
                    result.add(kf);
                    continue;
                }
                if (tokens.length != 16) continue;
                secs = Parser.parseDouble(tokens[0]);
                time = this.parseTime(tokens[1]);
                pos = new Vector3D(Parser.parseDouble(tokens[2]), Parser.parseDouble(tokens[3]), Parser.parseDouble(tokens[4]));
                dir = new Vector3D(Parser.parseDouble(tokens[5]), Parser.parseDouble(tokens[6]), Parser.parseDouble(tokens[7]));
                up = new Vector3D(Parser.parseDouble(tokens[8]), Parser.parseDouble(tokens[9]), Parser.parseDouble(tokens[10]));
                Vector3D target = new Vector3D(Parser.parseDouble(tokens[11]), Parser.parseDouble(tokens[12]), Parser.parseDouble(tokens[13]));
                boolean seam = Parser.parseInt(tokens[14]) == 1;
                String name = tokens[15];
                Keyframe kf = new Keyframe(name, pos, dir, up, target, time, secs, seam);
                result.add(kf);
            }
            list = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        br.close();
        return list;
    }

    private Instant parseTime(String timeToken) {
        Instant time;
        try {
            time = Instant.ofEpochMilli(Parser.parseLongException(timeToken));
        }
        catch (NumberFormatException ignored) {
            time = Instant.parse(timeToken);
        }
        return time;
    }

    public void saveKeyframesFile(List<Keyframe> keyframes, String fileName, boolean notification) {
        Path f = SysUtils.getDefaultCameraDir().resolve(fileName);
        if (Files.exists(f, new LinkOption[0])) {
            f = SysUtils.uniqueFileName(f);
        }
        try {
            assert (f != null);
            try (BufferedWriter os = new BufferedWriter(new FileWriter(f.toFile()));){
                for (Keyframe kf : keyframes) {
                    os.append(Double.toString(kf.seconds)).append(",").append(kf.time.toString()).append(",");
                    os.append(Double.toString(kf.pos.x)).append(",").append(Double.toString(kf.pos.y)).append(",").append(Double.toString(kf.pos.z)).append(",");
                    os.append(Double.toString(kf.dir.x)).append(",").append(Double.toString(kf.dir.y)).append(",").append(Double.toString(kf.dir.z)).append(",");
                    os.append(Double.toString(kf.up.x)).append(",").append(Double.toString(kf.up.y)).append(",").append(Double.toString(kf.up.z)).append(",");
                    if (kf.target != null) {
                        os.append(Double.toString(kf.target.x)).append(",").append(Double.toString(kf.target.y)).append(",").append(Double.toString(kf.target.z)).append(",");
                    }
                    os.append(Integer.toString(kf.seam ? 1 : 0)).append(",");
                    os.append(kf.name).append("\n");
                }
            }
        }
        catch (IOException e) {
            logger.error(e);
            return;
        }
        if (notification) {
            GaiaSky.popupNotification(I18n.msg("gui.keyframes.save.ok", keyframes.size(), f.toString()), 10.0f, this);
        }
    }

    public double[] samplePaths(Array<Array<Vector3D>> pointsSep, double[] points, int samplesPerSegment, PathType pathType) {
        if (pathType == PathType.LINEAR) {
            double[] result = new double[points.length];
            System.arraycopy(points, 0, result, 0, points.length);
            return result;
        }
        Array res = new Array();
        for (Array vec : pointsSep) {
            int nSamples = (vec.size - 1) * samplesPerSegment + 1;
            int nChunks = nSamples - 1;
            Vector3D aux = new Vector3D();
            PathDouble<Vector3D> sampler = this.getPath(this.toArray((Array<Vector3D>)vec), pathType);
            double step = 1.0 / (double)nChunks;
            int i = 0;
            double t = 0.0;
            while (i < nSamples * 3) {
                sampler.valueAt(aux, t);
                res.add((Object)aux.x);
                res.add((Object)aux.y);
                res.add((Object)aux.z);
                i += 3;
                t += step;
            }
        }
        double[] result = new double[res.size];
        int i = 0;
        for (Double d : res) {
            result[i] = d;
            ++i;
        }
        return result;
    }

    private Vector3D[] toArray(Array<Vector3D> v) {
        Vector3D[] out = new Vector3D[v.size];
        for (int i = 0; i < v.size; ++i) {
            out[i] = (Vector3D)v.get(i);
        }
        return out;
    }

    public void exportKeyframesFile(List<Keyframe> keyframes, String fileName) {
        Path f = SysUtils.getDefaultCameraDir().resolve(fileName);
        if (Files.exists(f, new LinkOption[0])) {
            try {
                Files.delete(f);
            }
            catch (IOException e) {
                logger.error(e);
            }
        }
        CameraPath cameraPath = new CameraPath(keyframes, this.positionsToPathParts(keyframes, Settings.settings.camrecorder.keyframe.position));
        try {
            cameraPath.persist(f);
        }
        catch (Exception e) {
            logger.error(e);
            return;
        }
        double frameRate = Settings.settings.camrecorder.targetFps;
        GaiaSky.popupNotification(I18n.msg("gui.keyframes.export.ok", keyframes.size(), cameraPath.n, frameRate, f), 10.0f, this);
    }

    private PathPart[] positionsToPathParts(List<Keyframe> keyframes, PathType pathType) {
        double frameRate = Settings.settings.camrecorder.targetFps;
        Array positionsSep = new Array();
        Array current = new Array();
        Array times = new Array();
        int i = 0;
        double secs = 0.0;
        for (Keyframe kf : keyframes) {
            if (kf.seam && pathType == PathType.CATMULL_ROM_SPLINE && i > 0 && i < keyframes.size() - 1) {
                current.add((Object)kf.pos);
                positionsSep.add((Object)current);
                times.add((Object)(secs + kf.seconds));
                current = new Array();
                secs = -kf.seconds;
            }
            secs += kf.seconds;
            current.add((Object)kf.pos);
            ++i;
        }
        positionsSep.add((Object)current);
        times.add((Object)secs);
        PathPart[] res = new PathPart[positionsSep.size];
        int j = 0;
        for (Array part : positionsSep) {
            PathPart pp;
            double elapsed = (Double)times.get(j);
            res[j] = pp = new PathPart(this.getPath(this.toArray((Array<Vector3D>)part), pathType), part.size, (long)(frameRate * elapsed));
            ++j;
        }
        return res;
    }

    public void play() {
        this.state.set(Camcorder.RecorderState.PLAYING);
    }

    public boolean isPlaying() {
        return this.state.get() == Camcorder.RecorderState.PLAYING;
    }

    public void pause() {
        this.state.set(Camcorder.RecorderState.IDLE);
    }

    public boolean isIdle() {
        return this.state.get() == Camcorder.RecorderState.IDLE;
    }

    public void stepping() {
        this.state.set(Camcorder.RecorderState.STEPPING);
    }

    public boolean isStepping() {
        return this.state.get() == Camcorder.RecorderState.STEPPING;
    }

    public void skip(long frame) {
        if (frame < this.currentPath.n) {
            this.currentPath.i = frame;
            this.stepping();
        }
    }

    private void setFrame() {
        if (!GaiaSky.instance.getCameraManager().getMode().isFree()) {
            EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FREE_MODE});
        }
        EventManager.publish(Event.CAMERA_STOP, this, new Object[0]);
        EventManager.publish(Event.TIME_CHANGE_CMD, this, this.currentPath.times.get((int)this.currentPath.i));
        int ip = (int)this.currentPath.i * 9;
        this.pos.set(this.currentPath.data.get(ip), this.currentPath.data.get(ip + 1), this.currentPath.data.get(ip + 2));
        this.dir.set(this.currentPath.data.get(ip + 3), this.currentPath.data.get(ip + 4), this.currentPath.data.get(ip + 5));
        this.up.set(this.currentPath.data.get(ip + 6), this.currentPath.data.get(ip + 7), this.currentPath.data.get(ip + 8));
    }

    public boolean checkKeyframeTimings() {
        if (!this.keyframes.isEmpty()) {
            double fPS = Settings.settings.camrecorder.targetFps;
            double sPF = 1.0 / fPS;
            long msPF = (long)(sPF * 1000.0);
            for (Keyframe kf : this.keyframes) {
                double frames = kf.seconds * fPS;
                if (frames % 1.0 == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public void runOptFlowCamScript(Path loc, Path outputFile) {
        String scriptName = "optflowcam_convert.py";
        String inputFileName = "temp_keyframes.gkf";
        GaiaSky.instance.getExecutorService().execute(() -> {
            EventManager.publish(Event.KEYFRAMES_FILE_SAVE, this, this.keyframes, "temp_keyframes.gkf", false);
            Path inputFile = SysUtils.getDefaultCameraDir().resolve("temp_keyframes.gkf");
            String pythonInterpreter = SysUtils.isWindows() ? "python3.exe" : "python3";
            ProcessBuilder builder = new ProcessBuilder(pythonInterpreter, loc.resolve("optflowcam_convert.py").toString(), "-i", inputFile.toString(), "-o", outputFile.toString(), "--fps", Double.toString(Settings.settings.camrecorder.targetFps));
            builder.directory(loc.toFile());
            try {
                Process process = builder.start();
                process.waitFor();
                if (process.exitValue() == 0) {
                    InputStream output = process.getInputStream();
                    List<String> lines = new BufferedReader(new InputStreamReader(output, StandardCharsets.UTF_8)).lines().toList();
                    String outputFileLocation = outputFile.toAbsolutePath().toString();
                    if (!lines.isEmpty()) {
                        outputFileLocation = lines.getLast().substring(23);
                    }
                    GaiaSky.popupNotification(I18n.msg("gui.keyframes.export.ok.short", this.keyframes.size(), outputFileLocation), 10.0f, this);
                } else {
                    GaiaSky.popupNotification(I18n.msg("error.process.run", "exit value " + process.exitValue()), 10.0f, this, Logger.LoggerLevel.ERROR, null);
                    InputStream err = process.getErrorStream();
                    InputStream out = process.getInputStream();
                    String errStr = new BufferedReader(new InputStreamReader(err)).lines().collect(Collectors.joining("\n"));
                    String outStr = new BufferedReader(new InputStreamReader(out)).lines().collect(Collectors.joining("\n"));
                    logger.error("ERROR STREAM:");
                    logger.error(errStr);
                    logger.error("OUT STREAM:");
                    logger.error(outStr);
                }
                process.destroy();
            }
            catch (IOException | InterruptedException e) {
                GaiaSky.popupNotification(I18n.msg("error.process.run", e.getLocalizedMessage()), 10.0f, this, Logger.LoggerLevel.ERROR, e);
            }
            try {
                Files.deleteIfExists(inputFile);
            }
            catch (IOException e) {
                GaiaSky.popupNotification(I18n.msg("error.loading.notexistent", inputFile.toString()), 10.0f, this, Logger.LoggerLevel.ERROR, e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case KEYFRAMES_FILE_SAVE: {
                List keyframes = (List)data[0];
                String fileName = (String)data[1];
                Boolean notification = true;
                if (data.length > 2) {
                    notification = (Boolean)data[2];
                }
                this.saveKeyframesFile(keyframes, fileName, notification);
                break;
            }
            case KEYFRAMES_EXPORT: {
                List keyframes = (List)data[0];
                String fileName = (String)data[1];
                this.exportKeyframesFile(keyframes, fileName);
                break;
            }
            case UPDATE_CAM_RECORDER: {
                KeyframesManager keyframes = this;
                synchronized (keyframes) {
                    this.t = (ITimeFrameProvider)data[0];
                    this.pos = (Vector3Q)data[1];
                    this.dir = (Vector3D)data[2];
                    this.up = (Vector3D)data[3];
                }
                if (this.state.get() == Camcorder.RecorderState.PLAYING && this.currentPath != null) {
                    this.setFrame();
                    this.currentPath.i = (this.currentPath.i + 1L) % this.currentPath.n;
                    if (this.currentPath.i == 0L) {
                        this.pause();
                    }
                    EventManager.publish(Event.KEYFRAME_PLAY_FRAME, this, this.currentPath.i);
                    break;
                }
                if (this.state.get() != Camcorder.RecorderState.STEPPING || this.currentPath == null) break;
                this.setFrame();
                this.pause();
                EventManager.publish(Event.KEYFRAME_PLAY_FRAME, this, this.currentPath.i);
                break;
            }
            case KEYFRAME_PLAY_FRAME: {
                if (source == this || this.currentPath == null) break;
                long frame = (Long)data[0];
                this.skip(frame);
                break;
            }
        }
    }

    public static enum PathType {
        LINEAR,
        CATMULL_ROM_SPLINE,
        B_SPLINE;

    }

    public static class PathPart {
        PathDouble<Vector3D> path;
        int nPoints;
        int nChunks;
        long nFrames;

        public PathPart(PathDouble<Vector3D> path, int nPoints, long nFrames) {
            this.path = path;
            this.nPoints = nPoints;
            this.nChunks = nPoints - 1;
            this.nFrames = nFrames;
        }
    }
}

