/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.color;

import net.jafama.FastMath;

public class BVToTeffBallesteros {
    private final double a;
    private final double b;
    private final double c;
    private final double T0;

    public BVToTeffBallesteros() {
        this.a = 0.92;
        this.b = 1.7;
        this.c = 0.62;
        this.T0 = 4600.0;
    }

    public double bvToTeff(double bv) {
        return this.T0 * (1.0 / (this.a * bv + this.b) + 1.0 / (this.a * bv + this.c));
    }

    public double teffToBv(double teff) {
        double z = teff / this.T0;
        double ap = z * (this.a * this.a);
        double bp = this.a * this.c * z + this.b * this.a * z - 2.0 * this.a;
        double cp = this.b * this.c * z - this.c - this.b;
        double sqrtarg = bp * bp - 4.0 * ap * cp;
        return (-bp + FastMath.sqrt((double)sqrtarg)) / (2.0 * ap);
    }
}

