/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.color;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import gaiasky.util.Logger;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.parse.Parser;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import net.jafama.FastMath;

public class ColorUtils {
    public static float[] gGreen = new float[]{0.05882353f, 0.6156863f, 0.34509805f, 1.0f};
    public static com.badlogic.gdx.graphics.Color gGreenC = ColorUtils.getCol(gGreen);
    public static float[] gBlue = new float[]{0.25882354f, 0.52156866f, 0.95686275f, 1.0f};
    public static com.badlogic.gdx.graphics.Color gBlueC = ColorUtils.getCol(gBlue);
    public static float[] gRed = new float[]{0.85882354f, 0.26666668f, 0.21568628f, 1.0f};
    public static com.badlogic.gdx.graphics.Color gRedC = ColorUtils.getCol(gRed);
    public static float[] gYellow = new float[]{0.95686275f, 0.627451f, 0.0f, 1.0f};
    public static com.badlogic.gdx.graphics.Color gYellowC = ColorUtils.getCol(gYellow);
    public static float[] gWhite = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    public static com.badlogic.gdx.graphics.Color gWhiteC = ColorUtils.getCol(gWhite);
    public static float[] gPink = new float[]{1.0f, 0.4f, 1.0f, 1.0f};
    public static com.badlogic.gdx.graphics.Color gPinkC = ColorUtils.getCol(gPink);
    public static float[] aOrange = new float[]{1.0f, 0.6f, 0.0f, 1.0f};
    public static com.badlogic.gdx.graphics.Color aOrangeC = ColorUtils.getCol(aOrange);
    public static float[] tPurple = new float[]{0.047058824f, 0.1254902f, 0.50980395f, 1.0f};
    public static com.badlogic.gdx.graphics.Color tPurpleC = ColorUtils.getCol(tPurple);
    public static float[] ddMagenta = new float[]{0.85490197f, 0.09411765f, 0.5176471f, 1.0f};
    public static com.badlogic.gdx.graphics.Color ddMagentaC = ColorUtils.getCol(ddMagenta);
    public static float[] ddBrown = new float[]{0.39607844f, 0.21960784f, 0.09803922f, 1.0f};
    public static com.badlogic.gdx.graphics.Color ddBrownC = ColorUtils.getCol(ddBrown);
    public static float[] oLighterGray = new float[]{0.85f, 0.85f, 0.85f, 1.0f};
    public static com.badlogic.gdx.graphics.Color oLighterGrayC = ColorUtils.getCol(oLighterGray);
    public static float[] oLightGray = new float[]{0.85f, 0.85f, 0.85f, 1.0f};
    public static com.badlogic.gdx.graphics.Color oLightGrayC = ColorUtils.getCol(oLightGray);
    public static float[] oDarkGray = new float[]{0.3f, 0.3f, 0.3f, 1.0f};
    public static com.badlogic.gdx.graphics.Color oDarkGrayC = ColorUtils.getCol(oDarkGray);
    public static float[] oCyan = new float[]{0.0f, 0.9019608f, 1.0f, 1.0f};
    public static com.badlogic.gdx.graphics.Color oCyanC = ColorUtils.getCol(ddMagenta);
    public static float[][] colorArray = new float[][]{gBlue, gRed, gYellow, gGreen, gPink, aOrange, tPurple, ddBrown, ddMagenta, oCyan};
    private static float[][] teffToRGB_harre;

    private static com.badlogic.gdx.graphics.Color getCol(float[] c) {
        return new com.badlogic.gdx.graphics.Color(c[0], c[1], c[2], c[3]);
    }

    public static float[] getColorFromIndex(int idx) {
        return colorArray[idx % colorArray.length];
    }

    public static float[] getRgbaComplimentary(float[] rgba) {
        float[] hsb = ColorUtils.rgbToHsb(rgba);
        float hue = hsb[0] * 360.0f;
        hsb[0] = (hue + 180.0f) % 360.0f / 360.0f;
        float[] rgb = ColorUtils.hsbToRgb(hsb);
        return new float[]{rgb[0], rgb[1], rgb[2], rgba[3]};
    }

    public static float[] getRgbComplimentary(float[] rgb) {
        float[] hsb = ColorUtils.rgbToHsb(rgb);
        float hue = hsb[0] * 360.0f;
        hsb[0] = (hue + 180.0f) % 360.0f / 360.0f;
        hsb[0] = 1.0f - hsb[0];
        return ColorUtils.hsbToRgb(hsb);
    }

    public static float[] rgbToHsb(float[] color) {
        int r = (int)(color[0] * 255.0f);
        int g = (int)(color[1] * 255.0f);
        int b = (int)(color[2] * 255.0f);
        return Color.RGBtoHSB(r, g, b, null);
    }

    public static float[] hsbToRgb(float[] hsb) {
        Color c = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
        return new float[]{(float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f};
    }

    public static String rgbaToHex(float[] color) {
        int r = (int)(color[0] * 255.0f);
        int g = (int)(color[1] * 255.0f);
        int b = (int)(color[2] * 255.0f);
        int a = (int)(color[3] * 255.0f);
        return String.format("#%02x%02x%02x%02x", r, g, b, a);
    }

    public static String rgbToHex(float[] color) {
        int r = (int)(color[0] * 255.0f);
        int g = (int)(color[1] * 255.0f);
        int b = (int)(color[2] * 255.0f);
        return String.format("#%02x%02x%02x", r, g, b);
    }

    public static float[] hexToRgba(String hex) {
        return new float[]{(float)Integer.valueOf(hex.substring(1, 3), 16).intValue() / 255.0f, (float)Integer.valueOf(hex.substring(3, 5), 16).intValue() / 255.0f, (float)Integer.valueOf(hex.substring(5, 7), 16).intValue() / 255.0f, (float)Integer.valueOf(hex.substring(7, 9), 16).intValue() / 255.0f};
    }

    public static float[] hexToRgb(String hex) {
        return new float[]{(float)Integer.valueOf(hex.substring(1, 3), 16).intValue() / 255.0f, (float)Integer.valueOf(hex.substring(3, 5), 16).intValue() / 255.0f, (float)Integer.valueOf(hex.substring(5, 7), 16).intValue() / 255.0f};
    }

    public static float normalize(float value, float min, float max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return (value - min) / (max - min);
    }

    public static void grayscale(float value, float[] rgba) {
        rgba[0] = value;
        rgba[1] = value;
        rgba[2] = value;
        rgba[3] = 1.0f;
    }

    public static void colormap_blue_white_red(float value, float[] rgba) {
        float a = value * 2.0f - 1.0f;
        if (a <= 0.0f) {
            rgba[0] = rgba[1] = 1.0f + a;
            rgba[2] = 1.0f;
        } else {
            rgba[0] = 1.0f;
            rgba[1] = rgba[2] = 1.0f - a;
        }
    }

    public static void colormap_short_rainbow(float value, float[] rgba) {
        float a = (1.0f - value) / 0.25f;
        int X = (int)FastMath.floor((float)a);
        float Y = a - (float)X;
        rgba[3] = 1.0f;
        switch (X) {
            case 0: {
                rgba[0] = 1.0f;
                rgba[1] = Y;
                rgba[2] = 0.0f;
                break;
            }
            case 1: {
                rgba[0] = 1.0f - Y;
                rgba[1] = 1.0f;
                rgba[2] = 0.0f;
                break;
            }
            case 2: {
                rgba[0] = 0.0f;
                rgba[1] = 1.0f;
                rgba[2] = Y;
                break;
            }
            case 3: {
                rgba[0] = 0.0f;
                rgba[1] = 1.0f - Y;
                rgba[2] = 1.0f;
                break;
            }
            case 4: {
                rgba[0] = 0.0f;
                rgba[1] = 0.0f;
                rgba[2] = 1.0f;
            }
        }
    }

    public static void colormap_long_rainbow(float value, float[] rgba) {
        if (rgba == null) {
            return;
        }
        float a = (1.0f - value) / 0.2f;
        int X = (int)FastMath.floor((float)a);
        float Y = a - (float)X;
        rgba[3] = 1.0f;
        switch (X) {
            case 0: {
                rgba[0] = 1.0f;
                rgba[1] = Y;
                rgba[2] = 0.0f;
                break;
            }
            case 1: {
                rgba[0] = 1.0f - Y;
                rgba[1] = 1.0f;
                rgba[2] = 0.0f;
                break;
            }
            case 2: {
                rgba[0] = 0.0f;
                rgba[1] = 1.0f;
                rgba[2] = Y;
                break;
            }
            case 3: {
                rgba[0] = 0.0f;
                rgba[1] = 1.0f - Y;
                rgba[2] = 1.0f;
                break;
            }
            case 4: {
                rgba[0] = Y;
                rgba[1] = 0.0f;
                rgba[2] = 1.0f;
                break;
            }
            case 5: {
                rgba[0] = 1.0f;
                rgba[1] = 0.0f;
                rgba[2] = 1.0f;
            }
        }
    }

    public static void colormap_yellow_to_red(float value, float[] rgba) {
        rgba[0] = 1.0f;
        rgba[1] = value;
        rgba[2] = 0.0f;
    }

    public static void colormap_blue_to_magenta(float value, float[] rgba) {
        rgba[0] = value;
        rgba[1] = 0.0f;
        rgba[2] = 1.0f;
    }

    private static void initHarreData() {
        if (teffToRGB_harre == null) {
            teffToRGB_harre = new float[105][];
            FileHandle fh = Gdx.files.internal("data/teff-rgb.csv.gz");
            try (GZIPInputStream gzipStream = new GZIPInputStream(fh.read());
                 BufferedReader reader = new BufferedReader(new InputStreamReader(gzipStream));){
                reader.readLine();
                int i = 0;
                while (reader.ready()) {
                    String[] tokens = reader.readLine().split(",");
                    float[] data = new float[]{Parser.parseFloat(tokens[0]), Parser.parseFloat(tokens[1]), Parser.parseFloat(tokens[2]), Parser.parseFloat(tokens[3])};
                    ColorUtils.teffToRGB_harre[i] = data;
                    ++i;
                }
            }
            catch (Exception e) {
                Logger.getLogger("ColorUtils").error("Error parsing teff-rgb.csv file");
                Logger.getLogger("ColorUtils").error(e);
            }
        }
    }

    public static float[] tEffToRGB_harre(double tEff) {
        ColorUtils.initHarreData();
        float[] rgb = new float[3];
        int idx = 0;
        int i = 1;
        while (i < teffToRGB_harre.length) {
            float tEff0 = teffToRGB_harre[i - 1][0];
            float tEff1 = teffToRGB_harre[i][0];
            if (tEff < (double)tEff0) break;
            if (tEff >= (double)tEff0 && tEff < (double)tEff1) {
                if (tEff - (double)tEff0 < (double)tEff1 - tEff) {
                    idx = i - 1;
                    break;
                }
                idx = i;
                break;
            }
            idx = i++;
        }
        rgb[0] = teffToRGB_harre[idx][1];
        rgb[1] = teffToRGB_harre[idx][2];
        rgb[2] = teffToRGB_harre[idx][3];
        return rgb;
    }

    public static float[] tEffToRGB_rough(double tEff) {
        double b;
        double g;
        double x;
        double r;
        double temp = tEff / 100.0;
        if (temp <= 66.0) {
            r = 255.0;
        } else {
            x = temp - 55.0;
            r = 351.97690566805693 + 0.114206453784165 * x - 40.25366309332127 * FastMath.log((double)x);
            r = MathUtilsDouble.clamp(r, 0.0, 255.0);
        }
        if (temp <= 66.0) {
            x = temp - 2.0;
            g = -155.25485562709179 - 0.44596950469579133 * x + 104.49216199393888 * FastMath.log((double)x);
        } else {
            x = temp - 50.0;
            g = 325.4494125711974 + 0.07943456536662342 * x - 28.0852963507957 * FastMath.log((double)x);
        }
        g = MathUtilsDouble.clamp(g, 0.0, 255.0);
        if (temp >= 66.0) {
            b = 255.0;
        } else if (temp <= 19.0) {
            b = 0.0;
        } else {
            x = temp - 10.0;
            b = -254.76935184120902 + 0.8274096064007395 * x + 115.67994401066147 * FastMath.log((double)x);
            b = MathUtilsDouble.clamp(b, 0.0, 255.0);
        }
        return new float[]{(float)(r / 255.0), (float)(g / 255.0), (float)(b / 255.0)};
    }

    public static float[] BVtoRGB(double bv) {
        double t = 4600.0 * (1.0 / (0.92 * bv + 1.7) + 1.0 / (0.92 * bv + 0.62));
        double x = 0.0;
        double y = 0.0;
        if (t >= 1667.0 && t <= 4000.0) {
            x = -0.2661239 * FastMath.pow((double)10.0, (double)9.0) / FastMath.pow((double)t, (double)3.0) + -0.234358 * FastMath.pow((double)10.0, (double)6.0) / FastMath.pow((double)t, (double)2.0) + 0.8776956 * FastMath.pow((double)10.0, (double)3.0) / t + 0.17991;
        } else if (t > 4000.0 && t <= 25000.0) {
            x = -3.0258469 * FastMath.pow((double)10.0, (double)9.0) / FastMath.pow((double)t, (double)3.0) + 2.1070379 * FastMath.pow((double)10.0, (double)6.0) / FastMath.pow((double)t, (double)2.0) + 0.2226347 * FastMath.pow((double)10.0, (double)3.0) / t + 0.24039;
        }
        if (t >= 1667.0 && t <= 2222.0) {
            y = -1.1063814 * FastMath.pow((double)x, (double)3.0) - 1.3481102 * FastMath.pow((double)x, (double)2.0) + 2.18555832 * x - 0.20219683;
        } else if (t > 2222.0 && t <= 4000.0) {
            y = -0.9549476 * FastMath.pow((double)x, (double)3.0) - 1.37418593 * FastMath.pow((double)x, (double)2.0) + 2.09137015 * x - 0.16748867;
        } else if (t > 4000.0 && t <= 25000.0) {
            y = 3.081758 * FastMath.pow((double)x, (double)3.0) - 5.8733867 * FastMath.pow((double)x, (double)2.0) + 3.75112997 * x - 0.37001483;
        }
        double Y = y == 0.0 ? 0.0 : 1.0;
        double X = y == 0.0 ? 0.0 : x * Y / y;
        double Z = y == 0.0 ? 0.0 : (1.0 - x - y) * Y / y;
        float[] cc = new float[4];
        cc[0] = ColorUtils.correctGamma(3.2406 * X - 1.5372 * Y - 0.4986 * Z);
        cc[1] = ColorUtils.correctGamma(-0.9689 * X + 1.8758 * Y + 0.0415 * Z);
        cc[2] = ColorUtils.correctGamma(0.0557 * X - 0.204 * Y + 1.057 * Z);
        float max = FastMath.max((float)1.0f, (float)FastMath.max((float)cc[2], (float)FastMath.max((float)cc[0], (float)cc[1])));
        cc[0] = FastMath.max((float)(cc[0] / max), (float)0.0f);
        cc[1] = FastMath.max((float)(cc[1] / max), (float)0.0f);
        cc[2] = FastMath.max((float)(cc[2] / max), (float)0.0f);
        return cc;
    }

    private static float correctGamma(double clinear) {
        float result;
        if (clinear <= 0.0031308) {
            result = 12.92f * (float)clinear;
        } else {
            float a = 0.5f;
            result = (float)((double)(1.0f + a) * FastMath.pow((double)clinear, (double)0.4166666567325592) - (double)a);
        }
        return result;
    }

    public static float[] brighten(float[] rgb, float luminosity) {
        float[] hsl = ColorUtils.rgbToHsl(rgb);
        hsl[2] = luminosity;
        return ColorUtils.hslToRgb(hsl);
    }

    public static float[] rgbToHsl(float[] rgb) {
        float s;
        float avg;
        float r = rgb[0];
        float g = rgb[1];
        float b = rgb[2];
        float max = FastMath.max((float)r, (float)FastMath.max((float)g, (float)b));
        float min = FastMath.min((float)r, (float)FastMath.min((float)g, (float)b));
        float h = avg = (max + min) / 2.0f;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            float d = max - min;
            float f = s = (double)avg > 0.5 ? d / (2.0f - max - min) : d / (max + min);
            if (max == r) {
                h = (g - b) / d + (float)(g < b ? 6 : 0);
            } else if (max == g) {
                h = (b - r) / d + 2.0f;
            } else if (max == b) {
                h = (r - g) / d + 4.0f;
            }
            h /= 6.0f;
        }
        return new float[]{h, s, avg};
    }

    public static float[] hslToRgb(float[] hsl) {
        float r;
        float g;
        float b;
        float h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = (double)l < 0.5 ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = ColorUtils.hue2rgb(p, q, h + 0.0f);
            g = ColorUtils.hue2rgb(p, q, h);
            b = ColorUtils.hue2rgb(p, q, h - 0.0f);
        }
        return new float[]{r, g, b};
    }

    private static float hue2rgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.0f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.0f - t) * 6.0f;
        }
        return p;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - FastMath.floor((float)hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBlue(int rgb) {
        return rgb & 0xFF;
    }

    public static boolean isZero(com.badlogic.gdx.graphics.Color c) {
        return c.r == 0.0f && c.g == 0.0f && c.b == 0.0f;
    }
}

