/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.color;

import gaiasky.util.math.MathUtilsDouble;

public class Colormap {
    private double colormap_blues_red(double x) {
        if (x < 0.8724578971287745) {
            return ((((-2985.80898761749 * x + 6750.1484548971) * x - 4969.41610635258) * x + 1201.90439358912) * x - 294.374708396149) * x + 248.449410219242;
        }
        return 8.0;
    }

    private double colormap_blues_green(double x) {
        if (x < 0.3725897611307026) {
            return -130.453729372935 * x + 251.07306930693;
        }
        return (-49.7095598364922 * x - 177.638812495581) * x + 275.554584848896;
    }

    private double colormap_blues_blue(double x) {
        if (x < 0.8782350698420436) {
            return (((-166.242968759033 * x + 250.86576602701) * x - 182.046165445353) * x - 32.9698266187334) * x + 253.927912915449;
        }
        return -385.153281423831 * x + 493.849833147981;
    }

    public double[] colormap_blues(double x) {
        double r = MathUtilsDouble.clamp(this.colormap_blues_red(x) / 255.0, 0.0, 1.0);
        double g = MathUtilsDouble.clamp(this.colormap_blues_green(x) / 255.0, 0.0, 1.0);
        double b = MathUtilsDouble.clamp(this.colormap_blues_blue(x) / 255.0, 0.0, 1.0);
        return new double[]{r, g, b};
    }

    private double colormap_greens_red(double x) {
        if (x < 0.6193682068820651) {
            return ((141.021531432983 * x - 378.122271460656) * x - 108.40369215417) * x + 245.743977533647;
        }
        return ((-863.146749682724 * x + 1761.95389457266) * x - 1438.07716183136) * x + 486.922446232568;
    }

    private double colormap_greens_green(double x) {
        return (-137.01346057616 * x - 45.4698187198101) * x + 252.098684286706;
    }

    private double colormap_greens_blue(double x) {
        if (x < 0.5062477983469252) {
            return ((395.06722693704 * x - 452.381961582927) * x - 125.304923569201) * x + 243.770002412197;
        }
        return ((298.249378459208 * x - 614.859580726999) * x + 222.299590241459) * x + 121.998454489668;
    }

    public double[] colormap_greens(double x) {
        double r = MathUtilsDouble.clamp(this.colormap_greens_red(x) / 255.0, 0.0, 1.0);
        double g = MathUtilsDouble.clamp(this.colormap_greens_green(x) / 255.0, 0.0, 1.0);
        double b = MathUtilsDouble.clamp(this.colormap_greens_blue(x) / 255.0, 0.0, 1.0);
        return new double[]{r, g, b};
    }

    private double colormap_reds_red(double x) {
        if (x < 0.7109796106815338) {
            return (((-958.108609441667 * x + 889.060620527714) * x - 242.747192807495) * x + 9.97906310565304) * x + 254.6412522194;
        }
        return ((-993.985373158007 * x + 1965.24174972026) * x - 1540.68189744713) * x + 672.947219603874;
    }

    private double colormap_reds_green(double x) {
        if (x < 0.7679868638515472) {
            return ((((2664.33610509335 * x - 5054.88641558587) * x + 3695.42277742922) * x - 1369.31912848446) * x - 51.2669839132577) * x + 241.92941719275;
        }
        return (-211.738816337853 * x + 278.333107855597) * x - 66.6958752910143;
    }

    private double colormap_reds_blue(double x) {
        return (((-683.475279000297 * x + 1552.50107598171) * x - 925.799053039285) * x - 167.380812671938) * x + 237.145226675143;
    }

    public double[] colormap_reds(double x) {
        double r = MathUtilsDouble.clamp(this.colormap_reds_red(x) / 255.0, 0.0, 1.0);
        double g = MathUtilsDouble.clamp(this.colormap_reds_green(x) / 255.0, 0.0, 1.0);
        double b = MathUtilsDouble.clamp(this.colormap_reds_blue(x) / 255.0, 0.0, 1.0);
        return new double[]{r, g, b};
    }

    public double[] colormap_rainbow18(double x) {
        double x16 = x * 16.0;
        double s = 0.00392156862745098;
        double[] f = x16 < 1.0 ? new double[]{150.0, 0.0, 150.0} : (x16 < 2.0 ? new double[]{200.0, 0.0, 200.0} : (x16 < 3.0 ? new double[]{100.0, 100.0, 150.0} : (x16 < 4.0 ? new double[]{100.0, 100.0, 200.0} : (x16 < 5.0 ? new double[]{100.0, 100.0, 255.0} : (x16 < 6.0 ? new double[]{0.0, 140.0, 0.0} : (x16 < 7.0 ? new double[]{150.0, 170.0, 0.0} : (x16 < 8.0 ? new double[]{200.0, 200.0, 0.0} : (x16 < 9.0 ? new double[]{150.0, 200.0, 0.0} : (x16 < 10.0 ? new double[]{200.0, 255.0, 120.0} : (x16 < 11.0 ? new double[]{255.0, 255.0, 0.0} : (x16 < 12.0 ? new double[]{255.0, 200.0, 0.0} : (x16 < 13.0 ? new double[]{255.0, 160.0, 0.0} : (x16 < 14.0 ? new double[]{255.0, 125.0, 0.0} : (x16 < 15.0 ? new double[]{200.0, 50.0, 100.0} : new double[]{175.0, 50.0, 75.0}))))))))))))));
        f[0] = f[0] * s;
        f[1] = f[1] * s;
        f[2] = f[2] * s;
        return f;
    }

    private double colormap_cool_red(double x) {
        return 1.0158730158730158 * x - 0.015873015873015872;
    }

    private double colormap_cool_green(double x) {
        return -1.0158730158730158 * x + 1.0158730158730158;
    }

    public double[] colormap_cool(double x) {
        double r = MathUtilsDouble.clamp(this.colormap_cool_red(x), 0.0, 1.0);
        double g = MathUtilsDouble.clamp(this.colormap_cool_green(x), 0.0, 1.0);
        double b = 1.0;
        return new double[]{r, g, b};
    }

    private double colormap_seismic_f(double x) {
        return ((-2010.0 * x + 2502.5950459) * x - 481.763180924) / 255.0;
    }

    private double colormap_seismic_red(double x) {
        if (x < 0.0) {
            return 0.011764705882352941;
        }
        if (x < 0.238) {
            return ((-1810.0 * x + 414.49) * x + 3.87702) / 255.0;
        }
        if (x < 0.4776142883583194) {
            return (1064.2103263002111 * x - 253.28205765945023) / 255.0;
        }
        if (x < 0.7514388698331492) {
            return 1.0;
        }
        if (x <= 1.0) {
            return (-688.04 * x + 772.02) / 255.0;
        }
        return 0.3254901960784314;
    }

    private double colormap_seismic_green(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (x < 0.238) {
            return 0.0;
        }
        if (x < 0.4776142883583194) {
            return this.colormap_seismic_f(x);
        }
        if (x < 0.739376978894039) {
            double xx = x - 0.4776142883583194;
            return ((-914.74 * xx - 734.72) * xx + 255.0) / 255.0;
        }
        return 0.0;
    }

    private double colormap_seismic_blue(double x) {
        if (x < 0.0) {
            return 0.07450980392156863;
        }
        if (x < 0.238) {
            double xx = x - 0.238;
            return (((1624.6 * xx + 1191.4) * xx + 1180.2) * xx + 255.0) / 255.0;
        }
        if (x < 0.4776142883583194) {
            return 1.0;
        }
        if (x < 0.681640625) {
            return (-951.67322673866 * x + 709.532730938451) / 255.0;
        }
        if (x < 0.745745353439206) {
            return (-705.250074130877 * x + 559.620050530617) / 255.0;
        }
        if (x <= 1.0) {
            return ((-399.29 * x + 655.71) * x - 233.25) / 255.0;
        }
        return 0.09019607843137255;
    }

    public double[] colormap_seismic(double x) {
        return new double[]{this.colormap_seismic_red(x), this.colormap_seismic_green(x), this.colormap_seismic_blue(x)};
    }

    private double colormap_carnation_f(double x) {
        return ((-9.93427 * x + 15.6301) * x + 244.663 * x) / 255.0;
    }

    private double colormap_carnation_blue(double x) {
        if (x < 0.0) {
            return 0.043137254901960784;
        }
        if (x < 0.16531216481302) {
            return ((-1635.0 * x + 1789.0) * x + 3.938) / 255.0;
        }
        if (x < 0.50663669203696) {
            return 1.0;
        }
        if (x < 0.67502056695956) {
            return (((1289.32 * x - 774.147) * x - 947.634) * x + 765.071) / 255.0;
        }
        if (x < 1.0) {
            return this.colormap_carnation_f(x);
        }
        return 0.984313725490196;
    }

    private double colormap_carnation_green(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (x < 0.33807590140751) {
            return this.colormap_carnation_f(x);
        }
        if (x < 0.50663669203696) {
            return (((-583.014 * x - 838.523) * x + 2038.23) * x - 486.592) / 255.0;
        }
        if (x < 0.84702285244773) {
            return 1.0;
        }
        if (x < 1.0) {
            return (((-503.306 * x + 2955.45) * x - 4192.1) * x + 1991.28) / 255.0;
        }
        return 0.984313725490196;
    }

    private double colormap_carnation_red(double x) {
        if (x < 0.16531216481302) {
            return 1.0;
        }
        if (x < 0.33807590140751) {
            return (((-5151.64 * x + 5305.64) * x - 2650.98) * x + 570.771) / 255.0;
        }
        if (x < 0.67502056695956) {
            return this.colormap_carnation_f(x);
        }
        if (x < 0.84702285244773) {
            return (((3341.36 * x - 9019.76) * x + 8397.4) * x - 2416.82) / 255.0;
        }
        return 1.0;
    }

    public double[] colormap_carnation(double x) {
        return new double[]{this.colormap_carnation_red(x), this.colormap_carnation_green(x), this.colormap_carnation_blue(x)};
    }

    private double colormap_hotmetal_green(double x) {
        if (x < 0.6) {
            return 0.0;
        }
        if (x <= 0.95) {
            return (x - 0.6) * 728.57 / 255.0;
        }
        return 1.0;
    }

    private double colormap_hotmetal_red(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (x <= 0.57147) {
            return 446.22 * x / 255.0;
        }
        return 1.0;
    }

    public double[] colormap_hotmetal(double x) {
        return new double[]{this.colormap_hotmetal_red(x), this.colormap_hotmetal_green(x), 0.0};
    }

    public double[] colormap_rainbow(double x) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        r = x < 0.0 ? 0.4980392156862745 : (x <= 0.1111111111111111 ? 1147.5 * (0.1111111111111111 - x) / 255.0 : (x <= 0.5555555555555556 ? 0.0 : (x <= 0.7777777777777778 ? 1147.5 * (x - 0.5555555555555556) / 255.0 : 1.0)));
        g = x <= 0.1111111111111111 ? 0.0 : (x <= 0.3333333333333333 ? 1147.5 * (x - 0.1111111111111111) / 255.0 : (x <= 0.7777777777777778 ? 1.0 : (x <= 1.0 ? 1.0 - 1147.5 * (x - 0.7777777777777778) / 255.0 : 0.0)));
        b = x <= 0.3333333333333333 ? 1.0 : (x <= 0.5555555555555556 ? 1.0 - 1147.5 * (x - 0.3333333333333333) / 255.0 : 0.0);
        if (x == 0.0) {
            return new double[]{0.0, 0.0, 0.0};
        }
        return new double[]{r, g, b};
    }

    public double[] colormap(int cmap, double value) {
        if ((cmap %= 9) == 0) {
            return this.colormap_reds(value);
        }
        if (cmap == 1) {
            return this.colormap_greens(value);
        }
        if (cmap == 2) {
            return this.colormap_blues(value);
        }
        if (cmap == 3) {
            return this.colormap_rainbow18(value);
        }
        if (cmap == 4) {
            return this.colormap_rainbow(value);
        }
        if (cmap == 5) {
            return this.colormap_seismic(value);
        }
        if (cmap == 6) {
            return this.colormap_carnation(value);
        }
        if (cmap == 7) {
            return this.colormap_hotmetal(value);
        }
        if (cmap == 8) {
            return this.colormap_cool(value);
        }
        return new double[]{0.0, 0.0, 0.0};
    }

    public double[] colormap(int cmap, double value, double min, double max) {
        double x;
        if (max < min) {
            x = (value - max) / (min - max);
            x = 1.0 - x;
        } else {
            x = (value - min) / (max - min);
        }
        return this.colormap(cmap, MathUtilsDouble.clamp(x, 0.0, 1.0));
    }
}

