/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.comp;

import java.math.BigInteger;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.regex.Pattern;
import net.jafama.FastMath;

public final class FilenameComparator
implements Comparator<Path> {
    private static final Pattern NUMBERS = Pattern.compile("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");

    @Override
    public final int compare(Path p1, Path p2) {
        if (p1 == null || p2 == null) {
            return p1 == null ? (p2 == null ? 0 : -1) : 1;
        }
        String o1 = p1.getFileName().toString();
        String o2 = p2.getFileName().toString();
        String[] split1 = NUMBERS.split(o1);
        String[] split2 = NUMBERS.split(o2);
        for (int i = 0; i < FastMath.min((int)split1.length, (int)split2.length); ++i) {
            char c1 = split1[i].charAt(0);
            char c2 = split2[i].charAt(0);
            int cmp = 0;
            if (c1 >= '0' && c1 <= '9' && c2 >= '0' && c2 <= '9') {
                cmp = new BigInteger(split1[i]).compareTo(new BigInteger(split2[i]));
            }
            if (cmp == 0) {
                cmp = split1[i].compareTo(split2[i]);
            }
            if (cmp == 0) continue;
            return cmp;
        }
        return split1.length - split2.length;
    }
}

