/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;

public class ServiceThread
extends Thread {
    protected final Object threadLock = new Object();
    protected final AtomicBoolean awake;
    protected final AtomicBoolean running = new AtomicBoolean(true);
    protected Runnable task;

    public ServiceThread() {
        this("service-thread");
    }

    public ServiceThread(String name) {
        this.awake = new AtomicBoolean(false);
        this.setName(name);
    }

    public Object getThreadLock() {
        return this.threadLock;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDaemon(boolean notifyAll) {
        this.running.set(false);
        if (notifyAll) {
            Object object = this.threadLock;
            synchronized (object) {
                this.threadLock.notifyAll();
            }
        }
    }

    public boolean isAwake() {
        return this.awake.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerTask(Runnable task) {
        this.waitCurrentTask();
        Object object = this.threadLock;
        synchronized (object) {
            this.task = task;
            this.threadLock.notify();
            this.awake.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        this.waitCurrentTask();
        Object object = this.threadLock;
        synchronized (object) {
            this.threadLock.notify();
            this.awake.set(true);
        }
    }

    public void waitCurrentTask() {
        while (this.awake.get()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running.get()) {
            Object object = this.threadLock;
            synchronized (object) {
                if (this.task != null) {
                    this.task.run();
                }
                try {
                    this.awake.set(false);
                    this.threadLock.wait(0x7FFFFFFFFFFFFFF7L);
                }
                catch (InterruptedException e) {
                    this.awake.set(true);
                }
            }
        }
    }
}

