/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord;

import com.badlogic.ashley.core.Entity;
import gaiasky.data.util.PointCloudData;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.component.Verts;
import gaiasky.scene.entity.EntityUtils;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.coord.IBodyCoordinates;
import gaiasky.util.math.Vector3D;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractOrbitCoordinates
implements IBodyCoordinates {
    protected static final Logger.Log logger = Logger.getLogger(AbstractOrbitCoordinates.class);
    protected static final List<AbstractOrbitCoordinates> instances = new ArrayList<AbstractOrbitCoordinates>();
    protected String orbitName;
    protected boolean periodic = true;
    protected Vector3D center;
    protected Entity entity;
    protected Entity owner;
    protected double scaling = 1.0;

    protected AbstractOrbitCoordinates() {
        instances.add(this);
    }

    public static List<AbstractOrbitCoordinates> getInstances() {
        return instances;
    }

    public static <T extends AbstractOrbitCoordinates> T getInstance(Class<T> clazz) {
        for (AbstractOrbitCoordinates o : instances) {
            if (!clazz.isInstance(o)) continue;
            return (T)o;
        }
        AbstractOrbitCoordinates obj = null;
        try {
            obj = (AbstractOrbitCoordinates)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error(e);
        }
        return (T)obj;
    }

    @Override
    public void doneLoading(Object ... params) {
        if (params.length == 0) {
            logger.error(new RuntimeException("No parameters found, can't initialize coordinates from orbit: " + this.orbitName));
        } else if (this.orbitName != null && !this.orbitName.isEmpty()) {
            Object object;
            if (params[0] instanceof Scene) {
                this.entity = ((Scene)params[0]).index().getEntity(this.orbitName);
            }
            if ((object = params[1]) instanceof Entity) {
                Entity bodyObject;
                this.owner = bodyObject = (Entity)object;
                Trajectory trajectory = (Trajectory)Mapper.trajectory.get(this.entity);
                trajectory.setBody(this.owner, EntityUtils.getRadius(this.owner), trajectory.distDown, trajectory.distUp);
            }
        }
    }

    public String getOrbitName() {
        return this.orbitName;
    }

    public void setOrbitName(String orbitName) {
        this.orbitName = orbitName;
    }

    public void setOrbitname(String orbitName) {
        this.setOrbitName(orbitName);
    }

    public void setPeriodic(Boolean periodic) {
        this.periodic = periodic;
    }

    public void setScaling(double scaling) {
        this.scaling = scaling;
    }

    public String toString() {
        return "{name='" + this.orbitName + "', orbit=" + String.valueOf(this.entity) + ", scaling=" + this.scaling + "}";
    }

    public void setCentre(double[] center) {
        this.setCenter(center);
    }

    public void setCenter(double[] center) {
        this.setCenterkm(center);
    }

    public void setCenterkm(double[] center) {
        this.center = new Vector3D(center[0] * Constants.KM_TO_U, center[1] * Constants.KM_TO_U, center[2] * Constants.KM_TO_U);
    }

    public void setCenterpc(double[] center) {
        this.center = new Vector3D(center[0] * Constants.PC_TO_U, center[1] * Constants.PC_TO_U, center[2] * Constants.PC_TO_U);
    }

    protected PointCloudData getData() {
        if (this.entity != null) {
            return ((Verts)Mapper.verts.get((Entity)this.entity)).pointCloudData;
        }
        return null;
    }

    protected void updateOwner(Map<String, Entity> index) {
        Entity newOwner;
        Base base;
        if (this.owner != null && (base = (Base)Mapper.base.get(this.owner)) != null && (newOwner = index.get(base.getName().toLowerCase(Locale.ROOT))) != null) {
            this.owner = newOwner;
        }
    }

    protected void copyParameters(AbstractOrbitCoordinates other) {
        other.orbitName = this.orbitName;
        other.center = this.center;
        other.periodic = this.periodic;
        other.owner = this.owner;
        other.entity = this.entity;
        other.scaling = this.scaling;
    }

    @Override
    public void updateReferences(Map<String, Entity> index) {
    }

    @Override
    public IBodyCoordinates getCopy() {
        return this;
    }
}

