/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord;

import com.badlogic.gdx.utils.Array;
import gaiasky.util.Constants;
import gaiasky.util.LruCacheLong;
import gaiasky.util.Pair;
import gaiasky.util.coord.NslSun;
import gaiasky.util.math.Vector3Q;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import net.jafama.FastMath;

public class AstroUtils {
    public static final double JD_TO_Y = 365.25;
    public static final double JD_J2000 = AstroUtils.getJulianDate(2000.0);
    public static final double JD_J2010 = AstroUtils.getJulianDate(2010.0);
    public static final double JD_J2015 = AstroUtils.getJulianDate(2015.0);
    public static final double JD_J2015_5 = AstroUtils.getJulianDate(2015.5);
    public static final long J2000_MS;
    private static final LruCacheLong<Double> julianDateCache;
    private static final NslSun nslSun;
    private static Instant cacheSunLongitudeDate;
    private static double cacheSunLongitude;
    private static final Instant gregorianSwitch;
    private static final double GREGORIAN_EPOCH = 1721425.5;
    private static Array<Pair<Float, String>> spectralTypes;

    public static double getJulianDate(double refEpoch) {
        int year = (int)refEpoch;
        double part = refEpoch - (double)year;
        return AstroUtils.getJulianDateUTC(year, 1, 1, 0, 0, 0, 0, true) + 365.25 * part;
    }

    public static double getSunLongitude(Instant date) {
        if (!date.equals(cacheSunLongitudeDate)) {
            double julianDate = AstroUtils.getJulianDateCache(date);
            nslSun.setTime(julianDate);
            double aux = FastMath.toDegrees((double)nslSun.getSolarLongitude()) % 360.0;
            cacheSunLongitudeDate = Instant.ofEpochMilli(date.toEpochMilli());
            cacheSunLongitude = aux % 360.0;
        }
        return cacheSunLongitude;
    }

    public static double getJulianDateUTC(int year, int month, int day, int hour, int min, int sec, int nanos) {
        ZonedDateTime zdt = ZonedDateTime.of(year, month, day, hour, min, sec, nanos, ZoneOffset.UTC);
        Instant instant = zdt.toInstant();
        return AstroUtils.getJulianDateUTC(year, month, day, hour, min, sec, nanos, instant.isAfter(gregorianSwitch));
    }

    private static double getJulianDateUTC(int year, int month, int day, int hour, int min, int sec, int nanos, boolean gregorian) {
        if (gregorian) {
            return AstroUtils.getJulianDayNumberGregorian(year, month, day) + AstroUtils.getDayFraction(hour, min, sec, nanos);
        }
        return AstroUtils.getJulianDayNumberJulianCalendar(year, month, day) + AstroUtils.getDayFraction(hour, min, sec, nanos);
    }

    public static synchronized double getJulianDateCache(Instant instant) {
        long time = instant.toEpochMilli();
        if (julianDateCache.containsKey(time)) {
            return julianDateCache.get(time);
        }
        double jd = AstroUtils.getJulianDate(instant);
        julianDateCache.put(time, jd);
        return jd;
    }

    public static double getJulianDate(Instant instant) {
        LocalDateTime date = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        int year = date.getYear();
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        int hour = date.getHour();
        int min = date.getMinute();
        int sec = date.getSecond();
        int nanos = date.getNano();
        return AstroUtils.getJulianDateUTC(year, month, day, hour, min, sec, nanos, instant.isAfter(gregorianSwitch));
    }

    public static double getDaysSinceJ2000(Instant date) {
        return AstroUtils.getJulianDateCache(date) - JD_J2000;
    }

    public static double getMsSince(Instant date, double epoch_jd) {
        return (AstroUtils.getJulianDateCache(date) - epoch_jd) * 8.64E7;
    }

    public static double getDaysSince(Instant date, double epoch_jd) {
        return AstroUtils.getJulianDateCache(date) - epoch_jd;
    }

    public static long[] getCalendarDay(double julianDate) {
        double C;
        double D;
        double X = julianDate + 0.5;
        double Z = FastMath.floor((double)X);
        double F = X - Z;
        double Y = FastMath.floor((double)((Z - 1867216.25) / 36524.25));
        double A = Z + 1.0 + Y - FastMath.floor((double)(Y / 4.0));
        double B = A + 1524.0;
        double G = FastMath.floor((double)((B - (D = FastMath.floor((double)(365.25 * (C = FastMath.floor((double)((B - 122.1) / 365.25))))))) / 30.6001));
        double month = G < 13.5 ? G - 1.0 : G - 13.0;
        double year = month < 2.5 ? C - 4715.0 : C - 4716.0;
        double UT = B - D - FastMath.floor((double)(30.6001 * G)) + F;
        double day = FastMath.floor((double)UT);
        UT -= FastMath.floor((double)UT);
        double hour = FastMath.floor((double)(UT *= 24.0));
        UT -= FastMath.floor((double)UT);
        double minute = FastMath.floor((double)(UT *= 60.0));
        UT -= FastMath.floor((double)UT);
        double second = FastMath.floor((double)(UT *= 60.0));
        UT -= FastMath.floor((double)UT);
        long ms = FastMath.round((double)(UT *= 1.0E9));
        return new long[]{(long)year, (long)month, (long)day, (long)hour, (long)minute, (long)second, ms};
    }

    @Deprecated
    public static double getJulianDayNumberBook(int year, int month, int day) {
        int a = year / 100;
        int b = 2 - a + a / 4;
        return (double)((long)(365.242 * (double)(year + 4716)) + (long)(30.6001 * (double)month) + (long)day + (long)b) - 1524.5;
    }

    public static double getJulianDayNumberJulianCalendar(int year, int month, int day) {
        if (month <= 2) {
            --year;
            month += 12;
        }
        int A = (int)(365.25 * (double)(year + 4716));
        int B = (int)(30.6001 * (double)(month + 1));
        double JD = (double)(A + B + day) - 1524.5;
        return JD;
    }

    public static boolean isLeapYearGregorian(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static double getJulianDayNumberGregorian(int year, int month, int day) {
        return 1721424.5 + (double)(365 * (year - 1)) + (double)((year - 1) / 4) + -((double)((year - 1) / 100)) + (double)((year - 1) / 400) + (double)((367 * month - 362) / 12 + (month <= 2 ? 0 : (AstroUtils.isLeapYearGregorian(year) ? -1 : -2)) + day);
    }

    public static Instant julianDateToInstant(double jd) {
        long[] cd = AstroUtils.getCalendarDay(jd);
        LocalDateTime ldt = LocalDateTime.of((int)cd[0], (int)cd[1], (int)cd[2], (int)cd[3], (int)cd[4], (int)cd[5], (int)cd[6]);
        return ldt.toInstant(ZoneOffset.UTC);
    }

    private static double getDayFraction(int hour, int min, int sec, int nanos) {
        return (double)hour / 24.0 + (double)min / 1440.0 + ((double)sec + (double)nanos / 1.0E9) / 86400.0;
    }

    @Deprecated
    public static long[] getDayQuantities(double dayFraction) {
        double hourFrac = dayFraction * 24.0;
        double minFrac = (hourFrac - (double)((long)hourFrac)) * 60.0;
        double secFrac = (minFrac - (double)((long)minFrac)) * 60.0;
        double nanosFrac = (secFrac - (double)((long)secFrac)) * 1.0E9;
        return new long[]{(long)hourFrac, (long)minFrac, (long)secFrac, (long)nanosFrac};
    }

    public static double obliquity(double julianDate) {
        double T = AstroUtils.T(julianDate);
        return 23.433333333333334 + (21.406 - (46.836769 - (1.831E-4 + (0.0020034 - (5.76E-7 - 4.34E-8 * T) * T) * T) * T) * T) / 3600.0;
    }

    public static double T(double julianDate) {
        return (julianDate - 2451545.0) / 36525.0;
    }

    public static double tau(double julianDate) {
        return (julianDate - 2451545.0) / 365250.0;
    }

    public static double apparentToAbsoluteMagnitude(double distPc, double appMag) {
        double v = 5.0 * FastMath.log10((double)(distPc <= 0.0 ? 10.0 : distPc));
        return appMag - v + 5.0;
    }

    public static double absoluteToApparentMagnitude(double distPc, double absMag) {
        double v = 5.0 * FastMath.log10((double)(distPc <= 0.0 ? 10.0 : distPc));
        return absMag + v - 5.0;
    }

    public static double absoluteMagnitudeToPseudoSize(double absMag) {
        double pseudoL = FastMath.pow((double)10.0, (double)(-0.4 * absMag));
        double sizeFactor = 3.08567758149137E16 * Constants.ORIGINAL_M_TO_U * 0.15;
        return FastMath.min((double)(Math.pow(pseudoL, 0.5) * sizeFactor), (double)1.0E10) * Constants.DISTANCE_SCALE_FACTOR;
    }

    public static String getSpectralType(float tEff) {
        AstroUtils.initSpectralTypeTable();
        int n = AstroUtils.spectralTypes.size;
        for (int i = n - 1; i >= 0; --i) {
            Pair p = (Pair)spectralTypes.get(i);
            if (!(tEff <= ((Float)p.getFirst()).floatValue())) continue;
            return (String)p.getSecond();
        }
        return null;
    }

    private static void initSpectralTypeTable() {
        if (spectralTypes == null) {
            spectralTypes = new Array();
            AstroUtils.addToSpTable(54000.0f, "O5");
            AstroUtils.addToSpTable(45000.0f, "O6");
            AstroUtils.addToSpTable(43300.0f, "O7");
            AstroUtils.addToSpTable(40600.0f, "O8");
            AstroUtils.addToSpTable(37800.0f, "O9");
            AstroUtils.addToSpTable(29200.0f, "B0");
            AstroUtils.addToSpTable(23000.0f, "B1");
            AstroUtils.addToSpTable(21000.0f, "B2");
            AstroUtils.addToSpTable(17600.0f, "B3");
            AstroUtils.addToSpTable(15200.0f, "B5");
            AstroUtils.addToSpTable(14300.0f, "B6");
            AstroUtils.addToSpTable(13500.0f, "B7");
            AstroUtils.addToSpTable(12300.0f, "B8");
            AstroUtils.addToSpTable(11400.0f, "B9");
            AstroUtils.addToSpTable(9600.0f, "A0");
            AstroUtils.addToSpTable(9330.0f, "A1");
            AstroUtils.addToSpTable(9040.0f, "A2");
            AstroUtils.addToSpTable(8750.0f, "A3");
            AstroUtils.addToSpTable(8480.0f, "A4");
            AstroUtils.addToSpTable(8310.0f, "A5");
            AstroUtils.addToSpTable(7920.0f, "A7");
            AstroUtils.addToSpTable(7350.0f, "F0");
            AstroUtils.addToSpTable(7050.0f, "F2");
            AstroUtils.addToSpTable(6850.0f, "F3");
            AstroUtils.addToSpTable(6700.0f, "F5");
            AstroUtils.addToSpTable(6550.0f, "F6");
            AstroUtils.addToSpTable(6400.0f, "F7");
            AstroUtils.addToSpTable(6300.0f, "F8");
            AstroUtils.addToSpTable(6050.0f, "G0");
            AstroUtils.addToSpTable(5930.0f, "G1");
            AstroUtils.addToSpTable(5800.0f, "G2");
            AstroUtils.addToSpTable(5660.0f, "G5");
            AstroUtils.addToSpTable(5440.0f, "G8");
            AstroUtils.addToSpTable(5240.0f, "K0");
            AstroUtils.addToSpTable(5110.0f, "K1");
            AstroUtils.addToSpTable(4960.0f, "K2");
            AstroUtils.addToSpTable(4800.0f, "K3");
            AstroUtils.addToSpTable(4600.0f, "K4");
            AstroUtils.addToSpTable(4400.0f, "K5");
            AstroUtils.addToSpTable(4000.0f, "K7");
            AstroUtils.addToSpTable(3750.0f, "M0");
            AstroUtils.addToSpTable(3700.0f, "M1");
            AstroUtils.addToSpTable(3600.0f, "M2");
            AstroUtils.addToSpTable(3500.0f, "M3");
            AstroUtils.addToSpTable(3400.0f, "M4");
            AstroUtils.addToSpTable(3200.0f, "M5");
            AstroUtils.addToSpTable(3100.0f, "M6");
            AstroUtils.addToSpTable(2900.0f, "M7");
            AstroUtils.addToSpTable(2700.0f, "M8");
            AstroUtils.addToSpTable(2600.0f, "L0");
            AstroUtils.addToSpTable(2200.0f, "L3");
            AstroUtils.addToSpTable(1500.0f, "L8");
            AstroUtils.addToSpTable(1400.0f, "T2");
            AstroUtils.addToSpTable(1000.0f, "T6");
            AstroUtils.addToSpTable(800.0f, "T8");
        }
    }

    private static void addToSpTable(float tEff, String spType) {
        if (spectralTypes != null) {
            spectralTypes.add(new Pair<Float, String>(Float.valueOf(tEff), spType));
        }
    }

    public static void plutoEclipticCoordinates(Instant date, Vector3Q out) {
        if (Constants.notWithinVSOPTime(date.toEpochMilli())) {
            return;
        }
        AstroUtils.plutoEclipticCoordinates(AstroUtils.getDaysSinceJ2000(date), out);
    }

    private static void plutoEclipticCoordinates(double d, Vector3Q out) {
        double S = FastMath.toRadians((double)(50.03 + 0.033459652 * d));
        double P = FastMath.toRadians((double)(238.95 + 0.003968789 * d));
        double lonEcl = 238.9508 + 0.00400703 * d - 19.799 * FastMath.sin((double)P) + 19.848 * FastMath.cos((double)P) + 0.897 * FastMath.sin((double)(2.0 * P)) - 4.956 * FastMath.cos((double)(2.0 * P)) + 0.61 * FastMath.sin((double)(3.0 * P)) + 1.211 * FastMath.cos((double)(3.0 * P)) - 0.341 * FastMath.sin((double)(4.0 * P)) - 0.19 * FastMath.cos((double)(4.0 * P)) + 0.128 * FastMath.sin((double)(5.0 * P)) - 0.034 * FastMath.cos((double)(5.0 * P)) - 0.038 * FastMath.sin((double)(6.0 * P)) + 0.031 * FastMath.cos((double)(6.0 * P)) + 0.02 * FastMath.sin((double)(S - P)) - 0.01 * FastMath.cos((double)(S - P));
        double latEcl = -3.9082 - 5.453 * FastMath.sin((double)P) - 14.975 * FastMath.cos((double)P) + 3.527 * FastMath.sin((double)(2.0 * P)) + 1.673 * FastMath.cos((double)(2.0 * P)) - 1.051 * FastMath.sin((double)(3.0 * P)) + 0.328 * FastMath.cos((double)(3.0 * P)) + 0.179 * FastMath.sin((double)(4.0 * P)) - 0.292 * FastMath.cos((double)(4.0 * P)) + 0.019 * FastMath.sin((double)(5.0 * P)) + 0.1 * FastMath.cos((double)(5.0 * P)) - 0.031 * FastMath.sin((double)(6.0 * P)) - 0.026 * FastMath.cos((double)(6.0 * P)) + 0.011 * FastMath.cos((double)(S - P));
        double r = 40.72 + 6.68 * FastMath.sin((double)P) + 6.9 * FastMath.cos((double)P) - 1.18 * FastMath.sin((double)(2.0 * P)) - 0.03 * FastMath.cos((double)(2.0 * P)) + 0.15 * FastMath.sin((double)(3.0 * P)) - 0.14 * FastMath.cos((double)(3.0 * P));
        out.set(Math.toRadians(lonEcl), FastMath.toRadians((double)latEcl), 1.49597871E8 * r);
    }

    static {
        julianDateCache = new LruCacheLong(10);
        nslSun = new NslSun();
        cacheSunLongitudeDate = Instant.now();
        gregorianSwitch = Instant.parse("1582-10-15T00:00:00.000Z");
        Instant d = LocalDateTime.of(2000, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC);
        J2000_MS = d.toEpochMilli();
    }
}

