/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.tag.TagNoProcess;
import gaiasky.util.Logger;
import gaiasky.util.coord.IBodyCoordinates;
import gaiasky.util.coord.TimedOrbitCoordinates;
import gaiasky.util.math.Vector3Q;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Map;

public class ComposedTimedOrbitCoordinates
implements IBodyCoordinates {
    protected static final Logger.Log logger = Logger.getLogger(ComposedTimedOrbitCoordinates.class);
    public Array<TimedOrbitCoordinates> coordinates;
    public boolean processOnlyActive = true;
    private Scene scene;

    public void setProcessOnlyActive(Boolean b) {
        this.processOnlyActive = b;
    }

    public void setSequence(Object[] seq) {
        this.coordinates = new Array();
        for (Object obj : seq) {
            if (obj instanceof TimedOrbitCoordinates) {
                TimedOrbitCoordinates toc = (TimedOrbitCoordinates)obj;
                this.coordinates.add((Object)toc);
                continue;
            }
            logger.error(this.getClass().getSimpleName() + " can only hold objects of type " + TimedOrbitCoordinates.class.getSimpleName());
        }
    }

    @Override
    public void doneLoading(Object ... params) {
        for (TimedOrbitCoordinates c : this.coordinates) {
            c.doneLoading(params);
        }
        if (this.processOnlyActive) {
            if (params.length == 0) {
                logger.error(new RuntimeException("No parameters found, can't initialize scene."));
            } else if (params[0] instanceof Scene) {
                this.scene = (Scene)params[0];
            }
        }
    }

    private Vector3Q getGenericCoordinates(Instant instant, Vector3Q out, Method method) {
        boolean found = false;
        for (TimedOrbitCoordinates c : this.coordinates) {
            if (c.isValid(instant)) {
                Entity entity = c.coordinates.entity;
                if (Mapper.tagNoProcess.has(entity) && GaiaSky.instance.isInitialised()) {
                    entity.remove(TagNoProcess.class);
                }
                Entity owner = c.coordinates.owner;
                if (c.parent != null && ((GraphNode)Mapper.graph.get((Entity)owner)).parent != c.parent) {
                    GraphNode parentGraph = (GraphNode)Mapper.graph.get(c.parent);
                    parentGraph.addChild(c.parent, owner, true, 1);
                }
                if (found) continue;
                try {
                    method.invoke((Object)c, instant, out);
                    found = true;
                }
                catch (Exception e) {
                    logger.error(e, "Error invoking method: " + String.valueOf(method));
                }
                continue;
            }
            if (!this.processOnlyActive || Mapper.tagNoProcess.has(c.coordinates.entity) || !GaiaSky.instance.isInitialised()) continue;
            c.coordinates.entity.add(this.scene.engine.createComponent(TagNoProcess.class));
        }
        return out;
    }

    @Override
    public Vector3Q getEclipticSphericalCoordinates(Instant instant, Vector3Q out) {
        String method = "getEclipticSphericalCoordinates";
        try {
            return this.getGenericCoordinates(instant, out, IBodyCoordinates.class.getMethod(method, Instant.class, Vector3Q.class));
        }
        catch (NoSuchMethodException nsme) {
            logger.error(nsme, "Method does not exist: " + method);
            return out;
        }
    }

    @Override
    public Vector3Q getEclipticCartesianCoordinates(Instant instant, Vector3Q out) {
        String method = "getEclipticCartesianCoordinates";
        try {
            return this.getGenericCoordinates(instant, out, IBodyCoordinates.class.getMethod(method, Instant.class, Vector3Q.class));
        }
        catch (NoSuchMethodException nsme) {
            logger.error(nsme, "Method does not exist: " + method);
            return out;
        }
    }

    @Override
    public Vector3Q getEquatorialCartesianCoordinates(Instant instant, Vector3Q out) {
        String method = "getEquatorialCartesianCoordinates";
        try {
            return this.getGenericCoordinates(instant, out, IBodyCoordinates.class.getMethod(method, Instant.class, Vector3Q.class));
        }
        catch (NoSuchMethodException nsme) {
            logger.error(nsme, "Method does not exist: " + method);
            return out;
        }
    }

    @Override
    public void updateReferences(Map<String, Entity> index) {
        for (TimedOrbitCoordinates c : this.coordinates) {
            c.updateReferences(index);
        }
    }

    @Override
    public IBodyCoordinates getCopy() {
        ComposedTimedOrbitCoordinates copy = new ComposedTimedOrbitCoordinates();
        copy.processOnlyActive = this.processOnlyActive;
        copy.scene = this.scene;
        copy.coordinates = new Array(this.coordinates.size);
        for (TimedOrbitCoordinates c : this.coordinates) {
            copy.coordinates.add((Object)((TimedOrbitCoordinates)c.getCopy()));
        }
        return copy;
    }
}

