/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord;

import com.badlogic.gdx.math.Matrix4;
import gaiasky.util.Constants;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Quadruple;
import gaiasky.util.math.QuadrupleMath;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.jafama.FastMath;

public class Coordinates {
    public static final double OBLIQUITY_DEG_J2000 = 23.4392808;
    public static final double OBLIQUITY_RAD_J2000 = FastMath.toRadians((double)23.4392808);
    public static final double OBLIQUITY_ARCSEC_J2000 = 84381.411;
    private static final double R = 32.93192;
    private static final double Q = 27.12825;
    private static final double P = 192.85948;
    private static final Matrix4D equatorialToEcliptic = Coordinates.getRotationMatrix(0.0, -23.4392808, 0.0);
    private static final Matrix4D eclipticToEquatorial;
    private static final Matrix4D equatorialToGalactic;
    private static final Matrix4D galacticToEquatorial;
    private static final Matrix4D eclipticToGalactic;
    private static final Matrix4D galacticToEcliptic;
    private static final Matrix4D mat4didt;
    private static final Matrix4 equatorialToEclipticF;
    private static final Matrix4 eclipticToEquatorialF;
    private static final Matrix4 equatorialToGalacticF;
    private static final Matrix4 galacticToEquatorialF;
    private static final Matrix4 eclipticToGalacticF;
    private static final Matrix4 galacticToEclipticF;
    private static final Matrix4 mat4fidt;
    private static final Map<String, Matrix4D> mapd;
    private static final Map<String, Matrix4> mapf;

    public static Map<String, Matrix4D> getMap() {
        return mapd;
    }

    public static Matrix4D getRotationMatrix(double alpha, double beta, double gamma) {
        return new Matrix4D().rotate(0.0, 1.0, 0.0, gamma).rotate(0.0, 0.0, 1.0, beta).rotate(0.0, 1.0, 0.0, alpha);
    }

    public static Matrix4D eclToEq() {
        return eclipticToEquatorial;
    }

    public static Matrix4D eclipticToEquatorial() {
        return Coordinates.eclToEq();
    }

    public static Matrix4 eclToEqF() {
        return eclipticToEquatorialF;
    }

    public static Matrix4 eclipticToEquatorialF() {
        return Coordinates.eclToEqF();
    }

    public static Matrix4D eclToEq(double julianDate) {
        return Coordinates.getRotationMatrix(0.0, AstroUtils.obliquity(julianDate), 0.0);
    }

    public static Matrix4D eclipticToEquatorial(double jd) {
        return Coordinates.eclToEq(jd);
    }

    public static Matrix4D eqToEcl() {
        return equatorialToEcliptic;
    }

    public static Matrix4D equatorialToEcliptic() {
        return Coordinates.eqToEcl();
    }

    public static Matrix4 eqToEclF() {
        return equatorialToEclipticF;
    }

    public static Matrix4 equatorialToEclipticF() {
        return Coordinates.eqToEclF();
    }

    public static Matrix4D eqToEcl(double julianDate) {
        return Coordinates.getRotationMatrix(0.0, -AstroUtils.obliquity(julianDate), 0.0);
    }

    public static Matrix4D equatorialToEcliptic(double jd) {
        return Coordinates.eqToEcl(jd);
    }

    public static Matrix4D galToEq() {
        return galacticToEquatorial;
    }

    public static Matrix4D galacticToEquatorial() {
        return Coordinates.galToEq();
    }

    public static Matrix4 galToEqF() {
        return galacticToEquatorialF;
    }

    public static Matrix4 galacticToEquatorialF() {
        return Coordinates.galToEqF();
    }

    public static Matrix4D eqToGal() {
        return equatorialToGalactic;
    }

    public static Matrix4D equatorialToGalactic() {
        return Coordinates.eqToGal();
    }

    public static Matrix4 eqToGalF() {
        return equatorialToGalacticF;
    }

    public static Matrix4 equatorialToGalacticF() {
        return Coordinates.eqToGalF();
    }

    public static Vector2D equatorialToGalactic(double alpha, double delta, Vector2D out) {
        Vector3D aux = new Vector3D(alpha, delta, Constants.PC_TO_U);
        Coordinates.sphericalToCartesian(aux, aux);
        aux.mul(equatorialToGalactic);
        Coordinates.cartesianToSpherical(aux, aux);
        out.x = aux.x;
        out.y = aux.y;
        return out;
    }

    public static Vector2D galacticToEquatorial(double l, double b, Vector2D out) {
        Vector3D aux = new Vector3D(l, b, Constants.PC_TO_U);
        Coordinates.sphericalToCartesian(aux, aux);
        aux.mul(galacticToEquatorial);
        Coordinates.cartesianToSpherical(aux, aux);
        out.x = aux.x;
        out.y = aux.y;
        return out;
    }

    public static Vector2D eclipticToEquatorial(Vector2D vec, Vector2D out) {
        return Coordinates.eclipticToEquatorial(vec.x, vec.y, out);
    }

    public static Vector2D eclipticToEquatorial(double lambda, double beta, Vector2D out) {
        double alpha = FastMath.atan2((double)(Math.sin(lambda) * FastMath.cos((double)OBLIQUITY_RAD_J2000) - FastMath.tan((double)beta) * FastMath.sin((double)OBLIQUITY_RAD_J2000)), (double)FastMath.cos((double)lambda));
        if (alpha < 0.0) {
            alpha += Math.PI * 2;
        }
        double delta = FastMath.asin((double)(Math.sin(beta) * FastMath.cos((double)OBLIQUITY_RAD_J2000) + FastMath.cos((double)beta) * FastMath.sin((double)OBLIQUITY_RAD_J2000) * FastMath.sin((double)lambda)));
        return out.set(alpha, delta);
    }

    public static Matrix4D eclipticToGalactic() {
        return eclipticToGalactic;
    }

    public static Matrix4 eclipticToGalacticF() {
        return eclipticToGalacticF;
    }

    public static Matrix4D galacticToEcliptic() {
        return galacticToEcliptic;
    }

    public static Matrix4 galacticToEclipticF() {
        return galacticToEclipticF;
    }

    public static Vector3D sphericalToCartesian(Vector3D vec, Vector3D out) {
        return Coordinates.sphericalToCartesian(vec.x, vec.y, vec.z, out);
    }

    public static Vector3Q sphericalToCartesian(Vector3Q vec, Vector3Q out) {
        return Coordinates.sphericalToCartesian(vec.x.doubleValue(), vec.y.doubleValue(), vec.z, out);
    }

    public static Vector3D sphericalToCartesian(double longitude, double latitude, double radius, Vector3D out) {
        out.x = radius * FastMath.cos((double)latitude) * FastMath.sin((double)longitude);
        out.y = radius * FastMath.sin((double)latitude);
        out.z = radius * FastMath.cos((double)latitude) * FastMath.cos((double)longitude);
        return out;
    }

    public static Vector3Q sphericalToCartesian(double longitude, double latitude, Quadruple radius, Vector3Q out) {
        out.x.assign(radius).multiply(new Quadruple(Math.cos(latitude) * FastMath.sin((double)longitude)));
        out.y.assign(radius).multiply(new Quadruple(Math.sin(latitude)));
        out.z.assign(radius).multiply(new Quadruple(Math.cos(latitude) * FastMath.cos((double)longitude)));
        return out;
    }

    public static Vector3D cartesianToSpherical(Vector3D vec, Vector3D out) {
        double xsq = vec.x * vec.x;
        double ysq = vec.y * vec.y;
        double zsq = vec.z * vec.z;
        double distance = FastMath.sqrt((double)(xsq + ysq + zsq));
        double alpha = FastMath.atan2((double)vec.x, (double)vec.z);
        if (alpha < 0.0) {
            alpha += Math.PI * 2;
        }
        double delta = zsq + xsq == 0.0 ? (vec.y > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : FastMath.atan((double)(vec.y / FastMath.sqrt((double)(zsq + xsq))));
        out.x = alpha;
        out.y = delta;
        out.z = distance;
        return out;
    }

    public static Vector3D cartesianToSpherical(Vector3Q vec, Vector3D out) {
        if (vec == null || out == null) {
            return null;
        }
        double x = vec.x.doubleValue();
        double y = vec.y.doubleValue();
        double z = vec.z.doubleValue();
        double xsq = x * x;
        double ysq = y * y;
        double zsq = z * z;
        double distance = FastMath.sqrt((double)(xsq + ysq + zsq));
        double alpha = FastMath.atan2((double)x, (double)z);
        if (alpha < 0.0) {
            alpha += Math.PI * 2;
        }
        double delta = zsq + xsq == 0.0 ? (y > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : FastMath.atan((double)(y / FastMath.sqrt((double)(zsq + xsq))));
        out.x = alpha;
        out.y = delta;
        out.z = distance;
        return out;
    }

    public static Vector3Q cartesianToSpherical(Vector3Q vec, Vector3Q out) {
        Quadruple delta;
        Quadruple xsq = vec.x.multiply(vec.x);
        Quadruple ysq = vec.y.multiply(vec.y);
        Quadruple zsq = vec.z.multiply(vec.z);
        Quadruple distance = xsq.add(ysq).add(zsq).sqrt();
        Quadruple alpha = QuadrupleMath.atan2(vec.x, vec.z);
        if (alpha.doubleValue() < 0.0) {
            alpha.add(QuadrupleMath.pi2());
        }
        if (zsq.add(xsq).doubleValue() == 0.0) {
            Quadruple piOverTwo = QuadrupleMath.piOver2();
            delta = vec.y.doubleValue() > 0.0 ? piOverTwo : piOverTwo.multiply(Quadruple.from(-1.0));
        } else {
            delta = QuadrupleMath.atan(vec.y.divide(zsq.add(xsq).sqrt()));
        }
        return out.set(alpha, delta, distance);
    }

    public static Vector3D properMotionsToCartesian(double muAlphaStar, double muDelta, double radVel, double ra, double dec, double distPc, Vector3D out) {
        double ma = muAlphaStar * 0.001;
        double md = muDelta * 0.001;
        double vta = ma * distPc * 4.74047;
        double vtd = md * distPc * 4.74047;
        double cosAlpha = FastMath.cos((double)ra);
        double sinAlpha = FastMath.sin((double)ra);
        double cosDelta = FastMath.cos((double)dec);
        double sinDelta = FastMath.sin((double)dec);
        double vx = radVel * cosDelta * cosAlpha - vta * sinAlpha - vtd * sinDelta * cosAlpha;
        double vy = radVel * cosDelta * sinAlpha + vta * cosAlpha - vtd * sinDelta * sinAlpha;
        double vz = radVel * sinDelta + vtd * cosDelta;
        return out.set(vy, vz, vx).scl(Constants.KM_TO_U / 3.168808781402895E-8);
    }

    public static Vector3D cartesianToProperMotions(double vx, double vy, double vz, double ra, double dec, double distPc, Vector3D out) {
        double kmPerYearToInternal = Constants.U_TO_KM / 3.15576E7;
        double arcsecPerYearToKm = 4.74047 * distPc;
        double vxKms = vz * kmPerYearToInternal;
        double vyKms = vx * kmPerYearToInternal;
        double vzKms = vy * kmPerYearToInternal;
        double cosA = FastMath.cos((double)ra);
        double sinA = FastMath.sin((double)ra);
        double cosD = FastMath.cos((double)dec);
        double sinD = FastMath.sin((double)dec);
        double rx = cosD * cosA;
        double ry = cosD * sinA;
        double rz = sinD;
        double ax = -sinA;
        double ay = cosA;
        double az = 0.0;
        double dx = -cosA * sinD;
        double dy = -sinA * sinD;
        double dz = cosD;
        double vr = vxKms * rx + vyKms * ry + vzKms * rz;
        double vta = vxKms * ax + vyKms * ay + vzKms * az;
        double vtd = vxKms * dx + vyKms * dy + vzKms * dz;
        double muAlphaStar = vta / arcsecPerYearToKm * 1000.0;
        double muDelta = vtd / arcsecPerYearToKm * 1000.0;
        return out.set(muAlphaStar, muDelta, vr);
    }

    public static Matrix4D getTransformD(String name) {
        if (name == null || name.isEmpty() || !mapf.containsKey(name)) {
            return mat4didt;
        }
        return mapd.get(name.toLowerCase(Locale.ROOT));
    }

    public static Matrix4 getTransformF(String name) {
        if (name == null || name.isEmpty() || !mapf.containsKey(name)) {
            return mat4fidt;
        }
        return mapf.get(name.toLowerCase(Locale.ROOT));
    }

    public static Matrix4D idt() {
        return mat4didt;
    }

    public static Matrix4 idtF() {
        return mat4fidt;
    }

    static {
        equatorialToEclipticF = equatorialToEcliptic.putIn(new Matrix4());
        eclipticToEquatorial = Coordinates.getRotationMatrix(0.0, 23.4392808, 0.0);
        eclipticToEquatorialF = eclipticToEquatorial.putIn(new Matrix4());
        galacticToEquatorial = Coordinates.getRotationMatrix(-32.93192, 62.87175, 282.85947999999996);
        galacticToEquatorialF = galacticToEquatorial.putIn(new Matrix4());
        equatorialToGalactic = new Matrix4D(galacticToEquatorial).inv();
        equatorialToGalacticF = equatorialToGalactic.putIn(new Matrix4());
        eclipticToGalactic = new Matrix4D(galacticToEquatorial).mul(equatorialToEcliptic);
        eclipticToGalacticF = eclipticToGalactic.putIn(new Matrix4());
        galacticToEcliptic = new Matrix4D(eclipticToEquatorial).mul(equatorialToGalactic);
        galacticToEclipticF = galacticToEcliptic.putIn(new Matrix4());
        mat4didt = new Matrix4D();
        mat4fidt = new Matrix4();
        mapd = new HashMap<String, Matrix4D>();
        mapf = new HashMap<String, Matrix4>();
        mapd.put("equatorialtoecliptic", equatorialToEcliptic);
        mapd.put("eqtoecl", equatorialToEcliptic);
        mapf.put("equatorialtoecliptic", equatorialToEclipticF);
        mapf.put("eqtoecl", equatorialToEclipticF);
        mapd.put("ecliptictoequatorial", eclipticToEquatorial);
        mapd.put("ecltoeq", eclipticToEquatorial);
        mapf.put("ecliptictoequatorial", eclipticToEquatorialF);
        mapf.put("ecltoeq", eclipticToEquatorialF);
        mapd.put("galactictoequatorial", galacticToEquatorial);
        mapd.put("galtoeq", galacticToEquatorial);
        mapf.put("galactictoequatorial", galacticToEquatorialF);
        mapf.put("galtoeq", galacticToEquatorialF);
        mapd.put("equatorialtogalactic", equatorialToGalactic);
        mapd.put("eqtogal", equatorialToGalactic);
        mapf.put("equatorialtogalactic", equatorialToGalacticF);
        mapf.put("eqtogal", equatorialToGalacticF);
        mapd.put("ecliptictogalactic", eclipticToGalactic);
        mapd.put("ecltogal", eclipticToGalactic);
        mapf.put("ecliptictogalactic", eclipticToGalacticF);
        mapf.put("ecltogal", eclipticToGalacticF);
        mapd.put("galactictoecliptic", galacticToEcliptic);
        mapd.put("galtoecl", galacticToEcliptic);
        mapf.put("galactictoecliptic", galacticToEclipticF);
        mapf.put("galtoecl", galacticToEclipticF);
    }
}

