/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord;

import com.badlogic.ashley.core.Entity;
import gaiasky.util.coord.AbstractOrbitCoordinates;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.coord.IBodyCoordinates;
import gaiasky.util.math.Vector3Q;
import java.time.Instant;
import java.util.Map;

public class HeliotropicOrbitCoordinates
extends AbstractOrbitCoordinates {
    @Override
    public Vector3Q getEclipticCartesianCoordinates(Instant date, Vector3Q out) {
        return null;
    }

    @Override
    public Vector3Q getEclipticSphericalCoordinates(Instant date, Vector3Q out) {
        return null;
    }

    @Override
    public Vector3Q getEquatorialCartesianCoordinates(Instant date, Vector3Q out) {
        boolean inRange = this.getData().loadPoint(out, date);
        if (!inRange) {
            return null;
        }
        return out.rotate(AstroUtils.getSunLongitude(date) + 180.0, 0.0, 1.0, 0.0).mul(Coordinates.eclToEq()).scl(this.scaling);
    }

    @Override
    public void updateReferences(Map<String, Entity> index) {
        this.updateOwner(index);
    }

    @Override
    public IBodyCoordinates getCopy() {
        HeliotropicOrbitCoordinates copy = new HeliotropicOrbitCoordinates();
        this.copyParameters(copy);
        return copy;
    }
}

