/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord;

import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.QuaternionDouble;
import gaiasky.util.math.Vector3D;
import net.jafama.FastMath;

public class NslSun {
    static final double missionReferenceEpoch = 0.0;
    static final double piHalf = 1.5707963267948966;
    static final double NOMINALSUN_ORBITALECCENTRICITY_J2000 = 0.01671;
    static final double NOMINALSUN_MEANLONGITUDE_J2000 = 280.4665;
    static final double NOMINALSUN_MEANLONGITUDERATE_J2000 = 0.98560903;
    static final double NOMINALSUN_ORBITALMEANANOMALY_J2000 = 357.529;
    static final double NOMINALSUN_ORBITALMEANANOMALYRATE_J2000 = 0.9856002;
    static final double OBLIQUITY_DEG = 23.4392808;
    static final double e = 0.01671;
    static final double d2e = FastMath.toDegrees((double)0.03342);
    static final double d5_2e2 = FastMath.toDegrees((double)6.9806025E-4);
    static final double sineObliquity = FastMath.sin((double)Coordinates.OBLIQUITY_RAD_J2000);
    static final double cosineObliquity = FastMath.cos((double)Coordinates.OBLIQUITY_RAD_J2000);
    static final double ABERRATION_CONSTANT_J2000 = 20.49122;
    static final Vector3D X_AXIS = Vector3D.getUnitX();
    static final Vector3D Y_AXIS = Vector3D.getUnitY();
    static final Vector3D Z_AXIS = Vector3D.getUnitZ();
    private final double timeOriginDaysFromJ2000 = 0.0 - (AstroUtils.JD_J2000 - AstroUtils.JD_J2010);
    private final double timeOriginNsFromJ2000 = 0.0 - (AstroUtils.JD_J2000 - AstroUtils.JD_J2010) * 8.64E13;
    private double sLon;
    private double sLonMod4Pi;
    private double sLonDot;
    private double sineLon;
    private double cosineLon;

    public void setTime(double julianDate) {
        long tNs = (long)((julianDate - AstroUtils.JD_J2000) * 8.64E13);
        this.setTime(tNs);
    }

    public void setTime(long tNs) {
        double daysFromJ2000 = this.timeOriginDaysFromJ2000 + (double)tNs * 1.1574074074074074E-14;
        double xl = 280.46080799444445 + 0.98560903 * daysFromJ2000;
        double xm = 357.529 + 0.9856002 * daysFromJ2000;
        double sm = FastMath.sin((double)Math.toRadians(xm));
        double cm = FastMath.cos((double)Math.toRadians(xm));
        double lon = xl + sm * (d2e + d5_2e2 * cm);
        this.sLonDot = Math.toRadians(0.98560903 + 0.9856002 * FastMath.toRadians((double)(d2e * cm + d5_2e2 * (cm * cm - sm * sm))));
        this.sLon = FastMath.toRadians((double)lon);
        this.sLonMod4Pi = FastMath.toRadians((double)(lon % 720.0));
        this.sineLon = FastMath.sin((double)this.sLonMod4Pi);
        this.cosineLon = FastMath.cos((double)this.sLonMod4Pi);
    }

    public double getSolarLongitude() {
        return this.sLon;
    }

    public double getSolarLongitudeMod4Pi() {
        return this.sLonMod4Pi;
    }

    public double getSolarLongitudeDot() {
        return this.sLonDot;
    }

    public Vector3D getSolarDirection(Vector3D out) {
        return out.set(this.cosineLon, this.sineLon * cosineObliquity, this.sineLon * sineObliquity);
    }

    public QuaternionDouble heliotropicToQuaternion(long t, double xi, double nu, double Omega) {
        this.setTime(t);
        double sLon = this.getSolarLongitude();
        QuaternionDouble q = new QuaternionDouble(Z_AXIS, 23.4392808);
        q.mul(new QuaternionDouble(Y_AXIS, FastMath.toDegrees((double)sLon)));
        q.mul(new QuaternionDouble(Z_AXIS, FastMath.toDegrees((double)(nu - 1.5707963267948966))));
        q.mul(new QuaternionDouble(X_AXIS, FastMath.toDegrees((double)(1.5707963267948966 - xi))));
        q.mul(new QuaternionDouble(Y_AXIS, FastMath.toDegrees((double)Omega)));
        return q;
    }

    public double angleBase(double x, int nRev) {
        double x1;
        double base = (double)nRev * 2.0 * Math.PI;
        for (x1 = x; x1 >= base; x1 -= base) {
        }
        while (x1 < 0.0) {
            x1 += base;
        }
        return x1;
    }
}

