/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord;

import com.badlogic.ashley.core.Entity;
import gaiasky.data.util.PointCloudData;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.RefSysTransform;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.component.Verts;
import gaiasky.scene.record.OrbitComponent;
import gaiasky.util.coord.AbstractOrbitCoordinates;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.coord.IBodyCoordinates;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.time.Instant;
import java.util.Map;
import net.jafama.FastMath;

public class OrbitLintCoordinates
extends AbstractOrbitCoordinates {
    OrbitComponent orbitalParams;
    PointCloudData data;
    Matrix4D transform;
    Vector3D aux = new Vector3D();

    @Override
    public void doneLoading(Object ... params) {
        if (params.length == 0) {
            logger.error(new RuntimeException("OrbitLintCoordinates need the scene graph"));
        } else {
            super.doneLoading(params);
            this.transform = new Matrix4D();
            if (this.entity != null) {
                Trajectory trajectory = (Trajectory)Mapper.trajectory.get(this.entity);
                Verts verts = (Verts)Mapper.verts.get(this.entity);
                if (trajectory == null) {
                    throw new RuntimeException("Trajectory component does not exist for orbit object: " + ((Base)Mapper.base.get(this.entity)).getName());
                }
                if (verts == null) {
                    throw new RuntimeException("Verts component does not exist for orbit object: " + ((Base)Mapper.base.get(this.entity)).getName());
                }
                this.orbitalParams = trajectory.oc;
                this.data = verts.pointCloudData;
            } else {
                throw new RuntimeException("This " + this.getClass().getSimpleName() + " object does have neither an orbit nor an entity object.");
            }
        }
    }

    @Override
    public Vector3Q getEclipticSphericalCoordinates(Instant date, Vector3Q out) {
        this.getEclipticCartesianCoordinates(date, out);
        Coordinates.cartesianToSpherical(out, out);
        return out;
    }

    @Override
    public Vector3Q getEclipticCartesianCoordinates(Instant date, Vector3Q out) {
        this.getEquatorialCartesianCoordinates(date, out);
        out.mul(Coordinates.eqToEcl());
        return out;
    }

    @Override
    public Vector3Q getEquatorialCartesianCoordinates(Instant date, Vector3Q out) {
        boolean inRange = this.getData().loadPoint(out, date);
        if (!this.periodic && !inRange) {
            return null;
        }
        if (this.data == null) {
            return out;
        }
        long dateWrap = this.data.getWrapTimeMs(date);
        int baseIndex = this.data.getIndex(dateWrap);
        int nextIndex = (baseIndex + 1) % this.data.getNumPoints();
        double percent = (double)FastMath.abs((long)(dateWrap - this.data.getDate(baseIndex).toEpochMilli())) / (double)FastMath.abs((long)(this.data.getDate(nextIndex).toEpochMilli() - this.data.getDate(baseIndex).toEpochMilli()));
        this.data.loadPoint(out, baseIndex);
        this.data.loadPoint(this.aux, nextIndex);
        double len = this.aux.sub(out).len();
        this.aux.nor().scl(percent * len);
        out.add(this.aux);
        Matrix4D transformFunction = this.getTransformFunction();
        Matrix4D parentOrientation = this.getParentOrientation();
        if (transformFunction == null && parentOrientation != null) {
            this.transform.set(parentOrientation);
        } else if (transformFunction != null) {
            this.transform.set(transformFunction);
        } else {
            this.transform.idt();
        }
        if (!this.isNewMethod()) {
            this.transform.rotate(0.0, 1.0, 0.0, this.orbitalParams.argOfPericenter);
            this.transform.rotate(0.0, 0.0, 1.0, this.orbitalParams.i);
            this.transform.rotate(0.0, 1.0, 0.0, this.orbitalParams.ascendingNode);
        } else if (this.entity != null && ((Trajectory)Mapper.trajectory.get((Entity)this.entity)).model.isExtrasolar()) {
            this.transform.rotate(0.0, 1.0, 0.0, 90.0);
        }
        out.mul(this.transform).scl(this.scaling);
        if (this.center != null && !this.center.isZero()) {
            out.add(this.center);
        }
        return out;
    }

    protected boolean isNewMethod() {
        if (this.entity != null) {
            return ((Trajectory)Mapper.trajectory.get((Entity)this.entity)).newMethod;
        }
        return false;
    }

    protected Matrix4D getTransformFunction() {
        if (this.entity != null) {
            return ((RefSysTransform)Mapper.transform.get((Entity)this.entity)).matrix;
        }
        return null;
    }

    protected Matrix4D getParentOrientation() {
        if (this.entity != null) {
            return ((GraphNode)Mapper.graph.get((Entity)((GraphNode)Mapper.graph.get((Entity)this.entity)).parent)).orientation;
        }
        return null;
    }

    @Override
    public void updateReferences(Map<String, Entity> index) {
        this.updateOwner(index);
    }

    @Override
    public IBodyCoordinates getCopy() {
        OrbitLintCoordinates copy = new OrbitLintCoordinates();
        copy.orbitalParams = this.orbitalParams;
        copy.transform = this.transform.cpy();
        copy.data = this.data;
        this.copyParameters(copy);
        return copy;
    }
}

