/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord;

import gaiasky.util.Constants;
import gaiasky.util.coord.AbstractOrbitCoordinates;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.math.Vector3Q;
import java.time.Instant;

public class PlutoCoordinates
extends AbstractOrbitCoordinates {
    @Override
    public void doneLoading(Object ... params) {
        super.doneLoading(params);
    }

    @Override
    public Vector3Q getEclipticSphericalCoordinates(Instant date, Vector3Q out) {
        AstroUtils.plutoEclipticCoordinates(date, out);
        out.z = out.z.multiply(Constants.KM_TO_U * this.scaling);
        return out;
    }

    @Override
    public Vector3Q getEclipticCartesianCoordinates(Instant date, Vector3Q out) {
        this.getEclipticSphericalCoordinates(date, out);
        Coordinates.sphericalToCartesian(out, out);
        return out;
    }

    @Override
    public Vector3Q getEquatorialCartesianCoordinates(Instant date, Vector3Q out) {
        this.getEclipticSphericalCoordinates(date, out);
        Coordinates.sphericalToCartesian(out, out);
        out.mul(Coordinates.eclToEq());
        return out;
    }
}

