/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.api.ISpacecraft;
import gaiasky.scene.view.FocusView;
import gaiasky.scene.view.SpacecraftView;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.coord.IBodyCoordinates;
import gaiasky.util.math.IntersectorDouble;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.time.Instant;
import java.util.Map;

public class SpacecraftCoordinates
implements IBodyCoordinates {
    private static final Logger.Log logger = Logger.getLogger(SpacecraftCoordinates.class);
    private ISpacecraft spacecraft;
    private final Vector3D D31 = new Vector3D();
    private final Vector3D D32 = new Vector3D();
    private final Vector3D D33 = new Vector3D();
    private final Vector3Q B31 = new Vector3Q();
    private final Vector3Q B32 = new Vector3Q();
    private final Vector3Q B33 = new Vector3Q();
    private final Vector3Q B34 = new Vector3Q();

    public void setSpacecraft(ISpacecraft sc) {
        this.spacecraft = sc;
    }

    @Override
    public void doneLoading(Object ... params) {
    }

    @Override
    public Vector3Q getEclipticSphericalCoordinates(Instant date, Vector3Q out) {
        this.getEclipticCartesianCoordinates(date, out);
        Coordinates.cartesianToSpherical(out, out);
        return out;
    }

    @Override
    public Vector3Q getEclipticCartesianCoordinates(Instant date, Vector3Q out) {
        this.getEquatorialCartesianCoordinates(date, out);
        out.mul(Coordinates.eqToEcl());
        return out;
    }

    @Override
    public Vector3Q getEquatorialCartesianCoordinates(Instant instant, Vector3Q out) {
        return this.computePosition(GaiaSky.instance.time.getDt(), GaiaSky.instance.getICamera().getSecondClosestBody(), this.spacecraft.currentEnginePower(), this.spacecraft.thrust(), this.spacecraft.direction(), this.spacecraft.force(), this.spacecraft.accel(), this.spacecraft.vel(), out);
    }

    public Vector3Q computePosition(double dt, IFocus closest, double currentEnginePower, Vector3D thrust, Vector3D direction, Vector3D force, Vector3D accel, Vector3D vel, Vector3Q posb) {
        double mass = this.spacecraft.mass();
        this.spacecraft.currentEnginePower(Math.signum(currentEnginePower));
        currentEnginePower = this.spacecraft.currentEnginePower();
        thrust.set(direction).scl(this.spacecraft.thrustMagnitude() * this.spacecraft.thrustFactor()[this.spacecraft.thrustFactorIndex()] * currentEnginePower);
        force.set(thrust);
        if (Settings.settings.runtime.relativisticAberration) {
            double speed = vel.len();
            double scale = (this.spacecraft.relativisticSpeedCap() - speed) / this.spacecraft.relativisticSpeedCap();
            force.scl(scale);
        }
        double friction = this.spacecraft.drag() * 2.0E16 * dt;
        force.add(this.D31.set(vel).scl(-friction));
        if (this.spacecraft.stopping()) {
            Vector3D nextVel;
            double speed = vel.len();
            if (speed != 0.0) {
                this.spacecraft.currentEnginePower(-1.0);
                thrust.set(vel).nor().scl(this.spacecraft.thrustMagnitude() * this.spacecraft.thrustFactor()[this.spacecraft.thrustFactorIndex()] * currentEnginePower);
                force.set(thrust);
            }
            if (vel.angle(nextVel = this.D33.set(force).scl(1.0 / mass).scl(Constants.M_TO_U).scl(dt).add(vel)) > 90.0) {
                this.spacecraft.currentEnginePower(0.0);
                force.scl(0.0);
                vel.scl(0.0);
                EventManager.publish(Event.SPACECRAFT_STOP_CMD, this, false);
            }
        }
        accel.set(force).scl(1.0 / mass);
        Vector3D acc = this.D31.set(accel).scl(Constants.M_TO_U);
        if (Settings.settings.spacecraft.velocityDirection) {
            double velocityLength = vel.len();
            vel.set(direction).nor().scl(velocityLength);
        }
        vel.add(acc.scl(dt));
        Vector3Q velocity = this.B32.set(vel);
        Vector3Q newPosition = this.B33.set(posb).add(velocity.scl(dt));
        Vector3Q pos = posb.put(this.B34);
        IFocus me = GaiaSky.instance.getICamera().getClosestBody();
        if (closest != null && !closest.isEmpty() && closest instanceof FocusView && this.spacecraft instanceof SpacecraftView && ((FocusView)closest).getEntity() != ((SpacecraftView)this.spacecraft).getEntity()) {
            double twoRadii = closest.getRadius() + me.getRadius();
            if (!vel.isZero() && IntersectorDouble.distanceSegmentPoint(pos.put(this.D31), newPosition.put(this.D32), closest.getPos().put(this.D33)) < twoRadii) {
                logger.info("Crashed against " + closest.getName() + "!");
                Array<Vector3D> intersections = IntersectorDouble.intersectRaySphere(pos.put(this.D31), newPosition.put(this.D32), closest.getPos().put(this.D31), twoRadii);
                if (intersections.size >= 1) {
                    posb.set((Vector3D)intersections.get(0));
                }
                this.spacecraft.stopAllMovement();
            } else if (posb.dstD(closest.getPos()) < twoRadii) {
                posb.set(this.B31.set(posb).sub(closest.getPos()).nor().scl(posb.dst(closest.getPos(), this.B32)));
            } else {
                posb.set(newPosition);
            }
        } else {
            posb.set(newPosition);
        }
        return posb;
    }

    @Override
    public void updateReferences(Map<String, Entity> index) {
    }

    @Override
    public IBodyCoordinates getCopy() {
        return this;
    }
}

