/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.coord.IBodyCoordinates;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Quadruple;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import java.time.Instant;
import java.util.Map;

public class StaticCoordinates
implements IBodyCoordinates {
    private Vector3Q position;
    private String transformName;
    private Matrix4D trf;

    @Override
    public void doneLoading(Object ... params) {
        if (this.trf != null) {
            this.position.mul(this.trf);
        }
    }

    @Override
    public Vector3Q getEclipticSphericalCoordinates(Instant date, Vector3Q out) {
        return out.set(this.position);
    }

    @Override
    public Vector3Q getEclipticCartesianCoordinates(Instant date, Vector3Q out) {
        return out.set(this.position);
    }

    @Override
    public Vector3Q getEquatorialCartesianCoordinates(Instant date, Vector3Q out) {
        return out.set(this.position);
    }

    public void setTransformFunction(String transformName) {
        this.setTransformName(transformName);
    }

    public void setTransformName(String transformName) {
        this.transformName = transformName;
        if (transformName != null) {
            Class<Coordinates> c = Coordinates.class;
            try {
                Method m = ClassReflection.getMethod(c, (String)transformName, (Class[])new Class[0]);
                Object obj = m.invoke(null, new Object[0]);
                if (obj instanceof Matrix4) {
                    this.trf = new Matrix4D(((Matrix4)obj).val);
                } else if (obj instanceof Matrix4D) {
                    this.trf = new Matrix4D((Matrix4D)obj);
                }
            }
            catch (ReflectionException e) {
                Logger.getLogger(this.getClass()).error("Error getting/invoking method Coordinates." + transformName + "()");
            }
        }
    }

    public void setTransformMatrix(double[] transformMatrix) {
        this.trf = new Matrix4D(transformMatrix);
    }

    public Vector3Q getPosition() {
        return this.position;
    }

    public void setPosition(Vector3Q pos) {
        this.position = new Vector3Q(pos);
    }

    public void setPosition(double[] position) {
        this.setPositionKm(position);
    }

    public void setPositionKm(double[] position) {
        this.position = new Vector3Q(position[0] * Constants.KM_TO_U, position[1] * Constants.KM_TO_U, position[2] * Constants.KM_TO_U);
    }

    public void setPositionkm(double[] position) {
        this.setPositionKm(position);
    }

    public void setPositionEquatorial(double[] position) {
        this.position = new Vector3Q();
        this.position.set(Coordinates.sphericalToCartesian(position[0] * (Math.PI / 180), position[1] * (Math.PI / 180), position[2] * Constants.PC_TO_U, new Vector3D()));
    }

    public void setPositionGalactic(double[] position) {
        this.position = new Vector3Q();
        this.position.set(Coordinates.sphericalToCartesian(position[0] * (Math.PI / 180), position[1] * (Math.PI / 180), position[2] * Constants.PC_TO_U, new Vector3D()));
        this.position.mul(Coordinates.galacticToEquatorial());
    }

    public void setPositionEcliptic(double[] position) {
        this.position = new Vector3Q();
        this.position.set(Coordinates.sphericalToCartesian(position[0] * (Math.PI / 180), position[1] * (Math.PI / 180), position[2] * Constants.PC_TO_U, new Vector3D()));
        this.position.mul(Coordinates.eclipticToEquatorial());
    }

    public void setPositionPc(double[] position) {
        this.position = new Vector3Q(position[0] * Constants.PC_TO_U, position[1] * Constants.PC_TO_U, position[2] * Constants.PC_TO_U);
    }

    public void setPositionpc(double[] position) {
        this.setPositionPc(position);
    }

    public void setEquatorial(double[] equatorial) {
        double ra = Math.PI / 180 * equatorial[0];
        double dec = Math.PI / 180 * equatorial[1];
        double dist = Constants.PC_TO_U * equatorial[2];
        this.position = new Vector3Q();
        Coordinates.sphericalToCartesian(ra, dec, Quadruple.from(dist), this.position);
    }

    public String toString() {
        return "{pos=" + String.valueOf(this.position) + ", trf='" + this.transformName + "'}";
    }

    @Override
    public void updateReferences(Map<String, Entity> index) {
    }

    @Override
    public IBodyCoordinates getCopy() {
        return this;
    }
}

