/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord;

import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.coord.AstroUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class TLEParser {
    private static final long CACHE_TIMEOUT_MS = 3600000L;

    public OrbitalElements getOrbitalElements(String url, String targetName) throws Exception {
        List<String> lines = this.fetchTLEData(url);
        return this.extractOrbitalElements(lines, targetName);
    }

    private String getGroupFromURL(URL url) throws RuntimeException {
        String query = url.getQuery();
        HashMap<String, String> queryPairs = new HashMap<String, String>();
        for (String pair : query.split("&")) {
            int idx = pair.indexOf(61);
            String key = URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8);
            String value = URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8);
            queryPairs.put(key, value);
        }
        return (String)queryPairs.get("GROUP");
    }

    public List<String> fetchTLEData(String urlString) throws IOException {
        String line;
        FileTime t;
        long modified;
        long now;
        URL url = URI.create(urlString).toURL();
        String group = this.getGroupFromURL(url);
        Path cacheDir = SysUtils.getDataCacheDir(Settings.settings.data.location);
        Path file = cacheDir.resolve("TLE-" + group);
        boolean download = true;
        if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0]) && (now = System.currentTimeMillis()) - (modified = (t = Files.getLastModifiedTime(file, new LinkOption[0])).to(TimeUnit.MILLISECONDS)) < 3600000L) {
            download = false;
        }
        BufferedReader reader = download ? new BufferedReader(new InputStreamReader(url.openStream())) : new BufferedReader(new InputStreamReader(Files.newInputStream(file, new OpenOption[0])));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            if (line.trim().isEmpty()) continue;
            lines.add(line);
        }
        reader.close();
        if (download) {
            Files.write(file, lines, new OpenOption[0]);
        }
        return lines;
    }

    public OrbitalElements extractOrbitalElements(List<String> lines, String name) {
        for (int i = 0; i < lines.size() - 2; ++i) {
            String line0 = lines.get(i).trim();
            String line1 = lines.get(i + 1).trim();
            String line2 = lines.get(i + 2).trim();
            if (!line0.equalsIgnoreCase(name) || !line1.startsWith("1 ") || !line2.startsWith("2 ")) continue;
            OrbitalElements elem = new OrbitalElements();
            elem.name = name;
            String epochStr = line1.substring(18, 32).trim();
            elem.epochJD = this.parseEpoch(epochStr);
            elem.inclination = Double.parseDouble(line2.substring(8, 16).trim());
            elem.ascendingNode = Double.parseDouble(line2.substring(17, 25).trim());
            elem.eccentricity = Double.parseDouble("0." + line2.substring(26, 33).trim());
            elem.argOfPericenter = Double.parseDouble(line2.substring(34, 42).trim());
            elem.meanAnomaly = Double.parseDouble(line2.substring(43, 51).trim());
            double meanMotion = Double.parseDouble(line2.substring(52, 63).trim());
            elem.period = 1.0 / meanMotion;
            elem.semiMajorAxis = this.getSemiMajorAxisKm(meanMotion);
            elem.revolutionNumber = Integer.parseInt(line2.substring(63, 68).trim());
            return elem;
        }
        return null;
    }

    private double getSemiMajorAxisKm(double meanMotion) {
        double mu = 398600.4418;
        double secondsPerDay = 86400.0;
        double meanMotionRadPerSec = Math.PI * 2 * meanMotion / 86400.0;
        double semiMajorAxis = Math.cbrt(398600.4418 / (meanMotionRadPerSec * meanMotionRadPerSec));
        return semiMajorAxis;
    }

    private double parseEpoch(String epoch) {
        int year = Integer.parseInt(epoch.substring(0, 2));
        double day = Double.parseDouble(epoch.substring(2));
        double jd = AstroUtils.getJulianDateUTC(year += year < 57 ? 2000 : 1900, 1, 1, 0, 0, 0, 0);
        return jd + day;
    }

    public static class OrbitalElements {
        public String name;
        public double period;
        public double epochJD;
        public double semiMajorAxis;
        public double inclination;
        public double ascendingNode;
        public double eccentricity;
        public double argOfPericenter;
        public double meanAnomaly;
        public int revolutionNumber;

        public String toString() {
            return "OrbitalElements{argOfPericenter=" + this.argOfPericenter + ", name='" + this.name + "', period=" + this.period + ", epochJD=" + this.epochJD + ", semiMajorAxis=" + this.semiMajorAxis + ", inclination=" + this.inclination + ", ascendingNode=" + this.ascendingNode + ", eccentricity=" + this.eccentricity + ", meanAnomaly=" + this.meanAnomaly + ", revolutionNumber=" + this.revolutionNumber + "}";
        }
    }
}

