/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.utils.Pool;
import gaiasky.scene.Scene;
import gaiasky.util.Logger;
import gaiasky.util.coord.AbstractOrbitCoordinates;
import gaiasky.util.coord.IBodyCoordinates;
import gaiasky.util.math.Vector3Q;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;

public class TimedOrbitCoordinates
implements IBodyCoordinates {
    static final Pool<TimedOrbitCoordinates> pool = new Pool<TimedOrbitCoordinates>(){

        protected TimedOrbitCoordinates newObject() {
            return new TimedOrbitCoordinates();
        }
    };
    protected static final Logger.Log logger = Logger.getLogger(TimedOrbitCoordinates.class);
    public AbstractOrbitCoordinates coordinates;
    public Instant start;
    public Instant end;
    public String parentName;
    public Entity parent;

    public void setParent(String parent) {
        this.parentName = parent;
    }

    public void setStart(String start) {
        this.start = Instant.parse(start);
    }

    public void setEnd(String end) {
        this.end = Instant.parse(end);
    }

    public void setCoordinates(IBodyCoordinates c) {
        if (c instanceof AbstractOrbitCoordinates) {
            AbstractOrbitCoordinates aoc;
            this.coordinates = aoc = (AbstractOrbitCoordinates)c;
        } else {
            logger.error(this.getClass().getSimpleName() + " can only hold (sub)objects of type " + AbstractOrbitCoordinates.class.getSimpleName());
        }
    }

    public boolean isValid(Instant t) {
        return t.equals(this.start) || t.equals(this.end) || t.isAfter(this.start) && t.isBefore(this.end);
    }

    @Override
    public void doneLoading(Object ... params) {
        Object object;
        this.coordinates.doneLoading(params);
        if (this.parentName != null && params.length > 0 && (object = params[0]) instanceof Scene) {
            Scene scene = (Scene)object;
            this.parent = scene.getEntity(this.parentName);
        }
    }

    @Override
    public Vector3Q getEclipticSphericalCoordinates(Instant instant, Vector3Q out) {
        return this.coordinates.getEclipticSphericalCoordinates(instant, out);
    }

    @Override
    public Vector3Q getEclipticCartesianCoordinates(Instant instant, Vector3Q out) {
        return this.coordinates.getEclipticCartesianCoordinates(instant, out);
    }

    @Override
    public Vector3Q getEquatorialCartesianCoordinates(Instant instant, Vector3Q out) {
        return this.coordinates.getEquatorialCartesianCoordinates(instant, out);
    }

    @Override
    public void updateReferences(Map<String, Entity> index) {
        String key;
        this.coordinates.updateReferences(index);
        if (this.parentName != null && index.containsKey(key = this.parentName.toLowerCase(Locale.ROOT))) {
            this.parent = index.get(key);
        }
    }

    @Override
    public IBodyCoordinates getCopy() {
        TimedOrbitCoordinates copy = (TimedOrbitCoordinates)pool.obtain();
        copy.start = this.start;
        copy.end = this.end;
        copy.parentName = this.parentName;
        copy.coordinates = (AbstractOrbitCoordinates)this.coordinates.getCopy();
        return copy;
    }
}

