/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord.chebyshev;

import gaiasky.util.Constants;
import gaiasky.util.coord.AbstractOrbitCoordinates;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.coord.chebyshev.ChebyshevCoefficients;
import gaiasky.util.coord.chebyshev.ChebyshevLoader;
import gaiasky.util.math.Vector3Q;
import java.nio.file.Path;
import java.time.Instant;

public class ChebyshevEphemeris
extends AbstractOrbitCoordinates {
    public String dataFile;
    public ChebyshevCoefficients data;

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public boolean initialize() {
        if (this.data == null) {
            if (this.dataFile != null) {
                ChebyshevLoader reader = new ChebyshevLoader();
                try {
                    this.data = reader.loadData(Path.of(this.dataFile, new String[0]));
                    return this.data != null;
                }
                catch (Exception e) {
                    logger.error("Error initializing coordinates: " + this.dataFile, e);
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public Vector3Q position(Instant date, Vector3Q out) {
        if (!this.initialize()) {
            return null;
        }
        double jd = AstroUtils.getJulianDateCache(date) - AstroUtils.JD_J2010;
        long nanosecondsTcb = (long)(jd * 8.64E13);
        boolean positionTypeIndex = false;
        ChebyshevCoefficients.Header positionHeader = this.data.header[0];
        ChebyshevCoefficients.Coefficients positionCoefficients = this.data.coefficients[0];
        return this.evaluateChebyshev(nanosecondsTcb, positionHeader, positionCoefficients, out);
    }

    private Vector3Q evaluateChebyshev(long nanosecondsTcb, ChebyshevCoefficients.Header header, ChebyshevCoefficients.Coefficients coefficients, Vector3Q out) {
        double t;
        int iGranule;
        if (header.isEquidistant) {
            long nanosecondsOffset = nanosecondsTcb - header.nanosecondsTcbBegin;
            double granuleLength = coefficients.nanoSecondsTcb[1] - coefficients.nanoSecondsTcb[0];
            iGranule = (int)((double)nanosecondsOffset / granuleLength);
            t = ((double)nanosecondsOffset - (double)iGranule * granuleLength) / granuleLength;
            if (iGranule == header.nGranules) {
                --iGranule;
                t = 1.0;
            }
        } else {
            iGranule = this.binarySearch(nanosecondsTcb, coefficients.nanoSecondsTcb);
            long nanosecondsTcbLow = coefficients.nanoSecondsTcb[iGranule];
            long nanosecondsTcbHigh = coefficients.nanoSecondsTcb[iGranule + 1];
            long granuleLength = nanosecondsTcbHigh - nanosecondsTcbLow;
            t = (double)(nanosecondsTcb - nanosecondsTcbLow) / (double)granuleLength;
        }
        if (iGranule > coefficients.data.length || iGranule < 0) {
            return null;
        }
        double[] coefficientsX = coefficients.data[iGranule][0];
        double[] coefficientsY = coefficients.data[iGranule][1];
        double[] coefficientsZ = coefficients.data[iGranule][2];
        int nCoefficients = coefficientsX.length;
        double t0 = 1.0;
        double x = coefficientsX[0] * t0;
        double y = coefficientsY[0] * t0;
        double z = coefficientsZ[0] * t0;
        double t1 = 2.0 * t - 1.0;
        x += coefficientsX[1] * t1;
        y += coefficientsY[1] * t1;
        z += coefficientsZ[1] * t1;
        double tau = 2.0 * t1;
        for (int iCoefficient = 2; iCoefficient < nCoefficients; ++iCoefficient) {
            double tn = tau * t1 - t0;
            t0 = t1;
            t1 = tn;
            x += coefficientsX[iCoefficient] * tn;
            y += coefficientsY[iCoefficient] * tn;
            z += coefficientsZ[iCoefficient] * tn;
        }
        out.set(y, z, x).scl(Constants.M_TO_U);
        return out;
    }

    private int binarySearch(long nanosecondsTcb, long[] nanosecondsTcbArray) {
        int nGranules = nanosecondsTcbArray.length;
        int low = 0;
        int high = nGranules;
        int lowPlus1 = low + 1;
        while (high > lowPlus1) {
            int mid = low + high >>> 1;
            if (nanosecondsTcbArray[mid] <= nanosecondsTcb) {
                low = mid;
                lowPlus1 = low + 1;
                continue;
            }
            high = mid;
        }
        return low;
    }

    @Override
    public Vector3Q getEclipticSphericalCoordinates(Instant instant, Vector3Q out) {
        this.position(instant, out);
        Coordinates.cartesianToSpherical(out, out);
        return out;
    }

    @Override
    public Vector3Q getEclipticCartesianCoordinates(Instant instant, Vector3Q out) {
        this.position(instant, out);
        out.mul(Coordinates.eqToEcl());
        return out;
    }

    @Override
    public Vector3Q getEquatorialCartesianCoordinates(Instant instant, Vector3Q out) {
        this.position(instant, out);
        return out;
    }
}

