/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.coord.chebyshev;

import gaiasky.util.coord.chebyshev.ChebyshevCoefficients;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;

public class ChebyshevLoader {
    private String fileName;

    protected ChebyshevLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChebyshevCoefficients loadData(Path filePath) throws FileNotFoundException {
        String positionTypeName = "position";
        boolean positionTypeIndex = false;
        FileInputStream inputStream = new FileInputStream(filePath.toFile());
        ChebyshevCoefficients chebyshevEphemerisData = new ChebyshevCoefficients();
        try {
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                chebyshevEphemerisData.header[0] = this.loadHeader(bufferedReader);
                chebyshevEphemerisData.coefficients[0] = this.loadData(bufferedReader, chebyshevEphemerisData.header[0]);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read the resource file " + String.valueOf(filePath), e);
        }
        return chebyshevEphemerisData;
    }

    private ChebyshevCoefficients.Header loadHeader(BufferedReader bufferedReader) throws IOException {
        String bodyLine = bufferedReader.readLine();
        if (null == bodyLine) {
            throw new IOException("Unexpeced end of file.");
        }
        String vectorLine = bufferedReader.readLine();
        if (null == vectorLine) {
            throw new IOException("Unexpeced end of file.");
        }
        String dimensionsLine = bufferedReader.readLine();
        if (null == dimensionsLine) {
            throw new IOException("Unexpeced end of file.");
        }
        String granulesLine = bufferedReader.readLine();
        if (null == granulesLine) {
            throw new IOException("Unexpeced end of file.");
        }
        String equisizedLine = bufferedReader.readLine();
        if (null == equisizedLine) {
            throw new IOException("Unexpeced end of file.");
        }
        String tcbBeginLine = bufferedReader.readLine();
        if (null == tcbBeginLine) {
            throw new IOException("Unexpeced end of file.");
        }
        String tcbEndLine = bufferedReader.readLine();
        if (null == tcbEndLine) {
            throw new IOException("Unexpeced end of file.");
        }
        String emptyLine = bufferedReader.readLine();
        if (null == emptyLine) {
            throw new IOException("Unexpeced end of file.");
        }
        String headerLine = bufferedReader.readLine();
        if (null == headerLine) {
            throw new IOException("Unexpeced end of file.");
        }
        if (!this.parseHeaderLine(vectorLine).equals("position")) {
            throw new IOException("Unexpected vector type in file.");
        }
        int nGranules = Integer.parseInt(this.parseHeaderLine(granulesLine));
        boolean isEquisized = Boolean.parseBoolean(this.parseHeaderLine(equisizedLine));
        long nanoscondsTcbBegin = Long.parseLong(this.parseHeaderLine(tcbBeginLine));
        long nanoscondsTcbEnd = Long.parseLong(this.parseHeaderLine(tcbEndLine));
        return new ChebyshevCoefficients.Header(nGranules, isEquisized, nanoscondsTcbBegin, nanoscondsTcbEnd);
    }

    private ChebyshevCoefficients.Coefficients loadData(BufferedReader bufferedReader, ChebyshevCoefficients.Header header) throws IOException {
        long[] nanosecondsTcbArray = new long[header.nGranules + 1];
        nanosecondsTcbArray[header.nGranules] = header.nanosecondsTcbEnd;
        double[][][] coefficientsArray = new double[header.nGranules][header.nDimensions][];
        for (int iGranule = 0; iGranule < header.nGranules; ++iGranule) {
            for (int iDimensions = 0; iDimensions < header.nDimensions; ++iDimensions) {
                String dataLine = bufferedReader.readLine();
                if (null == dataLine) {
                    throw new IOException("Unexpeced end of file.");
                }
                String[] dataLineTokens = this.splitDataLine(dataLine.strip());
                int[] dataLineHeader = this.parseDataLineHeader(dataLineTokens);
                if (iGranule != dataLineHeader[0]) {
                    throw new IOException("Unexpeced file format.");
                }
                if (iDimensions != dataLineHeader[1]) {
                    throw new IOException("Unexpeced file format.");
                }
                int nCoefficients = dataLineHeader[2];
                if (4 + nCoefficients != dataLineTokens.length) {
                    throw new IOException("Unexpeced file format.");
                }
                long nanosecondsTcb = this.parseDataLineTime(dataLineTokens);
                if (nanosecondsTcb < header.nanosecondsTcbBegin || header.nanosecondsTcbEnd < nanosecondsTcb) {
                    throw new IOException("Granule time out of range.");
                }
                nanosecondsTcbArray[iGranule] = nanosecondsTcb;
                coefficientsArray[iGranule][iDimensions] = this.parseDataLineCoefficients(dataLineTokens);
            }
            int nCoefficientsX = coefficientsArray[iGranule][0].length;
            int nCoefficientsY = coefficientsArray[iGranule][1].length;
            int nCoefficientsZ = coefficientsArray[iGranule][2].length;
            if (nCoefficientsX == nCoefficientsZ && nCoefficientsY == nCoefficientsZ) continue;
            throw new IOException("Different polynomial orders for vector components.");
        }
        return new ChebyshevCoefficients.Coefficients(nanosecondsTcbArray, coefficientsArray);
    }

    private String parseHeaderLine(String line) throws IOException {
        String[] splitLine = line.split(":");
        if (2 != splitLine.length) {
            throw new IOException("Unexpected file format.");
        }
        return splitLine[1].strip();
    }

    private String[] splitDataLine(String line) throws IOException {
        String[] splitLine = line.split("\\s+");
        if (4 > splitLine.length) {
            throw new IOException("Unexpected file format.");
        }
        return splitLine;
    }

    private int[] parseDataLineHeader(String[] dataLineTokens) {
        int iGranule = Integer.parseInt(dataLineTokens[0].strip());
        int nDimensions = Integer.parseInt(dataLineTokens[1].strip());
        int nCoefficients = Integer.parseInt(dataLineTokens[2].strip());
        return new int[]{iGranule, nDimensions, nCoefficients};
    }

    private long parseDataLineTime(String[] dataLineTokens) {
        return Long.parseLong(dataLineTokens[3].strip());
    }

    private double[] parseDataLineCoefficients(String[] dataLineTokens) {
        double[] coefficients = new double[dataLineTokens.length - 4];
        for (int iCoefficient = 0; iCoefficient < dataLineTokens.length - 4; ++iCoefficient) {
            coefficients[iCoefficient] = Double.parseDouble(dataLineTokens[iCoefficient + 4].strip());
        }
        return coefficients;
    }
}

